/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.X_UY_PayReceiptDef;

public class MUYPayReceiptDef
extends X_UY_PayReceiptDef {
    public MUYPayReceiptDef(Properties ctx, int UY_PayReceiptDef_ID, String trxName) {
        super(ctx, UY_PayReceiptDef_ID, trxName);
    }

    public MUYPayReceiptDef(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.setHeader();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        String message = "";
        String sql = "";
        if (success) {
            this.setHeader();
            if (this.getC_Invoice_ID() > 0) {
                MUYPayReceipt hdr = (MUYPayReceipt)this.getUY_PayReceipt();
                MInvoice inv = (MInvoice)this.getC_Invoice();
                if (hdr.isSOTrx()) {
                    if (inv != null && inv.get_ID() > 0) {
                        if (!inv.processIt("VO")) {
                            message = inv.getProcessMsg();
                            throw new AdempiereException(message);
                        }
                        inv.saveEx();
                        sql = " DELETE FROM Fact_Acct WHERE AD_Table_ID = " + X_C_Invoice.Table_ID + " AND " + "Record_ID" + " = " + inv.get_ID();
                        DB.executeUpdateEx(sql, this.get_TrxName());
                        inv.deleteEx(true);
                    }
                } else {
                    sql = "select i.c_invoice_id from c_invoice i join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where i.ref_invoice_id = " + this.getC_Invoice_ID() + " and d.docbasetype = 'DPC' and i.docstatus = 'CO'";
                    int invID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
                    if (invID > 0) {
                        DB.executeUpdateEx("delete from uy_payreceiptdoc where c_invoice_id = " + invID, this.get_TrxName());
                    }
                }
            }
        }
        return success;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MUYPayReceipt hdr = new MUYPayReceipt(this.getCtx(), this.getUY_PayReceipt_ID(), this.get_TrxName());
        if (newRecord && hdr.isSOTrx() && hdr.get_ValueAsBoolean("IsRepresentation") && hdr.getLinesGen("").size() > 0) {
            throw new AdempiereException("Ya hay cobros generados para este documento, no se permiten diferentes medios de pago");
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM UY_PayReceiptDef WHERE UY_PayReceipt_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getUY_PayReceipt_ID());
            this.setLine(ii);
        }
        return true;
    }

    private void setHeader() {
        MUYPayReceipt hdr = (MUYPayReceipt)this.getUY_PayReceipt();
        String sql = "";
        BigDecimal amtAllocated = Env.ZERO;
        amtAllocated = hdr.isSOTrx() ? this.getTotalPayAmt("", " AND dt.DocBaseType NOT IN ('ARI','ARC','DPC','DRC')") : this.getTotalPayAmt("", " AND dt.DocBaseType NOT IN ('API','APC','DPC','DRC')");
        sql = "SELECT COALESCE(SUM(AmtSource),0) FROM UY_PayReceiptDef WHERE IsActive='Y' AND UY_PayReceipt_ID=" + this.getUY_PayReceipt_ID();
        BigDecimal amtSource = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
        sql = "SELECT COALESCE(SUM(PayAmt),0) FROM UY_PayReceiptLine WHERE IsActive='Y' AND UY_PayReceipt_ID=" + this.getUY_PayReceipt_ID();
        BigDecimal payAmt = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
        BigDecimal totalAllocated = amtSource.add(payAmt).subtract(amtAllocated);
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET AllocatedAmt = " + totalAllocated + " where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET PayAmt = " + totalAllocated + " where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET OpenAmt = (" + totalAllocated + " - AmtToAllocate) * -1 where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET ChargeAmt = (" + totalAllocated + " - AmtToAllocate) * -1 where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
    }

    public static int maxLineNo(int headerID) {
        int value = 0;
        String sql = "select coalesce(max(line),0) from uy_payreceiptdef where uy_payreceipt_id = " + headerID;
        value = DB.getSQLValueEx(null, sql, new Object[0]);
        return value;
    }

    private BigDecimal getTotalPayAmt(String trx, String docBaseType) {
        String sql = "SELECT COALESCE(SUM(d.PayAmt),0) FROM UY_PayReceiptDoc d JOIN C_Invoice i ON d.C_Invoice_ID = i.C_Invoice_ID JOIN C_DocType dt ON i.C_DocTypeTarget_ID = dt.C_DocType_ID WHERE d.IsActive = 'Y' AND d.UY_PayReceipt_ID = " + this.getUY_PayReceipt_ID() + trx + docBaseType;
        BigDecimal payAmt = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
        return payAmt;
    }
}

