/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_AllocationHdr;
import org.compiere.model.X_C_AllocationLine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceiptDef;
import org.openup.core.model.MUYPayReceiptDoc;
import org.openup.core.model.MUYPayReceiptLine;
import org.openup.core.model.X_UY_PayReceipt;

public class MUYPayReceipt
extends X_UY_PayReceipt
implements DocAction,
DocOptions {
    private boolean linesWithCharge = false;
    private String processMsg = null;
    private static final long serialVersionUID = 20170620L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MUYPayReceipt(Properties ctx, int UY_PayReceipt_ID, String trxName) {
        super(ctx, UY_PayReceipt_ID, trxName);
    }

    public MUYPayReceipt(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        int newIndex = 0;
        if (docStatus.equalsIgnoreCase("DR") || docStatus.equalsIgnoreCase("IN") || docStatus.equalsIgnoreCase("IP")) {
            options[newIndex++] = "CO";
            options[newIndex++] = "VO";
        } else if (docStatus.equalsIgnoreCase("CO")) {
            options[newIndex++] = "VO";
        }
        return newIndex;
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.get_ValueAsInt("C_PaySelection_ID") == 0) {
            BigDecimal amtDiff = this.getOpenAmt().subtract(this.getChargeAmt());
            if (this.getOpenAmt().compareTo(Env.ZERO) > 0 && (amtDiff.compareTo(Env.ZERO) != 0 || this.getC_Charge_ID() <= 0) && !this.linesWithCharge) throw new AdempiereException("Imposible completar documento, existe saldo pendiente");
            if (this.isSOTrx()) {
                this.verifyDocuments();
            }
            this.processReceipt();
            if (!this.get_ValueAsBoolean("IsRepresentation") && (this.getAmtToAllocate().compareTo(Env.ZERO) > 0 || this.linesWithCharge)) {
                this.generateAllocation();
            }
            this.generateOppositeReceipt();
        } else {
            if (!this.get_ValueAsBoolean("IsRepresentation") && (this.getAmtToAllocate().compareTo(Env.ZERO) > 0 || this.linesWithCharge)) {
                this.generateAllocation();
            }
            this.generateOppositeReceipt();
            DB.executeUpdateEx("update c_payment set uy_payreceipt_id = " + this.get_ID() + " where c_payment_id in (select c_payment_id from UY_PayReceiptLine where UY_PayReceipt_ID = " + this.get_ID() + ")", this.get_TrxName());
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        if (this.getC_Charge_ID() > 0 && this.getChargeAmt().compareTo(Env.ZERO) != 0) {
            this.setPayAmt(this.getAllocatedAmt().add(this.getChargeAmt()));
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("VO");
        return "CO";
    }

    private void verifyDocuments() {
        String sql = "select count(uy_payreceiptdoc_id) from uy_payreceiptdoc where c_charge_id is not null and uy_payreceipt_id = " + this.get_ID();
        int qtyCharge = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (qtyCharge > 0) {
            this.linesWithCharge = true;
        }
        List<MUYPayReceiptDoc> docs = this.getLinesDoc("ARI", "");
        if (qtyCharge > 0 && docs.size() > 0) {
            throw new AdempiereException("Imposible completar: no se permite facturas de venta y cheques diferidos con cargo");
        }
        if (this.linesWithCharge) {
            sql = "select count(d.uy_payreceiptdoc_id) from uy_payreceiptdoc d inner join c_invoice i on d.c_invoice_id = i.c_invoice_id inner join c_doctype t on i.c_doctypetarget_id = t.c_doctype_id where t.docbasetype in ('DRC','DPC') and d.c_charge_id is null and d.uy_payreceipt_id = " + this.get_ID();
            int qtyNoCharge = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (qtyNoCharge > 0) {
                throw new AdempiereException("Imposible completar: no se permite cheques diferidos con cargo y otros sin cargo");
            }
        }
    }

    public void generateOppositeReceipt() {
        List<MUYPayReceiptDoc> docs = null;
        List<MUYPayReceiptDoc> docsAux = null;
        int docTypeID = 0;
        boolean isSOTrx = false;
        boolean IsValid = false;
        String description = "";
        BigDecimal amtToAllocate = Env.ZERO;
        if (this.isSOTrx()) {
            docs = this.getLinesDoc("API", "");
            docsAux = this.getLinesDoc("ARI", " d.payamt desc");
            if (docs.size() > 0 && docsAux.size() > 0) {
                IsValid = true;
            } else if (docs.size() > 0 && docsAux.size() <= 0) {
                throw new AdempiereException("En recibo de canje debe ingresar facturas de venta y compra");
            }
            docTypeID = MDocType.getDocType("BPP", "and ad_org_id = " + this.getAD_Org_ID());
            description = "RECIBO DE CANJE - GENERADO DESDE RECIBO DE COBRO Nro. " + this.getDocumentNo();
        } else {
            docs = this.getLinesDoc("ARI", "");
            docsAux = this.getLinesDoc("API", " d.payamt desc");
            if (docs.size() > 0 && docsAux.size() > 0) {
                IsValid = true;
            } else if (docs.size() > 0 && docsAux.size() <= 0) {
                throw new AdempiereException("En recibo de canje debe ingresar facturas de venta y compra");
            }
            isSOTrx = true;
            docTypeID = MDocType.getDocType("BRR", "and ad_org_id = " + this.getAD_Org_ID());
            description = "RECIBO DE CANJE - GENERADO DESDE RECIBO DE PAGO Nro. " + this.getDocumentNo();
        }
        if (IsValid) {
            if (docTypeID == 0) {
                throw new AdempiereException("ERROR: No se obtuvo tipo de documento de canje para la organizacion del recibo");
            }
            if (this.getPaymentDocumentNo() == null || this.getPaymentDocumentNo().equalsIgnoreCase("")) {
                throw new AdempiereException("Debe ingresar numero de recibo de canje");
            }
            MUYPayReceipt hdr = new MUYPayReceipt(this.getCtx(), 0, this.get_TrxName());
            hdr.setAD_Client_ID(this.getAD_Client_ID());
            hdr.setAD_Org_ID(this.getAD_Org_ID());
            hdr.setC_DocType_ID(docTypeID);
            hdr.setDocumentNo(this.getPaymentDocumentNo());
            hdr.setC_BPartner_ID(this.getC_BPartner_ID());
            hdr.setC_Currency_ID(this.getC_Currency_ID());
            hdr.setDateDoc(this.getDateDoc());
            hdr.setIsSOTrx(isSOTrx);
            hdr.setC_AllocationHdr_ID(this.getC_AllocationHdr_ID());
            hdr.setDescription(description);
            hdr.setParent_ID(this.get_ID());
            hdr.setDocStatus("CO");
            hdr.setDocAction("--");
            hdr.setProcessed(true);
            hdr.setProcessing(false);
            hdr.saveEx();
            for (MUYPayReceiptDoc docLine : docs) {
                MUYPayReceiptDoc line = new MUYPayReceiptDoc(this.getCtx(), 0, this.get_TrxName());
                line.setUY_PayReceipt_ID(hdr.get_ID());
                line.setC_BPartner_ID(docLine.getC_BPartner_ID());
                line.setPaymentRule(docLine.getPaymentRule());
                line.setC_Invoice_ID(docLine.getC_Invoice_ID());
                line.setIsPrepayment(docLine.isPrepayment());
                line.setC_InvoicePaySchedule_ID(docLine.getC_InvoicePaySchedule_ID());
                line.setDiscountAmt(docLine.getDiscountAmt());
                line.setIsSelected(docLine.isSelected());
                if (docLine.getAmtSource().compareTo(Env.ZERO) < 0) {
                    line.setAmtSource(docLine.getAmtSource().negate());
                } else {
                    line.setAmtSource(docLine.getAmtSource());
                }
                if (docLine.getPayAmt().compareTo(Env.ZERO) < 0) {
                    line.setPayAmt(docLine.getPayAmt().negate());
                } else {
                    line.setPayAmt(docLine.getPayAmt());
                }
                if (docLine.getOpenAmt().compareTo(Env.ZERO) < 0) {
                    line.setOpenAmt(docLine.getOpenAmt().negate());
                } else {
                    line.setOpenAmt(docLine.getOpenAmt());
                }
                line.saveEx();
                BigDecimal payAmt = docLine.getPayAmt();
                if (payAmt.compareTo(Env.ZERO) < 0) {
                    payAmt = payAmt.negate();
                }
                amtToAllocate = amtToAllocate.add(payAmt);
            }
            for (MUYPayReceiptDoc docLine : docsAux) {
                if (amtToAllocate.compareTo(Env.ZERO) <= 0) continue;
                BigDecimal payAmt = docLine.getPayAmt();
                if (payAmt.compareTo(amtToAllocate) > 0) {
                    payAmt = amtToAllocate;
                }
                MUYPayReceiptDoc line = new MUYPayReceiptDoc(this.getCtx(), 0, this.get_TrxName());
                line.setUY_PayReceipt_ID(hdr.get_ID());
                line.setC_BPartner_ID(docLine.getC_BPartner_ID());
                line.setPaymentRule(docLine.getPaymentRule());
                line.setC_Invoice_ID(docLine.getC_Invoice_ID());
                line.setIsPrepayment(docLine.isPrepayment());
                line.setC_InvoicePaySchedule_ID(docLine.getC_InvoicePaySchedule_ID());
                line.setDiscountAmt(docLine.getDiscountAmt());
                line.setIsSelected(docLine.isSelected());
                line.setPayAmt(payAmt.negate());
                line.setAmtSource(docLine.getAmtSource().negate());
                line.setOpenAmt(docLine.getOpenAmt().negate());
                line.saveEx();
                amtToAllocate = amtToAllocate.subtract(payAmt);
            }
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String sql = "";
        if (!newRecord && (this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_Currency_ID") || this.is_ValueChanged("DocumentNo") || this.is_ValueChanged("DateDoc") || this.is_ValueChanged("IsRepresentation") || this.is_ValueChanged("C_Project_ID") || this.is_ValueChanged("C_DocType_ID") || this.is_ValueChanged("IsPrepayment") || this.is_ValueChanged("IsMultiCurrency") || this.is_ValueChanged("CurrencyRate") || this.is_ValueChanged("C_ConversionType_ID") || this.is_ValueChanged("C_Currency_ID_To")) && (this.getLinesDoc().size() > 0 || this.getLinesDef().size() > 0 || this.getLinesGen("").size() > 0)) {
            throw new AdempiereException("El documento tiene lineas, no se permite modificar los datos del cabezal");
        }
        if (newRecord || this.is_ValueChanged("DateDoc") || this.is_ValueChanged("C_Currency_ID") || this.is_ValueChanged("IsMultiCurrency") || this.is_ValueChanged("C_Currency_ID_To") || this.is_ValueChanged("C_ConversionType_ID")) {
            if (this.isMultiCurrency()) {
                if (this.getC_ConversionType_ID() == 114 || this.getC_ConversionType_ID() == 201) {
                    int schema_currency_id = new MAcctSchema(this.getCtx(), Env.getContextAsInt(this.getCtx(), "$C_AcctSchema_ID"), null).getC_Currency_ID();
                    BigDecimal rate = MConversionRate.getRate(this.getC_Currency_ID_To(), this.getC_Currency_ID(), this.getDateDoc(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), 0);
                    if (this.getC_Currency_ID() != schema_currency_id) {
                        rate = rate != null && rate.compareTo(Env.ZERO) > 0 ? Env.ONE.divide(rate, 3, 4) : null;
                    }
                    if (rate != null) {
                        this.setCurrencyRate(rate);
                    } else {
                        this.setCurrencyRate(Env.ZERO);
                    }
                }
            } else {
                DB.executeUpdateEx("update uy_payreceipt set c_currency_id_to = null where uy_payreceipt_id = " + this.get_ID(), this.get_TrxName());
            }
        }
        if (!this.isMultiCurrency()) {
            DB.executeUpdateEx("update uy_payreceipt set c_currency_id_to = null where uy_payreceipt_id = " + this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getLinesDef().size() > 0 || this.getLinesGen("").size() > 0) {
            throw new AdempiereException("Para eliminar el recibo se debe antes borrar las lineas de cheques diferidos y pagos/cobros");
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord || this.is_ValueChanged("IsMultiCurrency") || this.is_ValueChanged("C_ConversionType_ID") || this.is_ValueChanged("CurrencyRate") || this.is_ValueChanged("C_Currency_ID_To")) {
            DB.executeUpdateEx("delete from c_conversion_rate where ad_table_id = " + Table_ID + " and record_id = " + this.get_ID(), this.get_TrxName());
            int schema_currency_id = new MAcctSchema(this.getCtx(), Env.getContextAsInt(this.getCtx(), "$C_AcctSchema_ID"), null).getC_Currency_ID();
            if (this.isMultiCurrency() && this.getC_ConversionType_ID() > 0 && this.getC_ConversionType_ID() == 1000000 && this.getCurrencyRate().compareTo(Env.ZERO) > 0) {
                MConversionRate rate = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
                rate.setAD_Org_ID(0);
                rate.setC_ConversionType_ID(1000000);
                rate.setValidFrom(this.getDateDoc());
                rate.setValidTo(this.getDateDoc());
                rate.set_ValueOfColumn("AD_Table_ID", (Object)X_UY_PayReceipt.Table_ID);
                rate.set_ValueOfColumn("Record_ID", (Object)this.get_ID());
                if (this.getC_Currency_ID() == schema_currency_id) {
                    rate.setC_Currency_ID(this.getC_Currency_ID_To());
                    rate.setC_Currency_ID_To(this.getC_Currency_ID());
                    rate.setMultiplyRate(this.getCurrencyRate());
                } else {
                    rate.setC_Currency_ID(this.getC_Currency_ID());
                    rate.setC_Currency_ID_To(this.getC_Currency_ID_To());
                    rate.setMultiplyRate(this.getCurrencyRate());
                }
                rate.saveEx();
                rate = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
                rate.setAD_Org_ID(0);
                rate.setC_ConversionType_ID(1000000);
                rate.setValidFrom(this.getDateDoc());
                rate.setValidTo(this.getDateDoc());
                rate.set_ValueOfColumn("AD_Table_ID", (Object)X_UY_PayReceipt.Table_ID);
                rate.set_ValueOfColumn("Record_ID", (Object)this.get_ID());
                if (this.getC_Currency_ID() == schema_currency_id) {
                    rate.setC_Currency_ID(this.getC_Currency_ID());
                    rate.setC_Currency_ID_To(this.getC_Currency_ID_To());
                    rate.setDivideRate(this.getCurrencyRate());
                } else {
                    rate.setC_Currency_ID(this.getC_Currency_ID_To());
                    rate.setC_Currency_ID_To(this.getC_Currency_ID());
                    rate.setDivideRate(this.getCurrencyRate());
                }
                rate.saveEx();
            }
        }
        return true;
    }

    private void processReceipt() {
        String message = null;
        boolean generateCash = MSysConfig.getBooleanValue("RECEIPT_GENERATE_CASH", true, this.getAD_Client_ID());
        for (MUYPayReceiptLine line : this.getLinesGen("")) {
            MPayment pay;
            if (!line.getPaymentRule().equalsIgnoreCase("S") && !line.getPaymentRule().equalsIgnoreCase("T") && !line.getPaymentRule().equalsIgnoreCase("R") && (!generateCash || !line.getPaymentRule().equalsIgnoreCase("B")) || (pay = (MPayment)line.getC_Payment()).getDocStatus().equalsIgnoreCase("CO")) continue;
            if (!pay.processIt("CO")) {
                message = pay.getProcessMsg();
                throw new AdempiereException(message);
            }
            pay.saveEx();
        }
        if (!this.isSOTrx()) {
            String sql = "update c_invoice set InvoiceCollectionType = 'E', uy_payreceipt_id = " + this.get_ID() + " where c_invoice_id IN (select c_invoice_id from uy_payreceiptdef where uy_payreceipt_id = " + this.get_ID() + ")";
            DB.executeUpdateEx(sql, this.get_TrxName());
            int docID = MDocType.getDocType("END");
            if (docID <= 0) {
                throw new AdempiereException("No se encontro tipo de documento 'Pago Diferido Endoso'");
            }
            MBPartner partner = (MBPartner)this.getC_BPartner();
            for (MUYPayReceiptDef line : this.getLinesDef()) {
                MInvoice inv = (MInvoice)line.getC_Invoice();
                if (!inv.isSOTrx()) continue;
                this.generateEndorsement(inv, docID, partner);
            }
        }
    }

    public void generateEndorsement(MInvoice inv, int docID, MBPartner partner) {
        String message = "";
        MInvoice hdr = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        hdr.setC_DocTypeTarget_ID("END");
        hdr.setC_DocType_ID(docID);
        hdr.setDateInvoiced(this.getDateDoc());
        hdr.setDateAcct(this.getDateDoc());
        hdr.setC_Currency_ID(this.getC_Currency_ID());
        hdr.setIsSOTrx(true);
        hdr.setSalesRep_ID(Env.getAD_User_ID(this.getCtx()));
        hdr.setC_BPartner_ID(this.getC_BPartner_ID());
        hdr.setDescription("Creado desde: Recibo de Pago Nro. " + this.getDocumentNo());
        MBPartnerLocation loc = partner.getLocation(0);
        if (loc == null || loc.get_ID() < 0) {
            throw new AdempiereException("No se obtuvo localizacion para el socio de negocio '" + partner.getName() + "'");
        }
        hdr.setC_BPartner_Location_ID(loc.get_ID());
        hdr.setPaymentRule(inv.getPaymentRule());
        hdr.setC_PaymentTerm_ID(inv.getC_PaymentTerm_ID());
        hdr.setM_PriceList_ID(inv.getM_PriceList_ID());
        hdr.setTotalLines(inv.getGrandTotal());
        hdr.setGrandTotal(inv.getGrandTotal());
        hdr.setProcessed(false);
        hdr.setProcessing(false);
        hdr.setPosted(false);
        hdr.setDocStatus("DR");
        hdr.setDocAction("CO");
        hdr.saveEx();
        for (MInvoiceLine line : inv.getLines()) {
            MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
            iLine.setC_Invoice_ID(hdr.get_ID());
            iLine.setC_Charge_ID(line.getC_Charge_ID());
            iLine.setQtyEntered(line.getQtyEntered());
            iLine.setQtyInvoiced(line.getQtyInvoiced());
            iLine.setPriceEntered(line.getPriceEntered());
            iLine.setPriceActual(line.getPriceActual());
            iLine.setLineNetAmt(line.getLineNetAmt());
            iLine.setC_UOM_ID(line.getC_UOM_ID());
            iLine.setC_Tax_ID(line.getC_Tax_ID());
            iLine.setLineTotalAmt(line.getLineTotalAmt());
            iLine.saveEx();
        }
        if (!hdr.processIt("CO")) {
            message = hdr.getProcessMsg();
            throw new AdempiereException(message);
        }
        hdr.saveEx();
        inv.setInvoiceCollectionType("E");
        inv.saveEx();
    }

    public List<MUYPayReceiptDoc> getLinesDoc() {
        String whereClause = "UY_PayReceipt_ID=" + this.get_ID();
        List<MUYPayReceiptDoc> lines = new Query(this.getCtx(), "UY_PayReceiptDoc", whereClause, this.get_TrxName()).list();
        return lines;
    }

    public List<MUYPayReceiptDoc> getLinesDoc(String docType, String orderBy) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String where = "";
        String order = "";
        ArrayList<MUYPayReceiptDoc> lines = new ArrayList<MUYPayReceiptDoc>();
        if (docType != null && !docType.equalsIgnoreCase("")) {
            where = " and dt.docbasetype = '" + docType + "'";
        }
        if (orderBy != null && !orderBy.equalsIgnoreCase("")) {
            order = " order by " + orderBy;
        }
        String sql = "select d.uy_payreceiptdoc_id as payID from uy_payreceiptdoc d inner join c_invoice i on d.c_invoice_id = i.c_invoice_id inner join c_doctype dt on i.c_doctypetarget_id = dt.c_doctype_id where d.uy_payreceipt_id = " + this.get_ID() + where + order;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MUYPayReceiptDoc rd = new MUYPayReceiptDoc(this.getCtx(), rs.getInt("payID"), this.get_TrxName());
                lines.add(rd);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return lines;
    }

    public List<MUYPayReceiptDoc> getLinesDocInvoice() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<MUYPayReceiptDoc> lines = new ArrayList<MUYPayReceiptDoc>();
        String sql = "select d.uy_payreceiptdoc_id as payID from uy_payreceiptdoc d inner join c_invoice i on d.c_invoice_id = i.c_invoice_id inner join c_doctype dt on i.c_doctypetarget_id = dt.c_doctype_id where d.uy_payreceipt_id = " + this.get_ID() + " and dt.docbasetype in ('ARI','API','ARC','APC') and i.ispaid = 'N' order by d.payamt desc";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MUYPayReceiptDoc rd = new MUYPayReceiptDoc(this.getCtx(), rs.getInt("payID"), this.get_TrxName());
                lines.add(rd);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return lines;
    }

    public List<MUYPayReceiptDoc> getLinesDocNCDef() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<MUYPayReceiptDoc> lines = new ArrayList<MUYPayReceiptDoc>();
        String sql = "select d.uy_payreceiptdoc_id as payID from uy_payreceiptdoc d inner join c_invoice i on d.c_invoice_id = i.c_invoice_id inner join c_doctype dt on i.c_doctypetarget_id = dt.c_doctype_id where d.uy_payreceipt_id = " + this.get_ID() + " and dt.docbasetype in ('DRC','DPC') order by d.payamt desc";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MUYPayReceiptDoc rd = new MUYPayReceiptDoc(this.getCtx(), rs.getInt("payID"), this.get_TrxName());
                lines.add(rd);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return lines;
    }

    public List<MUYPayReceiptDef> getLinesDef() {
        String whereClause = "UY_PayReceipt_ID=" + this.get_ID();
        List<MUYPayReceiptDef> lines = new Query(this.getCtx(), "UY_PayReceiptDef", whereClause, this.get_TrxName()).list();
        return lines;
    }

    public List<MUYPayReceiptLine> getLinesGen(String orderBy) {
        String whereClause = "UY_PayReceipt_ID=" + this.get_ID();
        List<MUYPayReceiptLine> lines = new Query(this.getCtx(), "UY_PayReceiptLine", whereClause, this.get_TrxName()).setOrderBy(orderBy).list();
        return lines;
    }

    private void generateAllocation() {
        MAllocationHdr alloc = null;
        boolean IsAllocated = false;
        String description = "Generado autom\u00e1ticamente desde Recibo de Cobro Nro. ";
        if (!this.isSOTrx()) {
            description = "Generado autom\u00e1ticamente desde Recibo de Pago Nro. ";
        }
        alloc = new MAllocationHdr(this.getCtx(), true, this.getDateDoc(), this.getC_Currency_ID(), Env.getContext(Env.getCtx(), "#AD_User_Name"), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        alloc.setDescription(description + this.getDocumentNo());
        alloc.saveEx();
        if (this.isSOTrx() && this.linesWithCharge) {
            List<MUYPayReceiptDoc> docs = this.getLinesDoc("DRC", "");
            for (MUYPayReceiptDoc docLine : docs) {
                MInvoice inv = (MInvoice)docLine.getC_Invoice();
                MDocType doc = (MDocType)inv.getC_DocTypeTarget();
                MAllocationLine aLine = new MAllocationLine(alloc, docLine.getPayAmt().negate(), docLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
                aLine.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
                aLine.setC_BPartner_ID(inv.getC_BPartner_ID());
                aLine.saveEx();
                aLine = new MAllocationLine(alloc, docLine.getPayAmt().negate(), docLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
                aLine.setC_BPartner_ID(this.getC_BPartner_ID());
                aLine.setC_Charge_ID(docLine.getC_Charge_ID());
                aLine.saveEx();
            }
        } else {
            Object aLine;
            MUYPayReceiptLine payLine;
            MDocType doc;
            MInvoice inv;
            BigDecimal amtToAllocPay = this.getAmtToAllocate();
            BigDecimal unmatchedApplied = Env.ZERO;
            List<MUYPayReceiptDoc> invoices = this.getLinesDocInvoice();
            List<MUYPayReceiptLine> payLines = this.getLinesGen(" order by payamt desc");
            BigDecimal paymentAmt = Env.ZERO;
            BigDecimal multiplier = Env.ONE;
            for (MUYPayReceiptDoc docLine : invoices) {
                inv = (MInvoice)docLine.getC_Invoice();
                if (inv.getDateAcct().after(this.getDateDoc())) {
                    throw new AdempiereException("Fecha de recibo es menor a fecha de factura '" + inv.getDocumentNo() + "'");
                }
                doc = (MDocType)inv.getC_DocTypeTarget();
                multiplier = Env.ONE;
                BigDecimal amountInv = docLine.getPayAmt();
                if (this.get_ValueAsInt("C_PaySelection_ID") > 0) {
                    String sql = "select coalesce(sum(l.amount),0) from c_allocationline l inner join c_allocationhdr a on l.c_allocationhdr_id = a.c_allocationhdr_id where a.docstatus in ('CO','CL') and l.c_invoice_id = " + docLine.getC_Invoice_ID() + " and a.c_payselection_id = " + this.get_ValueAsInt("C_PaySelection_ID");
                    BigDecimal amtAllocated = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
                    if (amtAllocated.compareTo(Env.ZERO) < 0) {
                        amtAllocated = amtAllocated.negate();
                    }
                    amountInv = amountInv.subtract(amtAllocated);
                }
                if (this.isSOTrx()) {
                    if (doc.getDocBaseType().equalsIgnoreCase("API") && docLine.getPayAmt().compareTo(Env.ZERO) > 0 || doc.getDocBaseType().equalsIgnoreCase("ARI") && docLine.getPayAmt().compareTo(Env.ZERO) < 0) {
                        multiplier = multiplier.negate();
                    }
                } else if (docLine.getPayAmt().compareTo(Env.ZERO) < 0 && doc.getDocBaseType().equalsIgnoreCase("APC") || doc.getDocBaseType().equalsIgnoreCase("API") && docLine.getPayAmt().compareTo(Env.ZERO) > 0 || doc.getDocBaseType().equalsIgnoreCase("ARI") && docLine.getPayAmt().compareTo(Env.ZERO) < 0) {
                    multiplier = multiplier.negate();
                }
                for (MUYPayReceiptLine payLine2 : payLines) {
                    if (amountInv.signum() == 0 || (paymentAmt = (BigDecimal)payLine2.get_Value("AmtToAllocate")).signum() != amountInv.signum()) continue;
                    BigDecimal amount = amountInv;
                    if (amount.compareTo(paymentAmt) > 0) {
                        amount = paymentAmt;
                    }
                    MAllocationLine aLine2 = new MAllocationLine(alloc, amount.multiply(multiplier), docLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
                    aLine2.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
                    aLine2.setPaymentInfo(payLine2.getC_Payment_ID(), 0);
                    aLine2.saveEx();
                    amountInv = amountInv.subtract(amount);
                    paymentAmt = paymentAmt.subtract(amount);
                    payLine2.set_ValueOfColumn("AmtToAllocate", (Object)paymentAmt);
                }
                if (amountInv.signum() == 0) continue;
                int C_Payment_ID = 0;
                MAllocationLine aLine3 = new MAllocationLine(alloc, amountInv.multiply(multiplier), Env.ZERO, Env.ZERO, Env.ZERO);
                aLine3.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
                aLine3.setPaymentInfo(C_Payment_ID, 0);
                aLine3.saveEx();
                this.log.fine("Allocation Amount=" + amountInv);
                unmatchedApplied = unmatchedApplied.add(amountInv);
            }
            if (paymentAmt.signum() != 0 && (payLine = MUYPayReceiptLine.getFirst(this.getCtx(), this.get_ID(), this.get_TrxName())) != null && payLine.get_ID() > 0) {
                aLine = new MAllocationLine(alloc, paymentAmt.multiply(multiplier), Env.ZERO, Env.ZERO, Env.ZERO);
                ((X_C_AllocationLine)aLine).setC_BPartner_ID(payLine.getC_BPartner_ID());
                ((MAllocationLine)aLine).setPaymentInfo(payLine.getC_Payment_ID(), 0);
                ((PO)aLine).saveEx();
                this.log.fine("Allocation Amount=" + paymentAmt);
            }
            List<MUYPayReceiptDoc> ncDef = this.getLinesDocNCDef();
            for (MUYPayReceiptDoc docLine : ncDef) {
                inv = (MInvoice)docLine.getC_Invoice();
                if (inv.getDateAcct().after(this.getDateDoc())) {
                    throw new AdempiereException("Fecha de recibo es menor a fecha de NC diferida '" + inv.getDocumentNo() + "'");
                }
                doc = (MDocType)inv.getC_DocTypeTarget();
                multiplier = Env.ONE;
                BigDecimal amount = docLine.getPayAmt();
                if (doc.getDocBaseType().equalsIgnoreCase("DRC")) {
                    if (amount.compareTo(amtToAllocPay) > 0 && this.getC_Charge_ID() <= 0) {
                        amount = amtToAllocPay;
                    }
                    if (docLine.getPayAmt().compareTo(Env.ZERO) > 0) {
                        multiplier = multiplier.negate();
                    }
                }
                MAllocationLine aLine4 = new MAllocationLine(alloc, amount.multiply(multiplier), docLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
                aLine4.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
                aLine4.setC_BPartner_ID(inv.getC_BPartner_ID());
                aLine4.saveEx();
                amtToAllocPay = amtToAllocPay.subtract(amount);
            }
            if (this.getC_Charge_ID() > 0 && this.getChargeAmt().compareTo(Env.ZERO) != 0) {
                multiplier = Env.ONE;
                if (!this.isSOTrx()) {
                    multiplier = multiplier.negate();
                }
                aLine = new MAllocationLine(alloc, this.getChargeAmt().multiply(multiplier), Env.ZERO, Env.ZERO, Env.ZERO);
                ((X_C_AllocationLine)aLine).setC_BPartner_ID(this.getC_BPartner_ID());
                ((X_C_AllocationLine)aLine).setC_Charge_ID(this.getC_Charge_ID());
                ((PO)aLine).saveEx();
            }
        }
        if (alloc.getLines(true).length <= 0) {
            alloc.deleteEx(true);
            alloc = null;
        }
        if (alloc != null && alloc.get_ID() > 0) {
            if (!alloc.processIt("CO")) {
                throw new AdempiereException(alloc.getProcessMsg());
            }
            alloc.saveEx();
            this.setC_AllocationHdr_ID(alloc.get_ID());
            this.saveEx();
            IsAllocated = true;
        }
        if (IsAllocated) {
            this.testAllocation();
        }
    }

    private void testAllocation() {
        for (MUYPayReceiptDoc mUYPayReceiptDoc : this.getLinesDoc()) {
            int C_Invoice_ID = mUYPayReceiptDoc.getC_Invoice_ID();
            String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
            BigDecimal open = DB.getSQLValueBD(this.get_TrxName(), sql, C_Invoice_ID);
            if (open == null || open.signum() != 0) continue;
            sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
            int n = DB.executeUpdate(sql, this.get_TrxName());
        }
        for (MUYPayReceiptLine mUYPayReceiptLine : this.getLinesGen("")) {
            if (mUYPayReceiptLine.getC_Payment_ID() <= 0) continue;
            int paymentId = mUYPayReceiptLine.getC_Payment_ID();
            MPayment pay = new MPayment(Env.getCtx(), paymentId, this.get_TrxName());
            if (!pay.testAllocation()) continue;
            pay.saveEx();
        }
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    public boolean voidIt() {
        Iterator<PO> alloc;
        String message = "";
        String sql = "";
        if (this.getParent_ID() > 0) {
            MUYPayReceipt receipt = new MUYPayReceipt(this.getCtx(), this.getParent_ID(), this.get_TrxName());
            String tipo = "Cobro";
            if (this.isSOTrx()) {
                tipo = "Pago";
            }
            throw new AdempiereException("No se permite anular manualmente: Generado desde recibo de " + tipo + " Nro. " + receipt.getDocumentNo());
        }
        if (this.getC_AllocationHdr_ID() > 0 && (alloc = (MAllocationHdr)this.getC_AllocationHdr()) != null && ((PO)((Object)alloc)).get_ID() > 0 && ((X_C_AllocationHdr)((Object)alloc)).getDocStatus().equals("CO")) {
            if (!((MAllocationHdr)((Object)alloc)).processIt("VO")) {
                message = ((MAllocationHdr)((Object)alloc)).getProcessMsg();
                throw new AdempiereException(message);
            }
            ((PO)((Object)alloc)).saveEx();
        }
        if (this.get_ValueAsInt("C_PaySelection_ID") == 0) {
            if (this.isSOTrx()) {
                MInvoice inv;
                for (MUYPayReceiptDef def : this.getLinesDef()) {
                    inv = (MInvoice)def.getC_Invoice();
                    if (!inv.isPaid()) {
                        if (!inv.processIt("VO")) {
                            message = inv.getProcessMsg();
                            throw new AdempiereException(message);
                        }
                        inv.saveEx();
                        continue;
                    }
                    throw new AdempiereException("Imposible anular, el cheque Nro. " + inv.getDocumentNo() + " no esta en cartera");
                }
                if (this.get_ValueAsBoolean("IsRepresentation")) {
                    for (MUYPayReceiptDoc doc : this.getLinesDoc("DRC", "")) {
                        inv = (MInvoice)doc.getC_Invoice();
                        if (inv.get_ValueAsInt("UY_PayReceipt_ID") <= 0 || inv.get_ValueAsInt("UY_PayReceipt_ID") != this.get_ID()) continue;
                        if (!inv.processIt("VO")) {
                            message = inv.getProcessMsg();
                            throw new AdempiereException(message);
                        }
                        inv.saveEx();
                    }
                }
            }
            for (MUYPayReceiptLine payLine : this.getLinesGen("")) {
                if (payLine.getC_Payment_ID() <= 0) continue;
                MPayment pay = (MPayment)payLine.getC_Payment();
                if (!pay.processIt("VO")) {
                    message = pay.getProcessMsg();
                    throw new AdempiereException(message);
                }
                pay.saveEx();
            }
        } else {
            sql = "update c_payment set isdelivered = 'N' where c_payment_id in (select c_payment_id from uy_payreceiptline where uy_payreceipt_id = " + this.get_ID() + ")";
            DB.executeUpdateEx(sql, this.get_TrxName());
            DB.executeUpdateEx("update c_payment set uy_payreceipt_id = null where c_payment_id in (select c_payment_id from UY_PayReceiptLine where UY_PayReceipt_ID = " + this.get_ID() + ")", this.get_TrxName());
        }
        sql = "select uy_payreceipt_id from uy_payreceipt where parent_id = " + this.get_ID() + " and docstatus = 'CO'";
        int receiptID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (receiptID > 0) {
            MUYPayReceipt receipt = new MUYPayReceipt(this.getCtx(), receiptID, this.get_TrxName());
            receipt.setDocStatus("VO");
            receipt.setDocAction("--");
            receipt.saveEx();
        }
        DB.executeUpdateEx("delete from c_conversion_rate where ad_table_id = " + Table_ID + " and record_id = " + this.get_ID(), this.get_TrxName());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMsg != null) {
            return false;
        }
        this.log.info("voidIt - " + this.toString());
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        return this.reverseCorrectIt();
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MUYPayReceipt[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    public static MUYPayReceipt getForNoTrx(Properties ctx, int docID, int orgID, int partnerID, String nro) {
        String whereClause = "DocStatus NOT IN ('VO','CL') AND AD_Org_ID=? AND C_DocType_ID=? AND C_BPartner_ID=? AND DocumentNo=?";
        MUYPayReceipt model = (MUYPayReceipt)new Query(ctx, "UY_PayReceipt", "DocStatus NOT IN ('VO','CL') AND AD_Org_ID=? AND C_DocType_ID=? AND C_BPartner_ID=? AND DocumentNo=?", null).setParameters(orgID, docID, partnerID, nro).setOnlyActiveRecords(true).first();
        return model;
    }

    public static MUYPayReceipt getForTrx(Properties ctx, int docID, int orgID, String nro) {
        String whereClause = "DocStatus NOT IN ('VO','CL') AND AD_Org_ID=? AND C_DocType_ID=? AND DocumentNo=?";
        MUYPayReceipt model = (MUYPayReceipt)new Query(ctx, "UY_PayReceipt", "DocStatus NOT IN ('VO','CL') AND AD_Org_ID=? AND C_DocType_ID=? AND DocumentNo=?", null).setParameters(orgID, docID, nro).setOnlyActiveRecords(true).first();
        return model;
    }
}

