/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MSequence;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.openup.core.model.X_UY_ChangeOperation;

public class MUYChangeOperation
extends X_UY_ChangeOperation
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20180509L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MUYChangeOperation(Properties ctx, int UY_ChangeOperation_ID, String trxName) {
        super(ctx, UY_ChangeOperation_ID, trxName);
    }

    public MUYChangeOperation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.getCurrencyAmt() != this.getC_Currency_ID() && this.getCurrencyAmt() != this.getC_Currency_ID_To()) {
            throw new AdempiereException("Moneda de importe debe ser igual a moneda de una de las cuentas seleccionadas");
        }
        if (this.getPayAmt().compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("Importe debe ser mayor a cero");
        }
        this.executeOperation();
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("VO");
        return "CO";
    }

    private void executeOperation() {
        if (this.getCurrencyRate() == null || this.getCurrencyRate().compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("No hay tasa de cambio");
        }
        MBankAccount accountFrom = (MBankAccount)this.getC_BankAccount();
        MBankAccount accountTo = new MBankAccount(this.getCtx(), this.getC_BankAccount_ID_To(), this.get_TrxName());
        MClient client = new MClient(this.getCtx(), this.getAD_Client_ID(), null);
        MAcctSchema schema = client.getAcctSchema();
        int acctCurrID = schema.getC_Currency_ID();
        String secNumber = null;
        int seqID = MSequence.getNextID_ForName(this.getAD_Client_ID(), "DocNo_ChangeOperationDoc", this.get_TrxName());
        if (seqID <= 0) {
            throw new AdempiereException("No se obtuvo secuencia de numero de documento para pago/cobro a generar");
        }
        secNumber = String.valueOf(seqID).trim();
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(this.getC_BankAccount_ID());
        paymentBankFrom.setDocumentNo(secNumber);
        paymentBankFrom.setDateAcct(this.getDateDoc());
        paymentBankFrom.setDateTrx(this.getDateDoc());
        paymentBankFrom.setDescription("Generado desde Operaci\u00f3n de Cambio Nro. " + this.getDocumentNo());
        paymentBankFrom.setC_BPartner_ID(this.getC_BPartner_ID());
        paymentBankFrom.setC_ConversionType_ID(201);
        if (this.getPaymentRule().equalsIgnoreCase("S")) {
            paymentBankFrom.setTenderType("K");
            if (this.getCheckNo() != null) {
                paymentBankFrom.setCheckNo(this.getCheckNo());
            }
        } else if (this.getPaymentRule().equalsIgnoreCase("T")) {
            paymentBankFrom.setTenderType("A");
        } else if (this.getPaymentRule().equalsIgnoreCase("B")) {
            paymentBankFrom.setTenderType("X");
        }
        if (accountFrom.getC_Currency_ID() == this.getCurrencyAmt()) {
            paymentBankFrom.setPayAmt(this.getPayAmt());
            paymentBankFrom.setC_Currency_ID(this.getCurrencyAmt());
        } else {
            if (this.getCurrencyAmt() != acctCurrID && accountFrom.getC_Currency_ID() == acctCurrID) {
                paymentBankFrom.setPayAmt(this.getPayAmt().multiply(this.getCurrencyRate()).setScale(2, RoundingMode.HALF_UP));
            } else if (this.getCurrencyAmt() == acctCurrID && accountFrom.getC_Currency_ID() != acctCurrID) {
                paymentBankFrom.setPayAmt(this.getPayAmt().divide(this.getCurrencyRate(), 2, RoundingMode.HALF_UP));
            }
            paymentBankFrom.setC_Currency_ID(accountFrom.getC_Currency_ID());
        }
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(this.getC_Charge_ID());
        paymentBankFrom.saveEx();
        paymentBankFrom.processIt("CO");
        this.setC_Payment_ID(paymentBankFrom.get_ID());
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(accountTo.getC_BankAccount_ID());
        paymentBankTo.setDocumentNo(secNumber);
        paymentBankTo.setDateAcct(this.getDateDoc());
        paymentBankTo.setDateTrx(this.getDateDoc());
        paymentBankTo.setDescription("Generado desde Operaci\u00f3n de Cambio Nro. " + this.getDocumentNo());
        paymentBankTo.setC_BPartner_ID(this.getC_BPartner_ID());
        paymentBankTo.setC_ConversionType_ID(201);
        if (this.getPaymentRule_To().equalsIgnoreCase("S")) {
            paymentBankTo.setTenderType("K");
            if (this.getCheckNo_To() != null) {
                paymentBankTo.setCheckNo(this.getCheckNo_To());
            }
        } else if (this.getPaymentRule_To().equalsIgnoreCase("T")) {
            paymentBankTo.setTenderType("A");
        } else if (this.getPaymentRule_To().equalsIgnoreCase("B")) {
            paymentBankTo.setTenderType("X");
        }
        if (accountTo.getC_Currency_ID() == this.getCurrencyAmt()) {
            paymentBankTo.setPayAmt(this.getPayAmt());
            paymentBankTo.setC_Currency_ID(this.getCurrencyAmt());
        } else {
            if (this.getCurrencyAmt() != acctCurrID && accountTo.getC_Currency_ID() == acctCurrID) {
                paymentBankTo.setPayAmt(this.getPayAmt().multiply(this.getCurrencyRate()).setScale(2, RoundingMode.HALF_UP));
            } else if (this.getCurrencyAmt() == acctCurrID && accountTo.getC_Currency_ID() != acctCurrID) {
                paymentBankTo.setPayAmt(this.getPayAmt().divide(this.getCurrencyRate(), 2, RoundingMode.HALF_UP));
            }
            paymentBankTo.setC_Currency_ID(accountTo.getC_Currency_ID());
        }
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(this.getC_Charge_ID());
        paymentBankTo.saveEx();
        paymentBankTo.processIt("CO");
        this.setC_Payment_ID_To(paymentBankTo.get_ID());
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    public boolean voidIt() {
        String message = "";
        MPayment pay = null;
        if (this.getC_Payment_ID() > 0 && (pay = (MPayment)this.getC_Payment()) != null && pay.get_ID() > 0) {
            if (!pay.processIt("VO")) {
                message = pay.getProcessMsg();
                throw new AdempiereException(message);
            }
            pay.saveEx();
        }
        if (this.getC_Payment_ID_To() > 0 && (pay = new MPayment(this.getCtx(), this.getC_Payment_ID_To(), this.get_TrxName())) != null && pay.get_ID() > 0) {
            if (!pay.processIt("VO")) {
                message = pay.getProcessMsg();
                throw new AdempiereException(message);
            }
            pay.saveEx();
        }
        DB.executeUpdateEx("update uy_changeoperation set c_payment_id = null, c_payment_id_to = null where uy_changeoperation_id = " + this.get_ID(), this.get_TrxName());
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        MBankAccount accountFrom = (MBankAccount)this.getC_BankAccount();
        MBankAccount accountTo = new MBankAccount(this.getCtx(), this.getC_BankAccount_ID_To(), this.get_TrxName());
        if (newRecord) {
            BigDecimal rate = Env.ZERO;
            if (accountFrom.getC_Currency_ID() == 100 && accountTo.getC_Currency_ID() == 142) {
                rate = MConversionRate.getRate(100, 142, this.getDateDoc(), 201, this.getAD_Client_ID(), this.getAD_Org_ID());
            } else if (accountFrom.getC_Currency_ID() == 142 && accountTo.getC_Currency_ID() == 100) {
                rate = MUYChangeOperation.getDivideRate(142, 100, this.getDateDoc(), 201, this.getAD_Client_ID(), this.getAD_Org_ID());
            }
            if (rate == null || rate.compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("No se encuentra tasa de cambio para la fecha y monedas del documento");
            }
            DB.executeUpdateEx("update uy_changeoperation set currencyrate = " + rate + " where uy_changeoperation_id = " + this.get_ID(), this.get_TrxName());
            if (this.getPayAmt().compareTo(Env.ZERO) > 0) {
                BigDecimal amtConv = Env.ZERO;
                if (this.getCurrencyAmt() == 100) {
                    amtConv = this.getPayAmt().multiply(rate);
                } else if (this.getCurrencyAmt() == 142) {
                    amtConv = this.getPayAmt().divide(rate, 4);
                }
                amtConv = amtConv.setScale(2, 4);
                DB.executeUpdateEx("update uy_changeoperation set convertedamt = " + amtConv + " where uy_changeoperation_id = " + this.get_ID(), this.get_TrxName());
            }
        }
        return true;
    }

    public static BigDecimal getDivideRate(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (CurFrom_ID == CurTo_ID) {
            return Env.ONE;
        }
        int C_ConversionType_ID = ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
        }
        if (ConvDate == null) {
            ConvDate = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        }
        String sql = "SELECT DivideRate FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND\t? BETWEEN ValidFrom AND ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC";
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, CurFrom_ID);
            pstmt.setInt(2, CurTo_ID);
            pstmt.setInt(3, C_ConversionType_ID);
            pstmt.setTimestamp(4, ConvDate);
            pstmt.setInt(5, AD_Client_ID);
            pstmt.setInt(6, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            retValue = Env.ZERO;
        }
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MBankAccount accountFrom = (MBankAccount)this.getC_BankAccount();
        MBankAccount accountTo = new MBankAccount(this.getCtx(), this.getC_BankAccount_ID_To(), this.get_TrxName());
        if (accountFrom.getC_Currency_ID() == accountTo.getC_Currency_ID()) {
            throw new AdempiereException("Las cuentas bancarias tienen igual moneda");
        }
        if (!newRecord && (this.is_ValueChanged("DateDoc") || this.is_ValueChanged("C_BankAccount_ID") || this.is_ValueChanged("C_BankAccount_ID_To"))) {
            BigDecimal rate = Env.ZERO;
            if (accountFrom.getC_Currency_ID() == 100 && accountTo.getC_Currency_ID() == 142) {
                rate = MConversionRate.getRate(100, 142, this.getDateDoc(), 201, Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()));
            } else if (accountFrom.getC_Currency_ID() == 142 && accountTo.getC_Currency_ID() == 100) {
                rate = MUYChangeOperation.getDivideRate(142, 100, this.getDateDoc(), 201, Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()));
            }
            if (rate != null && rate.compareTo(Env.ZERO) > 0) {
                this.setCurrencyRate(rate);
            } else {
                throw new AdempiereException("No se encuentra tasa de cambio para la fecha y monedas del documento");
            }
        }
        if (this.getPayAmt().compareTo(Env.ZERO) > 0) {
            BigDecimal amtConv = Env.ZERO;
            if (this.getCurrencyAmt() == 100) {
                amtConv = this.getPayAmt().multiply(this.getCurrencyRate());
            } else if (this.getCurrencyAmt() == 142) {
                amtConv = this.getPayAmt().divide(this.getCurrencyRate(), 4);
            }
            this.setConvertedAmt(amtConv.setScale(2, 4));
        }
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        return this.reverseCorrectIt();
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MUYChangeOperation[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        int newIndex = 0;
        if (docStatus.equalsIgnoreCase("DR") || docStatus.equalsIgnoreCase("IN") || docStatus.equalsIgnoreCase("IP")) {
            options[newIndex++] = "CO";
        } else if (docStatus.equalsIgnoreCase("CO")) {
            options[newIndex++] = "VO";
        }
        return newIndex;
    }
}

