/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.openup.LUY.cfe.dto.generic.cfe.CAEDataType;
import org.openup.LUY.cfe.dto.generic.cfe.CFEDefType;
import org.openup.LUY.model.MLUYCAE;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.LUY.model.MLUYSender;

public class CFEUtils {
    public static final String DOCUMENTTYPE_RUT = "rut";

    public static BiMap<String, CfeType> getCfeTypes() {
        HashBiMap<String, CfeType> ret = HashBiMap.create();
        ret.put("101", CfeType.eTicket);
        ret.put("102", CfeType.eTicket_NC);
        ret.put("103", CfeType.eTicket_ND);
        ret.put("111", CfeType.eFactura);
        ret.put("112", CfeType.eFactura_NC);
        ret.put("113", CfeType.eFactura_ND);
        ret.put("181", CfeType.eRemito);
        ret.put("182", CfeType.eResguardo);
        ret.put("131", CfeType.eTicket_VxCA);
        ret.put("132", CfeType.eTicket_NC_VxCA);
        ret.put("133", CfeType.eTicket_ND_VxCA);
        ret.put("141", CfeType.eFactura_VxCA);
        ret.put("142", CfeType.eFactura_NC_VxCA);
        ret.put("143", CfeType.eFactura_ND_VxCA);
        ret.put("121", CfeType.eFactura_Exp);
        ret.put("122", CfeType.eFactura_NC_Exp);
        ret.put("123", CfeType.eFactura_ND_Exp);
        return ret;
    }

    public static String md5Encrypt(String input) {
        String md5 = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            BigInteger hash = new BigInteger(1, md.digest(input.getBytes("utf-8")));
            md5 = hash.toString(16);
            while (md5.length() < 32) {
                md5 = '0' + md5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5;
    }

    public static XMLGregorianCalendar Timestamp_to_XmlGregorianCalendar_OnlyDate(Timestamp timestamp, boolean withTime) {
        try {
            XMLGregorianCalendar xgcal;
            GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance();
            cal.setTime(timestamp);
            if (!withTime) {
                xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
            } else {
                xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
                xgcal.setHour(cal.get(11));
                xgcal.setMinute(cal.get(12));
                xgcal.setSecond(cal.get(13));
                xgcal.setMillisecond(cal.get(14));
                xgcal.setTimezone(-180);
            }
            return xgcal;
        }
        catch (DatatypeConfigurationException e) {
            throw new AdempiereException(e);
        }
    }

    public static void loadCAE(String trxName, Properties ctx, MLUYSender mluySender, CFEDefType objCfe, MDocType mDocType, CfeType cfeType, int AD_Client_ID, int AD_Org_ID) {
        CAEDataType caeDataType = new CAEDataType();
        switch (cfeType) {
            case eFactura: 
            case eFactura_NC: 
            case eFactura_ND: 
            case eFactura_VxCA: 
            case eFactura_NC_VxCA: 
            case eFactura_ND_VxCA: {
                objCfe.getEFact().setCAEData(caeDataType);
                break;
            }
            case eTicket: 
            case eTicket_NC: 
            case eTicket_ND: 
            case eTicket_VxCA: 
            case eTicket_NC_VxCA: 
            case eTicket_ND_VxCA: {
                objCfe.getETck().setCAEData(caeDataType);
            }
        }
        MLUYCAE mluycae = (MLUYCAE)new Query(ctx, "LUY_CAE", "CFEType=? AND IsActive=? AND LUY_Sender_ID=?", trxName).setParameters(CFEUtils.getCfeTypes().inverse().get((Object)cfeType), "Y", mluySender.get_ID()).first();
        if (mluycae == null || mluycae.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: El tipo de CFE no es un tipo aceptado por DGI");
        }
        caeDataType.setCAEID(new BigDecimal(mluycae.getDocumentNo()).toBigInteger());
        caeDataType.setDNro(BigInteger.valueOf(mluycae.getStartNo()));
        caeDataType.setHNro(BigInteger.valueOf(mluycae.getEndNo()));
        caeDataType.setFecVenc(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(mluycae.getEndDate(), false));
    }

    public static CfeType getCFETypeFromDoc(Properties ctx, MDocType mDocType, String trxName, int AD_Client_ID, int AD_Org_ID) {
        MLUYCFEType mluycfeType;
        CfeType ret = null;
        if (mDocType != null && mDocType.get_ID() > 0 && (mluycfeType = (MLUYCFEType)new Query(ctx, "LUY_CFEType", "C_DocType_ID=? AND IsActive=? AND AD_Client_ID=? AND AD_Org_ID=?", trxName).setParameters(mDocType.get_ID(), "Y", AD_Client_ID, AD_Org_ID).first()) != null && mluycfeType.get_ID() > 0) {
            ret = (CfeType)((Object)CFEUtils.getCfeTypes().get(mluycfeType.getCFEType()));
        }
        return ret;
    }

    public static boolean isCFEtoSend(Properties ctx, String trxName, PO po) {
        if (po.get_Table_ID() == I_C_Invoice.Table_ID) {
            MInvoice mInvoice = (MInvoice)po;
            MDocType mDocType = (MDocType)mInvoice.getC_DocTypeTarget();
            CfeType cfeType = CFEUtils.getCFETypeFromDoc(ctx, mDocType, trxName, mInvoice.getAD_Client_ID(), mInvoice.getAD_Org_ID());
            if (cfeType == null) {
                return false;
            }
            if (cfeType.is(CfeType.eResguardo)) {
                return true;
            }
            if (cfeType.is(CfeType.eTicket, CfeType.eTicket_NC, CfeType.eTicket_ND, CfeType.eFactura, CfeType.eFactura_NC, CfeType.eFactura_ND, CfeType.eTicket_VxCA, CfeType.eTicket_NC_VxCA, CfeType.eTicket_ND_VxCA, CfeType.eFactura_VxCA, CfeType.eFactura_NC_VxCA, CfeType.eFactura_ND_VxCA) && mInvoice.getReversal_ID() == 0) {
                return true;
            }
        }
        return false;
    }

    public static enum CfeType {
        eTicket,
        eTicket_NC,
        eTicket_ND,
        eFactura,
        eFactura_NC,
        eFactura_ND,
        eRemito,
        eResguardo,
        eTicket_VxCA,
        eTicket_NC_VxCA,
        eTicket_ND_VxCA,
        eFactura_VxCA,
        eFactura_NC_VxCA,
        eFactura_ND_VxCA,
        eFactura_Exp,
        eFactura_NC_Exp,
        eFactura_ND_Exp;


        public boolean is(CfeType ... expected) {
            return Arrays.asList(expected).contains((Object)this);
        }
    }
}

