/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.util;

import java.math.BigInteger;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCity;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRegion;
import org.openup.LUY.cfe.dto.generic.cfe.Emisor;

public class CFEGenericData {
    public static Emisor loadEmisor(MOrg mOrg, MOrgInfo mOrgInfo, MBPartner bpSender, Properties ctx, String trxName) {
        Emisor emisor = new Emisor();
        if (bpSender.getTaxID() == null) {
            throw new AdempiereException("CFE Error: Area Emisor (40) - RUT no establecido");
        }
        emisor.setRUCEmisor(bpSender.getTaxID());
        if (bpSender.getName() == null) {
            throw new AdempiereException("CFE Error: Area Emisor (41) - Razon Social no establecida");
        }
        emisor.setRznSoc(bpSender.getName());
        if (mOrgInfo.getPhone() != null) {
            emisor.getTelefono().add(mOrgInfo.getPhone());
        }
        emisor.setCorreoEmisor(mOrgInfo.getEMail());
        MLocation mLocationBp = (MLocation)mOrgInfo.getC_Location();
        emisor.setEmiSucursal(mOrg.getName());
        try {
            emisor.setCdgDGISucur(BigInteger.valueOf(bpSender.get_ValueAsInt("ReferenceNo")));
        }
        catch (Exception ex) {
            throw new AdempiereException("CFE Error: Area Emisor (47) - Identificador de DGI para local no establecido");
        }
        emisor.setDomFiscal(mLocationBp.getAddress1());
        MCity mCity = (MCity)mLocationBp.getC_City();
        if (mCity == null || mCity.getName() == null) {
            throw new AdempiereException("CFE Error: Area Emisor (49) - Ciudad para domicilio fiscal no establecida");
        }
        emisor.setCiudad(mCity.getName());
        MRegion mDepartamentos = (MRegion)mLocationBp.getC_Region();
        if (mDepartamentos == null || mDepartamentos.getName() == null) {
            throw new AdempiereException("CFE Error: Area Emisor (50) - Departamento para domicilio fiscal no establecido");
        }
        emisor.setDepartamento(mDepartamentos.getName());
        return emisor;
    }
}

