/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MRegion;
import org.compiere.model.MSequence;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.LUY.model.MLUYCertificate;
import org.openup.LUY.model.MLUYCertificateLine;
import org.openup.LUY.model.MLUYSender;
import org.openup.LUY.model.MLUYVendor;
import org.openup.LUY.model.MLUYVendorInvoicy;

public class CreateOrgCFEConfig
extends SvrProcess {
    private static CLogger log = CLogger.getCLogger(CreateOrgCFEConfig.class);
    private final String GL_CATEGORY_NAME = "AR Invoice";
    private final String UI_ISO_CODE = "UI";
    private final String TG_RUT = "RUT";
    private int p_ad_client_id;
    private int p_ad_org_id;
    private String p_c_bp_RUT;
    private String p_c_bp_BusinessName;
    private String p_c_bp_FantasyName;
    private String p_c_bp_Address;
    private int p_c_bp_City;
    private int p_c_bp_State;
    private int p_c_bp_Country;
    private String p_vendorinvoicy_endpoint;
    private String p_vendorinvoicy_integrationCode;
    private String p_vendorinvoicy_invoicyCK;
    private String p_vendorinvoicy_invoicyPK;
    private ArrayList<Integer> cfeTypes;
    private BigDecimal p_ui_rate;

    @Override
    protected void prepare() {
        this.cfeTypes = new ArrayList();
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (name == null) continue;
            if (name.equalsIgnoreCase("AD_Client_ID")) {
                this.p_ad_client_id = para.getParameterAsBigDecimal().intValue();
                continue;
            }
            if (name.equalsIgnoreCase("AD_Org_ID")) {
                this.p_ad_org_id = para.getParameterAsBigDecimal().intValue();
                continue;
            }
            if (name.equalsIgnoreCase("TaxID")) {
                this.p_c_bp_RUT = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("Name")) {
                this.p_c_bp_BusinessName = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("Name2")) {
                this.p_c_bp_FantasyName = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("Address1")) {
                this.p_c_bp_Address = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("C_City_ID")) {
                this.p_c_bp_City = para.getParameterAsBigDecimal().intValue();
                continue;
            }
            if (name.equalsIgnoreCase("C_Region_ID")) {
                this.p_c_bp_State = para.getParameterAsBigDecimal().intValue();
                continue;
            }
            if (name.equalsIgnoreCase("C_Country_ID")) {
                this.p_c_bp_Country = para.getParameterAsBigDecimal().intValue();
                continue;
            }
            if (name.equalsIgnoreCase("VendorEndpoint")) {
                this.p_vendorinvoicy_endpoint = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("VendorIntegrationCode")) {
                this.p_vendorinvoicy_integrationCode = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("VendorPK")) {
                this.p_vendorinvoicy_invoicyPK = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("VendorCK")) {
                this.p_vendorinvoicy_invoicyCK = para.getParameterAsString();
                continue;
            }
            if (name.equalsIgnoreCase("CFE_101") && para.getParameterAsBoolean()) {
                this.cfeTypes.add(101);
                continue;
            }
            if (name.equalsIgnoreCase("CFE_102") && para.getParameterAsBoolean()) {
                this.cfeTypes.add(102);
                continue;
            }
            if (name.equalsIgnoreCase("CFE_103") && para.getParameterAsBoolean()) {
                this.cfeTypes.add(103);
                continue;
            }
            if (name.equalsIgnoreCase("CFE_111") && para.getParameterAsBoolean()) {
                this.cfeTypes.add(111);
                continue;
            }
            if (name.equalsIgnoreCase("CFE_112") && para.getParameterAsBoolean()) {
                this.cfeTypes.add(112);
                continue;
            }
            if (name.equalsIgnoreCase("CFE_113") && para.getParameterAsBoolean()) {
                this.cfeTypes.add(113);
                continue;
            }
            if (name.equalsIgnoreCase("CFE_181") && para.getParameterAsBoolean()) {
                this.cfeTypes.add(181);
                continue;
            }
            if (!name.equalsIgnoreCase("Rate")) continue;
            this.p_ui_rate = para.getParameterAsBigDecimal();
        }
        this.addLog("AD_Client_ID      = " + this.p_ad_client_id);
        this.addLog("AD_Org_ID         = " + this.p_ad_org_id);
        this.addLog("C_BP RUT          = " + this.p_c_bp_RUT);
        this.addLog("C_BP BusinessName = " + this.p_c_bp_BusinessName);
        this.addLog("C_BP FantasyName  = " + this.p_c_bp_FantasyName);
        this.addLog("C_BP Address      = " + this.p_c_bp_Address);
        this.addLog("C_BP Loc City     = " + this.p_c_bp_City);
        this.addLog("C_BP Loc State    = " + this.p_c_bp_State);
        this.addLog("C_BP Loc Country  = " + this.p_c_bp_Country);
        this.addLog("Vendor Endpoint   = " + this.p_vendorinvoicy_endpoint);
        this.addLog("Vendor Int Code   = " + this.p_vendorinvoicy_integrationCode);
        this.addLog("Vendor CK         = " + this.p_vendorinvoicy_invoicyCK);
        this.addLog("Vendor PC         = " + this.p_vendorinvoicy_invoicyPK);
        for (Integer cfeType : this.cfeTypes) {
            this.addLog("CFE " + cfeType + " added");
        }
        this.addLog("UI Curr Rate      = " + this.p_ui_rate);
    }

    @Override
    protected String doIt() throws Exception {
        Timestamp tstmpUI;
        MOrg mOrg = new MOrg(this.getCtx(), this.p_ad_org_id, this.get_TrxName());
        String p_c_value = mOrg.getValue();
        MBPartner mbpCfe = (MBPartner)new Query(this.getCtx(), "C_BPartner", "AD_Client_ID=? AND AD_Org_ID=? AND Value=?", this.get_TrxName()).setParameters(this.p_ad_client_id, this.p_ad_org_id, "CFE" + p_c_value).first();
        if (mbpCfe != null) {
            throw new AdempiereException("C_BP.Value ya existente: CFE" + p_c_value + " (AD_Client_ID=" + this.p_ad_client_id + ", AD_Org_ID=" + this.p_ad_org_id + ")");
        }
        mbpCfe = new MBPartner(this.getCtx(), 0, this.get_TrxName());
        mbpCfe.setClientOrg(this.p_ad_client_id, this.p_ad_org_id);
        mbpCfe.setValue("CFE " + p_c_value);
        mbpCfe.setName(this.p_c_bp_BusinessName);
        mbpCfe.setName2(this.p_c_bp_FantasyName);
        mbpCfe.setTaxID(this.p_c_bp_RUT);
        mbpCfe.setC_TaxGroup_ID(new Query(this.getCtx(), "C_TaxGroup", "Value=?", this.get_TrxName()).setParameters("RUT").firstId());
        mbpCfe.saveEx();
        this.addLog("C_BP created");
        MCity mCity = new MCity(this.getCtx(), this.p_c_bp_City, this.get_TrxName());
        MRegion mRegion = new MRegion(this.getCtx(), this.p_c_bp_State, this.get_TrxName());
        MLocation mLocCfe = new MLocation(this.getCtx(), 0, this.get_TrxName());
        mLocCfe.setAD_Org_ID(this.p_ad_org_id);
        mLocCfe.setC_Country_ID(this.p_c_bp_Country);
        mLocCfe.setC_Region_ID(this.p_c_bp_State);
        mLocCfe.setRegionName(mRegion.getName());
        mLocCfe.setC_City_ID(this.p_c_bp_City);
        mLocCfe.setCity(mCity.getName());
        mLocCfe.setAddress1(this.p_c_bp_Address);
        mLocCfe.saveEx();
        this.addLog("C_Location created");
        MBPartnerLocation mbpLocCfe = new MBPartnerLocation(this.getCtx(), 0, this.get_TrxName());
        mbpLocCfe.setAD_Org_ID(this.p_ad_org_id);
        mbpLocCfe.setC_Location_ID(mLocCfe.get_ID());
        mbpLocCfe.setC_BPartner_ID(mbpCfe.get_ID());
        mbpLocCfe.setIsBillTo(true);
        mbpLocCfe.saveEx();
        this.addLog("C_BP_Location created");
        MLUYSender mluySender = (MLUYSender)new Query(this.getCtx(), "LUY_Sender", "AD_Client_ID=? AND AD_Org_ID=?", this.get_TrxName()).setParameters(this.p_ad_client_id, this.p_ad_org_id).first();
        if (mluySender != null) {
            throw new AdempiereException("LUY Sender ya existente: (AD_Client_ID=" + this.p_ad_client_id + ", AD_Org_ID=" + this.p_ad_org_id + ")");
        }
        mluySender = new MLUYSender(this.getCtx(), 0, this.get_TrxName());
        mluySender.setAD_Org_ID(this.p_ad_org_id);
        mluySender.setC_BPartner_ID(mbpCfe.get_ID());
        mluySender.setName("Sender " + p_c_value);
        mluySender.setWayMethod("DTO");
        mluySender.saveEx();
        this.addLog("Sender created");
        MLUYVendor mluyVendor = (MLUYVendor)new Query(this.getCtx(), "LUY_Vendor", "AD_Client_ID=? AND AD_Org_ID=?", this.get_TrxName()).setParameters(this.p_ad_client_id, this.p_ad_org_id).first();
        if (mluyVendor != null) {
            throw new AdempiereException("LUY Provider ya existente: (AD_Client_ID=" + this.p_ad_client_id + ", AD_Org_ID=" + this.p_ad_org_id + ")");
        }
        mluyVendor = new MLUYVendor(this.getCtx(), 0, this.get_TrxName());
        mluyVendor.setAD_Org_ID(this.p_ad_org_id);
        mluyVendor.setC_BPartner_ID(mbpCfe.get_ID());
        mluyVendor.setClassname("org.openup.LUY.engine.vendor.LUYInvoicyService");
        mluyVendor.setPassword("1234");
        mluyVendor.saveEx();
        this.addLog("Vendor created");
        MLUYVendorInvoicy mluyVendorInvoicy = new MLUYVendorInvoicy(this.getCtx(), 0, this.get_TrxName());
        mluyVendorInvoicy.setAD_Org_ID(this.p_ad_org_id);
        mluyVendorInvoicy.setLUY_Vendor_ID(mluyVendor.get_ID());
        mluyVendorInvoicy.setEndPoint(this.p_vendorinvoicy_endpoint);
        mluyVendorInvoicy.setValueNumber(new BigDecimal(this.p_vendorinvoicy_integrationCode));
        mluyVendorInvoicy.setInvoiCyCK(this.p_vendorinvoicy_invoicyCK);
        mluyVendorInvoicy.setInvoiCyPK(this.p_vendorinvoicy_invoicyPK);
        mluyVendorInvoicy.saveEx();
        this.addLog("Vendor InvoiCy created");
        MLUYCertificate mluyCertificate = new MLUYCertificate(this.getCtx(), 0, this.get_TrxName());
        mluyCertificate.set_ValueOfColumn("AD_Client_ID", (Object)this.p_ad_client_id);
        mluyCertificate.setAD_Org_ID(this.p_ad_org_id);
        mluyCertificate.setName("Certificado " + p_c_value);
        mluyCertificate.setPassword("1234");
        mluyCertificate.saveEx();
        this.addLog("Certificate created");
        for (Integer cfeType : this.cfeTypes) {
            MLUYCFEType mluycfeType = (MLUYCFEType)new Query(this.getCtx(), "LUY_CFEType", "AD_Client_ID=? AND AD_Org_ID=? AND CFEType=?", this.get_TrxName()).setParameters(this.p_ad_client_id, this.p_ad_org_id, String.valueOf(cfeType)).first();
            if (mluycfeType != null) {
                throw new AdempiereException("Tipo de Documento " + this.CFENroToStr(cfeType) + " ya definido");
            }
            MDocType mDocType = new MDocType(this.getCtx(), 0, this.get_TrxName());
            mDocType.setAD_Org_ID(this.p_ad_org_id);
            String docName = this.CFENroToStr(cfeType) + " " + p_c_value;
            mDocType.setName(docName);
            mDocType.setDescription(docName);
            mDocType.setPrintName(this.CFENroToStr(cfeType));
            mDocType.setPrintDocument("2");
            if (cfeType == 101 || cfeType == 102 || cfeType == 103 || cfeType == 111 || cfeType == 112 || cfeType == 113) {
                MGLCategory mglCategory = (MGLCategory)new Query(this.getCtx(), "GL_Category", "Name=? AND AD_Client_ID=?", this.getTableName()).setParameters("AR Invoice", this.p_ad_client_id).first();
                if (mglCategory == null) {
                    throw new AdempiereException("GL_Category AR Invoice not defined for AD_Client_ID=" + this.p_ad_client_id);
                }
                mDocType.setGL_Category_ID(mglCategory.get_ID());
                mDocType.setIsSOTrx(true);
                if (cfeType == 101 || cfeType == 103 || cfeType == 111 || cfeType == 113) {
                    mDocType.setDocBaseType("ARI");
                } else if (cfeType == 102 || cfeType == 112) {
                    mDocType.setDocBaseType("ARC");
                }
            } else {
                throw new AdempiereException("CFE Type unsupported: " + cfeType);
            }
            mDocType.setIsDocNoControlled(true);
            mDocType.setIsOverwriteSeqOnComplete(true);
            mDocType.setIsCopyDocNoOnReversal(true);
            mDocType.setIsCreateCounter(true);
            MSequence draftSeq = new MSequence(this.getCtx(), 0, this.get_TrxName());
            draftSeq.setAD_Org_ID(this.p_ad_org_id);
            draftSeq.setName("DRAFT " + docName);
            draftSeq.setIsAutoSequence(true);
            draftSeq.setIncrementNo(1);
            draftSeq.setCurrentNext(1000);
            draftSeq.setPrefix("DR-");
            draftSeq.saveEx();
            this.addLog("Draft Sequence created: " + this.CFENroToStr(cfeType));
            mDocType.setDocNoSequence_ID(draftSeq.get_ID());
            MSequence defSeq = new MSequence(this.getCtx(), 0, this.get_TrxName());
            defSeq.setAD_Org_ID(this.p_ad_org_id);
            defSeq.setName(docName);
            defSeq.setIsAutoSequence(true);
            defSeq.setIncrementNo(1);
            defSeq.setCurrentNext(1);
            defSeq.setPrefix("A");
            defSeq.saveEx();
            this.addLog("Definite Sequence created: " + this.CFENroToStr(cfeType));
            mDocType.setDefiniteSequence_ID(defSeq.get_ID());
            mDocType.saveEx();
            this.addLog("MDoctype created: " + this.CFENroToStr(cfeType));
            mluycfeType = new MLUYCFEType(this.getCtx(), 0, this.get_TrxName());
            mluycfeType.setAD_Org_ID(this.p_ad_org_id);
            mluycfeType.setC_DocType_ID(mDocType.get_ID());
            mluycfeType.setCFEType(String.valueOf(cfeType));
            if (cfeType == 101 || cfeType == 102 || cfeType == 103) {
                mluycfeType.set_ValueOfColumn("Type", (Object)1);
            } else {
                mluycfeType.set_ValueOfColumn("Type", (Object)2);
            }
            mluycfeType.saveEx();
            this.addLog("LUY CFE Type created: " + this.CFENroToStr(cfeType));
            MLUYCertificateLine mluyCertificateLine = new MLUYCertificateLine(this.getCtx(), 0, this.get_TrxName());
            mluyCertificateLine.setAD_Org_ID(this.p_ad_org_id);
            mluyCertificateLine.setLUY_Certificate_ID(mluyCertificate.getLUY_Certificate_ID());
            mluyCertificateLine.setC_DocType_ID(mDocType.get_ID());
            mluyCertificateLine.setLUY_Vendor_ID(mluyVendor.get_ID());
            mluyCertificateLine.saveEx();
            this.addLog("Certificate Line created: " + this.CFENroToStr(cfeType));
        }
        MCurrency uiCurrency = (MCurrency)new Query(this.getCtx(), "C_Currency", "ISO_Code=?", this.get_TrxName()).setParameters("UI").first();
        if (uiCurrency == null) {
            uiCurrency = new MCurrency(this.getCtx(), 0, this.get_TrxName());
            uiCurrency.set_ValueOfColumn("AD_Client_ID", (Object)0);
            uiCurrency.setAD_Org_ID(0);
            uiCurrency.setISO_Code("UI");
            uiCurrency.setCurSymbol("UI");
            uiCurrency.setDescription("Unidad Indexada");
            uiCurrency.setIsActive(true);
            uiCurrency.setStdPrecision(2);
            uiCurrency.setCostingPrecision(4);
            uiCurrency.saveEx();
            this.addLog("UI Currency created");
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.add(1, -1);
            String prevYear = new SimpleDateFormat("yyyy").format(new Timestamp(cal.getTimeInMillis()));
            tstmpUI = new Timestamp(new SimpleDateFormat("ddMMyyyy").parse("3112" + prevYear).getTime());
        }
        catch (Exception e) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado - No se puede obtener la fecha para la tasa de cambio de UI");
        }
        BigDecimal currRateUI = MConversionRate.getRate(uiCurrency.get_ID(), 142, tstmpUI, 0, this.p_ad_client_id, this.p_ad_org_id);
        if (currRateUI == null || currRateUI.compareTo(Env.ZERO) == 0) {
            MConversionRate uiRate = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
            uiRate.setAD_Org_ID(this.p_ad_org_id);
            uiRate.setMultiplyRate(this.p_ui_rate);
            uiRate.setDivideRate(Env.ONE.divide(this.p_ui_rate, 4));
            uiRate.setC_Currency_ID(uiCurrency.getC_Currency_ID());
            uiRate.setC_Currency_ID_To(142);
            uiRate.setC_ConversionType_ID(114);
            uiRate.saveEx();
            this.addLog("Currency Rate UI created");
        }
        return "Configuraci\u00f3n Realizada !!!";
    }

    private String CFENroToStr(int nro) {
        if (nro == 101) {
            return "e-Ticket";
        }
        if (nro == 102) {
            return "e-Ticket NC";
        }
        if (nro == 103) {
            return "e-Ticket ND";
        }
        if (nro == 111) {
            return "e-Factura";
        }
        if (nro == 112) {
            return "e-Factura NC";
        }
        if (nro == 113) {
            return "e-Factura ND";
        }
        throw new AdempiereException("Tipo de CFE desconocido: " + nro);
    }
}

