/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.engine.vendor;

import com.google.common.collect.BiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.transform.Source;
import org.adempiere.exceptions.AdempiereException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.LUY.cfe.dto.generic.cfe.CFEDefType;
import org.openup.LUY.cfe.dto.generic.cfe.CFEEmpresasType;
import org.openup.LUY.cfe.dto.generic.cfe.ComplFiscalDataType;
import org.openup.LUY.cfe.dto.generic.cfe.DscRcgGlobal;
import org.openup.LUY.cfe.dto.generic.cfe.Emisor;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocFact;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocFactExp;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocRem;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocResg;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocTck;
import org.openup.LUY.cfe.dto.generic.cfe.ItemDetFact;
import org.openup.LUY.cfe.dto.generic.cfe.ItemDetFactExp;
import org.openup.LUY.cfe.dto.generic.cfe.ItemRem;
import org.openup.LUY.cfe.dto.generic.cfe.ItemResg;
import org.openup.LUY.cfe.dto.generic.cfe.MediosPago;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorFact;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorFactExp;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorRem;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorResg;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorTck;
import org.openup.LUY.cfe.dto.generic.cfe.Referencia;
import org.openup.LUY.cfe.dto.generic.cfe.RetPercResg;
import org.openup.LUY.cfe.dto.generic.cfe.SubTotInfo;
import org.openup.LUY.cfe.dto.generic.cfe.Totales;
import org.openup.LUY.cfe.dto.generic.cfe.TotalesFactExp;
import org.openup.LUY.cfe.dto.generic.cfe.TotalesResg;
import org.openup.LUY.cfe.dto.invoicy.CFEInvoiCyCollectionType;
import org.openup.LUY.cfe.dto.invoicy.CFEInvoiCyType;
import org.openup.LUY.cfe.dto.invoicy.EncabezadoEnvioType;
import org.openup.LUY.cfe.dto.invoicy.EnvioCFE;
import org.openup.LUY.cfe.dto.invoicy.RetPerc;
import org.openup.LUY.cfe.dto.invoicy.SNType;
import org.openup.LUY.cfe.dto.invoicy.TipMonType;
import org.openup.LUY.cfe.dto.invoicy.response.EnvioCFERetorno;
import org.openup.LUY.cfe.dto.invoicy.response.ListaCFERetornoType;
import org.openup.LUY.engine.LUYVendorInterface;
import org.openup.LUY.model.MLUYDocument;
import org.openup.LUY.model.MLUYVendor;
import org.openup.LUY.model.MLUYVendorInvoicy;
import org.openup.LUY.util.CFEUtils;

public class LUYInvoicyService
implements LUYVendorInterface {
    MLUYVendor vendor = MLUYVendor.getByClassName(this.getClass().getCanonicalName());
    MLUYDocument mluyDocument;
    PO document;
    Properties ctx;
    String trxName;
    List<CFEInvoiCyType> invoicyDtos;
    EnvioCFE envioCfe;
    CFEEmpresasType genericDto;
    private MLUYVendorInvoicy mluyVendorInvoicy;

    public LUYInvoicyService() {
        if (this.vendor == null) {
            throw new AdempiereException("Implementaci\u00f3n para este proveedor de servicios no existe: " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public Source execute(MLUYDocument document, String typeService) throws Exception {
        return null;
    }

    @Override
    public void sendGenericDto(CFEEmpresasType genericDto, PO document) {
        this.genericDto = genericDto;
        this.document = document;
        this.mluyVendorInvoicy = (MLUYVendorInvoicy)new Query(document.getCtx(), "LUY_VendorInvoicy", "LUY_Vendor_ID=?", document.get_TrxName()).setParameters(this.vendor.get_ID()).first();
        if (this.mluyVendorInvoicy == null || this.mluyVendorInvoicy.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: La Configuraci\u00f3n para Proveedor InvoiCy no fue encontrada");
        }
        this.initSender();
        this.sendCfe();
    }

    @Override
    public MLUYDocument getLUYDocument() {
        return this.mluyDocument;
    }

    @Override
    public void setDocument(PO document) {
    }

    @Override
    public void getQR(MLUYDocument documentCFDI) {
    }

    @Override
    public void getToken(MLUYDocument documentCFDI) {
    }

    @Override
    public void getCFDI(MLUYDocument documentCFDI) {
    }

    @Override
    public void getCancelCFDI(MLUYDocument documentCFID) {
    }

    private void initSender() {
        this.envioCfe = new EnvioCFE();
        this.envioCfe.setCFE(new CFEInvoiCyCollectionType());
        this.invoicyDtos = this.envioCfe.getCFE().getCFEItem();
        this.ctx = this.document.getCtx();
        this.trxName = this.document.get_TrxName();
        this.invoicyDtos.add(this.mapDto(this.genericDto));
    }

    protected CFEInvoiCyType mapDto(CFEEmpresasType genericEDto) {
        CFEDefType genericDto = genericEDto.getCFE();
        CFEInvoiCyType invoicyDto = new CFEInvoiCyType();
        int cfeType = this.getCfeTypeGenericDto(genericDto);
        this.loadIdDoc(cfeType, genericDto, invoicyDto);
        this.loadDatosEmisor(cfeType, genericDto, invoicyDto);
        this.loadDatosReceptor(cfeType, genericDto, invoicyDto);
        this.loadTotales(cfeType, genericDto, invoicyDto);
        this.loadItems(cfeType, genericDto, invoicyDto);
        this.loadSubTotalesInfo(cfeType, genericDto, invoicyDto);
        this.loadDscRcgGlobal(cfeType, genericDto, invoicyDto);
        this.loadMediosPago(cfeType, genericDto, invoicyDto);
        this.loadReferencia(cfeType, genericDto, invoicyDto);
        this.loadAdenda(genericEDto.getAdenda(), invoicyDto);
        this.loadComplementoFiscal(cfeType, genericDto, invoicyDto);
        return invoicyDto;
    }

    protected int getCfeTypeGenericDto(CFEDefType genericDto) {
        int cfeType = 0;
        try {
            cfeType = genericDto.getEFact().getEncabezado().getIdDoc().getTipoCFE().intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cfeType == 0) {
            try {
                cfeType = genericDto.getETck().getEncabezado().getIdDoc().getTipoCFE().intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cfeType == 0) {
            try {
                cfeType = genericDto.getERem().getEncabezado().getIdDoc().getTipoCFE().intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cfeType == 0) {
            try {
                cfeType = genericDto.getEResg().getEncabezado().getIdDoc().getTipoCFE().intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cfeType == 0) {
            try {
                cfeType = genericDto.getEFactExp().getEncabezado().getIdDoc().getTipoCFE().intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cfeType;
    }

    protected void loadIdDoc(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        CFEInvoiCyType.IdDoc invoicyIdDoc = new CFEInvoiCyType.IdDoc();
        invoicyDto.setIdDoc(invoicyIdDoc);
        BiMap<String, CFEUtils.CfeType> cfeTypes = CFEUtils.getCfeTypes();
        String sql = "";
        if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
            if (genericDto.getEFact().getEncabezado() != null && genericDto.getEFact().getEncabezado().getIdDoc() != null) {
                IdDocFact genericIdDoc = genericDto.getEFact().getEncabezado().getIdDoc();
                sql = "select type from luy_cfetype where cfetype = '" + cfeType + "' and ad_client_id = " + this.document.getAD_Client_ID() + " and ad_org_id = " + this.document.getAD_Org_ID() + " and isactive = 'Y'";
                String type = DB.getSQLValueStringEx(this.document.get_TrxName(), sql, new Object[0]);
                invoicyIdDoc.setCFETipoCFE(BigInteger.valueOf(cfeType));
                invoicyIdDoc.setCFESerie(genericIdDoc.getSerie());
                invoicyIdDoc.setCFENro(genericIdDoc.getNro());
                invoicyIdDoc.setCFEFchEmis(genericIdDoc.getFchEmis());
                invoicyIdDoc.setCFEMntBruto(genericIdDoc.getMntBruto());
                invoicyIdDoc.setCFEFmaPago(genericIdDoc.getFmaPago());
                invoicyIdDoc.setCFEFchVenc(genericIdDoc.getFchVenc());
                invoicyIdDoc.setCFEImpFormato(new BigInteger(type));
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) {
            IdDocTck genericIdDoc = genericDto.getETck().getEncabezado().getIdDoc();
            invoicyIdDoc.setCFETipoCFE(BigInteger.valueOf(cfeType));
            invoicyIdDoc.setCFESerie(genericIdDoc.getSerie());
            invoicyIdDoc.setCFENro(genericIdDoc.getNro());
            invoicyIdDoc.setCFEFchEmis(genericIdDoc.getFchEmis());
            invoicyIdDoc.setCFEMntBruto(genericIdDoc.getMntBruto());
            invoicyIdDoc.setCFEFmaPago(genericIdDoc.getFmaPago());
            invoicyIdDoc.setCFEFchVenc(genericIdDoc.getFchVenc());
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eRemito))) {
            IdDocRem genericIdDoc = genericDto.getERem().getEncabezado().getIdDoc();
            invoicyIdDoc.setCFETipoCFE(BigInteger.valueOf(cfeType));
            invoicyIdDoc.setCFESerie(genericIdDoc.getSerie());
            invoicyIdDoc.setCFENro(genericIdDoc.getNro());
            invoicyIdDoc.setCFEFchEmis(genericIdDoc.getFchEmis());
            invoicyIdDoc.setCFETipoTraslado(genericIdDoc.getTipoTraslado());
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eResguardo))) {
            IdDocResg genericIdDoc = genericDto.getEResg().getEncabezado().getIdDoc();
            invoicyIdDoc.setCFETipoCFE(BigInteger.valueOf(cfeType));
            invoicyIdDoc.setCFESerie(genericIdDoc.getSerie());
            invoicyIdDoc.setCFENro(genericIdDoc.getNro());
            invoicyIdDoc.setCFEFchEmis(genericIdDoc.getFchEmis());
        } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) && genericDto.getEFactExp().getEncabezado() != null && genericDto.getEFactExp().getEncabezado().getIdDoc() != null) {
            IdDocFactExp genericIdDoc = genericDto.getEFactExp().getEncabezado().getIdDoc();
            invoicyIdDoc.setCFETipoCFE(BigInteger.valueOf(cfeType));
            invoicyIdDoc.setCFESerie(genericIdDoc.getSerie());
            invoicyIdDoc.setCFENro(genericIdDoc.getNro());
            invoicyIdDoc.setCFEFchEmis(genericIdDoc.getFchEmis());
            invoicyIdDoc.setCFEMntBruto(genericIdDoc.getMntBruto());
            invoicyIdDoc.setCFEFmaPago(genericIdDoc.getFmaPago());
            invoicyIdDoc.setCFEFchVenc(genericIdDoc.getFchVenc());
            invoicyIdDoc.setCFEExpClaVenta(genericIdDoc.getClauVenta());
            invoicyIdDoc.setCFEExpModVenta(genericIdDoc.getModVenta());
            invoicyIdDoc.setCFEExpViaTransporte(genericIdDoc.getViaTransp());
        }
    }

    protected void loadDatosEmisor(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        CFEInvoiCyType.Emisor invoicyEmisor = new CFEInvoiCyType.Emisor();
        invoicyDto.setEmisor(invoicyEmisor);
        BiMap<String, CFEUtils.CfeType> cfeTypes = CFEUtils.getCfeTypes();
        if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
            if (genericDto.getEFact().getEncabezado() != null && genericDto.getEFact().getEncabezado().getEmisor() != null) {
                Emisor genericEmisor = genericDto.getEFact().getEncabezado().getEmisor();
                invoicyEmisor.setEmiRznSoc(genericEmisor.getRznSoc());
                invoicyEmisor.setEmiComercial(genericEmisor.getNomComercial());
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 0) {
                    invoicyEmisor.setEmiTelefono(genericEmisor.getTelefono().get(0));
                }
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 1) {
                    invoicyEmisor.setEmiTelefono2(genericEmisor.getTelefono().get(1));
                }
                invoicyEmisor.setEmiCorreoEmisor(genericEmisor.getCorreoEmisor());
                invoicyEmisor.setEmiSucursal(genericEmisor.getEmiSucursal());
                invoicyEmisor.setEmiDomFiscal(genericEmisor.getDomFiscal());
                invoicyEmisor.setEmiCiudad(genericEmisor.getCiudad());
                invoicyEmisor.setEmiDepartamento(genericEmisor.getDepartamento());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) {
            if (genericDto.getETck().getEncabezado() != null && genericDto.getETck().getEncabezado().getEmisor() != null) {
                Emisor genericEmisor = genericDto.getETck().getEncabezado().getEmisor();
                invoicyEmisor.setEmiRznSoc(genericEmisor.getRznSoc());
                invoicyEmisor.setEmiComercial(genericEmisor.getNomComercial());
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 0) {
                    invoicyEmisor.setEmiTelefono(genericEmisor.getTelefono().get(0));
                }
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 1) {
                    invoicyEmisor.setEmiTelefono2(genericEmisor.getTelefono().get(1));
                }
                invoicyEmisor.setEmiCorreoEmisor(genericEmisor.getCorreoEmisor());
                invoicyEmisor.setEmiSucursal(genericEmisor.getEmiSucursal());
                invoicyEmisor.setEmiDomFiscal(genericEmisor.getDomFiscal());
                invoicyEmisor.setEmiCiudad(genericEmisor.getCiudad());
                invoicyEmisor.setEmiDepartamento(genericEmisor.getDepartamento());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eRemito))) {
            if (genericDto.getERem().getEncabezado() != null && genericDto.getERem().getEncabezado().getEmisor() != null) {
                Emisor genericEmisor = genericDto.getERem().getEncabezado().getEmisor();
                invoicyEmisor.setEmiRznSoc(genericEmisor.getRznSoc());
                invoicyEmisor.setEmiComercial(genericEmisor.getNomComercial());
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 0) {
                    invoicyEmisor.setEmiTelefono(genericEmisor.getTelefono().get(0));
                }
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 1) {
                    invoicyEmisor.setEmiTelefono2(genericEmisor.getTelefono().get(1));
                }
                invoicyEmisor.setEmiCorreoEmisor(genericEmisor.getCorreoEmisor());
                invoicyEmisor.setEmiSucursal(genericEmisor.getEmiSucursal());
                invoicyEmisor.setEmiDomFiscal(genericEmisor.getDomFiscal());
                invoicyEmisor.setEmiCiudad(genericEmisor.getCiudad());
                invoicyEmisor.setEmiDepartamento(genericEmisor.getDepartamento());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eResguardo))) {
            if (genericDto.getEResg().getEncabezado() != null && genericDto.getEResg().getEncabezado().getEmisor() != null) {
                Emisor genericEmisor = genericDto.getEResg().getEncabezado().getEmisor();
                invoicyEmisor.setEmiRznSoc(genericEmisor.getRznSoc());
                invoicyEmisor.setEmiComercial(genericEmisor.getNomComercial());
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 0) {
                    invoicyEmisor.setEmiTelefono(genericEmisor.getTelefono().get(0));
                }
                if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 1) {
                    invoicyEmisor.setEmiTelefono2(genericEmisor.getTelefono().get(1));
                }
                invoicyEmisor.setEmiCorreoEmisor(genericEmisor.getCorreoEmisor());
                invoicyEmisor.setEmiSucursal(genericEmisor.getEmiSucursal());
                invoicyEmisor.setEmiDomFiscal(genericEmisor.getDomFiscal());
                invoicyEmisor.setEmiCiudad(genericEmisor.getCiudad());
                invoicyEmisor.setEmiDepartamento(genericEmisor.getDepartamento());
            }
        } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) && genericDto.getEFactExp().getEncabezado() != null && genericDto.getEFactExp().getEncabezado().getEmisor() != null) {
            Emisor genericEmisor = genericDto.getEFactExp().getEncabezado().getEmisor();
            invoicyEmisor.setEmiRznSoc(genericEmisor.getRznSoc());
            invoicyEmisor.setEmiComercial(genericEmisor.getNomComercial());
            if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 0) {
                invoicyEmisor.setEmiTelefono(genericEmisor.getTelefono().get(0));
            }
            if (genericEmisor.getTelefono() != null && genericEmisor.getTelefono().size() > 1) {
                invoicyEmisor.setEmiTelefono2(genericEmisor.getTelefono().get(1));
            }
            invoicyEmisor.setEmiCorreoEmisor(genericEmisor.getCorreoEmisor());
            invoicyEmisor.setEmiSucursal(genericEmisor.getEmiSucursal());
            invoicyEmisor.setEmiDomFiscal(genericEmisor.getDomFiscal());
            invoicyEmisor.setEmiCiudad(genericEmisor.getCiudad());
            invoicyEmisor.setEmiDepartamento(genericEmisor.getDepartamento());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEmailReceptor(Integer documentType, String documentNo) {
        if (documentNo != null && !documentNo.equalsIgnoreCase("") && documentType != null && documentType > 0) {
            String strE;
            String sql = "SELECT email FROM C_BPartner_Location bpLoc JOIN C_BPartner bp ON bp.C_BPartner_ID = bpLoc.C_BPartner_ID WHERE bpLoc.IsPayFrom = 'Y' AND bp.taxID = '" + documentNo + "' AND bp.isActive='Y' AND bpLoc.isActive='Y'";
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            String strEmail = "";
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    strE = rs.getString("email");
                    if (strE == null) continue;
                    strEmail = strEmail + strE + ";";
                }
                strEmail = strEmail.length() > 0 ? strEmail.substring(0, strEmail.length()) : null;
                strE = strEmail != null ? strEmail : "";
            }
            catch (Exception e) {
                String string;
                try {
                    string = "";
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
                return string;
            }
            DB.close(rs, pstmt);
            return strE;
        }
        return "";
    }

    protected void loadDatosReceptor(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        CFEInvoiCyType.Receptor invoicyReceptor = new CFEInvoiCyType.Receptor();
        invoicyDto.setReceptor(invoicyReceptor);
        BiMap<String, CFEUtils.CfeType> cfeTypes = CFEUtils.getCfeTypes();
        if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
            if (genericDto.getEFact().getEncabezado() != null && genericDto.getEFact().getEncabezado().getReceptor() != null) {
                ReceptorFact genericReceptorFact = genericDto.getEFact().getEncabezado().getReceptor();
                invoicyReceptor.setRcpTipoDocRecep(genericReceptorFact.getTipoDocRecep());
                invoicyReceptor.setRcpCodPaisRecep(genericReceptorFact.getCodPaisRecep());
                invoicyReceptor.setRcpDocRecep(genericReceptorFact.getDocRecep());
                invoicyReceptor.setRcpRznSocRecep(genericReceptorFact.getRznSocRecep());
                invoicyReceptor.setRcpDirRecep(genericReceptorFact.getDirRecep());
                invoicyReceptor.setRcpCiudadRecep(genericReceptorFact.getCiudadRecep());
                invoicyReceptor.setRcpDeptoRecep(genericReceptorFact.getDeptoRecep());
                if (genericReceptorFact.getCP() != null) {
                    invoicyReceptor.setRcpCP(genericReceptorFact.getCP().toString());
                }
                invoicyReceptor.setRcpCorreoRecep(this.getEmailReceptor(invoicyReceptor.getRcpTipoDocRecep(), invoicyReceptor.getRcpDocRecep()));
                invoicyReceptor.setRcpInfAdiRecep(genericReceptorFact.getInfoAdicional());
                invoicyReceptor.setRcpDirPaisRecep(genericReceptorFact.getPaisRecep());
                invoicyReceptor.setRcpDstEntregaRecep(genericReceptorFact.getLugarDestEnt());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) {
            if (genericDto.getETck().getEncabezado() != null && genericDto.getETck().getEncabezado().getReceptor() != null) {
                ReceptorTck genericReceptorFact = genericDto.getETck().getEncabezado().getReceptor();
                invoicyReceptor.setRcpTipoDocRecep(genericReceptorFact.getTipoDocRecep());
                invoicyReceptor.setRcpCodPaisRecep(genericReceptorFact.getCodPaisRecep());
                String recepNumDoc = "";
                recepNumDoc = genericReceptorFact.getDocRecep() != null ? genericReceptorFact.getDocRecep() : genericReceptorFact.getDocRecepExt();
                invoicyReceptor.setRcpDocRecep(recepNumDoc);
                invoicyReceptor.setRcpRznSocRecep(genericReceptorFact.getRznSocRecep());
                invoicyReceptor.setRcpDirRecep(genericReceptorFact.getDirRecep());
                invoicyReceptor.setRcpCiudadRecep(genericReceptorFact.getCiudadRecep());
                invoicyReceptor.setRcpDeptoRecep(genericReceptorFact.getDeptoRecep());
                if (genericReceptorFact.getCP() != null) {
                    invoicyReceptor.setRcpCP(genericReceptorFact.getCP().toString());
                }
                invoicyReceptor.setRcpCorreoRecep(this.getEmailReceptor(invoicyReceptor.getRcpTipoDocRecep(), invoicyReceptor.getRcpDocRecep()));
                invoicyReceptor.setRcpInfAdiRecep(genericReceptorFact.getInfoAdicional());
                invoicyReceptor.setRcpDirPaisRecep(genericReceptorFact.getPaisRecep());
                invoicyReceptor.setRcpDstEntregaRecep(genericReceptorFact.getLugarDestEnt());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eRemito))) {
            if (genericDto.getERem().getEncabezado() != null && genericDto.getERem().getEncabezado().getReceptor() != null) {
                ReceptorRem genericReceptorRem = genericDto.getERem().getEncabezado().getReceptor();
                invoicyReceptor.setRcpTipoDocRecep(genericReceptorRem.getTipoDocRecep());
                invoicyReceptor.setRcpCodPaisRecep(genericReceptorRem.getCodPaisRecep());
                String recepNumDoc = "";
                recepNumDoc = genericReceptorRem.getDocRecep() != null ? genericReceptorRem.getDocRecep() : genericReceptorRem.getDocRecepExt();
                invoicyReceptor.setRcpDocRecep(recepNumDoc);
                invoicyReceptor.setRcpRznSocRecep(genericReceptorRem.getRznSocRecep());
                invoicyReceptor.setRcpDirRecep(genericReceptorRem.getDirRecep());
                invoicyReceptor.setRcpCiudadRecep(genericReceptorRem.getCiudadRecep());
                invoicyReceptor.setRcpDeptoRecep(genericReceptorRem.getDeptoRecep());
                if (genericReceptorRem.getCP() != null) {
                    invoicyReceptor.setRcpCP(genericReceptorRem.getCP().toString());
                }
                invoicyReceptor.setRcpCorreoRecep(this.getEmailReceptor(invoicyReceptor.getRcpTipoDocRecep(), invoicyReceptor.getRcpDocRecep()));
                invoicyReceptor.setRcpInfAdiRecep(genericReceptorRem.getInfoAdicional());
                invoicyReceptor.setRcpDirPaisRecep(genericReceptorRem.getPaisRecep());
                invoicyReceptor.setRcpDstEntregaRecep(genericReceptorRem.getLugarDestEnt());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eResguardo))) {
            if (genericDto.getEResg().getEncabezado() != null && genericDto.getEResg().getEncabezado().getReceptor() != null) {
                ReceptorResg genericReceptorResg = genericDto.getEResg().getEncabezado().getReceptor();
                invoicyReceptor.setRcpTipoDocRecep(genericReceptorResg.getTipoDocRecep());
                invoicyReceptor.setRcpCodPaisRecep(genericReceptorResg.getCodPaisRecep());
                String recepNumDoc = "";
                recepNumDoc = genericReceptorResg.getDocRecep() != null ? genericReceptorResg.getDocRecep() : genericReceptorResg.getDocRecepExt();
                invoicyReceptor.setRcpDocRecep(recepNumDoc);
                invoicyReceptor.setRcpRznSocRecep(genericReceptorResg.getRznSocRecep());
                invoicyReceptor.setRcpDirRecep(genericReceptorResg.getDirRecep());
                invoicyReceptor.setRcpCiudadRecep(genericReceptorResg.getCiudadRecep());
                invoicyReceptor.setRcpDeptoRecep(genericReceptorResg.getDeptoRecep());
                if (genericReceptorResg.getCP() != null) {
                    invoicyReceptor.setRcpCP(genericReceptorResg.getCP().toString());
                }
                invoicyReceptor.setRcpCorreoRecep(this.getEmailReceptor(invoicyReceptor.getRcpTipoDocRecep(), invoicyReceptor.getRcpDocRecep()));
                invoicyReceptor.setRcpInfAdiRecep(genericReceptorResg.getInfoAdicional());
                invoicyReceptor.setRcpDirPaisRecep(genericReceptorResg.getPaisRecep());
            }
        } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) && genericDto.getEFactExp().getEncabezado() != null && genericDto.getEFactExp().getEncabezado().getReceptor() != null) {
            ReceptorFactExp genericReceptorFact = genericDto.getEFactExp().getEncabezado().getReceptor();
            invoicyReceptor.setRcpTipoDocRecep(genericReceptorFact.getTipoDocRecep());
            invoicyReceptor.setRcpCodPaisRecep(genericReceptorFact.getCodPaisRecep());
            invoicyReceptor.setRcpDocRecep(genericReceptorFact.getDocRecep());
            invoicyReceptor.setRcpRznSocRecep(genericReceptorFact.getRznSocRecep());
            invoicyReceptor.setRcpDirRecep(genericReceptorFact.getDirRecep());
            invoicyReceptor.setRcpCiudadRecep(genericReceptorFact.getCiudadRecep());
            invoicyReceptor.setRcpDeptoRecep(genericReceptorFact.getDeptoRecep());
            if (genericReceptorFact.getCP() != null) {
                invoicyReceptor.setRcpCP(genericReceptorFact.getCP().toString());
            }
            invoicyReceptor.setRcpCorreoRecep(this.getEmailReceptor(invoicyReceptor.getRcpTipoDocRecep(), invoicyReceptor.getRcpDocRecep()));
            invoicyReceptor.setRcpInfAdiRecep(genericReceptorFact.getInfoAdicional());
            invoicyReceptor.setRcpDirPaisRecep(genericReceptorFact.getPaisRecep());
            invoicyReceptor.setRcpDstEntregaRecep(genericReceptorFact.getLugarDestEnt());
        }
    }

    protected void loadTotales(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        CFEInvoiCyType.Totales invoicyTotales = new CFEInvoiCyType.Totales();
        invoicyDto.setTotales(invoicyTotales);
        BiMap<String, CFEUtils.CfeType> cfeTypes = CFEUtils.getCfeTypes();
        if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
            if (genericDto.getEFact().getEncabezado() != null && genericDto.getEFact().getEncabezado().getTotales() != null) {
                Totales genericTotales = genericDto.getEFact().getEncabezado().getTotales();
                try {
                    invoicyTotales.setTotTpoMoneda(TipMonType.valueOf(genericTotales.getTpoMoneda().toString()));
                }
                catch (Exception e) {
                    throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Monto Totales del CFE (75) - Error al obtener la moneda del DTO Generico");
                }
                invoicyTotales.setTotTpoCambio(genericTotales.getTpoCambio());
                invoicyTotales.setTotMntNoGrv(genericTotales.getMntNoGrv());
                invoicyTotales.setTotMntExpoyAsim(genericTotales.getMntExpoyAsim());
                invoicyTotales.setTotMntImpuestoPerc(genericTotales.getMntImpuestoPerc());
                invoicyTotales.setTotMntIVaenSusp(genericTotales.getMntIVaenSusp());
                invoicyTotales.setTotMntNetoIvaTasaMin(genericTotales.getMntNetoIvaTasaMin());
                invoicyTotales.setTotMntNetoIVATasaBasica(genericTotales.getMntNetoIVATasaBasica());
                invoicyTotales.setTotMntNetoIVAOtra(genericTotales.getMntNetoIVAOtra());
                invoicyTotales.setTotIVATasaMin(genericTotales.getIVATasaMin());
                invoicyTotales.setTotIVATasaBasica(genericTotales.getIVATasaBasica());
                invoicyTotales.setTotMntIVATasaMin(genericTotales.getMntIVATasaMin());
                invoicyTotales.setTotMntIVATasaBasica(genericTotales.getMntIVATasaBasica());
                invoicyTotales.setTotMntIVAOtra(genericTotales.getMntIVAOtra());
                invoicyTotales.setTotMntTotal(genericTotales.getMntTotal());
                invoicyTotales.setTotMntTotRetenido(genericTotales.getMntTotRetenido());
                invoicyTotales.setTotMontoNF(genericTotales.getMontoNF());
                invoicyTotales.setTotMntPagar(genericTotales.getMntPagar());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) {
            if (genericDto.getETck().getEncabezado() != null && genericDto.getETck().getEncabezado().getTotales() != null) {
                Totales genericTotales = genericDto.getETck().getEncabezado().getTotales();
                try {
                    invoicyTotales.setTotTpoMoneda(TipMonType.valueOf(genericTotales.getTpoMoneda().toString()));
                }
                catch (Exception e) {
                    throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Monto Totales del CFE (75) - Error al obtener la moneda del DTO Generico");
                }
                invoicyTotales.setTotTpoCambio(genericTotales.getTpoCambio());
                invoicyTotales.setTotMntNoGrv(genericTotales.getMntNoGrv());
                invoicyTotales.setTotMntExpoyAsim(genericTotales.getMntExpoyAsim());
                invoicyTotales.setTotMntImpuestoPerc(genericTotales.getMntImpuestoPerc());
                invoicyTotales.setTotMntIVaenSusp(genericTotales.getMntIVaenSusp());
                invoicyTotales.setTotMntNetoIvaTasaMin(genericTotales.getMntNetoIvaTasaMin());
                invoicyTotales.setTotMntNetoIVATasaBasica(genericTotales.getMntNetoIVATasaBasica());
                invoicyTotales.setTotMntNetoIVAOtra(genericTotales.getMntNetoIVAOtra());
                invoicyTotales.setTotIVATasaMin(genericTotales.getIVATasaMin());
                invoicyTotales.setTotIVATasaBasica(genericTotales.getIVATasaBasica());
                invoicyTotales.setTotMntIVATasaMin(genericTotales.getMntIVATasaMin());
                invoicyTotales.setTotMntIVATasaBasica(genericTotales.getMntIVATasaBasica());
                invoicyTotales.setTotMntIVAOtra(genericTotales.getMntIVAOtra());
                invoicyTotales.setTotMntTotal(genericTotales.getMntTotal());
                invoicyTotales.setTotMntTotRetenido(genericTotales.getMntTotRetenido());
                invoicyTotales.setTotMontoNF(genericTotales.getMontoNF());
                invoicyTotales.setTotMntPagar(genericTotales.getMntPagar());
            }
        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eResguardo))) {
            if (genericDto.getEResg().getEncabezado() != null && genericDto.getEResg().getEncabezado().getTotales() != null) {
                TotalesResg resgTotales = genericDto.getEResg().getEncabezado().getTotales();
                try {
                    invoicyTotales.setTotTpoMoneda(TipMonType.valueOf(resgTotales.getTpoMoneda().toString()));
                }
                catch (Exception e) {
                    throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Monto Totales del CFE (75) - Error al obtener la moneda del DTO Generico");
                }
                invoicyTotales.setTotTpoCambio(resgTotales.getTpoCambio());
                invoicyTotales.setTotMntTotRetenido(resgTotales.getMntTotRetenido());
                CFEInvoiCyType.Totales.RetencPercepTot retencPercepTot = new CFEInvoiCyType.Totales.RetencPercepTot();
                invoicyTotales.setRetencPercepTot(retencPercepTot);
                for (TotalesResg.RetencPercep retPerc : resgTotales.getRetencPercep()) {
                    CFEInvoiCyType.Totales.RetencPercepTot.RetencPercepTotItem retencPercepTotItem = new CFEInvoiCyType.Totales.RetencPercepTot.RetencPercepTotItem();
                    retencPercepTot.getRetencPercepTotItem().add(retencPercepTotItem);
                    retencPercepTotItem.setRetPercCodRet(retPerc.getCodRet());
                    retencPercepTotItem.setRetPercValRetPerc(retPerc.getValRetPerc());
                }
            }
        } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) && genericDto.getEFactExp().getEncabezado() != null && genericDto.getEFactExp().getEncabezado().getTotales() != null) {
            TotalesFactExp genericTotales = genericDto.getEFactExp().getEncabezado().getTotales();
            try {
                invoicyTotales.setTotTpoMoneda(TipMonType.valueOf(genericTotales.getTpoMoneda().toString()));
            }
            catch (Exception e) {
                throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Monto Totales del CFE (75) - Error al obtener la moneda del DTO Generico");
            }
            invoicyTotales.setTotTpoCambio(genericTotales.getTpoCambio());
            invoicyTotales.setTotMntExpoyAsim(genericTotales.getMntExpoyAsim());
            invoicyTotales.setTotMntTotal(genericTotales.getMntTotal());
            invoicyTotales.setTotMontoNF(genericTotales.getMontoNF());
            invoicyTotales.setTotMntPagar(genericTotales.getMntPagar());
        }
    }

    protected void loadItems(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        block27: {
            List<ItemDetFactExp> genericItems;
            BiMap<String, CFEUtils.CfeType> cfeTypes;
            List<CFEInvoiCyType.Detalle.Item> invoicyItems;
            block29: {
                block28: {
                    block26: {
                        invoicyDto.setDetalle(new CFEInvoiCyType.Detalle());
                        invoicyItems = invoicyDto.getDetalle().getItem();
                        cfeTypes = CFEUtils.getCfeTypes();
                        if (cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) break block26;
                        List<ItemDetFact> genericItems2 = null;
                        if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
                            if (genericDto.getEFact().getDetalle() == null || genericDto.getEFact().getDetalle().getItem().size() == 0) {
                                throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Detalle del CFE (116) - El documento no tiene lineas");
                            }
                            genericItems2 = genericDto.getEFact().getDetalle().getItem();
                        } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) {
                            if (genericDto.getETck().getDetalle() == null || genericDto.getETck().getDetalle().getItem().size() == 0) {
                                throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Detalle del CFE (116) - El documento no tiene lineas");
                            }
                            genericItems2 = genericDto.getETck().getDetalle().getItem();
                        }
                        if (genericItems2 == null) break block27;
                        for (ItemDetFact itemDetFact : genericItems2) {
                            CFEInvoiCyType.Detalle.Item invoicyItem = new CFEInvoiCyType.Detalle.Item();
                            invoicyItems.add(invoicyItem);
                            CFEInvoiCyType.Detalle.Item.CodItem codItem = new CFEInvoiCyType.Detalle.Item.CodItem();
                            invoicyItem.setCodItem(codItem);
                            for (ItemDetFact.CodItem genericCodItem : itemDetFact.getCodItem()) {
                                CFEInvoiCyType.Detalle.Item.CodItem.CodItemItem codItemItem = new CFEInvoiCyType.Detalle.Item.CodItem.CodItemItem();
                                codItem.getCodItemItem().add(codItemItem);
                                codItemItem.setIteCodiTpoCod(genericCodItem.getTpoCod());
                                codItemItem.setIteCodiCod(genericCodItem.getCod());
                            }
                            invoicyItem.setIteIndFact(itemDetFact.getIndFact().intValue());
                            invoicyItem.setIteIndAgenteResp(itemDetFact.getIndAgenteResp());
                            invoicyItem.setIteNomItem(itemDetFact.getNomItem());
                            invoicyItem.setIteDscItem(itemDetFact.getDscItem());
                            invoicyItem.setIteCantidad(itemDetFact.getCantidad());
                            invoicyItem.setIteUniMed(itemDetFact.getUniMed());
                            invoicyItem.setItePrecioUnitario(itemDetFact.getPrecioUnitario());
                            invoicyItem.setIteDescuentoPct(itemDetFact.getDescuentoPct());
                            invoicyItem.setIteDescuentoMonto(itemDetFact.getDescuentoMonto());
                            for (ItemDetFact.SubDescuento subDescuento : itemDetFact.getSubDescuento()) {
                                CFEInvoiCyType.Detalle.Item.SubDescuento.SubDescuentoItem invoicySubDescuentoItem = new CFEInvoiCyType.Detalle.Item.SubDescuento.SubDescuentoItem();
                                invoicySubDescuentoItem.setSubDescDescTipo(subDescuento.getDescTipo());
                                invoicySubDescuentoItem.setSubDescDescVal(subDescuento.getDescVal());
                                invoicyItem.getSubDescuento().getSubDescuentoItem().add(invoicySubDescuentoItem);
                            }
                            invoicyItem.setIteRecargoPct(itemDetFact.getRecargoPct());
                            invoicyItem.setIteRecargoMnt(itemDetFact.getRecargoMnt());
                            for (ItemDetFact.SubRecargo subRecargo : itemDetFact.getSubRecargo()) {
                                CFEInvoiCyType.Detalle.Item.SubRecargo.SubRecargoItem invoicySubRecargoItem = new CFEInvoiCyType.Detalle.Item.SubRecargo.SubRecargoItem();
                                invoicySubRecargoItem.setSubRecaRecargoTipo(subRecargo.getRecargoTipo());
                                invoicySubRecargoItem.setSubRecaRecargoVal(subRecargo.getRecargoVal());
                                invoicyItem.getSubRecargo().getSubRecargoItem().add(invoicySubRecargoItem);
                            }
                            for (org.openup.LUY.cfe.dto.generic.cfe.RetPerc retPerc : itemDetFact.getRetencPercep()) {
                                CFEInvoiCyType.Detalle.Item.RetencPercep.RetencPercepItem invoicyRetPerc = new CFEInvoiCyType.Detalle.Item.RetencPercep.RetencPercepItem();
                                invoicyRetPerc.setIteRetPercCodRet(retPerc.getCodRet());
                                if (retPerc.getValRetPerc() != null) {
                                    invoicyRetPerc.setIteRetPercTasa(retPerc.getValRetPerc().toBigInteger());
                                }
                                invoicyRetPerc.setIteRetPercMntSujetoaRet(retPerc.getMntSujetoaRet());
                                invoicyRetPerc.setIteRetPercValRetPerc(retPerc.getValRetPerc());
                                invoicyItem.getRetencPercep().getRetencPercepItem().add(invoicyRetPerc);
                            }
                            invoicyItem.setIteMontoItem(itemDetFact.getMontoItem());
                        }
                        break block27;
                    }
                    if (cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eRemito))) break block28;
                    List<ItemRem> remItems = null;
                    if (genericDto.getERem().getDetalle() == null || genericDto.getERem().getDetalle().getItem().size() == 0) {
                        throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Detalle del CFE (116) - El documento no tiene lineas");
                    }
                    remItems = genericDto.getERem().getDetalle().getItem();
                    if (remItems == null) break block27;
                    for (ItemRem itemRem : remItems) {
                        CFEInvoiCyType.Detalle.Item invoicyItem = new CFEInvoiCyType.Detalle.Item();
                        invoicyItems.add(invoicyItem);
                        CFEInvoiCyType.Detalle.Item.CodItem codItem = new CFEInvoiCyType.Detalle.Item.CodItem();
                        invoicyItem.setCodItem(codItem);
                        for (ItemRem.CodItem remCodItem : itemRem.getCodItem()) {
                            CFEInvoiCyType.Detalle.Item.CodItem.CodItemItem codItemItem = new CFEInvoiCyType.Detalle.Item.CodItem.CodItemItem();
                            codItem.getCodItemItem().add(codItemItem);
                            codItemItem.setIteCodiTpoCod(remCodItem.getTpoCod());
                            codItemItem.setIteCodiCod(remCodItem.getCod());
                        }
                        if (itemRem.getIndFact() != null) {
                            invoicyItem.setIteIndFact(itemRem.getIndFact().intValue());
                        }
                        invoicyItem.setIteNomItem(itemRem.getNomItem());
                        invoicyItem.setIteDscItem(itemRem.getDscItem());
                        invoicyItem.setIteCantidad(itemRem.getCantidad());
                        invoicyItem.setIteUniMed(itemRem.getUniMed());
                    }
                    break block27;
                }
                if (cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eResguardo))) break block29;
                List<ItemResg> resgItems = null;
                if (genericDto.getEResg().getDetalle() == null || genericDto.getEResg().getDetalle().getItem().size() == 0) {
                    throw new AdempiereException("CFE OpenUp-Migrate Provider Error: Area Detalle del CFE (116) - El documento no tiene lineas");
                }
                resgItems = genericDto.getEResg().getDetalle().getItem();
                if (resgItems == null) break block27;
                for (ItemResg itemResg : resgItems) {
                    CFEInvoiCyType.Detalle.Item invoicyItem = new CFEInvoiCyType.Detalle.Item();
                    invoicyItems.add(invoicyItem);
                    CFEInvoiCyType.Detalle.Item.CodItem codItem = new CFEInvoiCyType.Detalle.Item.CodItem();
                    invoicyItem.setCodItem(codItem);
                    if (itemResg.getIndFact() != null) {
                        invoicyItem.setIteIndFact(itemResg.getIndFact().intValue());
                    }
                    for (RetPercResg retPercResg : itemResg.getRetencPercep()) {
                        CFEInvoiCyType.Detalle.Item.RetencPercep.RetencPercepItem retencPercepItem = new CFEInvoiCyType.Detalle.Item.RetencPercep.RetencPercepItem();
                        if (invoicyItem.getRetencPercep() == null) {
                            invoicyItem.setRetencPercep(new CFEInvoiCyType.Detalle.Item.RetencPercep());
                        }
                        invoicyItem.getRetencPercep().getRetencPercepItem().add(retencPercepItem);
                        retencPercepItem.setIteRetPercCodRet(retPercResg.getCodRet());
                        if (retPercResg.getTasa() != null) {
                            retencPercepItem.setIteRetPercTasa(retPercResg.getTasa().toBigInteger());
                        }
                        retencPercepItem.setIteRetPercMntSujetoaRet(retPercResg.getMntSujetoaRet());
                        retencPercepItem.setIteRetPercValRetPerc(retPercResg.getValRetPerc());
                        retencPercepItem.setIteRetPerc(RetPerc.R);
                    }
                }
                break block27;
            }
            if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) && (genericItems = genericDto.getEFactExp().getDetalle().getItem()) != null) {
                for (ItemDetFactExp itemDetFactExp : genericItems) {
                    CFEInvoiCyType.Detalle.Item invoicyItem = new CFEInvoiCyType.Detalle.Item();
                    invoicyItems.add(invoicyItem);
                    CFEInvoiCyType.Detalle.Item.CodItem codItem = new CFEInvoiCyType.Detalle.Item.CodItem();
                    invoicyItem.setCodItem(codItem);
                    for (ItemDetFactExp.CodItem genericCodItem : itemDetFactExp.getCodItem()) {
                        CFEInvoiCyType.Detalle.Item.CodItem.CodItemItem codItemItem = new CFEInvoiCyType.Detalle.Item.CodItem.CodItemItem();
                        codItem.getCodItemItem().add(codItemItem);
                        codItemItem.setIteCodiTpoCod(genericCodItem.getTpoCod());
                        codItemItem.setIteCodiCod(genericCodItem.getCod());
                    }
                    invoicyItem.setIteIndFact(itemDetFactExp.getIndFact().intValue());
                    invoicyItem.setIteNomItem(itemDetFactExp.getNomItem());
                    invoicyItem.setIteDscItem(itemDetFactExp.getDscItem());
                    invoicyItem.setIteCantidad(itemDetFactExp.getCantidad());
                    invoicyItem.setIteUniMed(itemDetFactExp.getUniMed());
                    invoicyItem.setItePrecioUnitario(itemDetFactExp.getPrecioUnitario());
                    invoicyItem.setIteDescuentoPct(itemDetFactExp.getDescuentoPct());
                    invoicyItem.setIteDescuentoMonto(itemDetFactExp.getDescuentoMonto());
                    for (ItemDetFactExp.SubDescuento subDescuento : itemDetFactExp.getSubDescuento()) {
                        CFEInvoiCyType.Detalle.Item.SubDescuento.SubDescuentoItem invoicySubDescuentoItem = new CFEInvoiCyType.Detalle.Item.SubDescuento.SubDescuentoItem();
                        invoicySubDescuentoItem.setSubDescDescTipo(subDescuento.getDescTipo());
                        invoicySubDescuentoItem.setSubDescDescVal(subDescuento.getDescVal());
                        invoicyItem.getSubDescuento().getSubDescuentoItem().add(invoicySubDescuentoItem);
                    }
                    invoicyItem.setIteRecargoPct(itemDetFactExp.getRecargoPct());
                    invoicyItem.setIteRecargoMnt(itemDetFactExp.getRecargoMnt());
                    for (ItemDetFactExp.SubRecargo subRecargo : itemDetFactExp.getSubRecargo()) {
                        CFEInvoiCyType.Detalle.Item.SubRecargo.SubRecargoItem invoicySubRecargoItem = new CFEInvoiCyType.Detalle.Item.SubRecargo.SubRecargoItem();
                        invoicySubRecargoItem.setSubRecaRecargoTipo(subRecargo.getRecargoTipo());
                        invoicySubRecargoItem.setSubRecaRecargoVal(subRecargo.getRecargoVal());
                        invoicyItem.getSubRecargo().getSubRecargoItem().add(invoicySubRecargoItem);
                    }
                    invoicyItem.setIteMontoItem(itemDetFactExp.getMontoItem());
                }
            }
        }
    }

    protected void loadSubTotalesInfo(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        block10: {
            BiMap<String, CFEUtils.CfeType> cfeTypes;
            List<CFEInvoiCyType.SubTotInfo.STIItem> invoicySubTotales;
            block9: {
                invoicyDto.setSubTotInfo(new CFEInvoiCyType.SubTotInfo());
                invoicySubTotales = invoicyDto.getSubTotInfo().getSTIItem();
                cfeTypes = CFEUtils.getCfeTypes();
                if (cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) break block9;
                List<SubTotInfo.STIItem> genericSubTotInfo = null;
                if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
                    if (genericDto.getEFact().getSubTotInfo() != null && genericDto.getEFact().getSubTotInfo().getSTIItem() != null) {
                        genericSubTotInfo = genericDto.getEFact().getSubTotInfo().getSTIItem();
                    }
                } else if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) {
                    // empty if block
                }
                if (genericSubTotInfo == null) break block10;
                for (SubTotInfo.STIItem subTotInfo : genericSubTotInfo) {
                    CFEInvoiCyType.SubTotInfo.STIItem invoicySubTotInfo = new CFEInvoiCyType.SubTotInfo.STIItem();
                    invoicySubTotales.add(invoicySubTotInfo);
                    invoicySubTotInfo.setSubTotNroSTI(subTotInfo.getNroSTI());
                    invoicySubTotInfo.setSubTotGlosaSTI(subTotInfo.getGlosaSTI());
                    invoicySubTotInfo.setSubTotOrdenSTI(subTotInfo.getOrdenSTI());
                    invoicySubTotInfo.setSubTotValSubtotSTI(subTotInfo.getValSubtotSTI());
                }
                break block10;
            }
            if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) {
                List<SubTotInfo.STIItem> genericSubTotInfo = null;
                if (genericDto.getEFactExp().getSubTotInfo() != null && genericDto.getEFactExp().getSubTotInfo().getSTIItem() != null) {
                    genericSubTotInfo = genericDto.getEFactExp().getSubTotInfo().getSTIItem();
                }
                if (genericSubTotInfo != null) {
                    for (SubTotInfo.STIItem subTotInfo : genericSubTotInfo) {
                        CFEInvoiCyType.SubTotInfo.STIItem invoicySubTotInfo = new CFEInvoiCyType.SubTotInfo.STIItem();
                        invoicySubTotales.add(invoicySubTotInfo);
                        invoicySubTotInfo.setSubTotNroSTI(subTotInfo.getNroSTI());
                        invoicySubTotInfo.setSubTotGlosaSTI(subTotInfo.getGlosaSTI());
                        invoicySubTotInfo.setSubTotOrdenSTI(subTotInfo.getOrdenSTI());
                        invoicySubTotInfo.setSubTotValSubtotSTI(subTotInfo.getValSubtotSTI());
                    }
                }
            }
        }
    }

    protected void loadDscRcgGlobal(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        block10: {
            BiMap<String, CFEUtils.CfeType> cfeTypes;
            List<CFEInvoiCyType.DscRcgGlobal.DRGItem> invoicyDscRcgGlobal;
            block9: {
                invoicyDto.setDscRcgGlobal(new CFEInvoiCyType.DscRcgGlobal());
                invoicyDscRcgGlobal = invoicyDto.getDscRcgGlobal().getDRGItem();
                cfeTypes = CFEUtils.getCfeTypes();
                if (cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) break block9;
                List<DscRcgGlobal.DRGItem> drgItems = null;
                if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
                    if (genericDto.getEFact().getDscRcgGlobal() != null) {
                        drgItems = genericDto.getEFact().getDscRcgGlobal().getDRGItem();
                    }
                } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) && genericDto.getETck().getDscRcgGlobal() != null) {
                    drgItems = genericDto.getETck().getDscRcgGlobal().getDRGItem();
                }
                if (drgItems == null) break block10;
                for (DscRcgGlobal.DRGItem dscRcgGlobal : drgItems) {
                    CFEInvoiCyType.DscRcgGlobal.DRGItem invoicyDscRcgGlob = new CFEInvoiCyType.DscRcgGlobal.DRGItem();
                    invoicyDscRcgGlobal.add(invoicyDscRcgGlob);
                    invoicyDscRcgGlob.setDscRcgNroLinDR(dscRcgGlobal.getNroLinDR());
                    invoicyDscRcgGlob.setDscRcgTpoMovDR(dscRcgGlobal.getTpoMovDR());
                    invoicyDscRcgGlob.setDscRcgTpoDR(dscRcgGlobal.getTpoDR());
                    invoicyDscRcgGlob.setDscRcgCodDR(dscRcgGlobal.getCodDR());
                    invoicyDscRcgGlob.setDscRcgGlosaDR(dscRcgGlobal.getGlosaDR());
                    invoicyDscRcgGlob.setDscRcgValorDR(dscRcgGlobal.getValorDR());
                    if (dscRcgGlobal.getIndFactDR() == null) continue;
                    invoicyDscRcgGlob.setDscRcgIndFactDR(dscRcgGlobal.getIndFactDR().intValue());
                }
                break block10;
            }
            if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) {
                List<DscRcgGlobal.DRGItem> drgItems = null;
                if (genericDto.getEFactExp().getDscRcgGlobal() != null) {
                    drgItems = genericDto.getEFactExp().getDscRcgGlobal().getDRGItem();
                }
                if (drgItems != null) {
                    for (DscRcgGlobal.DRGItem dscRcgGlobal : drgItems) {
                        CFEInvoiCyType.DscRcgGlobal.DRGItem invoicyDscRcgGlob = new CFEInvoiCyType.DscRcgGlobal.DRGItem();
                        invoicyDscRcgGlobal.add(invoicyDscRcgGlob);
                        invoicyDscRcgGlob.setDscRcgNroLinDR(dscRcgGlobal.getNroLinDR());
                        invoicyDscRcgGlob.setDscRcgTpoMovDR(dscRcgGlobal.getTpoMovDR());
                        invoicyDscRcgGlob.setDscRcgTpoDR(dscRcgGlobal.getTpoDR());
                        invoicyDscRcgGlob.setDscRcgCodDR(dscRcgGlobal.getCodDR());
                        invoicyDscRcgGlob.setDscRcgGlosaDR(dscRcgGlobal.getGlosaDR());
                        invoicyDscRcgGlob.setDscRcgValorDR(dscRcgGlobal.getValorDR());
                        if (dscRcgGlobal.getIndFactDR() == null) continue;
                        invoicyDscRcgGlob.setDscRcgIndFactDR(dscRcgGlobal.getIndFactDR().intValue());
                    }
                }
            }
        }
    }

    protected void loadMediosPago(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        block10: {
            BiMap<String, CFEUtils.CfeType> cfeTypes;
            List<CFEInvoiCyType.MediosPago.MediosPagoItem> invoicyMediosPago;
            block9: {
                invoicyDto.setMediosPago(new CFEInvoiCyType.MediosPago());
                invoicyMediosPago = invoicyDto.getMediosPago().getMediosPagoItem();
                cfeTypes = CFEUtils.getCfeTypes();
                if (cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) break block9;
                List<MediosPago.MedioPago> genericMedioPago = null;
                if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
                    if (genericDto.getEFact().getMediosPago() != null) {
                        genericMedioPago = genericDto.getEFact().getMediosPago().getMedioPago();
                    }
                } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) && genericDto.getETck().getMediosPago() != null) {
                    genericMedioPago = genericDto.getETck().getMediosPago().getMedioPago();
                }
                if (genericMedioPago == null) break block10;
                for (MediosPago.MedioPago medioPago : genericMedioPago) {
                    CFEInvoiCyType.MediosPago.MediosPagoItem invoicyMP = new CFEInvoiCyType.MediosPago.MediosPagoItem();
                    invoicyMediosPago.add(invoicyMP);
                    invoicyMP.setMedPagNroLinMP(medioPago.getNroLinMP());
                    invoicyMP.setMedPagCodMP(medioPago.getCodMP());
                    invoicyMP.setMedPagGlosaMP(medioPago.getGlosaMP());
                    invoicyMP.setMedPagOrdenMP(medioPago.getOrdenMP());
                    invoicyMP.setMedPagValorPago(medioPago.getValorPago());
                }
                break block10;
            }
            if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_Exp)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_Exp))) {
                List<MediosPago.MedioPago> genericMedioPago = null;
                if (genericDto.getEFactExp().getMediosPago() != null) {
                    genericMedioPago = genericDto.getEFactExp().getMediosPago().getMedioPago();
                }
                if (genericMedioPago != null) {
                    for (MediosPago.MedioPago medioPago : genericMedioPago) {
                        CFEInvoiCyType.MediosPago.MediosPagoItem invoicyMP = new CFEInvoiCyType.MediosPago.MediosPagoItem();
                        invoicyMediosPago.add(invoicyMP);
                        invoicyMP.setMedPagNroLinMP(medioPago.getNroLinMP());
                        invoicyMP.setMedPagCodMP(medioPago.getCodMP());
                        invoicyMP.setMedPagGlosaMP(medioPago.getGlosaMP());
                        invoicyMP.setMedPagOrdenMP(medioPago.getOrdenMP());
                        invoicyMP.setMedPagValorPago(medioPago.getValorPago());
                    }
                }
            }
        }
    }

    protected void loadReferencia(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        block10: {
            BiMap<String, CFEUtils.CfeType> cfeTypes;
            List<CFEInvoiCyType.Referencia.ReferenciaItem> invoicyReferencias;
            block9: {
                invoicyDto.setReferencia(new CFEInvoiCyType.Referencia());
                invoicyReferencias = invoicyDto.getReferencia().getReferenciaItem();
                cfeTypes = CFEUtils.getCfeTypes();
                if (cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) && cfeType != Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) break block9;
                List<Referencia.Referencia1> genericReferencias = null;
                if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
                    if (genericDto.getEFact().getReferencia() != null) {
                        genericReferencias = genericDto.getEFact().getReferencia().getReferencia1();
                    }
                } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) && genericDto.getETck().getReferencia() != null) {
                    genericReferencias = genericDto.getETck().getReferencia().getReferencia1();
                }
                if (genericReferencias == null) break block10;
                for (Referencia.Referencia1 genericRef : genericReferencias) {
                    CFEInvoiCyType.Referencia.ReferenciaItem invoicyReferenciaItem = new CFEInvoiCyType.Referencia.ReferenciaItem();
                    invoicyReferencias.add(invoicyReferenciaItem);
                    invoicyReferenciaItem.setRefNroLinRef(genericRef.getNroLinRef());
                    invoicyReferenciaItem.setRefIndGlobal(genericRef.getIndGlobal());
                    invoicyReferenciaItem.setRefTpoDocRef(genericRef.getTpoDocRef());
                    invoicyReferenciaItem.setRefSerie(genericRef.getSerie());
                    invoicyReferenciaItem.setRefNroCFERef(genericRef.getNroCFERef());
                    invoicyReferenciaItem.setRefRazonRef(genericRef.getRazonRef());
                    invoicyReferenciaItem.setRefFechaCFEref(genericRef.getFechaCFEref());
                }
                break block10;
            }
            if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND))) {
                List<Referencia.Referencia1> genericReferencias = null;
                if (genericDto.getEFactExp().getReferencia() != null) {
                    genericReferencias = genericDto.getEFactExp().getReferencia().getReferencia1();
                }
                if (genericReferencias != null) {
                    for (Referencia.Referencia1 genericRef : genericReferencias) {
                        CFEInvoiCyType.Referencia.ReferenciaItem invoicyReferenciaItem = new CFEInvoiCyType.Referencia.ReferenciaItem();
                        invoicyReferencias.add(invoicyReferenciaItem);
                        invoicyReferenciaItem.setRefNroLinRef(genericRef.getNroLinRef());
                        invoicyReferenciaItem.setRefIndGlobal(genericRef.getIndGlobal());
                        invoicyReferenciaItem.setRefTpoDocRef(genericRef.getTpoDocRef());
                        invoicyReferenciaItem.setRefSerie(genericRef.getSerie());
                        invoicyReferenciaItem.setRefNroCFERef(genericRef.getNroCFERef());
                        invoicyReferenciaItem.setRefRazonRef(genericRef.getRazonRef());
                        invoicyReferenciaItem.setRefFechaCFEref(genericRef.getFechaCFEref());
                    }
                }
            }
        }
    }

    protected void loadAdenda(Object obj, CFEInvoiCyType invoicyDto) {
        CFEInvoiCyType.IdDoc idDoc = invoicyDto.getIdDoc();
        if (idDoc != null && obj != null) {
            idDoc.setCFEAdenda(obj.toString());
        }
    }

    private void loadComplementoFiscal(int cfeType, CFEDefType genericDto, CFEInvoiCyType invoicyDto) {
        ComplFiscalDataType genericComplFiscalData = null;
        BiMap<String, CFEUtils.CfeType> cfeTypes = CFEUtils.getCfeTypes();
        if (cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eFactura_ND_VxCA))) {
            if (genericDto.getEFact().getComplFiscal() != null) {
                genericComplFiscalData = genericDto.getEFact().getComplFiscal().getComplFiscalData();
            }
        } else if ((cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_NC_VxCA)) || cfeType == Integer.valueOf((String)cfeTypes.inverse().get((Object)CFEUtils.CfeType.eTicket_ND_VxCA))) && genericDto.getETck().getComplFiscal() != null) {
            genericComplFiscalData = genericDto.getETck().getComplFiscal().getComplFiscalData();
        }
        if (genericComplFiscalData != null) {
            CFEInvoiCyType.Mandante mandante = new CFEInvoiCyType.Mandante();
            invoicyDto.setMandante(mandante);
            mandante.setMndTipDoc(genericComplFiscalData.getTipoDocMdte());
            mandante.setMndCodPais(genericComplFiscalData.getPais());
            mandante.setMndNroDocumento(genericComplFiscalData.getDocMdte());
            mandante.setMndRazSocial(genericComplFiscalData.getNombreMdte());
            mandante.setMndEncriptar(SNType.N);
        }
    }

    private void sendCfe() {
        String endpoint = this.mluyVendorInvoicy.getEndPoint();
        String empCodigo = this.mluyVendorInvoicy.getValueNumber().setScale(0).toString();
        String empPK = this.mluyVendorInvoicy.getInvoiCyPK();
        String empCK = this.mluyVendorInvoicy.getInvoiCyCK();
        try {
            String linea;
            String lineaCfe;
            String fnpTimestamp = "tstm";
            try {
                fnpTimestamp = new SimpleDateFormat("yyyyMMdd_hhmmssSSS").format(new Timestamp(System.currentTimeMillis()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fnpCliOrg = "ccoo";
            try {
                fnpCliOrg = MSysConfig.getValue("UY_CFE_Tmp_File_Pattern_ORG", "ccoo", Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fnpDoc = "iii_snnn";
            try {
                CFEInvoiCyType.IdDoc idDoc = this.envioCfe.getCFE().getCFEItem().get(0).getIdDoc();
                fnpDoc = idDoc.getCFETipoCFE() + "_" + idDoc.getCFESerie() + idDoc.getCFENro();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String fnpName = "CFE_" + fnpTimestamp + "_" + fnpCliOrg + "_" + fnpDoc;
            File cfeFile = File.createTempFile(fnpName + "__generic__", ".xml");
            cfeFile.deleteOnExit();
            JAXBContext jaxbContextCfe = JAXBContext.newInstance((Class[])new Class[]{CFEInvoiCyCollectionType.class});
            Marshaller jaxbMarshallerCfe = jaxbContextCfe.createMarshaller();
            jaxbMarshallerCfe.setProperty("jaxb.formatted.output", (Object)false);
            jaxbMarshallerCfe.marshal((Object)this.envioCfe.getCFE(), cfeFile);
            FileReader frCfe = new FileReader(cfeFile);
            BufferedReader brCfe = new BufferedReader(frCfe);
            String xmlCfe = "";
            while ((lineaCfe = brCfe.readLine()) != null) {
                xmlCfe = xmlCfe + lineaCfe;
            }
            xmlCfe = empCK + xmlCfe.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "").replace(" xmlns=\"http://www.invoicy.com.uy/\"", "");
            String hashXmlCfe = CFEUtils.md5Encrypt(xmlCfe);
            EncabezadoEnvioType encabezado = new EncabezadoEnvioType();
            this.envioCfe.setEncabezado(encabezado);
            encabezado.setEmpCK(hashXmlCfe);
            encabezado.setEmpPK(empPK);
            encabezado.setEmpCodigo(empCodigo);
            File file = File.createTempFile(fnpName + "__invoicy__", ".xml");
            file.deleteOnExit();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EnvioCFE.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)false);
            jaxbMarshaller.marshal((Object)this.envioCfe, file);
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String xml = "";
            while ((linea = br.readLine()) != null) {
                xml = xml + linea;
            }
            xml = xml.replace(" xmlns=\"http://www.invoicy.com.uy/\"", "");
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(endpoint));
            call.setOperationName("Execute");
            call.setSOAPActionURI("Gxaction/AWS_EMISSIONFACTURA.Execute");
            call.addParameter(new QName("Gx", "Xmlrecepcao"), XMLType.XSD_STRING, ParameterMode.IN);
            call.setReturnType(XMLType.XSD_STRING);
            String result = (String)call.invoke(new Object[]{xml});
            File response = File.createTempFile(fnpName + "__response__", ".xml");
            response.deleteOnExit();
            FileWriter fichero = new FileWriter(response);
            PrintWriter pw = new PrintWriter(fichero);
            pw.print(result);
            pw.close();
            JAXBContext jaxbContextResponse = JAXBContext.newInstance((Class[])new Class[]{EnvioCFERetorno.class});
            Unmarshaller jaxbUnmarshaller = jaxbContextResponse.createUnmarshaller();
            EnvioCFERetorno envioCfeRetorno = (EnvioCFERetorno)jaxbUnmarshaller.unmarshal(response);
            this.processResponse(xml, result, envioCfeRetorno, this.document);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    public void processResponse(String xmlSent, String xmlResponse, EnvioCFERetorno envioCFERetorno, PO po) {
        this.mluyDocument = new MLUYDocument(po.getCtx(), 0, po.get_TrxName());
        ListaCFERetornoType.CFE cfe = null;
        try {
            cfe = envioCFERetorno.getListaCFE().getCFE().get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mluyDocument.setAD_Table_ID(po.get_Table_ID());
        this.mluyDocument.setRecord_ID(po.get_ID());
        this.mluyDocument.setCFECodigoSeguridad(cfe.getCFECodigoSeguridad());
        this.mluyDocument.setCFEEstadoAcuse(new BigDecimal(cfe.getCFEEstadoAcuse()));
        this.mluyDocument.setCFEMsgCod(new BigDecimal(cfe.getCFEMsgCod()));
        this.mluyDocument.setCFEMsgDsc(cfe.getCFEMsgDsc());
        this.mluyDocument.setCFENro(new BigDecimal(cfe.getCFENro()));
        this.mluyDocument.setCFENumReferencia(new BigDecimal(cfe.getCFENumReferencia()));
        this.mluyDocument.setCFERepImpressa(cfe.getCFERepImpressa());
        this.mluyDocument.setCFESerie(cfe.getCFESerie());
        this.mluyDocument.setCFEStatus(new BigDecimal(cfe.getCFEStatus()));
        this.mluyDocument.setCFETipo(new BigDecimal(cfe.getCFETipo()));
        try {
            if (this.mluyDocument.get_ColumnIndex("CFEQrCode") > 0) {
                this.mluyDocument.setCFEQrCode(cfe.getCFEQrCode());
            }
            if (this.mluyDocument.get_ColumnIndex("CFECAEId") > 0) {
                this.mluyDocument.setCFECAEId(String.valueOf(cfe.getCFEDatosAvanzados().getCFECAEId()));
            }
            if (this.mluyDocument.get_ColumnIndex("CFECAENroIni") > 0) {
                this.mluyDocument.setCFECAENroIni(cfe.getCFEDatosAvanzados().getCFECAENroIni().intValue());
            }
            if (this.mluyDocument.get_ColumnIndex("CFECAENroFin") > 0) {
                this.mluyDocument.setCFECAENroFin(cfe.getCFEDatosAvanzados().getCFECAENroFin().intValue());
            }
            if (this.mluyDocument.get_ColumnIndex("CFECAEFchVenc") > 0) {
                this.mluyDocument.setCFECAEFchVenc(new Timestamp(cfe.getCFEDatosAvanzados().getCFECAEFchVenc().toGregorianCalendar().getTimeInMillis()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String msgExtraInfo = "";
        if (cfe.getErros() != null) {
            for (ListaCFERetornoType.CFE.Erros.ErrosItem errosItem : cfe.getErros().getErrosItem()) {
                msgExtraInfo = msgExtraInfo + errosItem.getCFEErrCod() + " - " + errosItem.getCFEErrDesc() + "\n";
            }
        }
        if (cfe.getErrosDGI() != null) {
            for (ListaCFERetornoType.CFE.ErrosDGI.ErrosDGIItem errosDGIItem : cfe.getErrosDGI().getErrosDGIItem()) {
                msgExtraInfo = msgExtraInfo + errosDGIItem.getCFERetCod() + " - " + errosDGIItem.getCFERetDesc() + "\n";
            }
        }
        this.mluyDocument.setCFEMsgExtraInfo(msgExtraInfo);
        this.mluyDocument.setXMLSent(xmlSent);
        this.mluyDocument.setXMLResponded(xmlResponse);
        this.mluyDocument.saveEx();
        if (this.mluyDocument.getCFEStatus().equals(new BigDecimal(3))) {
            throw new AdempiereException("CFE OpenUp-Migrate Provider Error: CFE Rechazado");
        }
    }
}

