/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.engine;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.TreeSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.openup.LUY.engine.LUYVendorInterface;
import org.openup.LUY.model.MLUYVendor;

public final class LUYVendorEngine {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static LUYVendorEngine s_instance = null;
    private static TreeSet<String> s_VendorImplement = new TreeSet();
    private HashMap<String, LUYVendorInterface> m_VendorService = new HashMap();

    private LUYVendorEngine() {
        this.registerLUYVendor(true);
    }

    public LUYVendorInterface getLUYVendorFactory(String className) {
        if (this.m_VendorService.containsKey(className)) {
            return this.m_VendorService.get(className);
        }
        try {
            Class cl = this.getClass(className);
            Constructor constructor = null;
            try {
                constructor = cl.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                this.log.fine("Not found LUY Vendor");
            }
            if (constructor != null) {
                LUYVendorInterface vendorService = (LUYVendorInterface)constructor.newInstance(new Object[0]);
                this.m_VendorService.put(className, vendorService);
                return vendorService;
            }
            constructor = cl.getDeclaredConstructor(new Class[0]);
            LUYVendorInterface service = (LUYVendorInterface)constructor.newInstance(new Object[0]);
            this.m_VendorService.put(className, service);
            return service;
        }
        catch (ClassNotFoundException e) {
            s_VendorImplement.add(className);
        }
        catch (Throwable e) {
            throw new AdempiereException(e);
        }
        return null;
    }

    protected <T extends LUYVendorInterface> Class<T> getClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    protected void registerLUYVendor(boolean reset) {
        if (reset) {
            this.m_VendorService.clear();
        }
        for (MLUYVendor vendor : MLUYVendor.getVendors()) {
            this.getLUYVendorFactory(vendor.getClassname());
        }
    }

    public static LUYVendorEngine get() {
        return new LUYVendorEngine();
    }
}

