/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.service;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.I_HR_Period;
import org.eevolution.model.I_HR_Process;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPayroll;

public class HRActionNotice {
    protected static CLogger log = CLogger.getCLogger(HRActionNotice.class);
    public int m_WindowNo = 0;
    protected I_HR_Process payrollProcess = null;
    protected int payrollProcessId = 0;
    protected int payrollId = 0;
    protected int conceptId = 0;
    protected int partnerId = 0;
    protected int movementId = 0;
    protected boolean isLookupTextMsg = false;
    protected Timestamp dateStart = null;
    protected Timestamp dateEnd = null;
    protected BigDecimal quantity = Env.ZERO;
    protected BigDecimal amount = Env.ZERO;
    protected String text = null;
    protected Timestamp serviceDate = null;
    protected String description;
    protected Timestamp validFrom = null;
    protected Timestamp validTo = null;

    public void dynInit() throws Exception {
        log.info("HRActionNotice");
    }

    public void configureMiniTable(IMiniTable iMiniTable) {
        iMiniTable.addColumn("HR_Movement_ID");
        iMiniTable.addColumn("AD_Org_ID");
        iMiniTable.addColumn("HR_Concept_ID");
        iMiniTable.addColumn("ValidFrom");
        iMiniTable.addColumn("ColumnType");
        iMiniTable.addColumn("Qty");
        iMiniTable.addColumn("Amount");
        iMiniTable.addColumn("ServiceDate");
        iMiniTable.addColumn("TextMsg");
        iMiniTable.addColumn("Description");
        iMiniTable.setColumnClass(0, IDColumn.class, false, " ");
        iMiniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        iMiniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "HR_Concept_ID"));
        iMiniTable.setColumnClass(3, Timestamp.class, true, Msg.translate(Env.getCtx(), "ValidFrom"));
        iMiniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "ColumnType"));
        iMiniTable.setColumnClass(5, BigDecimal.class, true, Msg.translate(Env.getCtx(), "Qty"));
        iMiniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "Amount"));
        iMiniTable.setColumnClass(7, Timestamp.class, true, Msg.translate(Env.getCtx(), "ServiceDate"));
        iMiniTable.setColumnClass(8, String.class, true, Msg.translate(Env.getCtx(), "TextMsg"));
        iMiniTable.setColumnClass(9, String.class, true, Msg.translate(Env.getCtx(), "Description"));
        iMiniTable.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Properties properties, IMiniTable iMiniTable, int n) {
        if (this.payrollProcessId == 0 || this.partnerId == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT o.Name, hc.Name, hm.ValidFrom, cr.ColumnType, hm.Qty, hm.Amount, hm.ServiceDate, hm.TextMsg, hm.Description, hm.HR_Movement_ID, hm.AD_Org_ID, hm.HR_Process_ID,hm.HR_Concept_ID ");
        stringBuffer.append("FROM HR_Movement hm INNER JOIN AD_Org o ON(hm.AD_Org_ID = o.AD_Org_ID) INNER JOIN HR_Concept hc ON(hm.HR_Concept_ID = hc.HR_Concept_ID) LEFT JOIN (SELECT r.Value, COALESCE(rt.Name, r.Name) ColumnType \t\t\t\tFROM AD_Ref_List r \t\t\t\tLEFT JOIN AD_Ref_List_Trl rt ON(rt.AD_Ref_List_ID = r.AD_Ref_List_ID AND rt.AD_Language = ?) \t\t\t\tWHERE r.AD_Reference_ID = ?) cr ON(cr.Value = hc.ColumnType) ");
        stringBuffer.append("WHERE hm.Processed = 'N' AND hm.HR_Process_ID = ? AND hm.C_BPartner_ID = ? ");
        stringBuffer.append("ORDER BY o.AD_Org_ID, hm.HR_Process_ID, hm.ValidFrom, hm.HR_Concept_ID");
        int n2 = 0;
        iMiniTable.setRowCount(n2);
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            cPreparedStatement.setString(1, Env.getAD_Language(Env.getCtx()));
            cPreparedStatement.setInt(2, 53243);
            cPreparedStatement.setInt(3, this.payrollProcessId);
            cPreparedStatement.setInt(4, this.partnerId);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                int n3 = n;
                iMiniTable.setRowCount(n2 + 1);
                iMiniTable.setColumnClass(0, IDColumn.class, false, " ");
                iMiniTable.setValueAt(resultSet.getString(1), n2, n3++);
                iMiniTable.setValueAt(resultSet.getString(2), n2, n3++);
                iMiniTable.setValueAt(resultSet.getTimestamp(3), n2, n3++);
                iMiniTable.setValueAt(resultSet.getString(4), n2, n3++);
                iMiniTable.setValueAt(resultSet.getObject(5) != null ? resultSet.getBigDecimal(5) : Env.ZERO, n2, n3++);
                iMiniTable.setValueAt(resultSet.getObject(6) != null ? resultSet.getBigDecimal(6) : Env.ZERO, n2, n3++);
                iMiniTable.setValueAt(resultSet.getTimestamp(7), n2, n3++);
                iMiniTable.setValueAt(resultSet.getString(8), n2, n3++);
                iMiniTable.setValueAt(resultSet.getString(9), n2, n3++);
                ++n2;
            }
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, stringBuffer.toString(), sQLException);
        }
        finally {
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        iMiniTable.autoSize();
    }

    public static KeyNamePair[] getProcess() {
        String string = MRole.getDefault().addAccessSQL("SELECT hrp.HR_Process_ID,hrp.DocumentNo ||'-'|| hrp.Name, hrp.DocumentNo, hrp.Name FROM HR_Process hrp", "hrp", true, false) + " AND hrp.IsActive = 'Y' AND hrp.DocStatus IN('DR', 'IP') ";
        string = string + " ORDER BY hrp.DocumentNo, hrp.Name";
        return DB.getKeyNamePairs(string, true);
    }

    public static KeyNamePair[] getEmployeeValid(I_HR_Process i_HR_Process) {
        ArrayList<KeyNamePair> arrayList = new ArrayList<KeyNamePair>();
        if (i_HR_Process == null) {
            return new KeyNamePair[]{new KeyNamePair(0, "")};
        }
        MHRPayroll mHRPayroll = MHRPayroll.getById(Env.getCtx(), i_HR_Process.getHR_Payroll_ID(), i_HR_Process.getName());
        KeyNamePair keyNamePair = new KeyNamePair(0, "");
        arrayList.add(keyNamePair);
        String string = MRole.getDefault().addAccessSQL("SELECT bp.C_BPartner_ID, bp.Value || ' - ' || bp.Name || COALESCE(' ' || bp.Name2, '') FROM C_BPartner bp", "bp", true, false) + " AND bp.IsActive = 'Y' AND EXISTS(SELECT 1 FROM HR_Employee hrpe \t\t\t\tWHERE hrpe.C_BPartner_ID = bp.C_BPartner_ID \t\t\t\tAND hrpe.IsActive = 'Y'";
        if (i_HR_Process.getHR_Payroll_ID() != 0 && i_HR_Process.getHR_Payroll_ID() != 0 && !mHRPayroll.isIgnoreDefaultPayroll()) {
            string = string + " AND (hrpe.HR_Payroll_ID =" + i_HR_Process.getHR_Payroll_ID() + " OR hrpe.HR_Payroll_ID is NULL)";
            if (i_HR_Process.getHR_Department_ID() > 0) {
                string = string + " AND (hrpe.HR_Department_ID =" + i_HR_Process.getHR_Department_ID() + " OR hrpe.HR_Department_ID is NULL)";
            }
            if (i_HR_Process.getHR_Job_ID() > 0) {
                string = string + " AND (hrpe.HR_Job_ID =" + i_HR_Process.getHR_Job_ID() + " OR hrpe.HR_Job_ID is NULL)";
            }
            if (i_HR_Process.getHR_Employee_ID() > 0) {
                string = string + " AND (hrpe.HR_Employee_ID =" + i_HR_Process.getHR_Employee_ID() + " OR hrpe.HR_Employee_ID is NULL)";
            }
        }
        string = string + ") ORDER BY 2 ";
        return DB.getKeyNamePairs(string, true);
    }

    public KeyNamePair[] getConcept(I_HR_Process i_HR_Process, boolean bl) {
        if (i_HR_Process == null) {
            return null;
        }
        String string = MRole.getDefault().addAccessSQL("SELECT hrpc.HR_Concept_ID, hrpc.Value || ' - ' || hrpc.Name, hrpc.Value FROM HR_Concept hrpc ", "hrpc", true, false) + " AND hrpc.AD_Client_ID = " + i_HR_Process.getAD_Client_ID() + " AND hrpc.IsActive = 'Y' AND hrpc.IsManual = 'Y' AND hrpc.Type != 'E' AND EXISTS(SELECT 1 FROM HR_Attribute a \t\t\t\t\t\tWHERE a.HR_Concept_ID = hrpc.HR_Concept_ID";
        if (!bl) {
            if (i_HR_Process.getHR_Payroll_ID() != 0) {
                string = string + " AND (a.HR_Payroll_ID = " + i_HR_Process.getHR_Payroll_ID() + " OR a.HR_Payroll_ID is NULL)";
            }
            if (i_HR_Process.getHR_Department_ID() != 0) {
                // empty if block
            }
            string = string + " AND (a.HR_Department_ID = " + i_HR_Process.getHR_Department_ID() + " OR a.HR_Department_ID is NULL)";
            if (i_HR_Process.getHR_Job_ID() != 0) {
                // empty if block
            }
            string = string + " AND (a.HR_Job_ID = " + i_HR_Process.getHR_Job_ID() + " OR a.HR_Job_ID is NULL)";
            if (i_HR_Process.getHR_Department_ID() != 0) {
                // empty if block
            }
            string = string + " AND (a.HR_Employee_ID = " + i_HR_Process.getHR_Employee_ID() + " OR a.HR_Employee_ID is NULL)";
        }
        string = string + ") ORDER BY 2";
        return DB.getKeyNamePairs(string, true);
    }

    public int seekMovement(Timestamp timestamp) {
        if (this.conceptId <= 0) {
            return 0;
        }
        int n = 0;
        String string = DB.TO_DATE(timestamp);
        int n2 = this.payrollProcessId;
        int n3 = this.partnerId;
        int n4 = this.conceptId;
        if (n2 + n3 + n4 > 0) {
            n = DB.getSQLValue(null, "SELECT HR_Movement_ID  FROM HR_Movement WHERE HR_Process_ID = " + n2 + " AND C_BPartner_ID =" + n3 + " AND HR_Concept_ID = " + n4 + " AND TRUNC(ValidFrom) = TRUNC(" + string + ")");
        }
        return n;
    }

    public MLookup getColumnTypeLookup() {
        MLookupInfo mLookupInfo = MLookupFactory.getLookup_List(Env.getLanguage(Env.getCtx()), 53243);
        return new MLookup(mLookupInfo, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ValueNamePair> getConceptReference(int n) {
        ArrayList<ValueNamePair> arrayList = new ArrayList<ValueNamePair>();
        MLookupInfo mLookupInfo = MLookupFactory.getLookup_List(Env.getLanguage(Env.getCtx()), n);
        if (mLookupInfo == null) {
            return arrayList;
        }
        String string = mLookupInfo.Query;
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, null);
            resultSet = cPreparedStatement.executeQuery();
            ValueNamePair valueNamePair = null;
            arrayList.add(new ValueNamePair("", ""));
            while (resultSet.next()) {
                valueNamePair = new ValueNamePair(resultSet.getString(2), resultSet.getString(3));
                arrayList.add(valueNamePair);
            }
        }
        catch (SQLException sQLException) {
            try {
                log.log(Level.SEVERE, string, sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet);
                DB.close(cPreparedStatement);
                throw throwable;
            }
            DB.close(resultSet);
            DB.close(cPreparedStatement);
        }
        DB.close(resultSet);
        DB.close(cPreparedStatement);
        return arrayList;
    }

    protected Integer getConceptId() {
        return this.conceptId;
    }

    protected Integer getPartnerId() {
        return this.partnerId;
    }

    protected I_HR_Process getPayrollProcess() {
        return this.payrollProcess;
    }

    protected BigDecimal getQuantity() {
        return this.quantity;
    }

    protected BigDecimal getAmount() {
        return this.amount;
    }

    protected String getText() {
        return this.text;
    }

    protected String getDescription() {
        return this.description;
    }

    protected Timestamp getValidFrom() {
        return this.validFrom;
    }

    protected Timestamp getValidTo() {
        return this.validTo;
    }

    protected Timestamp getServiceDate() {
        return this.serviceDate;
    }

    public MHRMovement saveMovement() {
        MHRConcept mHRConcept = MHRConcept.getById(Env.getCtx(), this.getConceptId(), null);
        MHRMovement mHRMovement = new MHRMovement(Env.getCtx(), this.movementId, null);
        I_HR_Period i_HR_Period2 = this.getPayrollProcess().getHR_Period();
        mHRMovement.setSeqNo(mHRConcept.getSeqNo());
        Optional.ofNullable(this.getDescription()).ifPresent(string -> mHRMovement.setDescription(string.toString()));
        mHRMovement.setHR_Process_ID(this.getPayrollProcess().getHR_Process_ID());
        Optional.ofNullable(i_HR_Period2).ifPresent(i_HR_Period -> mHRMovement.setPeriodNo(i_HR_Period.getPeriodNo()));
        mHRMovement.setC_BPartner_ID(this.getPartnerId());
        mHRMovement.setHR_Concept_ID(this.getConceptId());
        mHRMovement.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
        if (mHRConcept.getColumnType().equals("Q")) {
            Optional.ofNullable(this.getQuantity()).ifPresent(bigDecimal -> mHRMovement.setQty((BigDecimal)bigDecimal));
        } else if (mHRConcept.getColumnType().equals("A")) {
            Optional.ofNullable(this.getAmount()).ifPresent(bigDecimal -> mHRMovement.setAmount((BigDecimal)bigDecimal));
        }
        mHRMovement.setTextMsg(this.getText());
        mHRMovement.setServiceDate(this.getServiceDate());
        mHRMovement.setValidFrom(this.getValidFrom());
        mHRMovement.setValidTo(this.getValidTo());
        MHREmployee mHREmployee = MHREmployee.getActiveEmployee(Env.getCtx(), mHRMovement.getC_BPartner_ID(), null);
        if (mHREmployee != null) {
            MHRPayroll mHRPayroll = MHRPayroll.getById(Env.getCtx(), this.payrollProcess.getHR_Payroll_ID(), null);
            mHRMovement.setAD_Org_ID(mHREmployee.getAD_Org_ID());
            mHRMovement.setHR_Department_ID(mHREmployee.getHR_Department_ID());
            mHRMovement.setHR_Job_ID(mHREmployee.getHR_Job_ID());
            mHRMovement.setHR_SkillType_ID(mHREmployee.getHR_SkillType_ID());
            mHRMovement.setC_Activity_ID(mHREmployee.getC_Activity_ID() > 0 ? mHREmployee.getC_Activity_ID() : mHREmployee.getHR_Department().getC_Activity_ID());
            mHRMovement.setHR_Payroll_ID(this.payrollProcess.getHR_Payroll_ID());
            mHRMovement.setHR_Contract_ID(mHRPayroll.getHR_Contract_ID());
            mHRMovement.setHR_Employee_ID(mHREmployee.getHR_Employee_ID());
            mHRMovement.setHR_EmployeeType_ID(mHREmployee.getHR_EmployeeType_ID());
        }
        mHRMovement.setIsManual(true);
        mHRMovement.saveEx();
        if (!(mHRMovement.getAmount() != null && !mHRMovement.getAmount().equals(Env.ZERO) || mHRMovement.getQty() != null && !mHRMovement.getQty().equals(Env.ZERO) || mHRMovement.getServiceDate() != null || mHRMovement.getTextMsg() != null && !Util.isEmpty(mHRMovement.getTextMsg()))) {
            mHRMovement.deleteEx(false);
        }
        this.movementId = mHRMovement.getHR_Movement_ID();
        return mHRMovement;
    }
}

