/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.X_T_BOMLine;
import org.eevolution.report.CostBillOfMaterialAbstract;

public class CostBillOfMaterial
extends CostBillOfMaterialAbstract {
    private static final String LEVELS = "....................";
    private boolean isImplosion = false;
    private int levelNo = 0;
    private int seqNo = 0;
    private List<MCostElement> costElements = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MAcctSchema accountSchema = MAcctSchema.get(this.getCtx(), this.getAccountingSchemaId());
        this.explodeProduct(accountSchema, this.getProductId(), false);
        return "@Ok@";
    }

    private void explodeProduct(MAcctSchema accountSchema, int productId, boolean isComponent) {
        MProduct product = MProduct.get(this.getCtx(), productId);
        List<MPPProductBOM> boms = this.getBOMs(product, isComponent);
        if (!isComponent && boms.size() == 0) {
            throw new AdempiereException("@Error@ Product is not a BOM");
        }
        boms.stream().filter(bom -> bom != null).forEach(bom -> {
            if (!isComponent) {
                this.createLines(accountSchema, (MPPProductBOM)bom, null);
            }
            ++this.levelNo;
            Arrays.stream(bom.getLines()).filter(bomLine -> bomLine != null && bomLine.isActive()).forEach(bomLine -> {
                this.createLines(accountSchema, (MPPProductBOM)bom, (MPPProductBOMLine)bomLine);
                this.explodeProduct(accountSchema, bomLine.getM_Product_ID(), true);
            });
            --this.levelNo;
        });
    }

    private List<MPPProductBOM> getBOMs(MProduct product, boolean includeAlternativeBOMs) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("M_Product_ID").append("=?");
        params.add(product.get_ID());
        if (includeAlternativeBOMs) {
            whereClause.append(" AND ").append("Value").append("=?");
            params.add(product.getValue());
        }
        return new Query(this.getCtx(), "PP_Product_BOM", whereClause.toString(), null).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Value").list();
    }

    private void createLines(MAcctSchema accountSchema, MPPProductBOM bom, MPPProductBOMLine bomLine) {
        BigDecimal qty;
        MProduct product;
        if (bomLine != null) {
            product = MProduct.get(this.getCtx(), bomLine.getM_Product_ID());
            qty = bomLine.getQty();
        } else if (bom != null) {
            product = MProduct.get(this.getCtx(), bom.getM_Product_ID());
            qty = Env.ONE;
        } else {
            throw new AdempiereException("@NotFound@ @PP_Product_BOM_ID@");
        }
        this.getCostElements().stream().filter(costElement -> costElement != null).forEach(costElement -> {
            X_T_BOMLine reportBOMLine = new X_T_BOMLine(this.getCtx(), 0, this.get_TrxName());
            reportBOMLine.setAD_Org_ID(this.getOrganizationId());
            reportBOMLine.setM_Warehouse_ID(this.getWarehouseId());
            reportBOMLine.setSel_Product_ID(this.getProductId());
            reportBOMLine.setImplosion(this.isImplosion);
            reportBOMLine.setC_AcctSchema_ID(this.getAccountingSchemaId());
            reportBOMLine.setM_CostType_ID(this.getCostTypeId());
            reportBOMLine.setCostingMethod(this.getCostingMethod());
            reportBOMLine.setAD_PInstance_ID(this.getAD_PInstance_ID());
            reportBOMLine.setM_CostElement_ID(costElement.get_ID());
            reportBOMLine.setM_Product_ID(product.get_ID());
            reportBOMLine.setM_Warehouse_ID(this.getWarehouseId());
            reportBOMLine.setQtyBOM(qty);
            reportBOMLine.setSeqNo(this.seqNo);
            reportBOMLine.setLevelNo(this.levelNo);
            reportBOMLine.setLevels(LEVELS.substring(0, this.levelNo) + this.levelNo);
            BigDecimal currentCostPrice = Env.ZERO;
            BigDecimal currentCostPriceLL = Env.ZERO;
            BigDecimal futureCostPrice = Env.ZERO;
            BigDecimal futureCostPriceLL = Env.ZERO;
            CostEngine engine = CostEngineFactory.getCostEngine(this.getAD_Client_ID());
            List<MCost> costs = MCost.getByElement(product, accountSchema, this.getCostTypeId(), this.getOrganizationId(), this.getWarehouseId(), 0, costElement.getM_CostElement_ID());
            boolean isCostFrozen = false;
            for (MCost cost : costs) {
                currentCostPrice = currentCostPrice.add(cost.getCurrentCostPrice());
                currentCostPriceLL = currentCostPriceLL.add(cost.getCurrentCostPriceLL());
                futureCostPrice = futureCostPrice.add(cost.getFutureCostPrice());
                futureCostPriceLL = futureCostPriceLL.add(cost.getFutureCostPriceLL());
                isCostFrozen = cost.isCostFrozen();
            }
            reportBOMLine.setCurrentCostPrice(currentCostPrice);
            reportBOMLine.setCurrentCostPriceLL(currentCostPriceLL);
            reportBOMLine.setFutureCostPrice(currentCostPrice);
            reportBOMLine.setFutureCostPriceLL(currentCostPriceLL);
            reportBOMLine.setIsCostFrozen(isCostFrozen);
            if (bomLine != null) {
                reportBOMLine.setPP_Product_BOM_ID(bomLine.getPP_Product_BOM_ID());
                reportBOMLine.setPP_Product_BOMLine_ID(bomLine.getPP_Product_BOMLine_ID());
            } else if (bom != null) {
                reportBOMLine.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            }
            reportBOMLine.saveEx();
            ++this.seqNo;
        });
    }

    public List<MCostElement> getCostElements() {
        if (this.costElements == null) {
            this.costElements = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        }
        return this.costElements;
    }
}

