/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.X_T_BOMLine;

public class SimulatedPickList
extends SvrProcess {
    private static final Properties ctx = Env.getCtx();
    private int p_M_Product_ID = 0;
    private int p_M_Warehouse_ID = 0;
    private Timestamp p_DateTrx;
    private BigDecimal p_QtyRequiered = Env.ONE;
    private String p_BackflushGroup = null;
    private int p_LevelNo = 1;
    private int LevelNo = 1;
    private int SeqNo = 0;
    private String levels = new String("....................");
    private int AD_PInstance_ID = 0;
    private static final String X_RV_PP_Product_BOMLine_Storage_TableName = "RV_PP_Product_BOMLine_Storage";

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("DateTrx")) {
                this.p_DateTrx = (Timestamp)para.getParameter();
                continue;
            }
            if (name.equals("QtyRequired")) {
                this.p_QtyRequiered = (BigDecimal)para.getParameter();
                continue;
            }
            if (name.equals("BackflushGroup")) {
                this.p_BackflushGroup = (String)para.getParameter();
                continue;
            }
            if (name.equals("LevelNo")) {
                this.p_LevelNo = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        MProduct product = MProduct.get(this.getCtx(), this.p_M_Product_ID);
        if (!product.isVerified()) {
            throw new AdempiereException("Product BOM Configuration not verified. Please verify the product first - " + product.getValue());
        }
        try {
            this.loadBOM();
            this.print();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "PrintBOM", e.toString());
            throw new Exception(e.getLocalizedMessage());
        }
        finally {
            String sql = "DELETE FROM T_BomLine WHERE AD_PInstance_ID = " + this.AD_PInstance_ID;
            DB.executeUpdateEx(sql, this.get_TrxName());
        }
        return "@OK@";
    }

    void print() throws Exception {
        Language language = Language.getLoginLanguage();
        MPrintFormat pf = null;
        int pfid = 0;
        RowSet pfrs = MPrintFormat.getAccessiblePrintFormats(MTable.getTable_ID(X_RV_PP_Product_BOMLine_Storage_TableName), -1, null);
        pfrs.next();
        pfid = pfrs.getInt("AD_PrintFormat_ID");
        pf = pfrs.getInt("AD_Client_ID") != 0 ? MPrintFormat.get(this.getCtx(), pfid, false) : MPrintFormat.copyToClient(this.getCtx(), pfid, this.getAD_Client_ID());
        pfrs.close();
        if (pf == null) {
            this.raiseError("Error: ", "No Print Format");
        }
        pf.setLanguage(language);
        pf.setTranslationLanguage(language);
        MQuery query = new MQuery(X_RV_PP_Product_BOMLine_Storage_TableName);
        query.addRestriction("AD_PInstance_ID", "=", this.AD_PInstance_ID, this.getParamenterName("AD_PInstance_ID"), this.getParamenterInfo("AD_PInstance_ID"));
        query.addRestriction("M_Warehouse_ID", "=", this.p_M_Warehouse_ID, this.getParamenterName("M_Warehouse_ID"), this.getParamenterInfo("M_Warehouse_ID"));
        query.addRestriction("M_Warehouse_ID", "=", this.p_M_Warehouse_ID, this.getParamenterName("DateTrx"), this.getParamenterInfo("DateTrx"));
        PrintInfo info = new PrintInfo(X_RV_PP_Product_BOMLine_Storage_TableName, MTable.getTable_ID(X_RV_PP_Product_BOMLine_Storage_TableName), this.getRecord_ID());
        ReportEngine re = new ReportEngine(this.getCtx(), pf, query, info);
        ReportCtl.preview(re);
        while (re.getView().isDisplayable()) {
            Env.sleep(1);
        }
    }

    public String getParamenterInfo(String name) {
        String sql = "SELECT ip.Info FROM AD_PInstance_Para ip WHERE ip.AD_PInstance_ID=? AND ip.ParameterName=?";
        return DB.getSQLValueString(this.get_TrxName(), "SELECT ip.Info FROM AD_PInstance_Para ip WHERE ip.AD_PInstance_ID=? AND ip.ParameterName=?", this.getProcessInfo().getAD_PInstance_ID(), name);
    }

    public String getParamenterName(String columnName) {
        boolean trl = !Env.isBaseLanguage(ctx, "AD_Process_Para");
        String sql = null;
        sql = trl ? "SELECT pp.Name FROM AD_Process_Para pp WHERE pp.IsActive='Y'  AND pp.AD_Process_ID=? AND pp.ColumnName=?" : "SELECT ppt.Name FROM AD_Process_Para pp , AD_Process_Para_Trl ppt WHERE pp.IsActive='Y' AND pp.AD_Process_Para_ID=ppt.AD_Process_Para_ID AND pp.AD_Process_ID=? AND pp.ColumnName=?";
        return DB.getSQLValueString(this.get_TrxName(), sql, this.getProcessInfo().getAD_Process_ID(), columnName);
    }

    private void loadBOM() throws Exception {
        int count = 0;
        if (this.p_M_Product_ID == 0) {
            this.raiseError("Error: ", "Product ID not found");
        }
        MProduct product = new MProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName());
        X_T_BOMLine tboml = new X_T_BOMLine(ctx, 0, null);
        tboml.setAD_Org_ID(product.getAD_Org_ID());
        tboml.setPP_Product_BOM_ID(0);
        tboml.setPP_Product_BOMLine_ID(0);
        tboml.setSel_Product_ID(this.p_M_Product_ID);
        tboml.setM_Product_ID(this.p_M_Product_ID);
        tboml.setSel_Product_ID(this.p_M_Product_ID);
        tboml.setDateTrx(this.p_DateTrx);
        tboml.setImplosion(false);
        tboml.setLevelNo(0);
        tboml.setLevels("0");
        tboml.setQtyBOM(Env.ONE);
        tboml.setQtyRequired(this.p_QtyRequiered);
        tboml.setM_Warehouse_ID(this.p_M_Warehouse_ID);
        tboml.setSeqNo(0);
        tboml.setAD_PInstance_ID(this.AD_PInstance_ID);
        tboml.saveEx();
        String whereClause = "M_Product_ID=?";
        List boms = new Query(this.getCtx(), "PP_Product_BOM", "M_Product_ID=?", this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(this.p_M_Product_ID).list();
        for (MPPProductBOM bom : boms) {
            if (!bom.isValidFromTo(this.p_DateTrx)) continue;
            this.parentExplotion(bom.get_ID(), this.p_QtyRequiered);
            ++count;
        }
        if (count == 0) {
            this.raiseError("Error: ", "Product is not a BOM");
        }
    }

    public void parentExplotion(int PP_Product_BOM_ID, BigDecimal qtyRequiered) throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(PP_Product_BOM_ID);
        StringBuilder whereClause = new StringBuilder("PP_Product_BOM_ID").append("=?");
        if (this.p_BackflushGroup != null) {
            whereClause.append(" AND ").append("BackflushGroup").append("LIKE ?");
            parameters.add(this.p_BackflushGroup);
        }
        List bomLines = new Query(this.getCtx(), "PP_Product_BOMLine", whereClause.toString(), this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("Line").list();
        for (MPPProductBOMLine line : bomLines) {
            if (!line.isValidFromTo(this.p_DateTrx)) continue;
            ++this.SeqNo;
            MProduct product = new MProduct(this.getCtx(), line.getM_Product_ID(), this.get_TrxName());
            X_T_BOMLine tboml = new X_T_BOMLine(ctx, 0, null);
            tboml.setAD_Org_ID(product.getAD_Org_ID());
            tboml.setPP_Product_BOM_ID(PP_Product_BOM_ID);
            tboml.setPP_Product_BOMLine_ID(line.get_ID());
            tboml.setM_Product_ID(line.getM_Product_ID());
            tboml.setLevelNo(this.LevelNo);
            tboml.setDateTrx(this.p_DateTrx);
            tboml.setLevels(this.levels.substring(0, this.LevelNo) + this.LevelNo);
            tboml.setSeqNo(this.SeqNo);
            tboml.setAD_PInstance_ID(this.AD_PInstance_ID);
            tboml.setSel_Product_ID(this.p_M_Product_ID);
            tboml.setQtyBOM(line.getQty(true));
            tboml.setQtyRequired(qtyRequiered.multiply(line.getQty(true)));
            tboml.setM_Warehouse_ID(this.p_M_Warehouse_ID);
            tboml.setImplosion(false);
            tboml.saveEx();
            this.component(line.getM_Product_ID(), tboml.getQtyBOM());
        }
    }

    public void component(int M_Product_ID, BigDecimal qtyRequiered) throws Exception {
        if (this.LevelNo == this.p_LevelNo) {
            return;
        }
        String value = DB.getSQLValueString(this.get_TrxName(), "SELECT Value FROM M_Product WHERE M_Product_ID=?", M_Product_ID);
        StringBuilder whereClause = new StringBuilder("Value").append("=? AND ").append("M_Product_ID").append("=?");
        List boms = new Query(this.getCtx(), "PP_Product_BOM", whereClause.toString(), this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(value, M_Product_ID).list();
        boolean level = false;
        for (MPPProductBOM bom : boms) {
            if (!bom.isValidFromTo(this.p_DateTrx)) continue;
            if (!level) {
                ++this.LevelNo;
            }
            level = true;
            this.parentExplotion(bom.get_ID(), qtyRequiered);
            --this.LevelNo;
        }
    }

    private void raiseError(String string, String hint) throws Exception {
        String msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = msg + hint;
        throw new Exception(msg);
    }
}

