/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.Optional;
import org.compiere.model.PO;
import org.eevolution.model.MDDLicenseAssignment;
import org.eevolution.model.MDDRequirementAssignment;
import org.eevolution.model.MDDVehicle;
import org.eevolution.process.ProcessingVehicleSelectionAbstract;

public class ProcessingVehicleSelection
extends ProcessingVehicleSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MDDVehicle> list = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MDDVehicle.Table_ID) {
            if (this.getProcessInfo().getTable_ID() == MDDVehicle.Table_ID) {
                MDDVehicle mDDVehicle = (MDDVehicle)list.stream().findFirst().get();
                MDDVehicle mDDVehicle2 = (MDDVehicle)this.getInstance(this.get_TrxName());
                if (mDDVehicle != null && mDDVehicle2 != null && mDDVehicle.get_ID() != mDDVehicle2.get_ID()) {
                    this.CopyVehicle(mDDVehicle, mDDVehicle2);
                }
            }
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingVehicle(list);
        }
        return "@Ok@";
    }

    private void UpdatingVehicle(List<MDDVehicle> list) {
        list.stream().filter(mDDVehicle -> mDDVehicle != null).forEach(mDDVehicle -> {
            int n = mDDVehicle.get_ColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = mDDVehicle.get_ColumnName(i);
                Optional.ofNullable(this.getSelection(mDDVehicle.get_ID(), this.getPrefixAliasForTableSelection() + string)).ifPresent(object -> mDDVehicle.set_ValueOfColumn(string, object));
            }
            mDDVehicle.saveEx();
        });
    }

    private void CopyVehicle(MDDVehicle mDDVehicle, MDDVehicle mDDVehicle2) {
        PO.copyValues(mDDVehicle, mDDVehicle2);
        mDDVehicle.getLicenseAssignments().forEach(mDDLicenseAssignment -> {
            MDDLicenseAssignment mDDLicenseAssignment2 = new MDDLicenseAssignment(mDDVehicle, mDDLicenseAssignment.getDD_License_ID());
            mDDLicenseAssignment2.saveEx();
        });
        mDDVehicle.getRequirementAssignments().forEach(mDDRequirementAssignment -> {
            MDDRequirementAssignment mDDRequirementAssignment2 = new MDDRequirementAssignment(mDDVehicle, mDDRequirementAssignment.getDD_Requirement_ID());
            mDDRequirementAssignment2.saveEx();
        });
        mDDVehicle2.saveEx();
    }
}

