/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.X_T_BOMLine;

public class PrintBOM
extends SvrProcess {
    private static final Properties ctx = Env.getCtx();
    private int p_M_Product_ID = 0;
    private boolean p_implosion = false;
    private int LevelNo = 1;
    private int SeqNo = 0;
    private String levels = new String("....................");
    private int AD_PInstance_ID = 0;
    private static final int X_RV_PP_Product_BOMLine_Table_ID = 53063;
    private static final String X_RV_PP_Product_BOMLine_Table_Name = "RV_PP_Product_BOMLine";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("Implosion")) {
                this.p_implosion = !((String)para[i].getParameter()).equals("N");
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        try {
            this.loadBOM();
            this.print();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "PrintBOM", e.toString());
            throw new Exception(e.getLocalizedMessage());
        }
        finally {
            String sql = "DELETE FROM T_BomLine WHERE AD_PInstance_ID = " + this.AD_PInstance_ID;
            DB.executeUpdate(sql, null);
        }
        return "@OK@";
    }

    void print() throws Exception {
        Language language = Language.getLoginLanguage();
        MPrintFormat pf = null;
        int pfid = 0;
        RowSet pfrs = MPrintFormat.getAccessiblePrintFormats(53063, -1, null);
        pfrs.next();
        pfid = pfrs.getInt("AD_PrintFormat_ID");
        pf = pfrs.getInt("AD_Client_ID") != 0 ? MPrintFormat.get(this.getCtx(), pfid, false) : MPrintFormat.copyToClient(this.getCtx(), pfid, this.getAD_Client_ID());
        pfrs.close();
        if (pf == null) {
            this.raiseError("Error: ", "No Print Format");
        }
        pf.setLanguage(language);
        pf.setTranslationLanguage(language);
        MQuery query = MQuery.get(this.getCtx(), this.AD_PInstance_ID, X_RV_PP_Product_BOMLine_Table_Name);
        query.addRestriction("AD_PInstance_ID", "=", this.AD_PInstance_ID);
        PrintInfo info = new PrintInfo(X_RV_PP_Product_BOMLine_Table_Name, 53063, this.getRecord_ID());
        ReportEngine re = new ReportEngine(this.getCtx(), pf, query, info);
        ReportCtl.preview(re);
        while (re.getView().isDisplayable()) {
            Env.sleep(1);
        }
    }

    private void loadBOM() throws Exception {
        block14: {
            ResultSet rs;
            CPreparedStatement stmt;
            block12: {
                int count;
                block13: {
                    ResultSet rs2;
                    CPreparedStatement stmt2;
                    block11: {
                        count = 0;
                        if (this.p_M_Product_ID == 0) {
                            this.raiseError("Error: ", "Product ID not found");
                        }
                        X_T_BOMLine tboml = new X_T_BOMLine(ctx, 0, null);
                        tboml.setPP_Product_BOM_ID(0);
                        tboml.setPP_Product_BOMLine_ID(0);
                        tboml.setM_Product_ID(this.p_M_Product_ID);
                        tboml.setSel_Product_ID(this.p_M_Product_ID);
                        tboml.setImplosion(this.p_implosion);
                        tboml.setLevelNo(0);
                        tboml.setLevels("0");
                        tboml.setSeqNo(0);
                        tboml.setAD_PInstance_ID(this.AD_PInstance_ID);
                        tboml.save();
                        if (!this.p_implosion) break block13;
                        stmt2 = null;
                        rs2 = null;
                        String sql = "SELECT PP_Product_BOMLine_ID FROM PP_Product_BOMLine WHERE IsActive = 'Y' AND M_Product_ID = ? ";
                        try {
                            stmt2 = DB.prepareStatement(sql, this.get_TrxName());
                            stmt2.setInt(1, this.p_M_Product_ID);
                            rs2 = stmt2.executeQuery();
                            while (rs2.next()) {
                                this.parentImplotion(rs2.getInt(1));
                                ++count;
                            }
                            if (count != 0) break block11;
                            this.raiseError("Error: ", "Product is not a component");
                        }
                        catch (SQLException e) {
                            try {
                                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                                throw new Exception("SQLException: " + e.getLocalizedMessage());
                            }
                            catch (Throwable throwable) {
                                DB.close(rs2, stmt2);
                                rs2 = null;
                                stmt2 = null;
                                throw throwable;
                            }
                        }
                    }
                    DB.close(rs2, stmt2);
                    rs2 = null;
                    stmt2 = null;
                    break block14;
                }
                stmt = null;
                rs = null;
                String sql = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM WHERE IsActive = 'Y' AND M_Product_ID = ? ";
                try {
                    stmt = DB.prepareStatement(sql, this.get_TrxName());
                    stmt.setInt(1, this.p_M_Product_ID);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.parentExplotion(rs.getInt(1));
                        ++count;
                    }
                    if (count != 0) break block12;
                    this.raiseError("Error: ", "Product is not a BOM");
                }
                catch (SQLException e) {
                    try {
                        this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                        throw new Exception("SQLException: " + e.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                }
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
    }

    public void parentImplotion(int PP_Product_BOMLine_ID) throws Exception {
        int PP_Product_BOM_ID = 0;
        int M_Product_ID = 0;
        X_T_BOMLine tboml = new X_T_BOMLine(ctx, 0, null);
        PP_Product_BOM_ID = DB.getSQLValue(null, "SELECT PP_Product_BOM_ID FROM PP_Product_BOMLine WHERE PP_Product_BOMLine_ID=?", PP_Product_BOMLine_ID);
        if (PP_Product_BOM_ID < 0) {
            throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.parentImplotion()"));
        }
        M_Product_ID = DB.getSQLValue(null, "SELECT M_Product_ID FROM PP_Product_BOM WHERE PP_Product_BOM_ID=?", PP_Product_BOM_ID);
        if (M_Product_ID < 0) {
            throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.parentImplotion()"));
        }
        tboml.setPP_Product_BOM_ID(PP_Product_BOM_ID);
        tboml.setPP_Product_BOMLine_ID(PP_Product_BOMLine_ID);
        tboml.setM_Product_ID(M_Product_ID);
        tboml.setLevelNo(this.LevelNo);
        tboml.setSel_Product_ID(this.p_M_Product_ID);
        tboml.setImplosion(this.p_implosion);
        if (this.LevelNo >= 11) {
            tboml.setLevels(this.levels + ">" + this.LevelNo);
        } else if (this.LevelNo >= 1) {
            tboml.setLevels(this.levels.substring(0, this.LevelNo) + this.LevelNo);
        }
        tboml.setSeqNo(this.SeqNo);
        tboml.setAD_PInstance_ID(this.AD_PInstance_ID);
        tboml.save();
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT PP_Product_BOM_ID, M_Product_ID FROM PP_Product_BOM WHERE IsActive = 'Y' AND M_Product_ID = ? ";
        try {
            stmt = DB.prepareStatement(sql, this.get_TrxName());
            stmt.setInt(1, M_Product_ID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ++this.SeqNo;
                this.component(rs.getInt(2));
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                throw new Exception("SQLException: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
    }

    public void parentExplotion(int PP_Product_BOM_ID) throws Exception {
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT PP_Product_BOMLine_ID, M_Product_ID FROM PP_Product_BOMLine boml WHERE IsActive = 'Y' AND PP_Product_BOM_ID = ? ORDER BY Line ";
        try {
            stmt = DB.prepareStatement(sql, this.get_TrxName());
            stmt.setInt(1, PP_Product_BOM_ID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ++this.SeqNo;
                X_T_BOMLine tboml = new X_T_BOMLine(ctx, 0, null);
                tboml.setPP_Product_BOM_ID(PP_Product_BOM_ID);
                tboml.setPP_Product_BOMLine_ID(rs.getInt(1));
                tboml.setM_Product_ID(rs.getInt(2));
                tboml.setLevelNo(this.LevelNo);
                tboml.setLevels(this.levels.substring(0, this.LevelNo) + this.LevelNo);
                tboml.setSeqNo(this.SeqNo);
                tboml.setAD_PInstance_ID(this.AD_PInstance_ID);
                tboml.setSel_Product_ID(this.p_M_Product_ID);
                tboml.setImplosion(this.p_implosion);
                tboml.save();
                this.component(rs.getInt(2));
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                throw new Exception("SQLException: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
    }

    public void component(int M_Product_ID) throws Exception {
        if (this.p_implosion) {
            ++this.LevelNo;
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = "SELECT PP_Product_BOMLine_ID FROM PP_Product_BOMLine WHERE IsActive = 'Y' AND M_Product_ID = ? ";
            try {
                stmt = DB.prepareStatement(sql, this.get_TrxName());
                stmt.setInt(1, M_Product_ID);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    this.parentImplotion(rs.getInt(1));
                }
                rs.close();
                stmt.close();
                --this.LevelNo;
            }
            catch (SQLException e) {
                try {
                    this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                    throw new Exception("SQLException: " + e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
            return;
        }
        String sql = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM  WHERE IsActive = 'Y' AND Value = ? ";
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String Value2 = DB.getSQLValueString(this.get_TrxName(), "SELECT Value FROM M_PRODUCT WHERE M_PRODUCT_ID=?", M_Product_ID);
            if (Value2 == null) {
                throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.component()"));
            }
            stmt = DB.prepareStatement(sql, this.get_TrxName());
            stmt.setString(1, Value2);
            rs = stmt.executeQuery();
            boolean level = false;
            while (rs.next()) {
                if (!level) {
                    ++this.LevelNo;
                }
                level = true;
                this.parentExplotion(rs.getInt(1));
                --this.LevelNo;
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                throw new Exception("SQLException: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
    }

    private void raiseError(String string, String hint) throws Exception {
        String msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = msg + hint;
        throw new Exception(msg);
    }
}

