/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.model.X_M_MovementLine;
import org.compiere.model.X_M_Storage;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.process.MovementGenerateAbstract;

public class MovementGenerate
extends MovementGenerateAbstract {
    private MMovement movement = null;
    private int createdCount = 0;
    private int lineNo = 0;
    private int lastPartnerLocationId = -1;
    private HashMap<SParameter, MStorage[]> storage = new HashMap();
    private SParameter lastParameter = null;
    private MStorage[] lastStorage = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MDDOrder> distributionOrders;
        this.log.info("Selection=" + this.isSelection() + ", M_Warehouse_ID=" + this.getWarehouseId() + ", C_BPartner_ID=" + this.getBPartnerId() + ", Consolidate=" + this.isConsolidateDocument() + ", IsUnconfirmed=" + this.isUnconfirmedInOut() + ", Movement=" + this.getMovementDate());
        if (this.isSelection()) {
            distributionOrders = this.getInstancesForSelection(this.get_TrxName());
        } else {
            if (this.getWarehouseId() <= 0) {
                throw new AdempiereException("@M_Warehouse_ID@ @NotFound@");
            }
            StringBuilder whereClause = new StringBuilder();
            StringBuilder orderByClause = new StringBuilder();
            ArrayList<Object> parameters = new ArrayList<Object>();
            whereClause.append("DocStatus").append("=? AND ").append("IsDropShip").append("=? AND ").append("DeliveryViaRule").append("<>? AND ").append("EXISTS (SELECT 1 FROM DD_OrderLine ol WHERE ").append("EXISTS (SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID=ol.M_Locator_ID AND l.M_Warehouse_ID=?) ");
            parameters.add("CO");
            parameters.add(false);
            parameters.add("M");
            parameters.add(this.getWarehouseId());
            Optional.ofNullable(this.getDatePromised()).ifPresent(datePromised -> {
                whereClause.append("AND TRUNC(ol.DatePromised) <= TRUNC(?) ");
                parameters.add(datePromised);
            });
            if (this.getBPartnerId() > 0) {
                whereClause.append(" AND ").append("C_BPartner_ID").append("=? ");
                parameters.add(this.getBPartnerId());
            }
            whereClause.append("AND ol.DD_Order_ID=DD_Order.DD_Order_ID AND ol.QtyOrdered <> ol.QtyInTransit )");
            orderByClause.append("M_Warehouse_ID, PriorityRule, M_Shipper_ID, C_BPartner_ID, C_BPartner_Location_ID, DD_Order_ID");
            distributionOrders = new Query(this.getCtx(), "DD_Order", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).setOrderBy(orderByClause.toString()).list();
        }
        return this.generate(distributionOrders);
    }

    private MClient getClient() {
        return MClient.get(this.getCtx());
    }

    private String generate(List<MDDOrder> distributionOrders) {
        distributionOrders.stream().filter(order -> order != null).forEach(order -> {
            this.getCurrentMovement().filter(movement -> movement != null || !this.isConsolidateDocument()).filter(movement -> movement.getC_BPartner_Location_ID() != order.getC_BPartner_Location_ID() || movement.getM_Shipper_ID() != order.getM_Shipper_ID()).ifPresent(movement -> this.completeMovement());
            this.log.fine("check: " + order + " - DeliveryRule=" + order.getDeliveryRule());
            Timestamp minGuaranteeDate = this.getMovementDate();
            StringBuilder where = new StringBuilder(" 1=1 ");
            if (this.getWarehouseId() > 0) {
                where.append(" AND ").append(this.getWarehouseId()).append(" IN (SELECT l.M_Warehouse_ID FROM M_Locator l WHERE l.M_Locator_ID=M_Locator_ID) ");
            }
            if (this.getDatePromised() != null) {
                where.append(" AND (TRUNC(DatePromised)<=").append(DB.TO_DATE(this.getDatePromised(), true)).append(" OR DatePromised IS NULL)");
            }
            if (!"F".equals(order.getDeliveryRule())) {
                where.append(" AND (DD_OrderLine.M_Product_ID IS NULL").append(" OR EXISTS (SELECT * FROM M_Product p ").append("WHERE DD_OrderLine.M_Product_ID=p.M_Product_ID").append(" AND IsExcludeAutoDelivery='N'))");
            }
            if (!this.isUnconfirmedInOut()) {
                where.append(" AND NOT EXISTS (SELECT * FROM M_MovementLine iol").append(" INNER JOIN M_Movement io ON (iol.M_Movement_ID=io.M_Movement_ID) ").append("WHERE iol.DD_OrderLine_ID=DD_OrderLine.DD_OrderLine_ID AND io.DocStatus IN ('IP','WC'))");
            }
            List<MDDOrderLine> orderLines = order.getLines(where.toString(), "M_Product_ID");
            orderLines.stream().filter(orderLine -> orderLine.getM_Product_ID() > 0 || orderLine.getC_Charge_ID() > 0).filter(orderLine -> orderLine.getConfirmedQty().signum() != 0).forEach(orderLine -> {
                MLocator locator = new MLocator(this.getCtx(), orderLine.getM_Locator_ID(), this.get_TrxName());
                if (this.getWarehouseId() > 0 && locator.getM_Warehouse_ID() != this.getWarehouseId()) {
                    return;
                }
                this.log.fine("check: " + orderLine);
                BigDecimal onHand = Env.ZERO;
                BigDecimal toDeliver = orderLine.getConfirmedQty();
                MProduct product = orderLine.getProduct();
                BigDecimal unconfirmedShippedQty = Env.ZERO;
                if (this.isUnconfirmedInOut() && product != null && toDeliver.signum() != 0) {
                    String whereLine = "EXISTS (SELECT * FROM M_Movement io WHERE io.M_Movement_ID=M_MovementLine.M_Movement_ID AND io.DocStatus IN ('IP','WC'))";
                    MMovementLine[] movementLines = MMovementLine.getOfOrderLine(this.getCtx(), orderLine.getDD_OrderLine_ID(), whereLine, null);
                    unconfirmedShippedQty = Arrays.asList(movementLines).stream().map(X_M_MovementLine::getMovementQty).reduce(BigDecimal.ZERO, BigDecimal::add);
                    String logInfo = "Unconfirmed Qty=" + unconfirmedShippedQty + " - ToDeliver=" + orderLine.getConfirmedQty() + "->";
                    toDeliver = orderLine.getConfirmedQty().subtract(unconfirmedShippedQty);
                    logInfo = logInfo + toDeliver;
                    if (toDeliver.signum() < 0) {
                        toDeliver = Env.ZERO;
                        logInfo = logInfo + " (set to 0)";
                    }
                    onHand = onHand.subtract(unconfirmedShippedQty);
                    this.log.fine(logInfo);
                }
                if (!(product != null && product.isStocked() || orderLine.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                    if (!"O".equals(order.getDeliveryRule())) {
                        this.createLine((MDDOrder)order, (MDDOrderLine)orderLine, toDeliver, null, false);
                    }
                    return;
                }
                String policyMaterialIssue = this.getPolicyIssue(product);
                MStorage[] storages = this.getStorages(locator.getM_Warehouse_ID(), orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID(), product.getM_AttributeSet_ID(), orderLine.getM_AttributeSetInstance_ID() == 0, minGuaranteeDate, "F".equals(policyMaterialIssue));
                onHand = Arrays.asList(storages).stream().map(X_M_Storage::getQtyOnHand).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean fullLine = onHand.compareTo(toDeliver) >= 0 || toDeliver.signum() < 0;
                boolean completeOrder = "O".equals(order.getDeliveryRule());
                if (completeOrder && !fullLine) {
                    this.log.fine("Failed CompleteOrder - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + orderLine);
                    return;
                }
                if (fullLine && "L".equals(order.getDeliveryRule())) {
                    this.log.fine("CompleteLine - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ", ToDeliver=" + toDeliver + " - " + orderLine);
                    this.createLine((MDDOrder)order, (MDDOrderLine)orderLine, toDeliver, storages, false);
                } else if ("A".equals(order.getDeliveryRule()) && (onHand.signum() > 0 || orderLine.getConfirmedQty().signum() < 0)) {
                    BigDecimal deliver = orderLine.getConfirmedQty();
                    this.log.fine("Available - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + orderLine);
                    if (deliver.compareTo(onHand) > 0) {
                        deliver = onHand;
                    }
                    this.createLine((MDDOrder)order, (MDDOrderLine)orderLine, deliver, storages, false);
                } else if ("F".equals(order.getDeliveryRule())) {
                    BigDecimal deliver = toDeliver;
                    this.log.fine("Force - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + orderLine);
                    this.createLine((MDDOrder)order, (MDDOrderLine)orderLine, deliver, storages, true);
                } else if ("M".equals(order.getDeliveryRule())) {
                    this.log.fine("Manual - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ") - " + orderLine);
                } else {
                    this.log.fine("Failed: " + order.getDeliveryRule() + " - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + orderLine);
                }
            });
            boolean completeOrder = "O".equals(order.getDeliveryRule());
            if (completeOrder && "O".equals(order.getDeliveryRule())) {
                for (MDDOrderLine orderLine2 : orderLines) {
                    MLocator l = new MLocator(this.getCtx(), orderLine2.getM_Locator_ID(), this.get_TrxName());
                    if (this.getWarehouseId() > 0 && l.getM_Warehouse_ID() != this.getWarehouseId()) continue;
                    MProduct product = orderLine2.getProduct();
                    BigDecimal toDeliver = orderLine2.getQtyOrdered().subtract(orderLine2.getQtyDelivered());
                    MStorage[] storages = null;
                    if (product != null && product.isStocked()) {
                        MProductCategory pc = MProductCategory.get(order.getCtx(), product.getM_Product_Category_ID());
                        String MMPolicy = pc.getMMPolicy();
                        if (MMPolicy == null || MMPolicy.length() == 0) {
                            MMPolicy = this.getClient().getMMPolicy();
                        }
                        storages = this.getStorages(l.getM_Warehouse_ID(), orderLine2.getM_Product_ID(), orderLine2.getM_AttributeSetInstance_ID(), product.getM_AttributeSet_ID(), orderLine2.getM_AttributeSetInstance_ID() == 0, minGuaranteeDate, "F".equals(MMPolicy));
                    }
                    this.createLine((MDDOrder)order, orderLine2, toDeliver, storages, false);
                }
            }
            this.lineNo += 1000;
            this.completeMovement();
        });
        return "@Created@ = " + this.createdCount;
    }

    private String getPolicyIssue(MProduct product) {
        MProductCategory pc = MProductCategory.get(product.getCtx(), product.getM_Product_Category_ID());
        String policyIssue = pc.getMMPolicy();
        if (policyIssue == null || policyIssue.length() == 0) {
            policyIssue = this.getClient().getMMPolicy();
        }
        return policyIssue;
    }

    private void createLine(MDDOrder order, MDDOrderLine orderLine, BigDecimal qty, MStorage[] storages, boolean force) {
        if (this.lastPartnerLocationId != order.getC_BPartner_Location_ID()) {
            this.completeMovement();
        }
        this.lastPartnerLocationId = order.getC_BPartner_Location_ID();
        MMovement currentMovement = this.getCurrentMovement().orElseGet(() -> {
            int docTypeId;
            MLocator locator = MLocator.get(this.getCtx(), orderLine.getM_Locator_ID());
            this.movement = new MMovement(order, this.getMovementDate());
            this.movement.setAD_Org_ID(locator.getAD_Org_ID());
            this.movement.setIsInTransit(true);
            if (order.getC_BPartner_ID() != order.getC_BPartner_ID()) {
                this.movement.setC_BPartner_ID(order.getC_BPartner_ID());
            }
            if (order.getC_BPartner_Location_ID() != order.getC_BPartner_Location_ID()) {
                this.movement.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
            }
            if ((docTypeId = MDocType.getDocType("MMM", this.movement.getAD_Org_ID())) > 0) {
                this.movement.setC_DocType_ID(docTypeId);
            }
            this.movement.saveEx();
            this.addLog(this.movement.get_ID(), this.movement.getMovementDate(), BigDecimal.ZERO, this.movement.getDocumentInfo());
            this.setCurrentMovement(this.movement);
            return this.movement;
        });
        if (storages == null) {
            MMovementLine line = new MMovementLine(currentMovement);
            line.setOrderLine(orderLine, Env.ZERO, false);
            line.setMovementQty(qty);
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                line.setMovementQty(qty.multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
            }
            line.setLine(this.lineNo + orderLine.getLine());
            if (!line.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            this.log.fine(line.toString());
            return;
        }
        MProduct product = orderLine.getProduct();
        boolean linePerASI = false;
        if (product.getM_AttributeSet_ID() != 0) {
            MAttributeSet mas = MAttributeSet.get(this.getCtx(), product.getM_AttributeSet_ID());
            linePerASI = mas.isInstanceAttribute();
        }
        ArrayList<X_M_MovementLine> list = new ArrayList<X_M_MovementLine>();
        BigDecimal toDeliver = qty;
        for (int i2 = 0; i2 < storages.length; ++i2) {
            BigDecimal deliver = toDeliver;
            MStorage storage = storages[i2];
            if (deliver.compareTo(storage.getQtyOnHand()) > 0 && storage.getQtyOnHand().signum() >= 0 && (!force || force && i2 + 1 != storages.length)) {
                deliver = storage.getQtyOnHand();
            }
            if (deliver.signum() == 0) continue;
            int M_Locator_ID = storage.getM_Locator_ID();
            X_M_MovementLine line = null;
            if (!linePerASI) {
                for (int ll = 0; ll < list.size(); ++ll) {
                    MMovementLine test = (MMovementLine)list.get(ll);
                    if (test.getM_Locator_ID() != M_Locator_ID) continue;
                    line = test;
                    break;
                }
            }
            if (line == null) {
                line = new MMovementLine(currentMovement);
                ((MMovementLine)line).setOrderLine(orderLine, deliver, false);
                ((MMovementLine)line).setMovementQty(deliver);
                list.add(line);
            } else {
                ((MMovementLine)line).setMovementQty(line.getMovementQty().add(deliver));
            }
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                ((MMovementLine)line).setMovementQty(line.getMovementQty().multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
            }
            line.setLine(this.lineNo + orderLine.getLine());
            if (linePerASI) {
                line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
            }
            line.saveEx();
            this.log.fine("ToDeliver=" + qty + "/" + deliver + " - " + line);
            toDeliver = toDeliver.subtract(deliver);
            storage.setQtyOnHand(storage.getQtyOnHand().subtract(deliver));
            if (toDeliver.signum() == 0) break;
        }
        if (toDeliver.signum() != 0) {
            throw new IllegalStateException("Not All Delivered - Remainder=" + toDeliver);
        }
    }

    private MStorage[] getStorages(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_AttributeSet_ID, boolean allAttributeInstances, Timestamp minGuaranteeDate, boolean FiFo) {
        this.lastParameter = new SParameter(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, M_AttributeSet_ID, allAttributeInstances, minGuaranteeDate, FiFo);
        this.lastStorage = this.storage.get(this.lastParameter);
        if (this.lastStorage == null) {
            this.lastStorage = MStorage.getWarehouse(this.getCtx(), M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, M_AttributeSet_ID, allAttributeInstances, minGuaranteeDate, FiFo, this.get_TrxName());
            this.storage.put(this.lastParameter, this.lastStorage);
        }
        return this.lastStorage;
    }

    private Optional<MMovement> getCurrentMovement() {
        return Optional.ofNullable(this.movement);
    }

    private void setCurrentMovement(MMovement movement) {
        this.movement = movement;
    }

    private void completeMovement() {
        this.getCurrentMovement().ifPresent(movement -> {
            if (!movement.processIt(this.getDocAction())) {
                this.log.warning("Failed: " + this.movement);
            }
            movement.saveEx();
            this.addLog(0, movement.getMovementDate(), null, movement.getDocumentInfo());
            ++this.createdCount;
            this.storage = new HashMap();
            this.lastParameter = null;
            this.lastStorage = null;
        });
        this.setCurrentMovement(null);
        this.lineNo = 0;
    }

    class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int p_Warehouse_ID, int p_Product_ID, int p_AttributeSetInstance_ID, int p_AttributeSet_ID, boolean p_allAttributeInstances, Timestamp p_minGuaranteeDate, boolean p_FiFo) {
            this.M_Warehouse_ID = p_Warehouse_ID;
            this.M_Product_ID = p_Product_ID;
            this.M_AttributeSetInstance_ID = p_AttributeSetInstance_ID;
            this.M_AttributeSet_ID = p_AttributeSet_ID;
            this.allAttributeInstances = p_allAttributeInstances;
            this.minGuaranteeDate = p_minGuaranteeDate;
            this.FiFo = p_FiFo;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SParameter) {
                boolean eq;
                SParameter cmp = (SParameter)obj;
                boolean bl = eq = cmp.M_Warehouse_ID == this.M_Warehouse_ID && cmp.M_Product_ID == this.M_Product_ID && cmp.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && cmp.M_AttributeSet_ID == this.M_AttributeSet_ID && cmp.allAttributeInstances == this.allAttributeInstances && cmp.FiFo == this.FiFo;
                if (!(!eq || cmp.minGuaranteeDate == null && this.minGuaranteeDate == null || cmp.minGuaranteeDate != null && this.minGuaranteeDate != null && cmp.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    eq = false;
                }
                return eq;
            }
            return false;
        }

        public int hashCode() {
            long hash = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                hash *= -1L;
            }
            if (this.FiFo) {
                // empty if block
            }
            if ((hash *= -2L) < 0L) {
                hash = -hash + 7L;
            }
            while (hash > Integer.MAX_VALUE) {
                hash -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                hash += (long)this.minGuaranteeDate.hashCode();
                while (hash > Integer.MAX_VALUE) {
                    hash -= Integer.MAX_VALUE;
                }
            }
            return (int)hash;
        }
    }
}

