/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.I_M_AttributeSearch;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeUse;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.model.X_M_AttributeSearch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.eevolution.model.X_I_Product_ASI;

public class ImportProductASI
extends SvrProcess {
    private boolean m_DeleteOldImported = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private boolean isImported = false;
    private int imported = 0;
    private int notimported = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsImportOnlyNoErrors")) {
                this.m_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_DeleteOldImported = "Y".equals(para.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_DeleteOldImported) {
            int no = 0;
            for (X_I_Product_ASI ip_asi : this.getRecords(true, false)) {
                ip_asi.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported + ", Not imported: " + this.notimported;
    }

    private void importRecords() throws SQLException {
        for (X_I_Product_ASI ip_asi : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            this.isImported = false;
            MAttributeInstance ai = this.importProductASI(ip_asi);
            if (ai != null || ai.get_ID() > 0) {
                this.isImported = true;
            }
            if (this.isImported) {
                ip_asi.setI_IsImported(true);
                ip_asi.setProcessed(true);
                ip_asi.setI_ErrorMsg("");
                ip_asi.saveEx();
                ++this.imported;
                ip_asi.saveEx();
                continue;
            }
            ip_asi.setI_IsImported(false);
            ip_asi.setProcessed(false);
            ip_asi.saveEx();
            ++this.notimported;
        }
    }

    private MAttributeInstance importProductASI(X_I_Product_ASI ip_asi) throws SQLException {
        MProduct product = (MProduct)ip_asi.getM_Product();
        MAttributeSet attributeSet = null;
        if (ip_asi.getM_AttributeSet_ID() <= 0) {
            attributeSet = this.getAttributeSet(ip_asi);
            product.setM_AttributeSet_ID(attributeSet.get_ID());
            product.saveEx();
            ip_asi.setM_AttributeSet_ID(attributeSet.getM_AttributeSet_ID());
            ip_asi.saveEx();
        } else {
            attributeSet = (MAttributeSet)product.getM_AttributeSet();
        }
        MAttribute attribute = null;
        if (ip_asi.getM_Attribute_ID() <= 0) {
            attribute = this.getAttribute(ip_asi);
            ip_asi.setM_Attribute_ID(attribute.getM_Attribute_ID());
            ip_asi.saveEx();
        } else {
            attribute = (MAttribute)ip_asi.getM_Attribute();
        }
        this.checkAttributeUse(attributeSet, attribute);
        MAttributeSetInstance asi = (MAttributeSetInstance)product.getM_AttributeSetInstance();
        if (asi == null || asi.get_ID() <= 0) {
            asi = this.getAttributeSetInstance(product, attributeSet);
            product.setM_AttributeSetInstance_ID(asi.get_ID());
            product.saveEx();
            ip_asi.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
            ip_asi.saveEx();
        }
        MAttributeInstance ai = this.addAttributeLine(asi, attribute, ip_asi);
        ip_asi.saveEx();
        this.commitEx();
        return ai;
    }

    private void checkAttributeUse(MAttributeSet attributeSet, MAttribute attribute) {
        StringBuilder select = new StringBuilder("FROM M_AttributeUse WHERE ");
        select.append("M_AttributeSet_ID").append("=? AND ");
        select.append("M_Attribute_ID").append("=? ");
        MAttributeUse attributeUse = null;
        int attributeId = DB.getSQLValue(this.get_TrxName(), "SELECT M_Attribute_ID " + select.toString(), attributeSet.get_ID(), attribute.get_ID());
        int seqNo = DB.getSQLValue(this.get_TrxName(), "SELECT count(M_Attribute_ID) " + select.toString(), attributeSet.get_ID(), attribute.get_ID());
        if (attributeId <= 0) {
            attributeUse = new MAttributeUse(this.getCtx(), 0, this.get_TrxName());
            attributeUse.setM_AttributeSet_ID(attributeSet.get_ID());
            attributeUse.setM_Attribute_ID(attribute.get_ID());
            attributeUse.setSeqNo(seqNo == 0 ? 10 : seqNo * 10);
            attributeUse.saveEx();
        }
    }

    private MAttributeSetInstance getAttributeSetInstance(MProduct product, MAttributeSet attributeSet) {
        MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), product.getM_AttributeSetInstance_ID(), product.get_TrxName());
        if (asi == null || asi.get_ID() <= 0) {
            asi = new MAttributeSetInstance(product.getCtx(), 0, product.get_TrxName());
            asi.setM_AttributeSet_ID(product.getM_AttributeSet_ID());
            asi.saveEx();
        }
        return asi;
    }

    private MAttributeInstance addAttributeLine(MAttributeSetInstance asi, MAttribute attribute, X_I_Product_ASI ip_asi) {
        MAttributeInstance instance = attribute.getMAttributeInstance(asi.get_ID());
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), 0, this.get_TrxName());
            instance.setM_Attribute_ID(attribute.getM_Attribute_ID());
            instance.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
            instance.saveEx();
        }
        if ("L".equals(attribute.getAttributeValueType())) {
            MAttributeValue attributeValue = this.getAttributeValue(attribute, ip_asi);
            attribute.setMAttributeInstance(instance.get_ID(), attributeValue.getValue());
            ip_asi.setM_AttributeValue_ID(attributeValue.get_ID());
            ip_asi.saveEx();
        } else if ("N".equals(attribute.getAttributeValueType())) {
            BigDecimal numericValue = new BigDecimal(ip_asi.getAttributeValue());
            attribute.setMAttributeInstance(instance.get_ID(), numericValue);
        } else if ("S".equals(attribute.getAttributeValueType())) {
            attribute.setMAttributeInstance(instance.get_ID(), ip_asi.getAttributeValue().length() > 40 ? ip_asi.getAttributeValue().substring(0, 40) : ip_asi.getAttributeValue());
        }
        return instance;
    }

    private MAttributeSet getAttributeSet(X_I_Product_ASI ip_asi) {
        MAttributeSet attributeSet = new MAttributeSet(this.getCtx(), ip_asi.getM_AttributeSet_ID(), this.get_TrxName());
        if (attributeSet == null || attributeSet.get_ID() <= 0) {
            attributeSet = new MAttributeSet(ip_asi.getCtx(), 0, ip_asi.get_TrxName());
            attributeSet.setName(ip_asi.getAttributeSetName());
            attributeSet.setIsLot(ip_asi.isLot());
            attributeSet.setIsLotMandatory(ip_asi.isLotMandatory());
            attributeSet.setIsGuaranteeDate(ip_asi.isGuaranteeDate());
            attributeSet.setIsGuaranteeDateMandatory(ip_asi.isGuaranteeDateMandatory());
            attributeSet.setGuaranteeDays(ip_asi.getGuaranteeDays());
            attributeSet.setMandatoryType(ip_asi.getMandatoryType());
            attributeSet.saveEx();
        }
        return attributeSet;
    }

    private MAttribute getAttribute(X_I_Product_ASI ip_asi) {
        MAttribute attribute = null;
        int attributeId = this.getID("M_Attribute", "Name=?", ip_asi.getAttributeName());
        if (attributeId <= 0) {
            attribute = new MAttribute(ip_asi.getCtx(), 0, ip_asi.get_TrxName());
            attribute.setName(ip_asi.getAttributeName());
            attribute.setIsMandatory(ip_asi.isMandatory());
            attribute.setAttributeValueType(ip_asi.getAttributeValueType());
            attribute.setIsMandatory(ip_asi.isMandatory());
            attribute.saveEx();
        } else {
            attribute = new MAttribute(this.getCtx(), attributeId, this.get_TrxName());
        }
        if (ip_asi.getAttributeSearchName() != null) {
            X_M_AttributeSearch attributeSearch = (X_M_AttributeSearch)this.getAttributeSearch(ip_asi);
            attribute.setM_AttributeSearch_ID(attributeSearch.get_ID());
            attribute.saveEx();
            ip_asi.setM_AttributeSearch_ID(attributeSearch.get_ID());
            ip_asi.saveEx();
        }
        if ("L".equals(ip_asi.getAttributeValueType())) {
            this.getAttributeValue(attribute, ip_asi);
        }
        return attribute;
    }

    private MAttributeValue getAttributeValue(MAttribute attribute, X_I_Product_ASI ip_asi) {
        MAttributeValue attributeValue = null;
        if ("L".equals(ip_asi.getAttributeValueType())) {
            MAttributeValue[] attributeValues;
            for (MAttributeValue aValue : attributeValues = attribute.getMAttributeValues()) {
                if (!aValue.getName().equals(ip_asi.getElementName())) continue;
                return aValue;
            }
            attributeValue = new MAttributeValue(this.getCtx(), 0, this.get_TrxName());
            attributeValue.setM_Attribute_ID(attribute.getM_Attribute_ID());
            attributeValue.setValue(ip_asi.getAttributeValue());
            attributeValue.setName(ip_asi.getElementName());
            attributeValue.saveEx();
        }
        return attributeValue;
    }

    private I_M_AttributeSearch getAttributeSearch(X_I_Product_ASI ip_asi) {
        X_M_AttributeSearch asearch = null;
        int attributeSearchId = this.getID("M_AttributeSearch", "Name=?", ip_asi.getAttributeSearchName());
        if (attributeSearchId <= 0) {
            asearch = new X_M_AttributeSearch(this.getCtx(), 0, this.get_TrxName());
            asearch.setName(ip_asi.getAttributeSearchName());
            asearch.saveEx();
            ip_asi.setM_AttributeSearch_ID(asearch.get_ID());
            ip_asi.saveEx();
        } else {
            asearch = new X_M_AttributeSearch(this.getCtx(), attributeSearchId, this.get_TrxName());
        }
        return asearch;
    }

    private void fillIDValues() throws SQLException {
        for (X_I_Product_ASI ip_asi : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            int M_Product_ID = 0;
            if (ip_asi.getM_Product_ID() > 0) {
                M_Product_ID = this.getID("M_Product", "M_Product_ID = ?", ip_asi.getM_Product_ID());
            }
            if (M_Product_ID <= 0 && ip_asi.getProductValue() != null) {
                M_Product_ID = this.getID("M_Product", "Value = ?", ip_asi.getProductValue());
                ip_asi.setM_Product_ID(M_Product_ID);
            } else {
                ip_asi.setM_Product_ID(M_Product_ID);
            }
            int M_AttributeSet_ID = 0;
            if (ip_asi.getM_AttributeSet_ID() > 0) {
                M_AttributeSet_ID = this.getID("M_AttributeSet", "M_AttributeSet_ID = ?", ip_asi.getM_AttributeSet_ID());
            }
            if (M_AttributeSet_ID <= 0 && ip_asi.getAttributeSetName() != null) {
                M_AttributeSet_ID = this.getID("M_AttributeSet", "Name = ?", ip_asi.getAttributeSetName());
                ip_asi.setM_AttributeSet_ID(M_AttributeSet_ID);
            } else {
                ip_asi.setM_AttributeSet_ID(M_AttributeSet_ID);
            }
            int M_Attribute_ID = 0;
            if (ip_asi.getM_Attribute_ID() > 0) {
                M_Attribute_ID = this.getID("M_Attribute", "M_Attribute_ID = ?", ip_asi.getM_Attribute_ID());
            }
            if (M_Attribute_ID <= 0 && ip_asi.getAttributeName() != null) {
                M_Attribute_ID = this.getID("M_Attribute", "Name = ?", ip_asi.getAttributeName());
                ip_asi.setM_Attribute_ID(M_Attribute_ID);
            } else {
                ip_asi.setM_Attribute_ID(M_Attribute_ID);
            }
            if ("L".equals(ip_asi.getAttributeValueType()) && M_Attribute_ID > 0) {
                MAttribute mAttribute = new MAttribute(this.getCtx(), M_Attribute_ID, this.get_TrxName());
            }
            int M_AttributeSetInstance_ID = 0;
            if (ip_asi.getM_AttributeSetInstance_ID() > 0) {
                M_AttributeSetInstance_ID = this.getID("M_AttributeSetInstance", "M_AttributeSetInstance_ID = ?", ip_asi.getM_AttributeSetInstance_ID());
            }
            StringBuffer err = new StringBuffer("");
            if (ip_asi.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (ip_asi.getAttributeSetName() == null) {
                err.append(" @AttributeSetName@ @NotFound@,");
            }
            if (ip_asi.getMandatoryType() == null) {
                err.append(" @MandatoryType@ @NotFound@,");
            }
            if (ip_asi.getAttributeName() == null) {
                err.append(" @AttributeName@ @NotFound@,");
            }
            if (ip_asi.getAttributeValueType() == null) {
                err.append(" @AttributeValueType@ @NotFound@,");
            }
            if (ip_asi.getAttributeValue() == null) {
                err.append(" @AttributeValue@ @NotFound@,");
            }
            if ("L".equals(ip_asi.getAttributeValueType()) && ip_asi.getElementName() == null) {
                err.append(" @ElementName@ @NotFound@,");
            }
            if (err.toString() != null && err.toString().length() > 0) {
                ++this.notimported;
                ip_asi.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), err.toString()));
            }
            ip_asi.saveEx();
            this.commitEx();
        }
    }

    private int getID(String tableName, String whereClause, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setParameters(parameters).firstId();
    }

    private List<X_I_Product_ASI> getRecords(boolean imported, boolean isWithError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_Product_ASI", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(imported).list();
    }
}

