/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;
import org.eevolution.process.HRCreateInvoiceAbstract;

public class HRCreateInvoice
extends HRCreateInvoiceAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MHRProcess mHRProcess = new MHRProcess(this.getCtx(), this.getHRProcessId(), this.get_TrxName());
        Timestamp timestamp = this.getDateInvoiced() != null ? this.getDateInvoiced() : (mHRProcess.getHR_Period_ID() > 0 ? mHRProcess.getHR_Period().getStartDate() : mHRProcess.getDateAcct());
        Arrays.stream(this.getEmployeeIds(mHRProcess)).filter(n -> n > 0).forEach(n -> Trx.run(string -> {
            int n2 = 0;
            MHREmployee mHREmployee = null;
            MInvoice mInvoice = null;
            for (MHRMovement mHRMovement : this.getPayrollMovement(this.getHRProcessId(), n, string)) {
                MBPartner mBPartner = new MBPartner(this.getCtx(), n, string);
                MHRAttribute mHRAttribute = MHRAttribute.getByConceptIdAndPartnerId(mHRMovement.getCtx(), mHRMovement.getHR_Concept_ID(), mHRMovement.getC_BPartner_ID(), mHRMovement.getValidFrom(), string);
                if (mHRAttribute != null && mHRAttribute.getC_DocType_ID() == 0) {
                    this.log.log(Level.SEVERE, "@HR_Employee_ID@ " + mBPartner.getName() + "  @HR_Concept_ID@  " + mHRMovement.getHR_Concept().getName() + " @C_DocType_ID@ @NotFound@ : ");
                    this.addLog(0, null, null, "@HR_Employee_ID@ " + mBPartner.getName() + "  @HR_Concept_ID@  " + mHRMovement.getHR_Concept().getName() + " @C_DocType_ID@ @NotFound@ : ");
                    continue;
                }
                if (mHRAttribute != null && mHRAttribute.getC_Charge_ID() == 0) {
                    this.log.log(Level.SEVERE, "@HR_Employee_ID@ " + mBPartner.getName() + "  @HR_Concept_ID@  " + mHRMovement.getHR_Concept().getName() + " @C_Charge_ID@ @NotFound@ : ");
                    this.addLog(0, null, null, "@HR_Employee_ID@ " + mBPartner.getName() + "  @HR_Concept_ID@  " + mHRMovement.getHR_Concept().getName() + " @C_Charge_ID@ @NotFound@ : ");
                    continue;
                }
                if (mHRMovement.getC_BPartner_ID() != n2) {
                    n2 = mHRMovement.getC_BPartner_ID();
                    mHREmployee = MHREmployee.getActiveEmployee(this.getCtx(), mBPartner.getC_BPartner_ID(), string);
                    mInvoice = this.createInvoice(mHRProcess, mBPartner, mHREmployee, mHRAttribute.getC_DocType_ID(), timestamp);
                    if (mInvoice == null) continue;
                }
                if (mInvoice == null) continue;
                this.createInvoiceLine(mInvoice, mHREmployee, mHRMovement, mHRAttribute.getC_Charge_ID());
            }
        }));
        return "@OK@";
    }

    private List<MHRMovement> getPayrollMovement(int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HR_Movement.HR_Process_ID = ? AND HR_Movement.C_BPartner_ID=? AND ").append("EXISTS (SELECT 1 FROM HR_Concept c INNER JOIN HR_Attribute a ON (c.HR_Concept_ID = a.HR_Concept_ID) ").append("WHERE HR_Movement.C_InvoiceLine_ID IS NULL AND c.HR_Concept_ID=HR_Movement.HR_Concept_ID AND  a.IsActive = ? AND c.IsInvoiced=? AND a.C_DocType_ID > 0 AND a.C_Charge_ID > 0)");
        return new Query(this.getCtx(), "HR_Movement", stringBuilder.toString(), string).setClient_ID().setParameters(n, n2, true, true).list();
    }

    private MBPartnerLocation getLocationBill(MBPartner mBPartner) {
        String string = "C_BPartner_ID=? AND IsBillTo=? AND IsActive=?";
        return (MBPartnerLocation)new Query(mBPartner.getCtx(), "C_BPartner_Location", string, mBPartner.get_TrxName()).setClient_ID().setParameters(mBPartner.getC_BPartner_ID(), true, true).first();
    }

    public int[] getEmployeeIds(MHRProcess mHRProcess) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EXISTS ( SELECT 1 FROM HR_Attribute a ").append("INNER JOIN HR_Concept c ON c.HR_Concept_ID=a.HR_Concept_ID ").append("WHERE a.IsActive = 'Y' AND a.C_Charge_ID > 0 AND c.IsInvoiced='Y' ").append("AND a.C_DocType_ID > 0 AND EXISTS (SELECT 1 FROM HR_Movement m WHERE m.HR_Process_ID=? ").append("AND m.C_BPartner_ID=C_BPartner.C_BPartner_ID AND m.HR_Concept_ID = c.HR_Concept_ID AND m.C_InvoiceLine_ID IS NULL))");
        return new Query(this.getCtx(), "C_BPartner", stringBuilder.toString(), this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(mHRProcess.getHR_Process_ID()).setOrderBy("Value").getIDs();
    }

    private MInvoice createInvoice(MHRProcess mHRProcess, MBPartner mBPartner, MHREmployee mHREmployee, int n, Timestamp timestamp) {
        MBPartnerLocation mBPartnerLocation = this.getLocationBill(mBPartner);
        if (mBPartnerLocation == null) {
            this.log.log(Level.SEVERE, " @C_BPartner_Location_ID@ @NotFound@ : " + mBPartner.getName());
            this.addLog(0, mHRProcess.getDateAcct(), null, "@Bill_Location_ID@ @NotFound@ " + mHRProcess.getDocumentNo() + " " + mBPartner.getName());
            return null;
        }
        String string = mHREmployee.getPaymentRule();
        if (string == null || string.isEmpty()) {
            string = mBPartner.getPaymentRule();
        }
        if (string == null) {
            this.log.log(Level.SEVERE, " @PaymentRule@ @NotFound@ : " + mBPartner.getName());
            this.addLog(0, mHRProcess.getDateAcct(), null, "@PaymentRule@ @NotFound@ " + mHRProcess.getDocumentNo() + " " + mHRProcess.getName() + " " + mBPartner.getValue() + " " + mBPartner.getName());
            return null;
        }
        this.log.info("New Invoice for ");
        MInvoice mInvoice = new MInvoice(mHRProcess.getCtx(), 0, mBPartner.get_TrxName());
        mInvoice.setAD_Org_ID(mHRProcess.getAD_Org_ID());
        mInvoice.setIsSOTrx(false);
        mInvoice.setPaymentRule(string);
        mInvoice.setC_DocTypeTarget_ID(n);
        mInvoice.setC_DocType_ID(n);
        mInvoice.setDescription(Msg.parseTranslation(mHRProcess.getCtx(), "@HR_Process_ID@ " + mHRProcess.getName() + " @DocumentNo@ " + mHRProcess.getDocumentNo()));
        mInvoice.setDateOrdered(timestamp);
        mInvoice.setDateInvoiced(timestamp);
        mInvoice.setDateAcct(timestamp);
        mInvoice.setBPartner(mBPartner);
        MPaymentTerm mPaymentTerm = MPaymentTerm.getPaymentTermByDefault(this.getCtx(), mBPartner.get_TrxName());
        if (mPaymentTerm != null) {
            mInvoice.setC_PaymentTerm_ID(mPaymentTerm.getC_PaymentTerm_ID());
        }
        if (mHREmployee.getC_Activity_ID() != 0) {
            mInvoice.setC_Activity_ID(mHREmployee.getC_Activity_ID());
        }
        mInvoice.setDocStatus("DR");
        mInvoice.setDocAction("--");
        mInvoice.setSalesRep_ID(Env.getAD_User_ID(mHRProcess.getCtx()));
        mInvoice.saveEx();
        this.addLog(0, mInvoice.getDateInvoiced(), mInvoice.getGrandTotal(), "@C_Invoice_ID@ " + mInvoice.getDocumentNo() + " @C_BPartner_ID@  @TaxId@ " + mInvoice.getC_BPartner().getValue() + " @Name@ " + mInvoice.getC_BPartner().getName());
        return mInvoice;
    }

    private MInvoiceLine createInvoiceLine(MInvoice mInvoice, MHREmployee mHREmployee, MHRMovement mHRMovement, int n) {
        MInvoiceLine mInvoiceLine = new MInvoiceLine(mInvoice);
        mInvoiceLine.setC_Charge_ID(n);
        mInvoiceLine.setQty(BigDecimal.ONE);
        mInvoiceLine.setDescription(mHRMovement.getHR_Concept().getName());
        mInvoiceLine.setC_Activity_ID(mHREmployee.getC_Activity_ID());
        mInvoiceLine.setPrice(mHRMovement.getAmount());
        mInvoiceLine.setTax();
        mInvoiceLine.saveEx();
        this.addLog(mInvoiceLine.getLine(), mInvoice.getDateInvoiced(), mInvoiceLine.getLineNetAmt(), mHRMovement.getHR_Concept().getName());
        mHRMovement.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
        mHRMovement.saveEx();
        return mInvoiceLine;
    }
}

