/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_InOut;
import org.compiere.model.X_M_InOutLine;
import org.compiere.process.ProcessInfo;
import org.eevolution.model.I_DD_Order;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.X_DD_OrderLine;
import org.eevolution.model.X_PP_Order_BOMLine;
import org.eevolution.process.GenerateShipmentOutBoundAbstract;
import org.eevolution.process.MovementGenerate;
import org.eevolution.service.dsl.ProcessBuilder;

public class GenerateShipmentOutBound
extends GenerateShipmentOutBoundAbstract {
    private Hashtable<Integer, MInOut> shipments = new Hashtable();
    private Hashtable<Integer, I_DD_Order> distributionOrders = new Hashtable();
    private Hashtable<Integer, MPPCostCollector> manufacturingIssues = new Hashtable();
    private int documentCreated = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.getProcessInfo().setTableSelectionId(MWMInOutBoundLine.Table_ID);
        List<?> list = this.getInstancesForSelection(this.get_TrxName());
        list.stream().filter(mWMInOutBoundLine -> mWMInOutBoundLine.getQtyToDeliver().signum() > 0 || this.isIncludeNotAvailable()).forEach(this::createShipment);
        this.processingShipments();
        this.processingMovements();
        this.processingIssues();
        StringBuilder stringBuilder = new StringBuilder();
        this.shipments.forEach((n, mInOut) -> stringBuilder.append(" , ").append(mInOut.getDocumentInfo()));
        return "@Created@ " + this.documentCreated + stringBuilder.toString();
    }

    private void createShipment(MWMInOutBoundLine mWMInOutBoundLine) {
        Object object;
        Serializable serializable;
        MStorage[] mStorageArray;
        PO pO;
        if (mWMInOutBoundLine.getC_OrderLine_ID() > 0) {
            pO = mWMInOutBoundLine.getOrderLine();
            if (((X_C_OrderLine)pO).getQtyOrdered().subtract(((X_C_OrderLine)pO).getQtyDelivered()).subtract(mWMInOutBoundLine.getPickedQty()).signum() <= 0 && !this.isIncludeNotAvailable()) {
                return;
            }
            mStorageArray = this.getQtyDelivered(mWMInOutBoundLine, ((X_C_OrderLine)pO).getQtyDelivered());
            serializable = this.getShipment((MOrderLine)pO, mWMInOutBoundLine.getParent());
            object = new MInOutLine(mWMInOutBoundLine.getCtx(), 0, mWMInOutBoundLine.get_TrxName());
            ((X_M_InOutLine)object).setM_InOut_ID(((X_M_InOut)serializable).getM_InOut_ID());
            ((MInOutLine)object).setM_Locator_ID(mWMInOutBoundLine.getM_LocatorTo_ID());
            ((X_M_InOutLine)object).setM_Product_ID(mWMInOutBoundLine.getM_Product_ID());
            ((X_M_InOutLine)object).setC_UOM_ID(mWMInOutBoundLine.getC_UOM_ID());
            ((MInOutLine)object).setQtyEntered((BigDecimal)mStorageArray);
            ((MInOutLine)object).setMovementQty((BigDecimal)mStorageArray);
            ((X_M_InOutLine)object).setC_OrderLine_ID(((X_C_OrderLine)pO).getC_OrderLine_ID());
            ((X_M_InOutLine)object).setM_Shipper_ID(mWMInOutBoundLine.getM_Shipper_ID());
            ((X_M_InOutLine)object).setM_FreightCategory_ID(mWMInOutBoundLine.getM_FreightCategory_ID());
            ((X_M_InOutLine)object).setFreightAmt(mWMInOutBoundLine.getFreightAmt());
            ((X_M_InOutLine)object).setWM_InOutBoundLine_ID(mWMInOutBoundLine.getWM_InOutBoundLine_ID());
            ((PO)object).saveEx();
        }
        if (mWMInOutBoundLine.getDD_OrderLine_ID() > 0) {
            pO = (MDDOrderLine)mWMInOutBoundLine.getDD_OrderLine();
            if (this.distributionOrders.get(((X_DD_OrderLine)pO).getDD_Order_ID()) == null) {
                this.distributionOrders.put(((X_DD_OrderLine)pO).getDD_Order_ID(), ((X_DD_OrderLine)pO).getDD_Order());
            }
            ((X_DD_OrderLine)pO).setConfirmedQty(mWMInOutBoundLine.getPickedQty());
            pO.saveEx();
        }
        if (mWMInOutBoundLine.getPP_Order_BOMLine_ID() > 0) {
            pO = (MPPOrderBOMLine)mWMInOutBoundLine.getPP_Order_BOMLine();
            if (mWMInOutBoundLine.getPickedQty().subtract(((X_PP_Order_BOMLine)pO).getQtyDelivered()).signum() <= 0 && !this.isIncludeNotAvailable()) {
                return;
            }
            mStorageArray = MStorage.getAll(this.getCtx(), ((X_PP_Order_BOMLine)pO).getM_Product_ID(), mWMInOutBoundLine.getM_LocatorTo_ID(), this.get_TrxName());
            serializable = this.getQtyDelivered(mWMInOutBoundLine, ((X_PP_Order_BOMLine)pO).getQtyDelivered());
            object = MPPOrder.createIssue(((MPPOrderBOMLine)pO).getParent(), (MPPOrderBOMLine)pO, this.getMovementDate(), (BigDecimal)serializable, BigDecimal.ZERO, BigDecimal.ZERO, mStorageArray, true);
            object.forEach(mPPCostCollector -> {
                if (this.manufacturingIssues.get(mPPCostCollector.getPP_Cost_Collector_ID()) == null) {
                    this.manufacturingIssues.put(mPPCostCollector.getPP_Cost_Collector_ID(), (MPPCostCollector)mPPCostCollector);
                }
            });
        }
    }

    private BigDecimal getQtyDelivered(MWMInOutBoundLine mWMInOutBoundLine, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.isIncludeNotAvailable() ? mWMInOutBoundLine.getQtyToPick().subtract(bigDecimal) : mWMInOutBoundLine.getPickedQty().subtract(bigDecimal);
        return bigDecimal2;
    }

    private void processingIssues() {
        this.manufacturingIssues.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MPPCostCollector mPPCostCollector = (MPPCostCollector)entry.getValue();
            if ("DR".equals(mPPCostCollector.getDocStatus()) || "IP".equals(mPPCostCollector.getDocStatus())) {
                if (!mPPCostCollector.processIt("CO")) {
                    this.addLog("@ProcessFailed@ : " + mPPCostCollector.getDocumentInfo());
                    this.log.warning("@ProcessFailed@ :" + mPPCostCollector.getDocumentInfo());
                }
                mPPCostCollector.saveEx();
            }
        });
    }

    private void processingShipments() {
        ArrayList<PO> arrayList = new ArrayList<PO>();
        this.shipments.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MInOut mInOut = (MInOut)entry.getValue();
            if (!mInOut.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + mInOut.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + mInOut.getDocumentInfo());
            }
            mInOut.saveEx();
            ++this.documentCreated;
            this.addLog(mInOut.getDocumentInfo());
            arrayList.add(mInOut);
        });
        this.printDocument(arrayList, true);
    }

    private void processingMovements() {
        this.distributionOrders.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            I_DD_Order i_DD_Order = (I_DD_Order)entry.getValue();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(i_DD_Order.getDD_Order_ID());
            ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(MovementGenerate.getProcessId()).withSelectedRecordsIds(MDDOrder.Table_ID, arrayList).withParameter("M_Warehouse_ID", i_DD_Order.getM_Warehouse_ID()).withParameter("MovementDate", this.getMovementDate()).withoutTransactionClose().execute(this.get_TrxName());
            if (processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            this.addLog(processInfo.getSummary());
            Arrays.stream(processInfo.getIDs()).forEach(n -> {
                Optional<MMovement> optional = Optional.ofNullable(new MMovement(this.getCtx(), n, this.get_TrxName()));
                optional.ifPresent(mMovement -> {
                    ++this.documentCreated;
                    this.printDocument((PO)mMovement, true);
                });
            });
        });
    }

    private MInOut getShipment(MOrderLine mOrderLine, MWMInOutBound mWMInOutBound) {
        MInOut mInOut = this.shipments.get(mOrderLine.getC_Order_ID());
        if (mInOut != null) {
            return mInOut;
        }
        MOrder mOrder = mOrderLine.getParent();
        MDocType mDocType = (MDocType)mOrder.getC_DocType();
        int n = mDocType.getC_DocTypeShipment_ID();
        if (n == 0) {
            n = MDocType.getDocType("MMS", mOrderLine.getAD_Org_ID());
        }
        mInOut = new MInOut(mOrder, n, this.getMovementDate());
        mInOut.setIsSOTrx(true);
        mInOut.setM_Shipper_ID(mWMInOutBound.getM_Shipper_ID());
        mInOut.setM_FreightCategory_ID(mWMInOutBound.getM_FreightCategory_ID());
        mInOut.setFreightCostRule(mWMInOutBound.getFreightCostRule());
        mInOut.setFreightAmt(mWMInOutBound.getFreightAmt());
        mInOut.setDocAction("CO");
        mInOut.setDocStatus("DR");
        mInOut.saveEx();
        this.shipments.put(mOrder.getC_Order_ID(), mInOut);
        return mInOut;
    }
}

