/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.util.DB;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.process.GenerateInOutBoundAbstract;

public class GenerateInOutBound
extends GenerateInOutBoundAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MWMInOutBound mWMInOutBound = null;
        if ("ol".equals(this.getAliasForTableSelection())) {
            mWMInOutBound = this.createOutBoundOrder();
            this.createBasedOnSalesOrders(mWMInOutBound, this.getInstancesForSelection(this.get_TrxName()));
        }
        if ("demand".equals(this.getAliasForTableSelection())) {
            this.getProcessInfo().setTableSelectionId(MPPMRP.Table_ID);
            mWMInOutBound = this.createOutBoundOrder();
            this.createBasedOnDemand(mWMInOutBound, this.getInstancesForSelection(this.get_TrxName()));
        }
        return "@DocumentNo@ " + mWMInOutBound.getDocumentNo();
    }

    private MWMInOutBound createOutBoundOrder() {
        MLocator mLocator = MLocator.get(this.getCtx(), this.getLocatorId());
        MWMInOutBound mWMInOutBound = new MWMInOutBound(this.getCtx(), 0, this.get_TrxName());
        mWMInOutBound.setShipDate(this.getShipDate());
        mWMInOutBound.setPickDate(this.getPickDate());
        mWMInOutBound.setDocStatus("DR");
        String string = Optional.ofNullable(this.getDocAction()).orElse("PR");
        mWMInOutBound.setDocAction(string);
        Optional.ofNullable(this.getPOReference()).ifPresent(mWMInOutBound::setPOReference);
        Optional.ofNullable(this.getPriorityRule()).ifPresent(mWMInOutBound::setPriorityRule);
        Optional.ofNullable(this.getDeliveryViaRule()).ifPresent(mWMInOutBound::setDeliveryViaRule);
        Optional.ofNullable(this.getFreightCostRule()).ifPresent(mWMInOutBound::setFreightCostRule);
        Optional.ofNullable(this.getDeliveryRule()).ifPresent(mWMInOutBound::setDeliveryRule);
        if (this.getLocatorId() > 0) {
            mWMInOutBound.setM_Locator_ID(this.getLocatorId());
        }
        if (this.getDocTypeId() > 0) {
            mWMInOutBound.setC_DocType_ID(this.getDocTypeId());
        } else {
            int n = MDocType.getDocType("WMO");
            if (n <= 0) {
                throw new DocTypeNotFoundException("WMO", "");
            }
            mWMInOutBound.setC_DocType_ID(n);
        }
        if (this.getShipperId() > 0) {
            mWMInOutBound.setM_Shipper_ID(this.getShipperId());
        }
        if (this.getFreightCategoryId() > 0) {
            mWMInOutBound.setM_FreightCategory_ID(this.getFreightCategoryId());
        }
        mWMInOutBound.setM_Warehouse_ID(mLocator.getM_Warehouse_ID());
        mWMInOutBound.setIsSOTrx(true);
        mWMInOutBound.saveEx();
        this.addLog(mWMInOutBound.get_ID(), mWMInOutBound.getShipDate(), BigDecimal.ZERO, mWMInOutBound.getDocumentInfo());
        return mWMInOutBound;
    }

    private void createBasedOnSalesOrders(MWMInOutBound mWMInOutBound, List<MOrderLine> list) {
        list.forEach(mOrderLine -> {
            MWMInOutBoundLine mWMInOutBoundLine = new MWMInOutBoundLine(mWMInOutBound);
            mWMInOutBoundLine.setLine(this.getLineNo(mWMInOutBound));
            mWMInOutBoundLine.setM_Product_ID(mOrderLine.getM_Product_ID());
            mWMInOutBoundLine.setM_AttributeSetInstance_ID(mOrderLine.getM_AttributeSetInstance_ID());
            mWMInOutBoundLine.setMovementQty(mOrderLine.getQtyOrdered().subtract(mOrderLine.getQtyDelivered()));
            mWMInOutBoundLine.setC_UOM_ID(mOrderLine.getC_UOM_ID());
            mWMInOutBoundLine.setDescription(mOrderLine.getDescription());
            mWMInOutBoundLine.setC_Order_ID(mOrderLine.getC_Order_ID());
            mWMInOutBoundLine.setC_OrderLine_ID(mOrderLine.getC_OrderLine_ID());
            mWMInOutBoundLine.setPickDate(mWMInOutBound.getPickDate());
            mWMInOutBoundLine.setShipDate(mWMInOutBound.getShipDate());
            mWMInOutBoundLine.saveEx();
        });
    }

    private void createBasedOnDemand(MWMInOutBound mWMInOutBound, List<MPPMRP> list) {
        list.forEach(mPPMRP -> {
            Object object;
            MWMInOutBoundLine mWMInOutBoundLine = new MWMInOutBoundLine(mWMInOutBound);
            mWMInOutBoundLine.setLine(this.getLineNo(mWMInOutBound));
            mWMInOutBoundLine.setMovementQty(mPPMRP.getQty());
            mWMInOutBoundLine.setDescription(mPPMRP.getDescription());
            mWMInOutBoundLine.setPP_MRP_ID(mPPMRP.getPP_MRP_ID());
            mWMInOutBoundLine.setM_Product_ID(mPPMRP.getM_Product_ID());
            if ("SOO".equals(mPPMRP.getOrderType())) {
                object = mPPMRP.getC_OrderLine();
                mWMInOutBoundLine.setC_OrderLine_ID(mPPMRP.getC_OrderLine_ID());
                mWMInOutBoundLine.setC_Order_ID(mPPMRP.getC_Order_ID());
                mWMInOutBoundLine.setC_UOM_ID(object.getC_UOM_ID());
                mWMInOutBoundLine.setM_AttributeSetInstance_ID(object.getM_AttributeSetInstance_ID());
            }
            if ("DOO".equals(mPPMRP.getOrderType())) {
                object = mPPMRP.getDD_OrderLine();
                mWMInOutBoundLine.setDD_Order_ID(mPPMRP.getDD_Order_ID());
                mWMInOutBoundLine.setDD_OrderLine_ID(mPPMRP.getDD_OrderLine_ID());
                mWMInOutBoundLine.setC_UOM_ID(object.getC_UOM_ID());
                mWMInOutBoundLine.setM_AttributeSetInstance_ID(object.getM_AttributeSetInstance_ID());
            }
            if ("MOP".equals(mPPMRP.getOrderType())) {
                object = mPPMRP.getPP_Order_BOMLine();
                mWMInOutBoundLine.setPP_Order_ID(mPPMRP.getPP_Order_ID());
                mWMInOutBoundLine.setPP_Order_BOMLine_ID(mPPMRP.getPP_Order_BOMLine_ID());
                mWMInOutBoundLine.setC_UOM_ID(object.getC_UOM_ID());
                mWMInOutBoundLine.setM_AttributeSetInstance_ID(object.getM_AttributeSetInstance_ID());
            }
            mWMInOutBoundLine.setPickDate(mWMInOutBound.getPickDate());
            mWMInOutBoundLine.setShipDate(mWMInOutBound.getShipDate());
            mWMInOutBoundLine.saveEx();
        });
    }

    private int getLineNo(MWMInOutBound mWMInOutBound) {
        return DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM WM_InOutBoundLine WHERE WM_InOutBound_ID=?", mWMInOutBound.getWM_InOutBound_ID());
    }
}

