/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.engine.CostDimension;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.process.FrozenUnFrozenCostAbstract;

public class FrozenUnFrozenCost
extends FrozenUnFrozenCostAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MAcctSchema accountSchema = MAcctSchema.get(this.getCtx(), this.getAcctSchemaId());
        MCostType costType = MCostType.get(this.getCtx(), this.getCostTypeId());
        List<MCostElement> costElements = this.getCostElementId() > 0 ? Arrays.asList(MCostElement.get(this.getCtx(), this.getCostElementId())) : MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        costElements.stream().filter(costElement -> costElement != null).forEach(costElement -> {
            AtomicInteger records = new AtomicInteger(0);
            Arrays.stream(this.getProductIds()).filter(productId -> productId > 0).forEach(productId -> {
                MProduct product = MProduct.get(this.getCtx(), productId);
                CostDimension costDimension = new CostDimension(product, accountSchema, costType.getM_CostType_ID(), this.getOrgId(), this.getWarehouseId(), 0, costElement.getM_CostElement_ID());
                Trx.run(trxName -> {
                    List costs = costDimension.toQuery(MCost.class, trxName).list();
                    costs.stream().filter(cost -> cost != null).forEach(cost -> {
                        cost.setIsCostFrozen(this.isCostFrozen());
                        cost.saveEx();
                        records.updateAndGet(record -> record + 1);
                    });
                });
            });
            String message = "@M_CostElement_ID@ " + costElement.getName() + " @Records@ " + records.get() + " @IsCostFrozen@ = " + this.isCostFrozen();
            this.addLog(Msg.parseTranslation(this.getCtx(), message));
        });
        return "@OK@";
    }

    private int[] getProductIds() {
        StringBuilder whereClause = new StringBuilder("1=1 ");
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.getProductId() > 0) {
            whereClause.append("M_Product_ID").append("=? ");
            parameters.add(FrozenUnFrozenCost.getProcessId());
        }
        if (this.getProductCategoryId() > 0) {
            whereClause.append(" AND ").append("M_Product_Category_ID").append("=? ");
            parameters.add(this.getProductCategoryId());
        }
        if (this.getProductClassId() > 0) {
            whereClause.append(" AND ").append("M_Product_Class_ID").append("=?");
            parameters.add(this.getProductClassId());
        }
        if (this.getProductGroupId() > 0) {
            whereClause.append(" AND ").append("M_Product_Group_ID").append("=?");
            parameters.add(this.getProductGroupId());
        }
        if (this.getProductClassificationId() > 0) {
            whereClause.append(" AND ").append("M_Product_Classification_ID").append("=?");
            parameters.add(this.getProductClassificationId());
        }
        return new Query(this.getCtx(), "M_Product", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).getIDs();
    }
}

