/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MCashLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class FixPaymentCashLine
extends SvrProcess {
    private static final Properties ctx = Env.getCtx();
    private static CLogger s_log = CLogger.getCLogger(FixPaymentCashLine.class);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
    }

    @Override
    protected String doIt() throws Exception {
        String sql = "SELECT cl.C_CashLine_ID, c.Name FROM C_CashLine cl INNER JOIN C_Cash c ON (c.C_Cash_ID=cl.C_Cash_ID) WHERE cl.CashType='T'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Trx trx = Trx.get(Trx.createTrxName(), true);
                MCashLine cashline = new MCashLine(Env.getCtx(), rs.getInt(1), trx.getTrxName());
                Integer c_cashline_id = cashline.getC_CashLine_ID();
                int n = 0;
                MPayment[] payments = FixPaymentCashLine.getOfCash(Env.getCtx(), rs.getString(2), cashline.getAmount(), cashline.getC_BankAccount_ID(), cashline.getAD_Client_ID(), trx.getTrxName());
                MPayment[] mPaymentArray = payments;
                int n2 = mPaymentArray.length;
                if (n < n2) {
                    MPayment payment = mPaymentArray[n];
                    cashline.setC_Payment_ID(payment.getC_Payment_ID());
                    if (!cashline.save()) {
                        throw new IllegalStateException("Cannot assign payment to Cash Line");
                    }
                }
                trx.commit();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@ProcessOK@";
    }

    public static MPayment[] getOfCash(Properties ctx, String cashName, BigDecimal amt, int C_BankAccount_ID, int AD_Client_ID, String trxName) {
        String sql = "SELECT * FROM C_Payment p WHERE p.DocumentNo=? AND R_PnRef=? AND PayAmt=? AND C_BankAccount_ID=? AND AD_Client_ID=?  AND TrxType='X' AND TenderType='X'";
        ArrayList<MPayment> list = new ArrayList<MPayment>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setString(1, cashName);
            pstmt.setString(2, cashName);
            pstmt.setBigDecimal(3, amt.negate());
            pstmt.setInt(4, C_BankAccount_ID);
            pstmt.setInt(5, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPayment(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MPayment[] retValue = new MPayment[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        Env.setContext(Env.getCtx(), "#AD_Client_ID", 11);
        FixPaymentCashLine pcf = new FixPaymentCashLine();
        try {
            pcf.doIt();
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
        }
    }
}

