/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.engine.CostDimension;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.eevolution.process.CopyPriceToStandardAbstract;

public class CopyPriceToStandard
extends CopyPriceToStandardAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MAcctSchema accountSchema = MAcctSchema.get(this.getCtx(), this.getAcctSchemaId());
        MCostElement costElement = MCostElement.get(this.getCtx(), this.getCostElementId());
        if (!"M".equals(costElement.getCostElementType())) {
            throw new AdempiereException("Only Material Cost Elements are allowed");
        }
        AtomicInteger countUpdated = new AtomicInteger(0);
        MPriceListVersion priceListVersion = new MPriceListVersion(this.getCtx(), this.getPriceListVersionId(), this.get_TrxName());
        Arrays.stream(priceListVersion.getProductPrice(" AND PriceStd <> 0")).forEach(productPrice -> {
            int currencyId = priceListVersion.getPriceList().getC_Currency_ID();
            BigDecimal price = currencyId != accountSchema.getC_Currency_ID() ? MConversionRate.convert(this.getCtx(), productPrice.getPriceStd(), currencyId, accountSchema.getC_Currency_ID(), this.getAD_Client_ID(), this.getOrgId()) : productPrice.getPriceStd();
            MProduct product = MProduct.get(this.getCtx(), productPrice.getM_Product_ID());
            CostDimension costDimension = new CostDimension(product, accountSchema, this.getCostTypeId(), this.getOrgId(), 0, 0, this.getCostElementId());
            List costs = costDimension.toQuery(MCost.class, this.get_TrxName()).list();
            costs.stream().filter(cost -> cost != null && cost.getM_CostElement_ID() == costElement.get_ID()).findFirst().ifPresent(cost -> {
                cost.setFutureCostPrice(price);
                cost.saveEx();
                countUpdated.getAndUpdate(count -> count + 1);
            });
        });
        return "@Updated@ # " + countUpdated;
    }
}

