/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.RoundingMode;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MPayment;
import org.compiere.util.Env;
import org.eevolution.process.BankTransferAbstract;

public class BankTransferMultiCur
extends BankTransferAbstract {
    private int m_created = 0;
    MBankAccount mBankFrom = null;
    MBankAccount mBankTo = null;

    @Override
    protected String doIt() throws Exception {
        MClient client = new MClient(this.getCtx(), this.getAD_Client_ID(), null);
        MAcctSchema schema = client.getAcctSchema();
        this.mBankFrom = new MBankAccount(this.getCtx(), this.getBankAccountFromId(), this.get_TrxName());
        this.mBankTo = new MBankAccount(this.getCtx(), this.getBankAccountToId(), this.get_TrxName());
        if (this.mBankFrom.getC_Currency_ID() != schema.getC_Currency_ID() && this.mBankTo.getC_Currency_ID() != schema.getC_Currency_ID() && this.mBankFrom.getC_Currency_ID() != this.mBankTo.getC_Currency_ID()) {
            throw new AdempiereException("Al menos una de las cuentas debe ser en moneda del esquema contable");
        }
        if (this.mBankFrom.getC_Currency_ID() != this.mBankTo.getC_Currency_ID() && this.getCurrencyRate().compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("Debe ingresar tasa de cambio");
        }
        if (this.mBankFrom.getC_Currency_ID() == this.mBankTo.getC_Currency_ID() && this.getCurrencyId() != this.mBankFrom.getC_Currency_ID() && this.getCurrencyRate().compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("Debe ingresar tasa de cambio");
        }
        this.generateBankTransfer(schema.getC_Currency_ID());
        return "@Created@ = " + this.m_created;
    }

    private void generateBankTransfer(int acctCurrID) {
        MBankStatementLine bsl;
        MBankStatementLine bsl2;
        Timestamp statementDate = this.getStatementdate();
        Timestamp dateAcct = this.getAccountDate();
        String documentNoTo = this.getDocumentNoTo();
        String tenderTypeFrom = "";
        String tenderTypeTo = "";
        MCurrency curFrom = (MCurrency)this.mBankFrom.getC_Currency();
        MCurrency curTo = (MCurrency)this.mBankTo.getC_Currency();
        if (documentNoTo == null || documentNoTo.trim().length() == 0) {
            documentNoTo = this.getDocumentNo();
        }
        if (statementDate == null) {
            statementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (statementDate == null) {
            statementDate = new Timestamp(System.currentTimeMillis());
        }
        if (dateAcct == null) {
            dateAcct = statementDate;
        }
        if (this.getTenderType().equalsIgnoreCase("D")) {
            tenderTypeFrom = "D";
            tenderTypeTo = "A";
        } else if (this.getTenderType().equalsIgnoreCase("K")) {
            tenderTypeFrom = "K";
            tenderTypeTo = "A";
        }
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(this.mBankFrom.getC_BankAccount_ID());
        paymentBankFrom.setDocumentNo(this.getDocumentNo());
        paymentBankFrom.setDateAcct(dateAcct);
        paymentBankFrom.setDateTrx(statementDate);
        paymentBankFrom.setTenderType(tenderTypeFrom);
        paymentBankFrom.setDescription(this.getDescription());
        paymentBankFrom.setC_BPartner_ID(this.getBusinessPartnerId());
        if (this.getCurrencyTypeId() > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.getCurrencyTypeId());
        }
        if (this.mBankFrom.getC_Currency_ID() == this.getCurrencyId()) {
            paymentBankFrom.setPayAmt(this.getAmount());
            paymentBankFrom.setC_Currency_ID(this.getCurrencyId());
        } else {
            if (this.getCurrencyId() != acctCurrID && this.mBankFrom.getC_Currency_ID() == acctCurrID) {
                paymentBankFrom.setPayAmt(this.getAmount().multiply(this.getCurrencyRate()).setScale(2, RoundingMode.HALF_UP));
            } else if (this.getCurrencyId() == acctCurrID && this.mBankFrom.getC_Currency_ID() != acctCurrID) {
                paymentBankFrom.setPayAmt(this.getAmount().divide(this.getCurrencyRate(), 2, RoundingMode.HALF_UP));
            }
            paymentBankFrom.setC_Currency_ID(this.mBankFrom.getC_Currency_ID());
        }
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(this.getChargeId());
        paymentBankFrom.saveEx();
        paymentBankFrom.processIt("CO");
        paymentBankFrom.saveEx();
        if (this.isReconcileAutomatically() && (bsl2 = MBankStatement.addPayment(paymentBankFrom)) != null) {
            this.addLog("@C_Payment_ID@: " + paymentBankFrom.getDocumentNo() + " @Added@ @to@ [@AccountNo@ " + paymentBankFrom.getC_BankAccount().getAccountNo() + " @C_BankStatement_ID@ " + bsl2.getC_BankStatement().getName() + "]");
        }
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(this.mBankTo.getC_BankAccount_ID());
        paymentBankTo.setDocumentNo(documentNoTo);
        paymentBankTo.setDateAcct(dateAcct);
        paymentBankTo.setDateTrx(statementDate);
        paymentBankTo.setTenderType(tenderTypeTo);
        paymentBankTo.setDescription(this.getDescription());
        paymentBankTo.setC_BPartner_ID(this.getBusinessPartnerId());
        if (this.getCurrencyTypeId() > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.getCurrencyTypeId());
        }
        if (this.mBankTo.getC_Currency_ID() == this.getCurrencyId()) {
            paymentBankTo.setPayAmt(this.getAmount());
            paymentBankTo.setC_Currency_ID(this.getCurrencyId());
        } else {
            if (this.getCurrencyId() != acctCurrID && this.mBankTo.getC_Currency_ID() == acctCurrID) {
                paymentBankTo.setPayAmt(this.getAmount().multiply(this.getCurrencyRate()).setScale(2, RoundingMode.HALF_UP));
            } else if (this.getCurrencyId() == acctCurrID && this.mBankTo.getC_Currency_ID() != acctCurrID) {
                paymentBankTo.setPayAmt(this.getAmount().divide(this.getCurrencyRate(), 2, RoundingMode.HALF_UP));
            }
            paymentBankTo.setC_Currency_ID(this.mBankTo.getC_Currency_ID());
        }
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(this.getChargeId());
        paymentBankTo.saveEx();
        paymentBankTo.processIt("CO");
        paymentBankTo.saveEx();
        paymentBankFrom.setRef_Payment_ID(paymentBankTo.get_ID());
        paymentBankTo.setRef_Payment_ID(paymentBankFrom.get_ID());
        String descriptionFrom = this.mBankFrom.getDescription();
        String descriptionTo = this.mBankTo.getDescription();
        if (descriptionFrom == null || descriptionFrom.equalsIgnoreCase("")) {
            descriptionFrom = this.mBankFrom.getAccountNo();
        }
        if (descriptionTo == null || descriptionTo.equalsIgnoreCase("")) {
            descriptionTo = this.mBankTo.getAccountNo();
        }
        String description = "Origen: " + descriptionFrom + ", Pago " + paymentBankFrom.getDocumentNo() + " " + curFrom.getISO_Code() + " " + paymentBankFrom.getPayAmt().setScale(2, RoundingMode.HALF_UP) + " - Destino: " + descriptionTo + ", Cobro " + paymentBankTo.getDocumentNo() + " " + curTo.getISO_Code() + " " + paymentBankTo.getPayAmt().setScale(2, RoundingMode.HALF_UP);
        if (paymentBankFrom.getDescription() != null && !paymentBankFrom.getDescription().equalsIgnoreCase("")) {
            paymentBankFrom.setDescription(paymentBankFrom.getDescription() + " " + description);
        } else {
            paymentBankFrom.setDescription(description);
        }
        paymentBankFrom.saveEx();
        if (paymentBankTo.getDescription() != null && !paymentBankTo.getDescription().equalsIgnoreCase("")) {
            paymentBankTo.setDescription(paymentBankTo.getDescription() + " " + description);
        } else {
            paymentBankTo.setDescription(description);
        }
        paymentBankTo.saveEx();
        if (this.isReconcileAutomatically() && (bsl = MBankStatement.addPayment(paymentBankTo)) != null) {
            this.addLog("@C_Payment_ID@: " + paymentBankTo.getDocumentNo() + " @Added@ @to@ [@AccountNo@ " + paymentBankTo.getC_BankAccount().getAccountNo() + " @C_BankStatement_ID@ " + bsl.getC_BankStatement().getName() + "]");
        }
        ++this.m_created;
    }
}

