/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.Timestamp;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.util.Env;
import org.eevolution.process.BankTransferAbstract;

public class BankTransfer
extends BankTransferAbstract {
    private int m_created = 0;

    @Override
    protected String doIt() throws Exception {
        this.generateBankTransfer();
        return "@Created@ = " + this.m_created;
    }

    private void generateBankTransfer() {
        MBankStatementLine bsl;
        Timestamp statementDate = this.getStatementDate();
        Timestamp dateAcct = this.getDateAcct();
        String documentNoTo = this.getDocumentNoTo();
        if (documentNoTo == null || documentNoTo.trim().length() == 0) {
            documentNoTo = this.getDocumentNo();
        }
        if (statementDate == null) {
            statementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (statementDate == null) {
            statementDate = new Timestamp(System.currentTimeMillis());
        }
        if (dateAcct == null) {
            dateAcct = statementDate;
        }
        MBankAccount mBankFrom = new MBankAccount(this.getCtx(), this.getBankAccountFromId(), this.get_TrxName());
        MBankAccount mBankTo = new MBankAccount(this.getCtx(), this.getBankAccountToId(), this.get_TrxName());
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(mBankFrom.getC_BankAccount_ID());
        paymentBankFrom.setDocumentNo(this.getDocumentNo());
        paymentBankFrom.setDateAcct(dateAcct);
        paymentBankFrom.setDateTrx(statementDate);
        paymentBankFrom.setTenderType("A");
        paymentBankFrom.setDescription(this.getDescription());
        paymentBankFrom.setC_BPartner_ID(this.getBusinessPartnerId());
        paymentBankFrom.setC_Currency_ID(this.getCurrencyId());
        if (this.getConversionTypeId() > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.getConversionTypeId());
        }
        paymentBankFrom.setPayAmt(this.getAmount());
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(this.getChargeId());
        paymentBankFrom.saveEx();
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(mBankTo.getC_BankAccount_ID());
        paymentBankTo.setDocumentNo(documentNoTo);
        paymentBankTo.setDateAcct(dateAcct);
        paymentBankTo.setDateTrx(statementDate);
        paymentBankTo.setTenderType("A");
        paymentBankTo.setDescription(this.getDescription());
        paymentBankTo.setC_BPartner_ID(this.getBusinessPartnerId());
        paymentBankTo.setC_Currency_ID(this.getCurrencyId());
        if (this.getConversionTypeId() > 0) {
            paymentBankTo.setC_ConversionType_ID(this.getConversionTypeId());
        }
        if (this.getPosId() > 0) {
            paymentBankFrom.setC_POS_ID(this.getPosId());
            paymentBankTo.setC_POS_ID(this.getPosId());
        }
        paymentBankTo.setPayAmt(this.getAmount());
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(this.getChargeId());
        paymentBankTo.saveEx();
        paymentBankFrom.set_ValueOfColumn("RelatedPayment_ID", (Object)paymentBankTo.getC_Payment_ID());
        paymentBankFrom.saveEx();
        paymentBankFrom.processIt("CO");
        paymentBankFrom.saveEx();
        if (this.isAutoReconciled() && (bsl = MBankStatement.addPayment(paymentBankFrom)) != null) {
            this.addLog("@C_Payment_ID@: " + paymentBankFrom.getDocumentNo() + " @Added@ @to@ [@AccountNo@ " + paymentBankFrom.getC_BankAccount().getAccountNo() + " @C_BankStatement_ID@ " + bsl.getC_BankStatement().getName() + "]");
        }
        paymentBankTo.set_ValueOfColumn("RelatedPayment_ID", (Object)paymentBankFrom.getC_Payment_ID());
        paymentBankTo.saveEx();
        paymentBankTo.processIt("CO");
        paymentBankTo.saveEx();
        if (this.isAutoReconciled() && (bsl = MBankStatement.addPayment(paymentBankTo)) != null) {
            this.addLog("@C_Payment_ID@: " + paymentBankTo.getDocumentNo() + " @Added@ @to@ [@AccountNo@ " + paymentBankTo.getC_BankAccount().getAccountNo() + " @C_BankStatement_ID@ " + bsl.getC_BankStatement().getName() + "]");
        }
        ++this.m_created;
    }
}

