/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.eevolution.model.X_HR_WorkGroup;

public class MHRWorkGroup
extends X_HR_WorkGroup {
    private static final long serialVersionUID = -3426527194456182750L;
    private static CCache<Integer, MHRWorkGroup> workGroupCacheIds = new CCache("HR_WorkGroup", 30);
    private static CCache<String, MHRWorkGroup> workGroupCacheValues = new CCache("HR_WorkGroup", 30);

    public MHRWorkGroup(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRWorkGroup(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MHRWorkGroup getById(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MHRWorkGroup mHRWorkGroup = workGroupCacheIds.get(n);
        if (mHRWorkGroup != null && mHRWorkGroup.get_ID() > 0) {
            return mHRWorkGroup;
        }
        mHRWorkGroup = (MHRWorkGroup)new Query(properties, "HR_WorkGroup", "HR_WorkGroup_ID=?", string).setClient_ID().setParameters(n).first();
        if (mHRWorkGroup != null && mHRWorkGroup.get_ID() > 0) {
            int n2 = Env.getAD_Client_ID(properties);
            String string2 = n2 + "#" + mHRWorkGroup.getValue();
            workGroupCacheValues.put(string2, mHRWorkGroup);
            workGroupCacheIds.put(mHRWorkGroup.get_ID(), mHRWorkGroup);
        }
        return mHRWorkGroup;
    }

    public static MHRWorkGroup getByValue(Properties properties, String string, String string2) {
        int n;
        String string3;
        MHRWorkGroup mHRWorkGroup;
        if (string == null) {
            return null;
        }
        if (workGroupCacheValues.size() == 0) {
            MHRWorkGroup.getAll(properties, true);
        }
        if ((mHRWorkGroup = workGroupCacheValues.get(string3 = (n = Env.getAD_Client_ID(properties)) + "#" + string)) != null && mHRWorkGroup.get_ID() > 0) {
            return mHRWorkGroup;
        }
        mHRWorkGroup = (MHRWorkGroup)new Query(properties, "HR_WorkGroup", "Value=?", string2).setClient_ID().setParameters(string).first();
        if (mHRWorkGroup != null && mHRWorkGroup.get_ID() > 0) {
            workGroupCacheValues.put(string3, mHRWorkGroup);
            workGroupCacheIds.put(mHRWorkGroup.get_ID(), mHRWorkGroup);
        }
        return mHRWorkGroup;
    }

    public static List<MHRWorkGroup> getAll(Properties properties, boolean bl) {
        if (bl || workGroupCacheIds.size() > 0) {
            List<MHRWorkGroup> list = new Query(Env.getCtx(), "HR_WorkGroup", null, null).setClient_ID().setOrderBy("Name").list();
            list.stream().forEach(mHRWorkGroup -> {
                int n = Env.getAD_Client_ID(properties);
                String string = n + "#" + mHRWorkGroup.getValue();
                workGroupCacheIds.put(mHRWorkGroup.getHR_WorkGroup_ID(), (MHRWorkGroup)mHRWorkGroup);
                workGroupCacheValues.put(string, (MHRWorkGroup)mHRWorkGroup);
            });
            return list;
        }
        List<MHRWorkGroup> list = workGroupCacheIds.entrySet().stream().map(entry -> (MHRWorkGroup)entry.getValue()).collect(Collectors.toList());
        return list;
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (this.isShiftAllocation() && this.getHR_ShiftGroup_ID() == 0 && this.getHR_WorkShift_ID() == 0) {
            throw new AdempiereException("@HR_ShiftGroup_ID@ / @HR_WorkShift_ID@ @IsMandatory@");
        }
        return true;
    }

    @Override
    public String toString() {
        return "MHRWorkGroup [getHR_WorkGroup_ID()=" + this.getHR_WorkGroup_ID() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

