/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRLeaveAssign;
import org.eevolution.model.MHRLeaveType;
import org.eevolution.model.X_HR_Leave;
import org.spin.util.TNAUtil;

public class MHRLeave
extends X_HR_Leave
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20180911L;
    public static final String DocBaseType_Standard = "TNL";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MHRLeave(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRLeave(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    public void setC_DocType_ID() {
        String string = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID = ? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType = ?  AND IsActive = 'Y' ORDER BY AD_Org_ID, IsDefault DESC";
        int n = DB.getSQLValue(null, string, this.getAD_Client_ID(), DocBaseType_Standard);
        if (n <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseType=" + DocBaseType_Standard);
        } else {
            this.log.fine("(APS) - TNL");
            this.setC_DocType_ID(n);
        }
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (bl) {
            if (this.getC_DocType_ID() == 0) {
                this.setC_DocType_ID();
            }
            this.setLeaveTime();
        }
        return super.beforeSave(bl);
    }

    private void setLeaveTime() {
        if (this.getNoOfLeavesCredited() <= 0) {
            this.setNoOfLeavesCredited(1);
        }
        if (this.getStartDate() == null) {
            MHRLeaveType mHRLeaveType = MHRLeaveType.getById(this.getCtx(), this.getHR_LeaveType_ID(), this.get_TrxName());
            if (mHRLeaveType.getTimeFrom() != null && mHRLeaveType.getTimeTo() != null) {
                this.setStartDate(TimeUtil.getDayTime(this.getDateDoc(), mHRLeaveType.getTimeFrom()));
                this.setEndDate(TimeUtil.getDayTime(this.getDateDoc(), mHRLeaveType.getTimeTo()));
            } else {
                this.setStartDate(this.getDateDoc());
                BigDecimal bigDecimal = mHRLeaveType.getLeaveDurationTime();
                if (bigDecimal == null) {
                    bigDecimal = Env.ONE;
                }
                Timestamp timestamp = TimeUtil.addDuration(this.getDateDoc(), TNAUtil.getDurationUnitFromTimeUnit(mHRLeaveType.getTimeUnit()), bigDecimal);
                this.setEndDate(timestamp);
            }
        }
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.validateEmployee();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void validateEmployee() {
        MBPartner mBPartner = (MBPartner)this.getC_BPartner();
        MHREmployee mHREmployee = null;
        mHREmployee = this.getHR_Employee_ID() > 0 ? MHREmployee.getById(this.getCtx(), this.getHR_Employee_ID()) : MHREmployee.getActiveEmployee(this.getCtx(), mBPartner.getC_BPartner_ID(), this.get_TrxName());
        if (mHREmployee == null) {
            throw new AdempiereException("@HR_Employee_ID@ @NotFound@: " + mBPartner.getValue() + " - " + mBPartner.getName());
        }
        this.setHR_Employee_ID(mHREmployee.getHR_Employee_ID());
        this.saveEx();
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.addUsedLeave();
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void addUsedLeave() {
        if (this.getHR_LeaveAssign_ID() > 0) {
            MHRLeaveAssign mHRLeaveAssign = new MHRLeaveAssign(this.getCtx(), this.getHR_LeaveAssign_ID(), this.get_TrxName());
            mHRLeaveAssign.addUsedLeave(1);
            mHRLeaveAssign.saveEx();
        }
    }

    private void removeUsedLeave() {
        if (this.getHR_LeaveAssign_ID() > 0) {
            MHRLeaveAssign mHRLeaveAssign = new MHRLeaveAssign(this.getCtx(), this.getHR_LeaveAssign_ID(), this.get_TrxName());
            mHRLeaveAssign.addUsedLeave(-1);
            mHRLeaveAssign.saveEx();
        }
    }

    private void setDefiniteDocumentNo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (mDocType.isOverwriteSeqOnComplete()) {
            String string = null;
            int n = this.p_info.getColumnIndex("C_DocType_ID");
            if (n == -1) {
                n = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (n != -1) {
                string = DB.getDocumentNo(this.get_ValueAsInt(n), this.get_TrxName(), true);
            }
            if (string != null) {
                this.setDocumentNo(string);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.removeUsedLeave();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public int customizeValidActions(String string, Object object, String string2, String string3, int n, String[] stringArray, String[] stringArray2, int n2) {
        if (n == Table_ID) {
            if (string.equals("DR") || string.equals("IP") || string.equals("IN")) {
                stringArray2[n2++] = "PR";
            } else if (string.equals("CO")) {
                stringArray2[n2++] = "VO";
                stringArray2[n2++] = "RE";
                stringArray2[n2++] = "CL";
            } else if (string.equals("CL")) {
                stringArray2[n2++] = "--";
            }
        }
        return n2;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            stringBuffer.append(" - ").append(this.getDescription());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MHRLeave[").append(this.getSummary()).append("]");
        return stringBuffer.toString();
    }
}

