/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.grid;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.impexp.ArrayExcelExporter;
import org.adempiere.model.I_AD_View_Column;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MView;
import org.adempiere.model.MViewColumn;
import org.adempiere.model.MViewDefinition;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.eevolution.grid.BrowserRow;
import org.eevolution.grid.IBrowserTable;
import org.spin.util.ASPUtil;

public abstract class Browser {
    private MBrowse browseModel = null;
    private ASPUtil aspUtil = null;
    private MView view = null;
    public static final int WINDOW_WIDTH = 1024;
    private ArrayList<String> m_queryColumns = new ArrayList();
    private ArrayList<String> m_queryColumnsSql = new ArrayList();
    private ArrayList<Object> parameters;
    private ArrayList<Object> parametersValues;
    private ArrayList<Object> axisParameters;
    private ArrayList<Object> axisParametersValues;
    private ArrayList<GridFieldVO> parametersField;
    private String whereClause = "";
    private MProcess process = null;
    private ProcessInfo processInfo = null;
    private ProcessInfo browsePI = null;
    public boolean loadedOK = false;
    public int keyColumnIndex = -1;
    public boolean m_ok = false;
    private ArrayList<Integer> m_results = new ArrayList(3);
    private LinkedHashMap<Integer, LinkedHashMap<String, Object>> values = new LinkedHashMap();
    public CLogger log = CLogger.getCLogger(this.getClass());
    public List<MBrowseField> browserFields;
    public String m_sqlMain;
    public String m_sqlCount;
    public String m_sqlOrderBy;
    public int windowNo;
    public String p_FromClause;
    public String p_keyColumn;
    public boolean isMultiSelection;
    public String p_whereClause = "";
    public static final int INFO_WIDTH = 800;
    public boolean isAllSelected = false;
    private Exporter m_exporter = null;
    private Language m_language = null;
    protected ArrayList<ArrayList<Object>> m_rows = new ArrayList();
    private int parentWindowNo;

    public static LinkedHashMap<String, Object> getBrowseValues(int AD_PInstance_ID, String alias, int recordId, String trxName) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        try {
            StringBuilder sql = new StringBuilder("SELECT ColumnName , Value_String, Value_Date , Value_Number FROM T_Selection_Browse WHERE  AD_PInstance_ID=? AND T_Selection_ID=? ");
            parameters.add(AD_PInstance_ID);
            parameters.add(recordId);
            if (alias != null) {
                sql.append("AND ColumnName LIKE ?");
                parameters.add(alias.toUpperCase() + "_%");
            }
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            DB.setParameters((PreparedStatement)pstmt, parameters);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                String valueString = rs.getString(2);
                Timestamp valueDate = rs.getTimestamp(3);
                BigDecimal valueBigDecimal = rs.getBigDecimal(4);
                if (valueString != null) {
                    values.put(columnName, valueString);
                    continue;
                }
                if (valueDate != null) {
                    values.put(columnName, valueDate);
                    continue;
                }
                if (valueBigDecimal != null) {
                    values.put(columnName, valueBigDecimal);
                    continue;
                }
                values.put(columnName, valueString);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DBException(ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return values;
    }

    public Browser(boolean modal, int WindowNo, String value, MBrowse browse, String keyColumn, boolean multiSelection, String where) {
        this.browseModel = browse;
        this.aspUtil = ASPUtil.getInstance(this.browseModel.getCtx());
        this.view = browse.getAD_View();
        this.p_keyColumn = keyColumn;
        this.isMultiSelection = multiSelection;
        this.m_language = Language.getLanguage(Env.getAD_Language(this.browseModel.getCtx()));
        this.parentWindowNo = WindowNo;
        this.log.info(this.browseModel.getName() + " - " + keyColumn + " - " + this.p_whereClause);
    }

    public void setContextWhere(String where) {
        this.p_whereClause = null;
        String whereClause = where != null ? where : "";
        whereClause = this.browseModel.getWhereClause() != null ? whereClause + this.browseModel.getWhereClause() : " 1=1 ";
        if (whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause;
        } else {
            this.p_whereClause = Env.parseContext(Env.getCtx(), this.getWindowNo(), whereClause, false, false);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        this.log.info(this.browseModel.getName() + " - " + this.p_whereClause);
    }

    public void copyWinContext() {
        Object[] keys = Env.getCtx().keySet().toArray();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            String tag = keys[i2].toString();
            if (!tag.startsWith(this.getParentWindowNo() + "|")) continue;
            String context = tag.substring(tag.lastIndexOf("|") + 1);
            String value = Env.getContext(Env.getCtx(), this.getParentWindowNo(), context);
            Env.setContext(Env.getCtx(), this.getWindowNo(), context, value);
        }
    }

    public void initBrowserData() {
        this.browserFields = new ArrayList<MBrowseField>();
        MBrowseField fieldKey = this.aspUtil.getBrowseFieldKey(this.browseModel.getAD_Browse_ID());
        if (fieldKey != null) {
            this.browserFields.add(fieldKey);
        } else {
            MViewColumn column = new MViewColumn(this.browseModel.getCtx(), 0, this.browseModel.get_TrxName());
            column.setName("Row");
            column.setColumnSQL("'Row' AS \"Row\"");
            MBrowseField browseField = new MBrowseField(this.browseModel, column);
            browseField.setAD_Reference_ID(13);
            browseField.setIsKey(true);
            browseField.setIsReadOnly(false);
        }
        for (MBrowseField field : this.aspUtil.getBrowseDisplayFields(this.browseModel.getAD_Browse_ID())) {
            if (field.isQueryCriteria()) {
                this.m_queryColumns.add(field.getName());
            }
            this.m_queryColumnsSql.add(field.getAD_View_Column().getColumnSQL());
            if (field.isKey()) continue;
            if (field.getAxis_Column_ID() > 0) {
                for (MBrowseField fieldAxis : this.getInfoColumnForAxisField(field)) {
                    this.browserFields.add(fieldAxis);
                }
                continue;
            }
            this.browserFields.add(field);
        }
    }

    public ArrayList<Object> getAxisParameters() {
        return this.axisParameters;
    }

    public ArrayList<Object> getAxisParametersValues() {
        return this.axisParametersValues;
    }

    public ArrayList<Object> getParameters() {
        return this.parameters;
    }

    public ArrayList<Object> getParametersValues() {
        return this.parametersValues;
    }

    public void addSQLWhere(StringBuffer sql, int index, String value) {
        if (!value.equals("") && !value.equals("%") && index < this.m_queryColumns.size()) {
            sql.append(" UPPER(").append(this.m_queryColumnsSql.get(index).toString()).append(") LIKE '");
            sql.append(value);
            if (value.endsWith("%")) {
                sql.append("'");
            } else {
                sql.append("%'");
            }
        }
    }

    public int testCount() {
        int no = -1;
        no = this.getCount();
        MRole role = MRole.getDefault();
        if (role.isQueryMax(no)) {
            return no;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        int no;
        ResultSet rs;
        CPreparedStatement pstmt;
        long start;
        block6: {
            start = System.currentTimeMillis();
            String dynWhere = this.getSQLWhere(true);
            StringBuffer sql = new StringBuffer(this.m_sqlCount);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            String countSql = Env.parseContext(Env.getCtx(), this.getWindowNo(), sql.toString(), true, true);
            countSql = MRole.getDefault().addAccessSQL(countSql, this.view.getParentEntityAliasName(), true, false);
            this.log.finer(countSql);
            pstmt = null;
            rs = null;
            no = -1;
            try {
                pstmt = DB.prepareStatement(countSql, null);
                if (this.getParametersValues() != null && this.getParametersValues().size() > 0) {
                    DB.setParameters((PreparedStatement)pstmt, this.getParametersValues());
                }
                if (!(rs = pstmt.executeQuery()).next()) break block6;
                no = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, countSql, e);
                    no = -2;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        return no;
    }

    public boolean hasMandatoryParams() {
        for (Map.Entry<String, GridField> entry : this.getPanelParameters().entrySet()) {
            GridField editor = entry.getValue();
            if (!editor.isMandatory(true)) continue;
            return true;
        }
        return false;
    }

    public void initProcessInfo() {
        this.process = MProcess.get(Env.getCtx(), this.browseModel.getAD_Process_ID());
        this.browsePI = new ProcessInfo(this.process.getName(), this.browseModel.getAD_Process_ID());
        this.browsePI.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
        this.browsePI.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
        this.browsePI.setWindowNo(this.getWindowNo());
        this.browsePI.setIsSelection(true);
        if (this.processInfo != null) {
            this.browsePI.setTable_ID(this.processInfo.getTable_ID());
            this.browsePI.setRecord_ID(this.processInfo.getRecord_ID());
        }
    }

    public int getAD_Process_ID() {
        return this.browseModel.getAD_Process_ID();
    }

    public String getViewName() {
        return this.view.getName();
    }

    public String getBrowserName() {
        return this.browseModel.getName();
    }

    public String getSQLWhere(boolean refresh) {
        if (!refresh) {
            return this.whereClause;
        }
        StringBuilder sql = new StringBuilder(this.p_whereClause);
        LinkedHashMap<String, GridField> panelParameters = this.getPanelParameters();
        if (panelParameters == null || panelParameters.size() == 0) {
            this.whereClause = sql.toString();
            return this.whereClause;
        }
        this.parametersValues = new ArrayList();
        this.parameters = new ArrayList();
        boolean onRange = false;
        for (Map.Entry<String, GridField> entry : panelParameters.entrySet()) {
            GridField editor = entry.getValue();
            GridFieldVO field = editor.getVO();
            if (!onRange) {
                if (editor.getValue() != null && !field.IsRange) {
                    sql.append(" AND ");
                    if (10 == field.displayType) {
                        String value = (String)editor.getValue();
                        if (value.contains(",")) {
                            value = value.replace(" ", "");
                            String inStr = new String(value);
                            StringBuffer outStr = new StringBuffer("(");
                            int i2 = inStr.indexOf(44);
                            while (i2 != -1) {
                                outStr.append("'" + inStr.substring(0, i2) + "',");
                                inStr = inStr.substring(i2 + 1, inStr.length());
                                i2 = inStr.indexOf(44);
                            }
                            outStr.append("'" + inStr + "')");
                            sql.append(field.ColumnSQL).append(" IN ").append(outStr);
                            continue;
                        }
                        if (value.contains("%")) {
                            sql.append(" lower( ").append(field.ColumnSQL).append(") LIKE ? ");
                            this.parameters.add(field.ColumnSQL);
                            this.parametersValues.add(editor.getValue().toString().toLowerCase());
                            continue;
                        }
                        sql.append(" lower( ").append(field.ColumnSQL).append(") = ? ");
                        this.parameters.add(field.ColumnSQL);
                        this.parametersValues.add(editor.getValue().toString().toLowerCase());
                        continue;
                    }
                    sql.append(field.ColumnSQL).append("=? ");
                    this.parameters.add(field.ColumnSQL);
                    this.parametersValues.add(editor.getValue());
                    continue;
                }
                if (editor.getValue() != null && field.IsRange) {
                    sql.append(" AND ");
                    if (10 == field.displayType) {
                        sql.append(" lower( ").append(field.ColumnSQL).append(") >= ? ");
                        this.parameters.add(field.ColumnSQL);
                        this.parametersValues.add(editor.getValue().toString().toLowerCase());
                    } else {
                        sql.append(field.ColumnSQL).append(" >= ? ");
                        this.parameters.add(field.ColumnSQL);
                        this.parametersValues.add(editor.getValue());
                    }
                    onRange = true;
                    continue;
                }
                if (editor.getValue() != null || !field.IsRange) continue;
                onRange = true;
                continue;
            }
            if (editor.getValue() != null) {
                sql.append(" AND ");
                if (10 == field.displayType) {
                    sql.append(" lower( ").append(field.ColumnSQL).append(") <= ? ");
                    this.parameters.add(field.ColumnSQL);
                    this.parametersValues.add(editor.getValue().toString().toLowerCase());
                } else {
                    sql.append(field.ColumnSQL).append(" <= ? ");
                    this.parameters.add(field.ColumnSQL);
                    this.parametersValues.add(editor.getValue());
                }
                onRange = false;
                continue;
            }
            onRange = false;
        }
        this.whereClause = sql.toString();
        return sql.toString();
    }

    public void setParameters() {
        this.parametersValues = new ArrayList();
        this.parameters = new ArrayList();
        this.parametersField = new ArrayList();
        boolean onRange = false;
        for (Map.Entry<String, GridField> entry : this.getPanelParameters().entrySet()) {
            GridField editor = entry.getValue();
            GridFieldVO field = editor.getVO();
            if (!onRange) {
                if (editor.getValue() != null && !editor.getValue().toString().isEmpty() && !field.IsRange) {
                    this.parameters.add(field.ColumnNameAlias);
                    this.parametersValues.add(editor.getValue());
                    this.parametersField.add(field);
                    continue;
                }
                if (editor.getValue() == null || editor.getValue().toString().isEmpty() || !field.IsRange) continue;
                this.parameters.add(field.ColumnNameAlias);
                this.parametersValues.add(editor.getValue());
                this.parametersField.add(field);
                onRange = true;
                continue;
            }
            if (editor.getValue() == null || editor.getValue().toString().isEmpty()) continue;
            this.parameters.add(field.ColumnNameAlias);
            this.parametersValues.add(editor.getValue());
            this.parametersField.add(field);
            onRange = false;
        }
    }

    public Object getParameterValue(Object key) {
        GridField field = this.getPanelParameters().get(key);
        if (field != null) {
            return field.getValue();
        }
        return null;
    }

    protected void saveResultSelection(IBrowserTable browseTable) {
        if (this.keyColumnIndex == -1) {
            return;
        }
        if (this.isMultiSelection) {
            int rows = browseTable.getRowCount();
            BrowserRow browserRows = browseTable.getData();
            this.values = new LinkedHashMap();
            List<MBrowseField> fields = this.browserFields;
            for (int row = 0; row < rows; ++row) {
                IDColumn dataColumn;
                GridField selectedGridField = browserRows.getValue(row, this.keyColumnIndex);
                Object data = selectedGridField.getValue();
                if (!(data instanceof IDColumn) || !(dataColumn = (IDColumn)data).isSelected()) continue;
                LinkedHashMap<String, Object> selectedValues = new LinkedHashMap<String, Object>();
                for (MBrowseField field : fields) {
                    GridField gridField;
                    if (field.isReadOnly() && !field.isIdentifier() && !field.isKey() || (gridField = (GridField)browserRows.getValueOfColumn(row, field.getAD_View_Column().getColumnName())) == null) continue;
                    Object value = gridField.getValue();
                    if (value instanceof IDColumn) {
                        IDColumn id = (IDColumn)value;
                        value = id.getRecord_ID();
                    } else if (value instanceof Double) {
                        value = BigDecimal.valueOf((Double)value);
                    } else if (value instanceof Date) {
                        value = new Timestamp(((Date)value).getTime());
                    }
                    selectedValues.put(field.getColumnNameForSelection(), value);
                }
                if (selectedValues.size() <= 0) continue;
                this.values.put(dataColumn.getRecord_ID(), selectedValues);
            }
        }
    }

    public ArrayList<ArrayList<Object>> getDataRows(IBrowserTable browserTable) {
        ArrayList<ArrayList<Object>> rows = this.m_rows;
        if (this.isShowTotal()) {
            ArrayList<Object> row = new ArrayList<Object>(rows.size());
            BrowserRow data = browserTable.getData();
            int lastRow = browserTable.getRowCount() - 1;
            for (int column = 0; column < data.getColumnCount(); ++column) {
                GridField gridField = data.getValue(lastRow, column);
                Object value = null;
                if (gridField != null) {
                    value = gridField.getValue();
                }
                if (value == null) {
                    row.add(null);
                    continue;
                }
                row.add(value);
            }
            rows.add(row);
        }
        return rows;
    }

    protected void saveSelection(IBrowserTable browserTable) {
        if (browserTable == null) {
            return;
        }
        this.log.config("OK=" + this.m_ok);
        if (!this.m_ok) {
            this.m_results.clear();
            return;
        }
        if (this.isMultiSelection) {
            this.m_results.clear();
            this.m_results.addAll(this.getSelectedRowKeys(browserTable));
        } else {
            Integer data = this.getSelectedRowKey(browserTable);
            if (data != null) {
                this.m_results.add(data);
            }
        }
    }

    public void selectedRows(IBrowserTable browserTable) {
        int topIndex = browserTable.isShowTotals() ? 2 : 1;
        int rows = browserTable.getRowCount();
        if (this.isAllSelected) {
            for (int row = 0; row <= rows - topIndex; ++row) {
                Object data = browserTable.getValueAt(row, this.keyColumnIndex);
                if (!(data instanceof IDColumn)) continue;
                IDColumn dataColumn = (IDColumn)data;
                dataColumn.setSelected(true);
                browserTable.setValueAt(dataColumn, row, this.keyColumnIndex);
            }
        } else {
            for (int row = 0; row <= rows - topIndex; ++row) {
                Object data = browserTable.getValueAt(row, this.keyColumnIndex);
                if (!(data instanceof IDColumn)) continue;
                IDColumn dataColumn = (IDColumn)data;
                dataColumn.setSelected(false);
                browserTable.setValueAt(dataColumn, row, this.keyColumnIndex);
            }
        }
        this.isAllSelected = !this.isAllSelected;
    }

    public ArrayList<Integer> getSelectedRowKeys(IBrowserTable browseTable) {
        int row;
        ArrayList<Integer> selectedDataList = new ArrayList<Integer>();
        if (this.keyColumnIndex == -1) {
            return selectedDataList;
        }
        if (this.isMultiSelection) {
            int rows = browseTable.getRowCount();
            for (int row2 = 0; row2 < rows; ++row2) {
                IDColumn dataColumn;
                Object data = browseTable.getValueAt(row2, this.keyColumnIndex);
                if (!(data instanceof IDColumn) || !(dataColumn = (IDColumn)data).isSelected()) continue;
                selectedDataList.add(dataColumn.getRecord_ID());
            }
        }
        if (selectedDataList.size() == 0 && (row = browseTable.getSelectedRow()) != -1 && this.keyColumnIndex != -1) {
            Object data = browseTable.getValueAt(row, this.keyColumnIndex);
            if (data instanceof IDColumn) {
                selectedDataList.add(((IDColumn)data).getRecord_ID());
            }
            if (data instanceof Integer) {
                selectedDataList.add((Integer)data);
            }
        }
        return selectedDataList;
    }

    public void initBrowserTable(IBrowserTable table2) {
        table2.setRowCount(0);
        if (this.browserFields != null) {
            return;
        }
        this.initBrowserData();
        this.log.finest("Browse Fields #" + this.browserFields.size());
        this.prepareTable(table2);
    }

    private void prepareTable(IBrowserTable table2) {
        this.setContextWhere(null);
        String from = this.view.getFromClause();
        StringBuffer sql = new StringBuffer("SELECT DISTINCT ");
        sql.append(table2.prepareTable(this.browserFields, this.isMultiSelection));
        table2.setMultiSelection(this.isMultiSelection);
        table2.setShowTotals(this.browseModel.isShowTotal());
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ");
        this.m_sqlMain = sql.toString();
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE ";
        this.m_sqlOrderBy = this.getSQLOrderBy();
        if (this.keyColumnIndex == -1) {
            this.log.log(Level.WARNING, "No KeyColumn - " + sql);
        }
    }

    public void setProcessInfo(ProcessInfo pi) {
        this.processInfo = pi;
        if (this.processInfo != null && this.browsePI != null) {
            this.browsePI.setRecord_ID(this.processInfo.getRecord_ID());
            this.browsePI.setTable_ID(this.processInfo.getTable_ID());
        }
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public void setBrowseProcessInfo(ProcessInfo pi) {
        this.browsePI = pi;
    }

    public ProcessInfo getBrowseProcessInfo() {
        return this.browsePI;
    }

    public String getKeyColumn() {
        if (this.p_keyColumn == null || this.p_keyColumn.isEmpty()) {
            this.p_keyColumn = this.browseModel.getFieldKey().getAD_View_Column().getColumnName();
        }
        return this.p_keyColumn;
    }

    public Integer getSelectedRowKey(IBrowserTable browseTable) {
        ArrayList<Integer> selectedDataList = this.getSelectedRowKeys(browseTable);
        if (selectedDataList.size() == 0) {
            return null;
        }
        return selectedDataList.get(0);
    }

    public List<Integer> getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results;
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    protected int deleteSelection(IBrowserTable browseTable) {
        MTable table2 = this.getTable();
        if (table2 == null || table2.getAD_Table_ID() <= 0) {
            return 0;
        }
        int records = 0;
        for (int id : this.getSelectedRowKeys(browseTable)) {
            table2.getPO(id, null).deleteEx(true);
            ++records;
        }
        return records;
    }

    private MTable getTable() {
        MTable table2 = MTable.get(this.browseModel.getCtx(), this.browseModel.getAD_Table_ID());
        if (table2 != null && table2.getAD_Table_ID() > 0) {
            return table2;
        }
        MBrowseField fieldKey = this.browseModel.getFieldKey();
        if (fieldKey != null && fieldKey.getAD_View_Column().getAD_Column_ID() > 0) {
            table2 = (MTable)fieldKey.getAD_View_Column().getAD_Column().getAD_Table();
        }
        return table2;
    }

    protected int updateSelection(IBrowserTable browseTable) {
        MTable table2 = this.getTable();
        if (table2 == null || table2.getAD_Table_ID() <= 0) {
            return 0;
        }
        int records = 0;
        List<MColumn> columns = table2.getColumnsAsList();
        ArrayList<ValueNamePair> converter = new ArrayList<ValueNamePair>();
        block0: for (MBrowseField mBrowseField : this.browseModel.getDisplayFields()) {
            if (mBrowseField.isKey() || mBrowseField.isReadOnly() || mBrowseField.getAD_Element_ID() == 0) continue;
            for (MColumn column : columns) {
                if (column.getAD_Element_ID() != mBrowseField.getAD_Element_ID()) continue;
                converter.add(new ValueNamePair(mBrowseField.getAD_View_Column().getColumnName(), column.getColumnName()));
                continue block0;
            }
        }
        if (converter.size() == 0) {
            return 0;
        }
        this.saveResultSelection(browseTable);
        for (Map.Entry entry : this.getSelectedValues().entrySet()) {
            PO model = table2.getPO((Integer)entry.getKey(), null);
            for (ValueNamePair columnName : converter) {
                model.set_ValueOfColumn(columnName.getName(), ((LinkedHashMap)entry.getValue()).get(columnName.getValue()));
            }
            model.saveEx();
            ++records;
        }
        return records;
    }

    protected boolean isSelectedByDefault() {
        return this.browseModel.isSelectedByDefault();
    }

    protected boolean isExecuteQueryByDefault() {
        return this.browseModel.isExecutedQueryByDefault();
    }

    protected boolean isCollapsibleByDefault() {
        return this.browseModel.isCollapsibleByDefault();
    }

    protected boolean isDeleteable() {
        return this.browseModel.isDeleteable();
    }

    protected boolean isUpdateable() {
        return this.browseModel.isUpdateable();
    }

    protected boolean isShowTotal() {
        return this.browseModel.isShowTotal();
    }

    protected int getAD_Window_ID() {
        return this.browseModel.getAD_Window_ID();
    }

    public int getAD_Browse_ID() {
        return this.browseModel.getAD_Browse_ID();
    }

    public List<MBrowseField> getInfoColumnForAxisField(MBrowseField field) {
        ArrayList<MBrowseField> list = new ArrayList<MBrowseField>();
        this.axisParameters = new ArrayList();
        this.axisParametersValues = new ArrayList();
        try {
            MViewColumn xcol = field.getAD_View_Column();
            I_AD_View_Column pcol = field.getAxis_Parent_Column();
            I_AD_View_Column ycol = field.getAxis_Column();
            String columnName = xcol.getAD_Column().getColumnName();
            Optional<MBrowseField> maybeField = this.browseModel.getFields().stream().filter(fieldToFind -> fieldToFind.getAD_View_Column_ID() == ycol.getAD_View_Column_ID()).findFirst();
            if (maybeField.isPresent()) {
                MBrowseField yField = maybeField.get();
                MBrowseField fieldKey = this.getFieldKey();
                String yColumnName = null;
                int yReferenceId = 0;
                int yReferenceValueId = 0;
                if (ycol.getAD_Column_ID() > 0) {
                    MColumn column = MColumn.get(field.getCtx(), ycol.getAD_Column_ID());
                    yColumnName = column.getColumnName();
                    yReferenceId = column.getAD_Reference_ID();
                    yReferenceValueId = column.getAD_Reference_Value_ID();
                } else {
                    yColumnName = yField.getAD_Element().getColumnName();
                    yReferenceId = yField.getAD_Reference_ID();
                    yReferenceValueId = yField.getAD_Reference_Value_ID();
                }
                if (fieldKey == null) {
                    throw new AdempiereException("@NotFound@ @IsKey@");
                }
                MTable xTable = MTable.get(field.getCtx(), ycol.getAD_View_Definition().getAD_Table_ID());
                String xTableName = xTable.getTableName();
                String keyColumn = MQuery.getZoomColumnName(columnName);
                String tableName = MQuery.getZoomTableName(columnName);
                String whereClause = "";
                if (pcol != null && pcol.getAD_View_Column_ID() > 0) {
                    MTable parentTable = MTable.get(field.getCtx(), tableName);
                    MColumn parentColumn = this.getParentColumn(parentTable.getAD_Table_ID());
                    if (parentColumn == null) {
                        throw new AdempiereException("@NotFound@ @IsParent@");
                    }
                    if (field.getAD_Val_Rule_ID() > 0) {
                        whereClause = Env.parseContext(Env.getCtx(), this.getWindowNo(), field.getAD_Val_Rule().getCode(), false);
                    }
                }
                MLookup lookup = MLookupFactory.get(Env.getCtx(), 0, xcol.getAD_Column_ID(), field.getAD_Reference_ID(), this.m_language, keyColumn, field.getAD_Reference_Value_ID(), false, whereClause);
                String axisColumnName = ycol.getColumnSQL();
                if (Util.isEmpty(axisColumnName)) {
                    axisColumnName = yColumnName;
                }
                StringBuilder axisSql = new StringBuilder(axisColumnName);
                boolean isSQLAgregate = false;
                if (DisplayType.isNumeric(yReferenceId)) {
                    isSQLAgregate = !isSQLAgregate;
                    axisColumnName = axisColumnName.replaceAll(ycol.getAD_View_Definition().getTableAlias(), ycol.getAD_View_Definition().getAD_Table().getTableName());
                    axisSql = new StringBuilder("(SELECT ");
                    axisSql.append("SUM(").append(axisColumnName).append(") FROM  ").append(ycol.getAD_View_Definition().getAD_Table().getTableName()).append(" WHERE ").append(xTableName).append(".").append(fieldKey.getAD_View_Column().getAD_Column().getColumnName()).append("=").append(fieldKey.getAD_View_Column().getColumnSQL());
                }
                for (int recordId : this.getAxisRecordIds(tableName, whereClause)) {
                    String display = lookup.getDisplay(recordId).trim();
                    String colName = "";
                    String sqlColName = "";
                    if (isSQLAgregate) {
                        colName = display + "/" + Msg.translate(this.m_language, yColumnName);
                        String joinColumn = Msg.translate(this.m_language, yColumnName);
                        sqlColName = display + "/" + joinColumn;
                    } else {
                        colName = display;
                        sqlColName = display;
                    }
                    StringBuffer select = new StringBuffer(axisSql);
                    if (isSQLAgregate) {
                        StringBuilder axisWhere = new StringBuilder(" ");
                        axisWhere.append(this.getAxisSQLWhere(ycol)).append(" AND ").append(xcol.getAD_View_Definition().getTableAlias()).append(".").append(xcol.getAD_Column().getColumnName());
                        select = new StringBuffer();
                        select.append((CharSequence)axisSql).append((CharSequence)axisWhere);
                        select.append("=").append(recordId).append(")");
                    }
                    MViewColumn viewColumn = new MViewColumn(field.getCtx(), 0, field.get_TrxName());
                    MViewColumn.copyValues((MViewColumn)ycol, viewColumn);
                    viewColumn.setAD_View_Column_ID(ycol.getAD_View_Column_ID());
                    if (ycol.getAD_Column_ID() > 0) {
                        viewColumn.setAD_Column_ID(ycol.getAD_Column_ID());
                    }
                    viewColumn.setColumnSQL(select.toString().replaceAll("@Axis_Record_ID@", "" + recordId));
                    viewColumn.setColumnName("\"" + sqlColName + "\"");
                    MBrowseField browseField = new MBrowseField((MBrowse)field.getAD_Browse(), viewColumn);
                    browseField.setAD_Browse_ID(field.getAD_Browse_ID());
                    browseField.setAD_Element_ID(field.getAD_Element_ID());
                    browseField.setName(colName);
                    browseField.setDescription(viewColumn.getDescription());
                    browseField.setHelp(viewColumn.getHelp());
                    if (viewColumn.get_ID() > 0) {
                        browseField.setAD_View_Column_ID(viewColumn.getAD_View_Column_ID());
                    }
                    browseField.setIsActive(true);
                    browseField.setIsIdentifier(field.isIdentifier());
                    browseField.setIsRange(false);
                    browseField.setIsQueryCriteria(false);
                    browseField.setAD_Reference_ID(yReferenceId);
                    browseField.setAD_Reference_Value_ID(yReferenceValueId);
                    browseField.setIsKey(false);
                    browseField.setIsDisplayed(true);
                    browseField.setAxis_Column_ID(field.getAxis_Column_ID());
                    browseField.setAxis_Parent_Column_ID(field.getAxis_Parent_Column_ID());
                    browseField.setIsReadOnly(field.isReadOnly());
                    browseField.setAD_Element_ID(field.getAD_Element_ID());
                    browseField.setColumnNameForSelection(yColumnName + "_" + recordId);
                    list.add(browseField);
                    this.log.finest("Added Column=" + sqlColName + " SQL = " + select);
                }
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return list;
    }

    private int[] getAxisRecordIds(String tableName, String tableWhereClause) {
        StringBuilder whereClause = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM AD_Table t WHERE t.TableName=? AND t.AD_Table_ID=AD_Column.AD_Table_ID) AND ");
        whereClause.append("IsIdentifier").append("=?");
        List columns = new Query(Env.getCtx(), "AD_Column", whereClause.toString(), null).setOnlyActiveRecords(true).setParameters(tableName, true).setOrderBy("SeqNo").list();
        int count = 1;
        for (MColumn column : columns) {
            orderBy.append(column.getColumnName());
            if (count != columns.size()) {
                orderBy.append(",");
            }
            ++count;
        }
        return new Query(Env.getCtx(), tableName, tableWhereClause, null).setOnlyActiveRecords(true).setOrderBy(orderBy.toString()).getIDs();
    }

    private MColumn getParentColumn(int AD_Table_ID) {
        String whereClause = "AD_Table_ID=? AND IsParent=? ";
        return (MColumn)new Query(Env.getCtx(), "AD_Column", whereClause, null).setParameters(AD_Table_ID, true).first();
    }

    public MBrowseField getFieldKey() {
        MBrowseField fieldKey = this.browseModel.getFieldKey();
        return fieldKey;
    }

    public boolean IsIdentifierSelection(String columnName) {
        for (MBrowseField field : this.browseModel.getIdentifierFields()) {
            if (!field.getAD_View_Column().getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public MQuery getMQuery(IBrowserTable browseTable) {
        ArrayList<Integer> ids = this.getSelectedRowKeys(browseTable);
        String inClause = " IN" + ((Object)ids).toString().replace('[', '(').replace(']', ')');
        Integer record_ID = this.getSelectedRowKey(browseTable);
        if (record_ID == null) {
            return null;
        }
        MBrowseField fieldKey = this.getFieldKey();
        if (fieldKey == null) {
            return null;
        }
        MColumn column = fieldKey.getAD_View_Column().getAD_Column();
        String keyColumn = MQuery.getZoomColumnName(column.getColumnName());
        String tableName = column.getAD_Table().getTableName();
        MQuery query = new MQuery(tableName);
        query.addRestriction(keyColumn + inClause);
        return query;
    }

    public abstract LinkedHashMap<String, GridField> getPanelParameters();

    public abstract void init();

    public String getAxisSQLWhere(I_AD_View_Column viewColumn) {
        MViewDefinition viewDefinition = (MViewDefinition)viewColumn.getAD_View_Definition();
        MTable tableBaseName = viewDefinition.getAD_Table();
        StringBuilder whereAxis = new StringBuilder();
        boolean onRange = false;
        this.setParameters();
        for (int i2 = 0; i2 < this.parametersField.size(); ++i2) {
            String fieldName = "";
            MColumn column = tableBaseName.getColumn(this.parametersField.get((int)i2).ColumnName);
            if (column == null) continue;
            fieldName = tableBaseName.getTableName() + "." + column.getColumnName();
            if (!onRange) {
                if (this.parametersValues.get(i2) != null && !this.parametersValues.get(i2).toString().isEmpty() && !this.parametersField.get((int)i2).IsRange) {
                    whereAxis.append(" AND ");
                    whereAxis.append(fieldName).append("=").append(this.parametersValues.get(i2).toString());
                    continue;
                }
                if (this.parametersValues.get(i2) == null || this.parametersValues.get(i2).toString().isEmpty() || !this.parametersField.get((int)i2).IsRange) continue;
                whereAxis.append(" AND ");
                whereAxis.append(fieldName).append(" >= ? ");
                this.axisParameters.add(this.parametersField.get(i2));
                this.axisParametersValues.add(this.parametersValues.get(i2));
                onRange = true;
                continue;
            }
            if (this.parametersValues.get(i2) == null || this.parametersValues.get(i2).toString().isEmpty()) continue;
            whereAxis.append(" AND ");
            whereAxis.append(fieldName).append(" <= ? ");
            this.axisParameters.add(this.parametersField.get(i2));
            this.axisParametersValues.add(this.parametersValues.get(i2));
            onRange = false;
        }
        return whereAxis.toString();
    }

    protected String getSQL() {
        String dynWhere = this.getSQLWhere(false);
        StringBuilder sql = new StringBuilder(this.m_sqlMain);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        String dataSql = Env.parseContext(Env.getCtx(), this.getWindowNo(), sql.toString(), true, true);
        dataSql = MRole.getDefault().addAccessSQL(dataSql, this.view.getParentEntityAliasName(), true, false);
        dataSql = dataSql + this.m_sqlOrderBy;
        this.log.finer(dataSql);
        return dataSql;
    }

    public String getSQLOrderBy() {
        StringBuilder sqlOrderBy = new StringBuilder();
        for (MBrowseField field : this.browseModel.getOrderByFields()) {
            int orderByPosition;
            if (!field.isOrderBy() || (orderByPosition = this.getOrderByPosition(field)) <= 0) continue;
            if (sqlOrderBy.length() > 0) {
                sqlOrderBy.append(",");
            }
            sqlOrderBy.append(orderByPosition);
        }
        return sqlOrderBy.length() > 0 ? " ORDER BY " + sqlOrderBy.toString() : "";
    }

    private int getOrderByPosition(MBrowseField BrowserField) {
        int colOffset = 1;
        int col = 0;
        for (MBrowseField field : this.browserFields) {
            int sortBySqlNo = col + colOffset;
            if (BrowserField.getAD_Browse_Field_ID() == field.getAD_Browse_Field_ID()) {
                return sortBySqlNo;
            }
            ++col;
        }
        return -1;
    }

    protected PreparedStatement getStatement(String sql) {
        CPreparedStatement stmt = null;
        ArrayList<Object> parametersValue = new ArrayList<Object>();
        if (this.getAxisParametersValues() != null && this.getAxisParametersValues().size() > 0) {
            parametersValue.addAll(this.getAxisParametersValues());
        }
        if (this.getParametersValues() != null && this.getParametersValues().size() > 0) {
            parametersValue.addAll(this.getParametersValues());
        }
        try {
            stmt = DB.prepareStatement(sql, null);
            if (parametersValue.size() > 0) {
                DB.setParameters((PreparedStatement)stmt, parametersValue);
            }
            return stmt;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return stmt;
        }
    }

    protected File exportXLS(IBrowserTable browserTable) {
        File file = null;
        try {
            if (this.m_exporter != null && this.m_exporter.isAlive()) {
                return file;
            }
            this.m_exporter = new Exporter();
            this.m_exporter.start();
            while (this.m_exporter.isAlive()) {
            }
            ArrayList<ArrayList<Object>> rows = this.getDataRows(browserTable);
            if (rows.size() > 0) {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = this.makePrefix(this.browseModel.getName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                file = File.createTempFile(prefix, ".xls", new File(path));
                ArrayExcelExporter exporter = new ArrayExcelExporter(Env.getCtx(), rows, true);
                exporter.export(file, this.m_language, false);
            }
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "", e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return file;
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuffer prefix = new StringBuffer();
        for (char ch : nameArray = name.toCharArray()) {
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
                continue;
            }
            prefix.append("_");
        }
        return prefix.toString();
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public int getParentWindowNo() {
        return this.parentWindowNo;
    }

    public LinkedHashMap<Integer, LinkedHashMap<String, Object>> getSelectedValues() {
        return this.values;
    }

    class Exporter
    extends Thread {
        private PreparedStatement pstmt = null;
        private ResultSet resultSet = null;
        private String dataSql = null;

        Exporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            int no = 0;
            this.dataSql = Browser.this.getSQL();
            this.pstmt = Browser.this.getStatement(this.dataSql);
            Browser.this.m_rows = new ArrayList();
            try {
                Browser.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                this.resultSet = this.pstmt.executeQuery();
                Browser.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                boolean isFirstRow = true;
                while (this.resultSet.next()) {
                    if (this.isInterrupted()) {
                        Browser.this.log.finer("Interrupted");
                        this.close();
                        return;
                    }
                    ++no;
                    ArrayList<String> header = isFirstRow ? new ArrayList<String>() : null;
                    ArrayList<IDColumn> row = new ArrayList<IDColumn>();
                    int colOffset = 1;
                    int col = 0;
                    for (MBrowseField field : Browser.this.browserFields) {
                        if (isFirstRow) {
                            String columnName = field.getName();
                            header.add(columnName);
                        }
                        Object data = null;
                        int colIndex = col + colOffset;
                        data = field.isKey() && (DisplayType.isID(field.getAD_Reference_ID()) || 11 == field.getAD_Reference_ID()) ? new IDColumn(this.resultSet.getInt(colIndex)) : (field.isKey() && (field.getName().equals(field.getAD_View_Column().getColumnSQL().equals("'Row' AS \"Row\"")) || !DisplayType.isID(field.getAD_Reference_ID()) && 11 != field.getAD_Reference_ID()) ? new IDColumn(no) : (20 == field.getAD_Reference_ID() ? new Boolean("Y".equals(this.resultSet.getString(colIndex))) : (DisplayType.isDate(field.getAD_Reference_ID()) ? this.resultSet.getTimestamp(colIndex) : (DisplayType.isID(field.getAD_Reference_ID()) || 11 == field.getAD_Reference_ID() ? new Integer(this.resultSet.getInt(colIndex)) : (DisplayType.isNumeric(field.getAD_Reference_ID()) ? this.resultSet.getBigDecimal(colIndex) : this.resultSet.getString(colIndex))))));
                        row.add((IDColumn)data);
                        ++col;
                    }
                    if (isFirstRow) {
                        Browser.this.m_rows.add(header);
                    }
                    Browser.this.m_rows.add(row);
                    isFirstRow = false;
                }
            }
            catch (Throwable e) {
                Browser.this.log.log(Level.SEVERE, this.dataSql, e);
            }
            finally {
                this.close();
            }
            Browser.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            if (no == 0) {
                Browser.this.log.fine(this.dataSql);
            }
        }

        private void close() {
            DB.close(this.resultSet, this.pstmt);
            this.resultSet = null;
            this.pstmt = null;
        }
    }
}

