/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom.action;

import java.awt.event.ActionEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.util.Env;
import org.eevolution.form.action.PopupAction;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;

public class MergeBOMAction
extends PopupAction {
    public static final String COMMAND = "mergeBOM";
    protected JTree tree;
    protected boolean actionResult;

    public MergeBOMAction(JTree tree) {
        super(COMMAND);
        this.setActionCommand(COMMAND);
        this.tree = tree;
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }

    @Override
    protected boolean successful() {
        return this.actionResult;
    }

    @Override
    protected String validateAction() {
        return null;
    }

    @Override
    protected void doAction(ActionEvent e) {
        if (this.tree != null) {
            this.mergeBOMFrom((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent());
        }
    }

    private void mergeBOMFrom(DefaultMutableTreeNode node) {
        BOMWrapper sourceBOM = (BOMWrapper)node.getUserObject();
        MPPProductBOM targetBOM = new MPPProductBOM(Env.getCtx(), 0, null);
        targetBOM.setBOMType(sourceBOM.getBOMType());
        targetBOM.setDescription(sourceBOM.getDescription());
        targetBOM.setM_AttributeSetInstance_ID(sourceBOM.getM_AttributeSetInstance_ID());
        targetBOM.setM_Product_ID(sourceBOM.getM_Product_ID());
        targetBOM.setName(sourceBOM.getName());
        targetBOM.setRevision(sourceBOM.getRevision());
        targetBOM.setValidFrom(sourceBOM.getValidFrom());
        targetBOM.setValidTo(sourceBOM.getValidTo());
        targetBOM.setValue(sourceBOM.getValue());
        targetBOM.setDocumentNo(sourceBOM.getDocumentNo());
        targetBOM.setC_UOM_ID(sourceBOM.getC_UOM_ID());
        this.actionResult = targetBOM.save();
        if (this.successful()) {
            this.mergeInDepth(targetBOM.get_ID(), node);
        }
    }

    private void mergeInDepth(int bomId, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            node = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (node.isLeaf()) {
                this.createBOMLine(bomId, node);
            } else {
                this.mergeInDepth(bomId, node);
            }
            if (!this.successful()) break;
        }
    }

    private void createBOMLine(int bomId, DefaultMutableTreeNode node) {
        BOMLineWrapper sourceLine = (BOMLineWrapper)node.getUserObject();
        MPPProductBOMLine targetLine = new MPPProductBOMLine(Env.getCtx(), 0, null);
        targetLine.setPP_Product_BOM_ID(bomId);
        targetLine.setHelp(sourceLine.getHelp());
        targetLine.setM_ChangeNotice_ID(sourceLine.getM_ChangeNotice_ID());
        targetLine.setAssay(sourceLine.getAssay());
        targetLine.setQtyBatch(sourceLine.getQtyBatch());
        targetLine.setQtyBOM(sourceLine.getQtyBOM());
        targetLine.setIsQtyPercentage(sourceLine.isQtyPercentage());
        targetLine.setComponentType(sourceLine.getComponentType());
        targetLine.setC_UOM_ID(sourceLine.getC_UOM_ID());
        targetLine.setForecast(sourceLine.getForecast());
        targetLine.setIsCritical(sourceLine.isCritical());
        targetLine.setIssueMethod(sourceLine.getIssueMethod());
        targetLine.setLine(sourceLine.getLine());
        targetLine.setLeadTimeOffset(sourceLine.getLeadTimeOffset());
        targetLine.setM_AttributeSetInstance_ID(sourceLine.getM_AttributeSetInstance_ID());
        targetLine.setM_Product_ID(sourceLine.getM_Product_ID());
        targetLine.setScrap(sourceLine.getScrap());
        targetLine.setValidFrom(sourceLine.getValidFrom());
        targetLine.setValidTo(sourceLine.getValidTo());
        this.actionResult = targetLine.save();
    }
}

