/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom.action;

import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.apps.search.PAttributeInstance;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.action.ProcessPopupAction;
import org.eevolution.model.wrapper.BOMLineWrapper;

public class ChangeASIAction
extends ProcessPopupAction {
    public static final String COMMAND = "changeASI";
    public static final int PROCESS_ID = 1000102;
    protected JTree tree;

    public ChangeASIAction(JTree tree, JFrame window) {
        super(COMMAND, window);
        this.tree = tree;
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }

    @Override
    protected int getProcessID() {
        return 1000102;
    }

    @Override
    protected String validateAction() {
        String validate = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        BOMLineWrapper line = null;
        if (!(node.getUserObject() instanceof BOMLineWrapper)) {
            validate = "'" + node.getUserObject().getClass().getName() + "' isn't a type of 'BOMLineWrapper'(ClassCastException)";
        } else {
            line = (BOMLineWrapper)node.getUserObject();
            MProduct p = new MProduct(Env.getCtx(), line.getM_Product_ID(), null);
            if (p.getM_AttributeSet_ID() == 0) {
                validate = Msg.getMsg(Env.getCtx(), "PAttributeNoAttributeSet");
            }
        }
        return validate;
    }

    @Override
    protected void doProcess() {
        if (this.tree != null) {
            this.changeASI((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent());
        }
    }

    private void changeBOMLine(BOMLineWrapper line, MProduct p, MAttributeSetInstance asi) {
        line.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        this.savePO(line.get());
    }

    private void changeASI(DefaultMutableTreeNode node) {
        BOMLineWrapper line = (BOMLineWrapper)node.getUserObject();
        int selectedASI = this.selectASIID(line);
        if (selectedASI == -1) {
            this.setIgnoreChange(true);
            return;
        }
        MAttributeSetInstance asi = new MAttributeSetInstance(Env.getCtx(), selectedASI, null);
        MProduct p = new MProduct(Env.getCtx(), line.getM_Product_ID(), null);
        this.changeBOMLine(line, p, asi);
    }

    private int selectASIID(BOMLineWrapper line) {
        if (line.getM_Product_ID() <= 0) {
            return -1;
        }
        MProduct p = new MProduct(Env.getCtx(), line.getM_Product_ID(), null);
        PAttributeInstance pai = new PAttributeInstance((JFrame)null, p.getName(), this.getParameterValueAsInt("M_Warehouse_ID"), 0, line.getM_Product_ID(), 0);
        return pai.getM_AttributeSetInstance_ID();
    }
}

