/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Box;
import org.adempiere.controller.SmallViewEditable;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.model.GridField;
import org.compiere.swing.CEditor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.eevolution.grid.BrowserSearch;

public class VBrowserSearch
extends BrowserSearch
implements SmallViewEditable {
    private int cols = 0;
    private int row = 0;
    private ArrayList<CLabel> m_separators;
    private BorderLayout mainLayout;
    private ALayout centerLayout;
    private CPanel centerPanel;
    private CPanel mainPanel;
    private static CLogger log = CLogger.getCLogger(VBrowserSearch.class);

    public VBrowserSearch(int WindowNo, int p_AD_Browse_ID) {
        super(WindowNo, p_AD_Browse_ID);
    }

    public VBrowserSearch(int WindowNo, int p_AD_Browse_ID, int column) {
        super(WindowNo, p_AD_Browse_ID, column);
    }

    @Override
    public void initComponents() {
        if (this.mainPanel != null) {
            return;
        }
        this.mainLayout = new BorderLayout();
        this.centerPanel = new CPanel();
        this.mainPanel = new CPanel();
        this.m_separators = new ArrayList();
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.centerLayout = new ALayout();
        this.centerPanel.setLayout(this.centerLayout);
    }

    public CPanel getPanel() {
        return this.mainPanel;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mainPanel.removeAll();
    }

    @Override
    public CEditor createEditor(GridField field) {
        return VEditorFactory.getEditor(field, false);
    }

    @Override
    public void formatEditor(CEditor editor1, CEditor editor2) {
        log.fine("");
        VEditor editor = (VEditor)editor1;
        VEditor editorTo = (VEditor)editor2;
        if (editor == null) {
            return;
        }
        this.configColumns(editor, editorTo);
        CLabel label2 = VEditorFactory.getLabel(editor.getField());
        if (label2 == null) {
            this.centerPanel.add(Box.createHorizontalStrut(12), new ALayoutConstraint(this.row, this.cols++));
        } else {
            this.centerPanel.add((Component)label2, new ALayoutConstraint(this.row, this.cols++));
        }
        this.centerPanel.add((Component)((Object)editor), new ALayoutConstraint(this.row, this.cols++));
        if (editorTo == null) {
            this.m_separators.add(null);
            return;
        }
        CLabel dash = new CLabel(" - ");
        this.centerPanel.add((Component)dash, new ALayoutConstraint(this.row, this.cols++));
        this.m_separators.add(dash);
        this.centerPanel.add((Component)((Object)editorTo), new ALayoutConstraint(this.row, this.cols++));
    }

    private void configColumns(VEditor editor, VEditor editorTo) {
        int maxToAdd = this.getColumns() * 2;
        int columnsToAdd = this.getColumns();
        if (editorTo != null) {
            columnsToAdd += 2;
        }
        if (this.cols + columnsToAdd > maxToAdd) {
            this.cols = 0;
            ++this.row;
        }
    }

    @Override
    public void setComponentVisibility(int index, Boolean visible, Boolean isRange) {
        Component[] components;
        VEditor editor = (VEditor)this.getEditor(index);
        VEditor editorTo = (VEditor)this.getEditorTo(index);
        if (editor == null) {
            return;
        }
        for (Component comp : components = this.centerPanel.getComponents()) {
            if (!editor.getField().getColumnName().equals(comp.getName())) continue;
            if (visible.booleanValue()) {
                if (comp.isVisible()) continue;
                comp.setVisible(true);
                if (!isRange.booleanValue() || editorTo == null) continue;
                editorTo.setVisible(true);
                this.m_separators.get(index).setText(" - ");
                continue;
            }
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            if (!isRange.booleanValue() || editorTo == null) continue;
            editorTo.setVisible(false);
            this.m_separators.get(index).setText("");
        }
    }
}

