/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.engine.freight;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.TreeSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_Shipper;
import org.compiere.util.CLogger;
import org.eevolution.engine.freight.FreightRule;
import org.eevolution.engine.freight.FreightRuleInterface;

public class FreightEngine {
    static final String packageName = "org.eevolution.engine.freight";
    private static FreightEngine instanceFreightEngine;
    private static TreeSet<String> freightRuleNoImplement;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private HashMap<String, FreightRuleInterface> freightRules = new HashMap();

    public FreightEngine() {
        this.registerRules(true);
    }

    public static FreightEngine get() {
        if (instanceFreightEngine == null) {
            instanceFreightEngine = new FreightEngine();
        }
        return instanceFreightEngine;
    }

    protected void registerRules(boolean bl) {
        if (bl) {
            this.freightRules.clear();
        }
        this.getFreightRuleFactory(null, "C");
        this.getFreightRuleFactory(null, "I");
        this.getFreightRuleFactory(null, "L");
    }

    public String getPackageName() {
        return packageName;
    }

    protected <T extends FreightRuleInterface> Class<T> getClass(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public FreightRuleInterface getFreightRuleFactory(I_M_Shipper i_M_Shipper, String string) {
        String string2 = "";
        Boolean bl = i_M_Shipper != null && i_M_Shipper.getCalculationClass() == null || i_M_Shipper == null;
        if (bl.booleanValue()) {
            string2 = this.getPackageName() + "." + FreightRule.class.getSimpleName();
        } else if (i_M_Shipper.getCalculationClass() != null) {
            string2 = i_M_Shipper.getCalculationClass();
        }
        if (this.freightRules.containsKey(string2)) {
            return this.freightRules.get(string2);
        }
        try {
            Class clazz = this.getClass(string2);
            Constructor constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception exception) {
                this.log.fine("Freight Not Found");
            }
            if (constructor != null) {
                FreightRuleInterface freightRuleInterface = (FreightRuleInterface)constructor.newInstance(new Object[0]);
                this.freightRules.put(string2, freightRuleInterface);
                return freightRuleInterface;
            }
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            FreightRuleInterface freightRuleInterface = (FreightRuleInterface)constructor.newInstance(new Object[0]);
            this.freightRules.put(string2, freightRuleInterface);
            return freightRuleInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            freightRuleNoImplement.add(string2);
            throw new AdempiereException("@CalculationClass@ @NotFound@ " + classNotFoundException);
        }
        catch (Throwable throwable) {
            throw new AdempiereException(throwable);
        }
    }

    static {
        freightRuleNoImplement = new TreeSet();
    }
}

