/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.compiere.util.SecureInterface;

public class Secure
implements SecureInterface {
    private Cipher m_cipher = null;
    private SecretKey m_key = null;
    private MessageDigest m_md = null;
    private static Logger log = Logger.getLogger(Secure.class.getName());

    public static int hash(String key) {
        long tableSize = Integer.MAX_VALUE;
        long hashValue = 0L;
        for (int i2 = 0; i2 < key.length(); ++i2) {
            hashValue = 37L * hashValue + (long)(key.charAt(i2) - 31);
        }
        if ((hashValue %= tableSize) < 0L) {
            hashValue += tableSize;
        }
        int retValue = (int)hashValue;
        return retValue;
    }

    public static String convertToHexString(byte[] bytes) {
        int size = bytes.length;
        StringBuffer buffer = new StringBuffer(size * 2);
        for (int i2 = 0; i2 < size; ++i2) {
            String tmp;
            int x = bytes[i2];
            if (x < 0) {
                x += 256;
            }
            if ((tmp = Integer.toHexString(x)).length() == 1) {
                buffer.append("0");
            }
            buffer.append(tmp);
        }
        return buffer.toString();
    }

    public static byte[] convertHexString(String hexString) {
        if (hexString == null || hexString.length() == 0) {
            return null;
        }
        int size = hexString.length() / 2;
        byte[] retValue = new byte[size];
        String inString = hexString.toLowerCase();
        try {
            for (int i2 = 0; i2 < size; ++i2) {
                int index = i2 * 2;
                int ii = Integer.parseInt(inString.substring(index, index + 2), 16);
                retValue[i2] = (byte)ii;
            }
            return retValue;
        }
        catch (Exception e) {
            log.finest(hexString + " - " + e.getLocalizedMessage());
            return null;
        }
    }

    public Secure() {
        this.initCipher();
    }

    private synchronized void initCipher() {
        if (this.m_cipher != null) {
            return;
        }
        Cipher cc = null;
        try {
            cc = Cipher.getInstance("DES/ECB/PKCS5Padding");
            this.m_key = new SecretKeySpec(new byte[]{100, 25, 28, -122, -26, 94, -3, -26}, "DES");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        this.m_cipher = cc;
    }

    @Override
    public String encrypt(String value) {
        String clearText = value;
        if (clearText == null) {
            clearText = "";
        }
        if (this.m_cipher == null) {
            this.initCipher();
        }
        if (this.m_cipher != null) {
            try {
                this.m_cipher.init(1, this.m_key);
                byte[] encBytes = this.m_cipher.doFinal(clearText.getBytes("UTF8"));
                String encString = Secure.convertToHexString(encBytes);
                return encString;
            }
            catch (Exception ex) {
                log.log(Level.INFO, "Problem encrypting string", ex);
            }
        }
        return "xyz" + value + "";
    }

    @Override
    public String decrypt(String value) {
        byte[] data;
        boolean isEncrypted;
        if (value == null || value.length() == 0) {
            return value;
        }
        boolean bl = isEncrypted = value.startsWith("~") && value.endsWith("~");
        if (isEncrypted) {
            value = value.substring("~".length(), value.length() - "~".length());
        }
        if ((data = Secure.convertHexString(value)) == null) {
            if (isEncrypted) {
                log.info("Failed");
                return null;
            }
            return value;
        }
        if (this.m_cipher == null) {
            this.initCipher();
        }
        if (this.m_cipher != null && value != null && value.length() > 0) {
            try {
                AlgorithmParameters ap = this.m_cipher.getParameters();
                this.m_cipher.init(2, (Key)this.m_key, ap);
                byte[] out = this.m_cipher.doFinal(data);
                String retValue = new String(out, "UTF8");
                return retValue;
            }
            catch (Exception ex) {
                log.info("Failed decrypting " + ex.toString());
            }
        }
        return null;
    }

    @Override
    public Integer encrypt(Integer value) {
        return value;
    }

    @Override
    public Integer decrypt(Integer value) {
        return value;
    }

    @Override
    public BigDecimal encrypt(BigDecimal value) {
        return value;
    }

    @Override
    public BigDecimal decrypt(BigDecimal value) {
        return value;
    }

    @Override
    public Timestamp encrypt(Timestamp value) {
        return value;
    }

    @Override
    public Timestamp decrypt(Timestamp value) {
        return value;
    }

    @Override
    public String getDigest(String value) {
        if (this.m_md == null) {
            try {
                this.m_md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                nsae.printStackTrace();
            }
        }
        this.m_md.reset();
        byte[] input2 = value.getBytes();
        this.m_md.update(input2);
        byte[] output = this.m_md.digest();
        this.m_md.reset();
        return Secure.convertToHexString(output);
    }

    @Override
    public String getSHA512Hash(int iterations, String value, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-512");
        digest.reset();
        digest.update(salt);
        byte[] input2 = digest.digest(value.getBytes("UTF-8"));
        for (int i2 = 0; i2 < iterations; ++i2) {
            digest.reset();
            input2 = digest.digest(input2);
        }
        digest.reset();
        return Secure.convertToHexString(input2);
    }

    @Override
    public boolean isDigest(String value) {
        if (value == null || value.length() != 32) {
            return false;
        }
        return Secure.convertHexString(value) != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Secure[");
        sb.append(this.m_cipher).append("]");
        return sb.toString();
    }
}

