/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileWriter;
import java.sql.Timestamp;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;
import org.compiere.util.Ini;

public class CLogFile
extends Handler {
    private static CLogFile s_logFile = null;
    private String m_adempiereHome = null;
    private boolean m_doneHeader = false;
    private File m_file = null;
    private FileWriter m_writer = null;
    private String m_fileNameDate = "";
    private int m_records = 0;

    public static CLogFile get(boolean create, String adempiereHome, boolean isClient) {
        if (s_logFile == null && create) {
            s_logFile = new CLogFile(adempiereHome, true, isClient);
        }
        return s_logFile;
    }

    public CLogFile(String adempiereHome, boolean createLogDir, boolean isClient) {
        if (s_logFile == null) {
            s_logFile = this;
        } else {
            this.reportError("File Handler exists already", new IllegalStateException("Existing Handler"), 0);
        }
        this.m_adempiereHome = adempiereHome != null && adempiereHome.length() > 0 ? adempiereHome : Ini.findAdempiereHome();
        this.initialize(this.m_adempiereHome, createLogDir, isClient);
    }

    private void initialize(String adempiereHome, boolean createLogDir, boolean isClient) {
        if (this.m_writer != null) {
            this.close();
        }
        this.m_doneHeader = false;
        if (!this.createFile(adempiereHome, createLogDir, isClient)) {
            return;
        }
        try {
            this.m_writer = new FileWriter(this.m_file, true);
            this.m_records = 0;
        }
        catch (Exception ex) {
            this.reportError("writer", ex, 4);
            this.m_writer = null;
        }
        this.setFormatter(CLogFormatter.get());
        this.setLevel(Level.ALL);
        this.setFilter(CLogFilter.get());
    }

    private boolean createFile(String baseDirName, boolean createLogDir, boolean isClient) {
        String fileName = baseDirName;
        try {
            File dir;
            if (!(fileName == null || (dir = new File(fileName)).exists() && dir.isDirectory())) {
                this.reportError("Invalid base directory: " + fileName, null, 4);
                fileName = null;
            }
            if (fileName != null && createLogDir) {
                dir = new File(fileName = fileName + File.separator + "log");
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if (!dir.exists() || !dir.isDirectory()) {
                    this.reportError("Invalid log directory: " + fileName, null, 4);
                    fileName = null;
                }
            }
            if (fileName != null) {
                fileName = fileName + File.separator;
                if (isClient) {
                    fileName = fileName + "client";
                }
                this.m_fileNameDate = CLogFile.getFileNameDate(System.currentTimeMillis());
                fileName = fileName + this.m_fileNameDate + "_";
                for (int i2 = 0; i2 < 100; ++i2) {
                    String finalName = fileName + i2 + ".log";
                    File file = new File(finalName);
                    if (file.exists()) continue;
                    this.m_file = file;
                    break;
                }
            }
            if (this.m_file == null) {
                this.m_fileNameDate = CLogFile.getFileNameDate(System.currentTimeMillis());
                this.m_file = File.createTempFile("adempiere" + this.m_fileNameDate + "_", ".log");
            }
        }
        catch (Exception ex) {
            this.reportError("file", ex, 4);
            this.m_file = null;
            return false;
        }
        return true;
    }

    public static String getFileNameDate(long time) {
        Timestamp ts = new Timestamp(time);
        String s = ts.toString();
        return s.substring(0, 10);
    }

    private void rotateLog(long time) {
        if (this.m_fileNameDate == null || this.m_fileNameDate.equals(CLogFile.getFileNameDate(time))) {
            return;
        }
        this.rotateLog();
    }

    public void rotateLog() {
        this.initialize(this.m_adempiereHome, true, Ini.isClient());
    }

    public String getFileName() {
        if (this.m_file != null) {
            return this.m_file.getAbsolutePath();
        }
        return "";
    }

    public File getLogDirectory() {
        if (this.m_file != null) {
            return this.m_file.getParentFile();
        }
        return null;
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            return;
        }
        super.setLevel(newLevel);
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record) || this.m_writer == null) {
            return;
        }
        this.rotateLog(record.getMillis());
        String msg = null;
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError("formatting", ex, 5);
            return;
        }
        try {
            if (!this.m_doneHeader) {
                this.m_writer.write(this.getFormatter().getHead(this));
                this.m_doneHeader = true;
            }
            this.m_writer.write(msg);
            ++this.m_records;
            if (record.getLevel() == Level.SEVERE || record.getLevel() == Level.WARNING || this.m_records % 10 == 0) {
                this.flush();
            }
        }
        catch (Exception ex) {
            this.reportError("writing", ex, 1);
        }
    }

    @Override
    public void flush() {
        try {
            if (this.m_writer != null) {
                this.m_writer.flush();
            }
        }
        catch (Exception ex) {
            this.reportError("flush", ex, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this.m_writer == null) {
            return;
        }
        try {
            if (!this.m_doneHeader) {
                this.m_writer.write(this.getFormatter().getHead(this));
            }
            this.m_writer.write(this.getFormatter().getTail(this));
        }
        catch (Exception ex) {
            this.reportError("tail", ex, 1);
        }
        this.flush();
        try {
            this.m_writer.close();
        }
        catch (Exception ex) {
            this.reportError("close", ex, 3);
        }
        this.m_writer = null;
        this.m_file = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CLogFile[");
        sb.append(this.getFileName()).append(",Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }
}

