/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_PT
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", " Mil", " Milh\u00e3o", " Bilh\u00e3o", " Trilh\u00e3o", " Quatrilh\u00e3o", " Quinquilh\u00e3o"};
    private static final String[] majorNamesPlural = new String[]{"", " Mil", " Milh\u00f5es", " Bilh\u00f5es", " Trilh\u00f5es", " Quatrilh\u00f5es", " Quinquilh\u00f5es"};
    private static final String[] tensNames = new String[]{"", " Dez", " Vinte", " Trinta", " Quarenta", " Cinq\u00fcenta", " Sessenta", " Setenta", " Oitenta", " Noventa"};
    private static final String[] numNames = new String[]{"", " Um", " Dois", " Tr\u00eas", " Quatro", " Cinco", " Seis", " Sete", " Oito", " Nove", " Dez", " Onze", " Doze", " Treze", " Quatorze", " Quinze", " Dezesseis", " Dezessete", " Dezoito", " Dezenove"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            String s = Double.toString(number /= 10);
            soFar = s.endsWith("2") && !soFar.equals("") ? " Vinte e " + soFar.trim() : (soFar.equals("") ? tensNames[number % 10] + " e" + soFar : tensNames[number % 10] + " e" + soFar);
            number /= 10;
        }
        if (number == 0) {
            return tensNames[number % 10] + soFar;
        }
        if (number > 1) {
            soFar = "s e" + soFar;
        }
        if (number == 1 && !soFar.equals("")) {
            number = 0;
        }
        soFar = " e" + soFar;
        return numNames[number] + " Cento" + soFar;
    }

    private String convert(int number) {
        if (number == 0) {
            return "";
        }
        if (number == 1) {
            return "Um";
        }
        if (number == -1) {
            return "Menos Um";
        }
        String prefix = "";
        if (number < 0) {
            number = -number;
            prefix = "Menos";
        }
        if (number > 1000000 && number < 2000000) {
            prefix = "Um";
        }
        String soFar = "";
        int place = 0;
        do {
            int n;
            if ((n = number % 1000) != 0) {
                String s = this.convertLessThanOneThousand(n);
                if (s.startsWith("Um Cento e", 1)) {
                    s = s.replaceFirst("Um Cento e", "Cem");
                }
                if (s.startsWith("Dois Cento es", 1)) {
                    s = s.replaceFirst("Dois Cento es", "Duzentos");
                }
                if (s.startsWith("Tr\u00eas Cento es", 1)) {
                    s = s.replaceFirst("Tr\u00eas Cento es", "Trezentos");
                }
                if (s.startsWith("Quatro Cento es", 1)) {
                    s = s.replaceFirst("Quatro Cento es", "Quatrocentos");
                }
                if (s.startsWith("Cinco Cento es", 1)) {
                    s = s.replaceFirst("Cinco Cento es", "Quinhentos");
                }
                if (s.startsWith("Seis Cento es", 1)) {
                    s = s.replaceFirst("Seis Cento es", "Seiscentos");
                }
                if (s.startsWith("Sete Cento es", 1)) {
                    s = s.replaceFirst("Sete Cento es", "Setecentos");
                }
                if (s.startsWith("Oito Cento es", 1)) {
                    s = s.replaceFirst("Oito Cento es", "Oitocentos");
                }
                if (s.startsWith("Nove Cento es", 1)) {
                    s = s.replaceFirst("Nove Cento es", "Novecentos");
                }
                soFar = s.equals(" Um") ? majorNames[place] + soFar : (n > 1 ? s + majorNamesPlural[place] + soFar : s + majorNames[place] + soFar);
            }
            ++place;
        } while ((number /= 1000) > 0);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(44);
        int pos2 = amount.lastIndexOf(46);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        String vlr = amount.replaceAll(",", ".");
        amount = amount.replaceAll("\\.", "");
        int newpos = amount.lastIndexOf(44);
        int pesos = Integer.parseInt(amount.substring(0, newpos));
        double valor = Double.parseDouble(vlr);
        sb.append(this.convert(pesos));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            if (valor > 0.0 && valor < 1.0) {
                if (Integer.parseInt(cents) <= 0) continue;
                if (Integer.parseInt(cents) > 1) {
                    sb.append(this.convert(Integer.parseInt(cents))).append(" Centavos");
                    continue;
                }
                sb.append(this.convert(Integer.parseInt(cents))).append(" Centavo");
                continue;
            }
            if (valor > 1.0 && valor < 2.0 || valor > -2.0 && valor < -1.0) {
                if (Integer.parseInt(cents) <= 0) continue;
                if (Integer.parseInt(cents) > 1) {
                    sb.append(' ').append("Real e ").append(this.convert(Integer.parseInt(cents))).append(" Centavos");
                    break;
                }
                sb.append(' ').append("Real e ").append(this.convert(Integer.parseInt(cents))).append(" Centavo");
                break;
            }
            if (valor > -1.0 && valor < 0.0) {
                if (Integer.parseInt(cents) <= 0) continue;
                if (Integer.parseInt(cents) > 1) {
                    sb.append("Menos ").append(this.convert(Integer.parseInt(cents))).append(" Centavos");
                    break;
                }
                sb.append("Menos ").append(this.convert(Integer.parseInt(cents))).append(" Centavo");
                break;
            }
            if (Integer.parseInt(cents) <= 0) continue;
            if (Integer.parseInt(cents) > 1) {
                sb.append(' ').append("Reais e ").append(this.convert(Integer.parseInt(cents))).append(" Centavos");
                break;
            }
            sb.append(' ').append("Reais e ").append(this.convert(Integer.parseInt(cents))).append(" Centavo");
            break;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        AmtInWords_PT aiw = new AmtInWords_PT();
        System.out.println(aiw.getAmtInWords("134502932,01"));
    }
}

