/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.test;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.util.CLogMgt;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;
import test.AdempiereTestCase;

public class TimeUtilTest
extends AdempiereTestCase {
    private Properties testProperties = null;
    private Properties m_Ctx = null;
    private String fileName_DefaultValue = "/opt/Development/ADempiere_Properties/ADempiere_390_Fork.properties";
    private String fileName_Key = "AdempiereProperties";
    private String fileName_Value = "";
    private String isClient_DefaultValue = "Y";
    private String isClient_Key = "isClient";
    private boolean isClient_Value = true;
    private String AD_User_ID_DefaultValue = "0";
    private String AD_User_ID_Key = "AD_User_ID";
    private int AD_User_ID_Value = 0;

    @Override
    protected void setUp() throws Exception {
        this.testProperties = new Properties();
        this.fileName_Value = this.testProperties.getProperty(this.fileName_Key, this.fileName_DefaultValue);
        this.isClient_Value = "Y".equals(this.testProperties.getProperty(this.isClient_Key, this.isClient_DefaultValue));
        this.AD_User_ID_Value = Integer.parseInt(this.testProperties.getProperty(this.AD_User_ID_Key, this.AD_User_ID_DefaultValue));
        this.m_Ctx = new Properties();
        this.m_Ctx.setProperty("#AD_User_ID", new Integer(this.AD_User_ID_Value).toString());
        this.log.config("m_Ctx: " + this.m_Ctx);
        if (this.fileName_Value.length() < 1) {
            TimeUtilTest.assertEquals((String)"Please specify path to Adempiere.properties file!", (boolean)true, (boolean)false);
        }
        System.setProperty("PropertyFile", this.fileName_Value);
        Ini.setClient(this.isClient_Value);
        Adempiere.startup(this.isClient_Value);
        CLogMgt.setLevel(Level.CONFIG);
    }

    public void testTimeUtil() {
        Timestamp t1 = TimeUtil.getDay(2018, 1, 1);
        Timestamp t2 = TimeUtil.getDay(2019, 5, 31);
        this.log.config("(t1 - t2)=" + t1 + " - " + t2);
        this.log.config("getMonthsBetween(t1, t2)=" + TimeUtil.getMonthsBetween(t1, t2));
        Timestamp t3 = TimeUtil.getDay(3, 3, 3);
        Timestamp t4 = TimeUtil.getDay(1, 1, 1);
        Timestamp t5 = TimeUtil.getDay(2, 2, 2);
        this.log.config(t1 + " - " + t3);
        this.log.config(t2 + " - " + TimeUtil.isValid(t1, t3, t2));
        this.log.config(TimeUtil.isSameDay(t1, t4) + " == true");
        this.log.config(TimeUtil.isSameDay(t2, t5) + " == true");
        this.log.config(TimeUtil.isSameDay(t3, t5) + " == false");
        this.log.config("getDaysBetween(t1, t2)=" + TimeUtil.getDaysBetween(t1, t2, new int[0]));
        this.log.config("getHoursBetween(t1, t2)=" + TimeUtil.getHoursBetween(t1, t2));
        this.log.config("getMinutesBetween(t1, t2)=" + TimeUtil.getMinutesBetween(t1, t2));
        this.log.config("getSecondsBetween(t1, t2)=" + TimeUtil.getSecondsBetween(t1, t2));
        this.log.config("getMillisecondsBetween(t1, t2)=" + TimeUtil.getMillisecondsBetween(t1, t2));
        this.log.config("getDaysBetween(t1, t2, Calendar.SATURDAY, Calendar.SUNDAY)=" + TimeUtil.getDaysBetween(t1, t2, 7, 1));
        this.log.config("getNonBusinessDaysBetween(t1, t2, Calendar.SATURDAY, Calendar.SUNDAY)=" + TimeUtil.getNonBusinessDaysBetween(t1, t2, 7, 1));
        this.log.config("getBusinessDaysBetween(t1, t2, Calendar.MONDAY, Calendar.TUESDAY, Calendar.WEDNESDAY, Calendar.THURSDAY, Calendar.FRIDAY)=" + TimeUtil.getBusinessDaysBetween(t1, t2, 2, 3, 4, 5, 6));
        this.log.config("getYearsBetween(t1, t2)=" + TimeUtil.getYearsBetween(t1, t2));
    }
}

