/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import org.adempiere.exceptions.ValueChangeListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.model.GridField;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CEditor;

public class CButton
extends JButton
implements CEditor {
    private static final long serialVersionUID = 70278798402299341L;
    private boolean m_mandatory = false;
    private boolean m_readWrite = true;

    public CButton() {
        this(null, null);
    }

    public CButton(Icon icon) {
        this(null, icon);
    }

    public CButton(String text) {
        this(text, null);
    }

    public CButton(Action a2) {
        super(a2);
    }

    public CButton(String text, Icon icon) {
        super(text, icon);
    }

    @Override
    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        this.setBackgroundColor(new CompiereColor(bg));
        this.repaint();
    }

    @Override
    public void setBackground(boolean error) {
    }

    public void setBackgroundColor() {
        this.setBackgroundColor(null);
    }

    public void setBackgroundColor(CompiereColor bg) {
        if (bg == null) {
            bg = new CompiereColor(AdempierePLAF.getFormBackground());
        }
        this.putClientProperty("CompiereBackground", bg);
        super.setBackground(bg.getFlatColor());
        this.repaint();
    }

    public CompiereColor getBackgroundColor() {
        try {
            return (CompiereColor)this.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            System.err.println("CButton - ClientProperty: " + e.getMessage());
            return null;
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (this.isEnabled() != rw) {
            this.setEnabled(rw);
        }
        this.m_readWrite = rw;
    }

    @Override
    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public String getDisplay() {
        return this.getText();
    }

    @Override
    public void setText(String text) {
        char mnemonic;
        if (text == null) {
            super.setText(text);
            return;
        }
        int pos = text.indexOf(38);
        if (pos != -1 && (mnemonic = text.toUpperCase().charAt(pos + 1)) != ' ') {
            this.setMnemonic((int)mnemonic);
            text = text.substring(0, pos) + text.substring(pos + 1);
        }
        super.setText(text);
        if (this.getName() == null) {
            this.setName(text);
        }
    }

    @Override
    public void setToolTipText(String text) {
        char mnemonic;
        if (text == null) {
            super.setToolTipText(text);
            return;
        }
        int pos = text.indexOf(38);
        if (pos != -1 && (mnemonic = text.toUpperCase().charAt(pos + 1)) != ' ') {
            this.setMnemonic((int)mnemonic);
            text = text.substring(0, pos) + text.substring(pos + 1);
        }
        super.setToolTipText(text);
        if (this.getName() == null) {
            this.setName(text);
        }
    }

    @Override
    public void setActionCommand(String actionCommand) {
        super.setActionCommand(actionCommand);
        if (this.getName() == null && actionCommand != null && actionCommand.length() > 0) {
            this.setName(actionCommand);
        }
    }

    @Override
    public void setMnemonic(int mnemonic) {
        super.setMnemonic(mnemonic);
        if (mnemonic == 0) {
            return;
        }
        InputMap map = SwingUtilities.getUIInputMap(this, 2);
        if (map == null) {
            map = new ComponentInputMapUIResource(this);
            SwingUtilities.replaceUIInputMap(this, 2, map);
        }
        map.clear();
        int mask = 10;
        map.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "pressed");
        map.put(KeyStroke.getKeyStroke(mnemonic, mask, true), "released");
        map.put(KeyStroke.getKeyStroke(mnemonic, 0, true), "released");
        this.setInputMap(2, map);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    @Override
    public GridField getField() {
        return null;
    }
}

