/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.report.MReportTree;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class TrialBalance
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private int p_C_Period_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_AD_Org_ID = 0;
    private int p_Account_ID = 0;
    private String p_AccountValue_From = null;
    private String p_AccountValue_To = null;
    private int p_C_BPartner_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_C_Project_ID = 0;
    private int p_C_Activity_ID = 0;
    private int p_C_SalesRegion_ID = 0;
    private int p_C_Campaign_ID = 0;
    private String p_PostingType = "A";
    private int p_PA_Hierarchy_ID = 0;
    private int p_AD_OrgTrx_ID = 0;
    private int p_C_LocFrom_ID = 0;
    private int p_C_LocTo_ID = 0;
    private int p_User1_ID = 0;
    private int p_User2_ID = 0;
    private int p_User3_ID = 0;
    private int p_User4_ID = 0;
    private String p_seletedIDs = null;
    private String plID = null;
    private String bsID = null;
    private StringBuffer m_parameterWhere = new StringBuffer();
    private long m_start = System.currentTimeMillis();
    private static String s_insert = "INSERT INTO T_TrialBalance (AD_PInstance_ID, Fact_Acct_ID, AD_Client_ID, AD_Org_ID, Created,CreatedBy, Updated,UpdatedBy, C_AcctSchema_ID, Account_ID, AccountValue, DateTrx, DateAcct, C_Period_ID, AD_Table_ID, Record_ID, Line_ID, GL_Category_ID, GL_Budget_ID, C_Tax_ID, M_Locator_ID, PostingType, C_Currency_ID, AmtSourceDr, AmtSourceCr, AmtSourceBalance, AmtAcctDr, AmtAcctCr, AmtAcctBalance, C_UOM_ID, Qty, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID,C_LocTo_ID, C_SalesRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID,User3_ID, User4_ID, A_Asset_ID, Description)";

    @Override
    protected void prepare() {
        StringBuffer sb = new StringBuffer("AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Period_ID")) {
                this.p_C_Period_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct_From = (Timestamp)para[i2].getParameter();
                this.p_DateAcct_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("PA_Hierarchy_ID")) {
                this.p_PA_Hierarchy_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("Account_ID")) {
                this.p_Account_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AccountValue")) {
                this.p_AccountValue_From = (String)para[i2].getParameter();
                this.p_AccountValue_To = (String)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Project_ID")) {
                this.p_C_Project_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Activity_ID")) {
                this.p_C_Activity_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_SalesRegion_ID")) {
                this.p_C_SalesRegion_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Campaign_ID")) {
                this.p_C_Campaign_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("PostingType")) {
                this.p_PostingType = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("Period_ID")) {
                this.p_C_Period_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("seletedID")) {
                this.p_seletedIDs = para[i2].getParameterAsString();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_parameterWhere.append("C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID);
        if (this.p_AccountValue_From != null && this.p_AccountValue_From.length() == 0) {
            this.p_AccountValue_From = null;
        }
        if (this.p_AccountValue_To != null && this.p_AccountValue_To.length() == 0) {
            this.p_AccountValue_To = null;
        }
        if (this.p_AD_Org_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "OO", this.p_AD_Org_ID));
        }
        if (this.p_C_BPartner_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "BP", this.p_C_BPartner_ID));
        }
        if (this.p_M_Product_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PR", this.p_M_Product_ID));
        }
        if (this.p_C_Project_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PJ", this.p_C_Project_ID));
        }
        if (this.p_C_Activity_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "AY", this.p_C_Activity_ID));
        }
        if (this.p_C_Campaign_ID != 0) {
            this.m_parameterWhere.append(" AND C_Campaign_ID=").append(this.p_C_Campaign_ID);
        }
        if (this.p_C_SalesRegion_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "SR", this.p_C_SalesRegion_ID));
        }
        this.m_parameterWhere.append(" AND PostingType='").append(this.p_PostingType).append("'");
        this.setDateAcct();
        this.setDiffAccountByPlBs();
        sb.append(" - DateAcct ").append(this.p_DateAcct_From).append("-").append(this.p_DateAcct_To);
        sb.append(" - Where=").append(this.m_parameterWhere);
        this.log.fine(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDateAcct() {
        if (this.p_DateAcct_From != null) {
            if (this.p_DateAcct_To == null) {
                this.p_DateAcct_To = new Timestamp(System.currentTimeMillis());
            }
            return;
        }
        if (this.p_C_Period_ID == 0) {
            GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(5, 1);
            this.p_DateAcct_From = new Timestamp(cal.getTimeInMillis());
            cal.add(2, 1);
            cal.add(6, -1);
            this.p_DateAcct_To = new Timestamp(cal.getTimeInMillis());
            return;
        }
        String sql = "SELECT StartDate, EndDate FROM C_Period WHERE C_Period_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.p_C_Period_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.p_DateAcct_From = rs.getTimestamp(1);
                this.p_DateAcct_To = rs.getTimestamp(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            pstmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDiffAccountByPlBs() {
        StringBuffer bs = new StringBuffer();
        StringBuffer pl = new StringBuffer();
        StringBuffer sql = new StringBuffer("SELECT C_ElementValue_ID, value, AccountType FROM C_ElementValue WHERE AD_Client_ID = ? ");
        if (this.p_seletedIDs != null && !this.p_seletedIDs.isEmpty()) {
            sql.append(" AND C_ElementValue_ID IN (").append(this.p_seletedIDs).append(")");
        } else if (this.p_Account_ID > 0) {
            sql.append(" AND C_ElementValue_ID = ").append(this.p_Account_ID);
        } else if (this.p_AccountValue_From != null && this.p_AccountValue_To != null) {
            sql.append(" AND value >= ").append(DB.TO_STRING(this.p_AccountValue_From)).append(" AND Value <= ").append(DB.TO_STRING(this.p_AccountValue_To));
        } else if (this.p_AccountValue_From != null && this.p_AccountValue_To == null) {
            sql.append(" AND Value >= ").append(DB.TO_STRING(this.p_AccountValue_From));
        } else if (this.p_AccountValue_From == null && this.p_AccountValue_To != null) {
            sql.append("Value <= ").append(DB.TO_STRING(this.p_AccountValue_To));
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getString("AccountType").equals("A") || rs.getString("AccountType").equals("L") || rs.getString("AccountType").equals("O")) {
                    bs.append(rs.getInt("C_ElementValue_ID")).append(",");
                    continue;
                }
                pl.append(rs.getInt("C_ElementValue_ID")).append(",");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            if (bs.toString() != null && !bs.toString().isEmpty()) {
                this.bsID = bs.toString().substring(0, bs.lastIndexOf(","));
            }
            if (pl.toString() != null && !pl.toString().isEmpty()) {
                this.plID = pl.toString().substring(0, pl.lastIndexOf(","));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            pstmt = null;
        }
    }

    @Override
    protected String doIt() {
        if (this.bsID != null && !this.bsID.isEmpty()) {
            this.createBalanceLine(false);
        }
        if (this.plID != null && !this.plID.isEmpty()) {
            this.createBalanceLine(true);
        }
        this.createDetailLines();
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "";
    }

    private void createBalanceLine(boolean isPL_IDs) {
        StringBuffer sql = new StringBuffer(s_insert);
        sql.append("SELECT ").append(this.getAD_PInstance_ID()).append(",-1*Account_ID,");
        sql.append(this.getAD_Client_ID()).append(",");
        if (this.p_AD_Org_ID == 0) {
            sql.append("0");
        } else {
            sql.append(this.p_AD_Org_ID);
        }
        sql.append(", SysDate,").append(this.getAD_User_ID()).append(",SysDate,").append(this.getAD_User_ID()).append(",");
        sql.append(this.p_C_AcctSchema_ID).append(",");
        if (this.p_Account_ID == 0) {
            sql.append("Account_ID");
        } else {
            sql.append(this.p_Account_ID);
        }
        if (this.p_AccountValue_From != null) {
            sql.append(",").append(DB.TO_STRING(this.p_AccountValue_From));
        } else if (this.p_AccountValue_To != null) {
            sql.append(",' '");
        } else {
            sql.append(",null");
        }
        Timestamp balanceDay = this.p_DateAcct_From;
        sql.append(",null,").append(DB.TO_DATE(balanceDay, true)).append(",");
        if (this.p_C_Period_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_Period_ID);
        }
        sql.append(",");
        sql.append("null,null,null,");
        sql.append("null,null,null,null,'").append(this.p_PostingType).append("',");
        sql.append("null,null,null,null,");
        sql.append(" COALESCE(SUM(AmtAcctDr),0),COALESCE(SUM(AmtAcctCr),0),COALESCE(SUM(AmtAcctDr),0)-COALESCE(SUM(AmtAcctCr),0), null,COALESCE(SUM(Qty),0),");
        if (this.p_M_Product_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_M_Product_ID);
        }
        sql.append(",");
        if (this.p_C_BPartner_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_BPartner_ID);
        }
        sql.append(",");
        if (this.p_AD_OrgTrx_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_AD_OrgTrx_ID);
        }
        sql.append(",");
        if (this.p_C_LocFrom_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_LocFrom_ID);
        }
        sql.append(",");
        if (this.p_C_LocTo_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_LocTo_ID);
        }
        sql.append(",");
        if (this.p_C_SalesRegion_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_SalesRegion_ID);
        }
        sql.append(",");
        if (this.p_C_Project_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_Project_ID);
        }
        sql.append(",");
        if (this.p_C_Campaign_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_Campaign_ID);
        }
        sql.append(",");
        if (this.p_C_Activity_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_C_Activity_ID);
        }
        sql.append(",");
        if (this.p_User1_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_User1_ID);
        }
        sql.append(",");
        if (this.p_User2_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_User2_ID);
        }
        sql.append(",");
        if (this.p_User3_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_User3_ID);
        }
        sql.append(",");
        if (this.p_User4_ID == 0) {
            sql.append("null");
        } else {
            sql.append(this.p_User4_ID);
        }
        sql.append(", null,'");
        sql.append(Msg.getMsg(this.getCtx(), "opening.balance") + "'");
        sql.append(" FROM Fact_Acct WHERE AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND ").append(this.m_parameterWhere).append(" AND DateAcct < ").append(DB.TO_DATE(this.p_DateAcct_From, true));
        if (isPL_IDs) {
            MPeriod first = MPeriod.getFirstInYear(this.getCtx(), this.p_DateAcct_From, this.p_AD_Org_ID);
            if (first != null) {
                sql.append(" AND DateAcct >= ").append(DB.TO_DATE(first.getStartDate(), true));
            } else {
                this.log.log(Level.SEVERE, "first period not found");
            }
        }
        sql.append(" AND Account_ID IN (");
        if (isPL_IDs) {
            sql.append(this.plID).append(")");
        } else {
            sql.append(this.bsID).append(")");
        }
        sql.append(" GROUP BY Account_ID");
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no == 0) {
            this.log.fine(sql.toString());
        }
        this.log.fine("#" + no + " (Account_ID=" + this.p_Account_ID + ")");
    }

    private void createDetailLines() {
        StringBuffer sql = new StringBuffer(s_insert);
        sql.append("SELECT ").append(this.getAD_PInstance_ID()).append(",Fact_Acct_ID,");
        sql.append(this.getAD_Client_ID()).append(",AD_Org_ID,Created,CreatedBy, Updated,UpdatedBy,");
        sql.append("C_AcctSchema_ID, Account_ID, null, DateTrx, DateAcct, C_Period_ID,");
        sql.append("AD_Table_ID, Record_ID, Line_ID,");
        sql.append("GL_Category_ID, GL_Budget_ID, C_Tax_ID, M_Locator_ID, PostingType,");
        sql.append("C_Currency_ID, AmtSourceDr,AmtSourceCr, AmtSourceDr-AmtSourceCr,");
        sql.append(" AmtAcctDr,AmtAcctCr, AmtAcctDr-AmtAcctCr, C_UOM_ID,Qty,");
        sql.append("M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID,C_LocTo_ID,");
        sql.append("C_SalesRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID,");
        sql.append("User1_ID, User2_ID, User3_ID, User4_ID, A_Asset_ID, Description");
        sql.append(" FROM Fact_Acct WHERE AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND ").append(this.m_parameterWhere).append(" AND DateAcct >= ").append(DB.TO_DATE(this.p_DateAcct_From, true)).append(" AND TRUNC(DateAcct, 'DD') <= ").append(DB.TO_DATE(this.p_DateAcct_To, true));
        sql.append(" AND Account_ID IN (");
        if (this.plID != null && !this.plID.isEmpty()) {
            sql.append(this.plID);
        }
        if (this.bsID != null && !this.bsID.isEmpty()) {
            if (this.plID != null && !this.plID.isEmpty()) {
                sql.append(",");
            }
            sql.append(this.bsID);
        }
        sql.append(")");
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no == 0) {
            this.log.fine(sql.toString());
        }
        this.log.fine("#" + no + " (Account_ID=" + this.p_Account_ID + ")");
        String sql2 = "UPDATE T_TrialBalance tb SET AccountValue = (SELECT Value FROM C_ElementValue ev WHERE ev.C_ElementValue_ID=tb.Account_ID) WHERE tb.Account_ID IS NOT NULL AND tb.AD_PInstance_ID = " + this.getAD_PInstance_ID();
        no = DB.executeUpdate(sql2, this.get_TrxName());
        if (no > 0) {
            this.log.fine("Set AccountValue #" + no);
        }
    }
}

