/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.PO;
import org.compiere.model.X_C_RfQLine;
import org.compiere.process.RfQCreateSOAbstract;
import org.compiere.util.Env;

public class RfQCreateSO
extends RfQCreateSOAbstract {
    private static BigDecimal ONEHUNDRED = new BigDecimal(100);

    @Override
    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info("doIt - " + rfq);
        if (rfq.getC_BPartner_ID() == 0 || rfq.getC_BPartner_Location_ID() == 0) {
            throw new Exception("No Business Partner/Location");
        }
        MBPartner bp = new MBPartner(this.getCtx(), rfq.getC_BPartner_ID(), this.get_TrxName());
        MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setIsSOTrx(true);
        if (this.getDocTypeId() != 0) {
            order.setC_DocTypeTarget_ID(this.getDocTypeId());
        } else {
            order.setC_DocTypeTarget_ID();
        }
        order.setBPartner(bp);
        order.setC_BPartner_Location_ID(rfq.getC_BPartner_Location_ID());
        order.setSalesRep_ID(rfq.getSalesRep_ID());
        order.set_ValueOfColumn("C_RfQ_ID", (Object)rfq.getC_RfQ_ID());
        int campaignId = rfq.get_ValueAsInt("C_Campaign_ID");
        int user1Id = rfq.get_ValueAsInt("User1_ID");
        int projectId = rfq.get_ValueAsInt("C_Project_ID");
        if (campaignId > 0) {
            order.set_ValueOfColumn("C_Campaign_ID", (Object)campaignId);
        }
        if (user1Id > 0) {
            order.set_ValueOfColumn("User1_ID", (Object)user1Id);
        }
        if (projectId > 0) {
            order.set_ValueOfColumn("C_Project_ID", (Object)projectId);
            MProject project = new MProject(this.getCtx(), projectId, this.get_TrxName());
            order.set_ValueOfColumn("S_Contract_ID", project.get_Value("S_Contract_ID"));
        }
        if (rfq.getDateWorkComplete() != null) {
            order.setDatePromised(rfq.getDateWorkComplete());
        }
        MRfQResponse[] responses = rfq.getResponses(true, false);
        for (MRfQResponse mRfQResponse : responses) {
            if (!mRfQResponse.isSelectedWinner()) continue;
            order.setDropShip_BPartner_ID(mRfQResponse.getC_BPartner_ID());
            order.setIsDropShip(true);
            MBPartner partner = new MBPartner(this.getCtx(), mRfQResponse.getC_BPartner_ID(), null);
            MBPartnerLocation partnerLocation = partner.getPrimaryC_BPartner_Location();
            if (partnerLocation == null || partnerLocation.get_ID() <= 0) break;
            order.setDropShip_Location_ID(partnerLocation.get_ID());
            break;
        }
        order.saveEx();
        for (PO pO : rfq.getLines()) {
            for (MRfQLineQty lineQty : ((MRfQLine)pO).getQtys()) {
                if (!lineQty.isActive() || !lineQty.isOfferQty()) continue;
                MOrderLine orderLine = new MOrderLine(order);
                orderLine.setM_Product_ID(((X_C_RfQLine)pO).getM_Product_ID(), lineQty.getC_UOM_ID());
                orderLine.setDescription(((X_C_RfQLine)pO).getDescription());
                orderLine.setQty(lineQty.getQty());
                orderLine.setPrice();
                BigDecimal price = lineQty.getOfferAmt();
                if (price == null || price.signum() == 0) {
                    price = lineQty.getBestResponseAmt();
                    if (price == null || price.signum() == 0) {
                        price = Env.ZERO;
                        this.log.warning(" - BestResponse=0 - " + lineQty);
                    } else {
                        BigDecimal margin = lineQty.getMargin();
                        if (margin == null || margin.signum() == 0) {
                            margin = rfq.getMargin();
                        }
                        if (margin != null && margin.signum() != 0) {
                            margin = margin.add(ONEHUNDRED);
                            price = price.multiply(margin).divide(ONEHUNDRED, 2, 4);
                            orderLine.setPriceList(lineQty.getBestResponseAmt());
                        }
                    }
                }
                orderLine.setPrice(price);
                int projectTaskId = pO.get_ValueAsInt("C_ProjectTask_ID");
                int projectPhaseId = pO.get_ValueAsInt("C_ProjectPhase_ID");
                if (projectPhaseId > 0) {
                    orderLine.set_ValueOfColumn("C_ProjectPhase_ID", (Object)projectPhaseId);
                }
                if (projectTaskId > 0) {
                    orderLine.set_ValueOfColumn("C_ProjectTask_ID", (Object)projectTaskId);
                }
                orderLine.saveEx();
            }
        }
        rfq.setC_Order_ID(order.getC_Order_ID());
        rfq.saveEx();
        return order.getDocumentNo();
    }
}

