/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MRequest;
import org.compiere.model.MUser;
import org.compiere.process.RequestEMailProcessorAbstract;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Util;

public class RequestEMailProcessor
extends RequestEMailProcessorAbstract {
    private EMail email = null;
    private int noProcessed = 0;
    private int noRequest = 0;
    private int noError = 0;
    private static final int ERROR = 0;
    private static final int REQUEST = 1;

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - IMAPHost=" + this.getRequestUser() + " IMAPPwd=" + this.getRequestUserPW() + " RequestFolder=" + this.getRequestFolder() + " InboxFolder=" + this.getInboxFolder() + " ErrorFolder=" + this.getErrorFolder());
        try {
            this.processInBox();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processInBox", e);
        }
        this.addLog("@Total@=" + this.noProcessed);
        this.addLog("@R_Request_ID@=" + this.noRequest);
        this.addLog("@Error@=" + this.noError);
        return "Ok";
    }

    private void processInBox() throws Exception {
        Message[] messages;
        this.email = new EMail(MClient.get(this.getCtx()), this.getEMailConfigId());
        this.email.createAuthenticator(this.getRequestUser(), this.getRequestUserPW());
        Folder folder = this.email.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("@DefaultFolder@ @NotFound@");
        }
        Folder inbox = folder.getFolder(this.getInboxFolder());
        if (!inbox.exists()) {
            throw new IllegalStateException("@InboxFolder@ @NotFound@");
        }
        inbox.open(2);
        this.log.fine("processInBox - " + inbox.getName() + "; Messages Total=" + inbox.getMessageCount() + "; New=" + inbox.getNewMessageCount());
        if (!this.email.getProtocol().equals("I")) {
            return;
        }
        Folder requestFolder = folder.getFolder(this.getRequestFolder());
        if (!requestFolder.exists() && !requestFolder.create(1)) {
            throw new IllegalStateException("Cannot create Request Folder");
        }
        requestFolder.open(2);
        Folder errorFolder = folder.getFolder(this.getErrorFolder());
        if (!errorFolder.exists() && !errorFolder.create(1)) {
            throw new IllegalStateException("Cannot create Error Folder");
        }
        errorFolder.open(2);
        for (Message msg : messages = inbox.getMessages()) {
            String[] hdrs;
            int result = this.processMessage(msg);
            if (result == 1) {
                hdrs = msg.getHeader("Message-ID");
                try {
                    if (this.createRequest(msg)) {
                        msg.setFlag(Flags.Flag.SEEN, true);
                        msg.setFlag(Flags.Flag.ANSWERED, true);
                        requestFolder.appendMessages(new Message[]{msg});
                        this.log.info("message " + hdrs[0] + " moved to " + this.getRequestFolder() + " folder");
                        this.log.info("message info: Sent -> " + msg.getSentDate() + " From -> " + msg.getFrom()[0].toString());
                        msg.setFlag(Flags.Flag.DELETED, true);
                        inbox.expunge();
                        ++this.noRequest;
                    }
                }
                catch (Exception e) {
                    this.log.info("message " + hdrs[0] + " threw error");
                }
            } else {
                errorFolder.appendMessages(new Message[]{msg});
                hdrs = msg.getHeader("Message-ID");
                this.log.warning("message " + hdrs[0] + " moved to " + this.getErrorFolder() + " folder");
                this.log.warning("message info: Sent -> " + msg.getSentDate() + " From -> " + msg.getFrom()[0].toString());
                ++this.noError;
            }
            ++this.noProcessed;
        }
        this.log.info("processInBox - Total=" + this.noProcessed + " - Requests=" + this.noRequest + " - Errors=" + this.noError);
        errorFolder.close(false);
        requestFolder.close(false);
        inbox.close(true);
    }

    private boolean createRequest(Message msg) throws MessagingException, SQLException {
        MUser us;
        String fromAddress;
        Address[] from = msg.getFrom();
        if (from == null || from.length == 0) {
            return false;
        }
        if (from[0].toString().indexOf(60) != -1 && from[0].toString().indexOf(62) != -1) {
            fromAddress = from[0].toString().substring(from[0].toString().indexOf(60) + 1, from[0].toString().indexOf(62));
            this.log.info("fromAddress stripped: " + fromAddress);
        } else {
            fromAddress = from[0].toString();
        }
        String[] hdrs = msg.getHeader("Message-ID");
        String firstHeader = "";
        String documentNo = "";
        if (hdrs != null && hdrs.length > 0) {
            firstHeader = hdrs[0];
        }
        if (!Util.isEmpty(firstHeader)) {
            documentNo = firstHeader.length() >= 30 ? firstHeader.substring(0, 30) : firstHeader;
        }
        int retValuedup = 0;
        String sqldup = "SELECT R_Request_ID FROM R_Request where AD_Client_ID = ? AND DocumentNo = ? AND StartDate = ?";
        retValuedup = DB.getSQLValue(this.get_TrxName(), sqldup, this.getAD_Client_ID(), documentNo, new Timestamp(msg.getSentDate().getTime()));
        if (retValuedup > 0) {
            this.log.info("request already existed for msg -> " + firstHeader);
            return true;
        }
        int request_upd = 0;
        String sqlupd = "SELECT R_Request_ID   FROM R_Request  WHERE AD_Client_ID = ?    AND Summary LIKE 'FROM: ' || ? || '%'    AND (   DocumentNo =               SUBSTR                  (?,                   INSTR                       (?,                        '<'                       )                  )         OR (    ? LIKE 'Re: %'             AND Summary =                       'FROM: '                    || ?                    || CHR (10)                    || SUBSTR (?, 5)            )        ) ";
        request_upd = DB.getSQLValue(this.get_TrxName(), sqlupd, this.getAD_Client_ID(), fromAddress, msg.getSubject(), msg.getSubject(), msg.getSubject(), fromAddress, msg.getSubject());
        if (request_upd > 0) {
            this.log.info("msg -> " + firstHeader + " is an answer for req " + request_upd);
            return this.updateRequest(request_upd, msg);
        }
        MRequest request = new MRequest(this.getCtx(), 0, this.get_TrxName());
        request.setSummary("FROM: " + fromAddress + "\n" + msg.getSubject());
        request.setResult("FROM: " + from[0].toString() + "\n" + this.getMessage(msg));
        if (documentNo != null) {
            request.setDocumentNo(documentNo);
        }
        if (this.getRequestTypeId() > 0) {
            request.setR_RequestType_ID(this.getRequestTypeId());
        } else {
            request.setR_RequestType_ID();
        }
        if (this.getSalesRepId() > 0) {
            request.setSalesRep_ID(this.getSalesRepId());
        }
        if (this.getRoleId() > 0) {
            request.setAD_Role_ID(this.getRoleId());
        }
        String sqlu = "SELECT AD_User_ID   FROM AD_User  WHERE UPPER (EMail) = UPPER (?)    AND AD_Client_ID = ?";
        int retValueUserId = DB.getSQLValue(this.get_TrxName(), sqlu, fromAddress, this.getAD_Client_ID());
        if (retValueUserId > 0) {
            request.setAD_User_ID(retValueUserId);
        } else if (this.getUserId() > 0) {
            request.setAD_User_ID(this.getUserId());
        }
        if (request.getAD_User_ID() > 0 && (us = new MUser(this.getCtx(), request.getAD_User_ID(), this.get_TrxName())).getC_BPartner_ID() > 0) {
            request.setC_BPartner_ID(us.getC_BPartner_ID());
        }
        if (request.getC_BPartner_ID() <= 0 && this.getBPartnerId() > 0) {
            request.setC_BPartner_ID(this.getBPartnerId());
        }
        request.setStartDate(new Timestamp(msg.getSentDate().getTime()));
        if (this.getConfidentialType() != null) {
            request.setConfidentialType(this.getConfidentialType());
            request.setConfidentialTypeEntry(this.getConfidentialType());
        }
        if (this.getPriorityRule() != null) {
            request.setPriority(this.getPriorityRule());
            request.setPriorityUser(this.getPriorityRule());
        }
        if (request.save(this.get_TrxName())) {
            this.log.info("created request " + request.getR_Request_ID() + " from msg -> " + firstHeader);
            if (msg.isMimeType("multipart/*")) {
                try {
                    Multipart mp = (Multipart)msg.getContent();
                    int n = mp.getCount();
                    for (int i2 = 0; i2 < n; ++i2) {
                        BodyPart part = mp.getBodyPart(i2);
                        String disposition = part.getDisposition();
                        if (disposition == null || !disposition.equals("attachment") && !disposition.equals("inline")) continue;
                        MAttachment attach = request.createAttachment();
                        InputStream in = part.getInputStream();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        int BUF_SIZE = 256;
                        byte[] buffer = new byte[256];
                        int bytesRead = -1;
                        while ((bytesRead = in.read(buffer)) > -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                        in.close();
                        byte[] bytes = out.toByteArray();
                        attach.addEntry(part.getFileName(), bytes);
                        attach.saveEx(this.get_TrxName());
                    }
                }
                catch (IOException e) {
                    this.log.log(Level.FINE, "Error extracting attachments", e);
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateRequest(int request_upd, Message msg) throws MessagingException, SQLException {
        MRequest requp = new MRequest(this.getCtx(), request_upd, this.get_TrxName());
        Address[] from = msg.getFrom();
        requp.setResult("FROM: " + from[0].toString() + "\n" + this.getMessage(msg));
        return requp.save();
    }

    private int processMessage(Message msg) throws Exception {
        this.dumpEnvelope(msg);
        this.dumpBody(msg);
        this.log.finer(":::::::::::::::");
        this.log.finer(this.getSubject(msg));
        this.log.finer(":::::::::::::::");
        this.log.finer(this.getMessage(msg));
        this.log.finer(":::::::::::::::");
        String delivery = this.getDeliveryReport(msg);
        this.log.finer(delivery);
        this.log.finer(":::::::::::::::");
        Address[] from = msg.getFrom();
        if (from != null) {
            if (from[0].toString().equalsIgnoreCase("postmaster@CONSULTDESK")) {
                return 0;
            }
        } else {
            return 0;
        }
        return 1;
    }

    private String getSubject(Message msg) {
        try {
            String str = msg.getSubject();
            if (str != null) {
                return str.trim();
            }
        }
        catch (MessagingException e) {
            this.log.log(Level.SEVERE, "getSubject", e);
        }
        return "";
    }

    private String getMessage(Part msg) {
        StringBuffer sb = new StringBuffer();
        try {
            if (msg.isMimeType("text/plain")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("text/*")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("message/rfc822")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("multipart/alternative")) {
                String plainText = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    BodyPart part = mp.getBodyPart(i2);
                    Object content = part.getContent();
                    if (content == null || content.toString().trim().length() == 0) continue;
                    if (part.isMimeType("text/plain")) {
                        plainText = content.toString();
                        continue;
                    }
                    otherStuff = content.toString();
                }
                if (plainText != null) {
                    sb.append(plainText);
                } else if (otherStuff != null) {
                    sb.append(otherStuff);
                }
            } else if (msg.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i3 = 0; i3 < count; ++i3) {
                    String str = this.getMessage(mp.getBodyPart(i3));
                    if (str.length() <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append("\n-----\n");
                    }
                    sb.append(str);
                }
            } else {
                Object o = msg.getContent();
                if (o instanceof String) {
                    sb.append(o);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getMessage", e);
        }
        return sb.toString().trim();
    }

    private String getDeliveryReport(Part msg) {
        try {
            if (msg.isMimeType("multipart/report")) {
                String deliveryMessage = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    BodyPart part = mp.getBodyPart(i2);
                    Object content = part.getContent();
                    if (content == null) continue;
                    if (part.isMimeType("message/*")) {
                        deliveryMessage = this.getDeliveredReportDetail(part);
                        continue;
                    }
                    otherStuff = content.toString().trim();
                }
                if (deliveryMessage != null) {
                    return deliveryMessage;
                }
                return otherStuff;
            }
            if (msg.isMimeType("message/*")) {
                return this.getDeliveredReportDetail(msg);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getDeliveryReport", e);
        }
        return null;
    }

    private String getDeliveredReportDetail(Part part) throws Exception {
        String finalRecipient;
        int atIndex;
        Object content = part.getContent();
        if (content == null) {
            return null;
        }
        String deliveryMessage = null;
        if (content instanceof InputStream) {
            int c;
            StringBuffer sb = new StringBuffer();
            InputStream is = (InputStream)content;
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            deliveryMessage = sb.toString().trim();
        } else {
            deliveryMessage = content.toString().trim();
        }
        if (deliveryMessage == null) {
            return null;
        }
        int index = deliveryMessage.indexOf("Final-Recipient:");
        if (index != -1 && (atIndex = (finalRecipient = deliveryMessage.substring(index)).indexOf("@")) != -1) {
            index = finalRecipient.lastIndexOf(32, atIndex);
            if (index != -1) {
                finalRecipient = finalRecipient.substring(index + 1);
            }
            if ((atIndex = finalRecipient.indexOf("@")) != -1) {
                index = finalRecipient.indexOf(32, atIndex);
            }
            if (index != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            if ((index = finalRecipient.indexOf(10)) != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            return finalRecipient.trim();
        }
        return deliveryMessage;
    }

    private void dumpEnvelope(Message m) throws Exception {
        int i2;
        StringBuffer sb1;
        int j;
        this.log.finer("-----------------------------------------------------------------");
        Address[] a2 = m.getFrom();
        if (a2 != null) {
            for (j = 0; j < a2.length; ++j) {
                this.log.finer("FROM: " + a2[j].toString());
            }
        }
        if ((a2 = m.getRecipients(Message.RecipientType.TO)) != null) {
            for (j = 0; j < a2.length; ++j) {
                this.log.finer("TO: " + a2[j].toString());
            }
        }
        this.log.finer("SUBJECT: " + m.getSubject());
        Date d = m.getSentDate();
        this.log.finer("SendDate: " + (d != null ? d.toString() : "UNKNOWN"));
        Flags flags = m.getFlags();
        StringBuffer sb = new StringBuffer();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        for (int i3 = 0; i3 < sf.length; ++i3) {
            String s;
            Flags.Flag f = sf[i3];
            if (f == Flags.Flag.ANSWERED) {
                s = "\\Answered";
            } else if (f == Flags.Flag.DELETED) {
                s = "\\Deleted";
            } else if (f == Flags.Flag.DRAFT) {
                s = "\\Draft";
            } else if (f == Flags.Flag.FLAGGED) {
                s = "\\Flagged";
            } else if (f == Flags.Flag.RECENT) {
                s = "\\Recent";
            } else {
                if (f != Flags.Flag.SEEN) continue;
                s = "\\Seen";
            }
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        String[] uf = flags.getUserFlags();
        for (int i4 = 0; i4 < uf.length; ++i4) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i4]);
        }
        this.log.finer("FLAGS: " + sb.toString());
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            sb1 = new StringBuffer("X-Mailer: ");
            for (i2 = 0; i2 < hdrs.length; ++i2) {
                sb1.append(hdrs[i2]).append("  ");
            }
            this.log.finer(sb1.toString());
        } else {
            this.log.finer("X-Mailer NOT available");
        }
        hdrs = m.getHeader("Message-ID");
        if (hdrs != null) {
            sb1 = new StringBuffer("Message-ID: ");
            for (i2 = 0; i2 < hdrs.length; ++i2) {
                sb1.append(hdrs[i2]).append("  ");
            }
            this.log.finer(sb1.toString());
        } else {
            this.log.finer("Message-ID NOT available");
        }
        this.log.finer("ALL HEADERs:");
        Enumeration en = m.getAllHeaders();
        while (en.hasMoreElements()) {
            Header hdr = (Header)en.nextElement();
            this.log.finer("  " + hdr.getName() + " = " + hdr.getValue());
        }
        this.log.finer("-----------------------------------------------------------------");
    }

    private void dumpBody(Part p2) throws Exception {
        this.log.finer("=================================================================");
        this.log.finer("CONTENT-TYPE: " + p2.getContentType());
        if (p2.isMimeType("text/plain")) {
            this.log.finer("Plain text ---------------------------");
            this.log.finer((String)p2.getContent());
        } else if (p2.getContentType().toUpperCase().startsWith("TEXT")) {
            this.log.finer("Other text ---------------------------");
            this.log.finer((String)p2.getContent());
        } else if (p2.isMimeType("multipart/*")) {
            this.log.finer("Multipart ---------------------------");
            Multipart mp = (Multipart)p2.getContent();
            int count = mp.getCount();
            for (int i2 = 0; i2 < count; ++i2) {
                this.dumpBody(mp.getBodyPart(i2));
            }
        } else if (p2.isMimeType("message/rfc822")) {
            this.log.finer("Nested ---------------------------");
            this.dumpBody((Part)p2.getContent());
        } else {
            Object o = p2.getContent();
            if (o instanceof String) {
                this.log.finer("This is a string ---------------------------");
                this.log.finer((String)o);
            } else if (o instanceof InputStream) {
                this.log.finer("This is just an input stream ---------------------------");
            } else {
                this.log.finer("This is an unknown type ---------------------------");
                this.log.finer(o.toString());
            }
        }
        this.log.finer("=================================================================");
    }
}

