/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;

public class ProductUOMConvert
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_To_ID = 0;
    private int p_M_Locator_ID = 0;
    private BigDecimal p_Qty = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_To_ID")) {
                this.p_M_Product_To_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Locator_ID")) {
                this.p_M_Locator_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("Qty")) {
                this.p_Qty = (BigDecimal)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        BigDecimal qtyTo6;
        if (this.p_M_Product_ID == 0 || this.p_M_Product_To_ID == 0 || this.p_M_Locator_ID == 0 || this.p_Qty == null || Env.ZERO.compareTo(this.p_Qty) == 0) {
            throw new AdempiereUserError("Invalid Parameter");
        }
        MProduct product = MProduct.get(this.getCtx(), this.p_M_Product_ID);
        MProduct productTo = MProduct.get(this.getCtx(), this.p_M_Product_To_ID);
        this.log.info("Product=" + product + ", ProductTo=" + productTo + ", M_Locator_ID=" + this.p_M_Locator_ID + ", Qty=" + this.p_Qty);
        MUOMConversion[] conversions = MUOMConversion.getProductConversions(this.getCtx(), product.getM_Product_ID());
        MUOMConversion conversion = null;
        for (int i2 = 0; i2 < conversions.length; ++i2) {
            if (conversions[i2].getC_UOM_To_ID() != productTo.getC_UOM_ID()) continue;
            conversion = conversions[i2];
        }
        if (conversion == null) {
            throw new AdempiereUserError("@NotFound@: @C_UOM_Conversion_ID@");
        }
        MUOM uomTo = MUOM.get(this.getCtx(), productTo.getC_UOM_ID());
        BigDecimal qtyTo = this.p_Qty.divide(conversion.getDivideRate(), uomTo.getStdPrecision(), 4);
        if (qtyTo.compareTo(qtyTo6 = this.p_Qty.divide(conversion.getDivideRate(), 6, 4)) != 0) {
            throw new AdempiereUserError("@StdPrecision@: " + qtyTo + " <> " + qtyTo6 + " (" + this.p_Qty + "/" + conversion.getDivideRate() + ")");
        }
        this.log.info(conversion + " -> " + qtyTo);
        return "Not completed yet";
    }
}

