/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class ProcessInfo
implements Serializable {
    static final long serialVersionUID = -1993220053515488725L;
    private String title;
    private int processId;
    private int tableId;
    private int recordId;
    private int tableSelectionId;
    private String aliasTableSelection;
    private Integer userId;
    private Integer clientId;
    private String className = null;
    private int instanceId = 0;
    private String summary = "";
    private boolean hadError = false;
    private Serializable serializableObject = null;
    private transient Object transientObject = null;
    private int estimatedSeconds = 5;
    private boolean batch = false;
    private boolean timeout = false;
    private ArrayList<ProcessInfoLog> logs = null;
    private Hashtable<String, ProcessInfoParameter> parameters = null;
    private LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection = null;
    private List<Integer> keySelection = null;
    private String transactionName = null;
    private boolean printPreview = false;
    private boolean reportingProcess = false;
    private File pdfReportFile = null;
    private File reportAsFile = null;
    private String reportType = null;
    private String drillSource = null;
    private boolean managedTransaction = true;
    private boolean isSelection = false;
    private Throwable throwable = null;
    private String resultTableName = null;
    private String interfaceType;
    public static String INTERFACE_TYPE_NOT_SET = "not set";
    public static String INTERFACE_TYPE_ZK = "zk";
    public static String INTERFACE_TYPE_SWING = "swing";
    private Integer orgId = -1;
    private int windowNo = 0;
    private String whereClause = "";

    public ProcessInfo(String title, int processId, int tableId, int recordId) {
        this.setTitle(title);
        this.setAD_Process_ID(processId);
        this.setTable_ID(tableId);
        this.setRecord_ID(recordId);
        this.printPreview = Ini.isPropertyBool("PrintPreview");
    }

    public ProcessInfo(String title, int processId, int tableId, int recordId, boolean managedTransaction) {
        this(title, processId, tableId, recordId);
        this.managedTransaction = managedTransaction;
    }

    public ProcessInfo(String title, int processId) {
        this(title, processId, 0, 0);
    }

    public ProcessInfo(String title, int processId, boolean managedTransaction) {
        this(title, processId);
        this.managedTransaction = managedTransaction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ProcessInfo[");
        stringBuffer.append(this.title).append(",Process_ID=").append(this.processId);
        if (this.instanceId != 0) {
            stringBuffer.append(",AD_PInstance_ID=").append(this.instanceId);
        }
        if (this.recordId != 0) {
            stringBuffer.append(",Record_ID=").append(this.recordId);
        }
        if (this.className != null) {
            stringBuffer.append(",ClassName=").append(this.className);
        }
        stringBuffer.append(",Error=").append(this.isError());
        if (this.transientObject != null) {
            stringBuffer.append(",Transient=").append(this.transientObject);
        }
        if (this.serializableObject != null) {
            stringBuffer.append(",Serializable=").append(this.serializableObject);
        }
        stringBuffer.append(",Summary=").append(this.getSummary()).append(",Log=").append(this.logs == null ? 0 : this.logs.size());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setIsSelection(boolean isSelection) {
        this.isSelection = isSelection;
    }

    public boolean isSelection() {
        return this.isSelection;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return Util.cleanAmp(this.summary);
    }

    public void setSummary(String translatedSummary, boolean error) {
        this.setSummary(translatedSummary);
        this.setError(error);
    }

    public void addSummary(String additionalSummary) {
        this.summary = this.summary + additionalSummary;
    }

    public void setError(boolean error) {
        this.hadError = error;
    }

    public boolean isError() {
        return this.hadError;
    }

    public void setIsBatch(boolean batch) {
        this.batch = batch;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setIsTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public String getLogInfo(boolean html) {
        if (this.logs == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat dateFormat = DisplayType.getDateFormat(16);
        if (html) {
            stringBuffer.append("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\">");
        }
        for (int i2 = 0; i2 < this.logs.size(); ++i2) {
            if (html) {
                stringBuffer.append("<tr>");
            } else if (i2 > 0) {
                stringBuffer.append("\n");
            }
            ProcessInfoLog log = this.logs.get(i2);
            if (log.getP_Date() != null) {
                stringBuffer.append(html ? "<td>" : "").append(dateFormat.format(log.getP_Date())).append(html ? "</td>" : " \t");
            }
            if (log.getP_Number() != null) {
                stringBuffer.append(html ? "<td>" : "").append(log.getP_Number()).append(html ? "</td>" : " \t");
            }
            if (log.getP_Msg() != null) {
                stringBuffer.append(html ? "<td>" : "").append(Msg.parseTranslation(Env.getCtx(), log.getP_Msg())).append(html ? "</td>" : "");
            }
            if (!html) continue;
            stringBuffer.append("</tr>");
        }
        if (html) {
            stringBuffer.append("</table>");
        }
        return stringBuffer.toString();
    }

    public String getLogInfo() {
        return this.getLogInfo(false);
    }

    public int getAD_PInstance_ID() {
        return this.instanceId;
    }

    public void setAD_PInstance_ID(int instanceId) {
        this.instanceId = instanceId;
    }

    public int getAD_Process_ID() {
        return this.processId;
    }

    public void setAD_Process_ID(int processId) {
        this.processId = processId;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String ClassName) {
        this.className = ClassName;
        if (this.className != null && this.className.length() == 0) {
            this.className = null;
        }
    }

    public Object getTransientObject() {
        return this.transientObject;
    }

    public void setTransientObject(Object transientObject) {
        this.transientObject = transientObject;
    }

    public Serializable getSerializableObject() {
        return this.serializableObject;
    }

    public void setSerializableObject(Serializable serializableObject) {
        this.serializableObject = serializableObject;
    }

    public int getEstSeconds() {
        return this.estimatedSeconds;
    }

    public void setEstSeconds(int estimatedSeconds) {
        this.estimatedSeconds = estimatedSeconds;
    }

    public int getTable_ID() {
        return this.tableId;
    }

    public void setTable_ID(int tableId) {
        this.tableId = tableId;
    }

    public void setAliasForTableSelection(String aliasTableSelection) {
        this.aliasTableSelection = aliasTableSelection;
    }

    public String getAliasForTableSelection() {
        return this.aliasTableSelection;
    }

    public String getPrefixAliasForTableSelection() {
        return this.aliasTableSelection.toUpperCase() + "_";
    }

    public void setTableSelectionId(int tableSelectionId) {
        this.tableSelectionId = tableSelectionId;
    }

    public int getTableSelectionId() {
        return this.tableSelectionId;
    }

    public int getRecord_ID() {
        return this.recordId;
    }

    public void setRecord_ID(int recordId) {
        this.recordId = recordId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAD_Client_ID(int clientId) {
        this.clientId = new Integer(clientId);
    }

    public Integer getAD_Client_ID() {
        return Optional.ofNullable(this.clientId).orElseThrow(() -> new AdempiereException("@AD_Client_ID@ @NotFound@"));
    }

    public void setAD_User_ID(int userId) {
        this.userId = new Integer(userId);
    }

    public Integer getAD_User_ID() {
        return Optional.ofNullable(this.userId).orElseThrow(() -> new AdempiereException("@AD_User_ID@ @NotFound@"));
    }

    public ProcessInfoParameter[] getParameter() {
        if (this.parameters == null) {
            return null;
        }
        ProcessInfoParameter[] processInfoParameters = new ProcessInfoParameter[this.parameters.size()];
        this.parameters.values().toArray(processInfoParameters);
        return processInfoParameters;
    }

    public void setParameter(ProcessInfoParameter[] parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new Hashtable();
        for (ProcessInfoParameter parameter : parameters) {
            if (parameter.getParameterName() == null) continue;
            this.parameters.put(parameter.getParameterName(), parameter);
        }
    }

    public void setSelectionKeys(List<Integer> selection) {
        this.keySelection = selection;
        this.setIsSelection(selection != null && selection.size() > 0);
        this.saveSelection();
    }

    public List<Integer> getSelectionKeys() {
        return this.keySelection;
    }

    public void setSelectionValues(LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection) {
        this.selection = selection;
        this.setIsSelection(selection != null && selection.size() > 0 || this.getSelectionKeys() != null && this.getSelectionKeys().size() > 0);
        if (selection != null) {
            ArrayList<Integer> keySelection = new ArrayList<Integer>();
            for (Map.Entry<Integer, LinkedHashMap<String, Object>> records : selection.entrySet()) {
                keySelection.add(records.getKey());
            }
            if (this.getSelectionKeys() == null || this.getSelectionKeys().size() == 0) {
                this.setSelectionKeys(keySelection);
            }
        }
        this.saveSelectionValues();
    }

    private void saveSelection() {
        if (this.isSelection() && this.getAD_PInstance_ID() > 0 && this.getSelectionKeys() != null) {
            DB.createT_Selection(this.getAD_PInstance_ID(), this.getSelectionKeys(), this.getTransactionName());
        }
    }

    private void saveSelectionValues() {
        if (this.isSelection() && this.getAD_PInstance_ID() > 0 && this.getSelectionKeys() != null && this.getSelectionValues() != null) {
            DB.createT_Selection_Browse(this.getAD_PInstance_ID(), this.getSelectionValues(), this.getTransactionName());
        }
    }

    public List<?> getInstancesForSelection(String trxName) throws AdempiereException {
        return PO.getInstances(this.getTableSelectionId(), this.getSelectionKeys(), trxName);
    }

    public PO getInstance(String trxName) throws AdempiereException {
        if (this.tableId <= 0) {
            throw new AdempiereException("@AD_Table_ID@  @NotFound@");
        }
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@NoRecordID@");
        }
        MTable table2 = MTable.get(Env.getCtx(), this.tableId);
        return table2.getPO(this.getRecord_ID(), trxName);
    }

    public LinkedHashMap<Integer, LinkedHashMap<String, Object>> getSelectionValues() {
        return this.selection;
    }

    public void addLog(int Log_ID, int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg) {
        this.addLog(new ProcessInfoLog(Log_ID, P_ID, P_Date, P_Number, P_Msg));
    }

    public void addLog(int P_ID, Timestamp P_Date, BigDecimal P_Number, String P_Msg) {
        this.addLog(new ProcessInfoLog(P_ID, P_Date, P_Number, P_Msg));
    }

    public void addLog(ProcessInfoLog logEntry) {
        if (logEntry == null) {
            return;
        }
        if (this.logs == null) {
            this.logs = new ArrayList();
        }
        this.logs.add(logEntry);
    }

    public ProcessInfoLog[] getLogs() {
        if (this.logs == null) {
            return null;
        }
        ProcessInfoLog[] processInfoLogs = new ProcessInfoLog[this.logs.size()];
        this.logs.toArray(processInfoLogs);
        return processInfoLogs;
    }

    public int[] getIDs() {
        if (this.logs == null) {
            return null;
        }
        int[] ids = new int[this.logs.size()];
        for (int i2 = 0; i2 < this.logs.size(); ++i2) {
            ids[i2] = this.logs.get(i2).getP_ID();
        }
        return ids;
    }

    public ArrayList<ProcessInfoLog> getLogList() {
        return this.logs;
    }

    public void setLogList(ArrayList<ProcessInfoLog> logs) {
        this.logs = logs;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String trxName) {
        this.transactionName = trxName;
    }

    public void setPrintPreview(boolean printPreview) {
        this.printPreview = printPreview;
    }

    public boolean isPrintPreview() {
        return this.printPreview;
    }

    public boolean isReportingProcess() {
        return this.reportingProcess;
    }

    public void setReportingProcess(boolean reportingProcess) {
        this.reportingProcess = reportingProcess;
    }

    public void setPDFReport(File pdfFile) {
        this.pdfReportFile = pdfFile;
    }

    public File getPDFReport() {
        return this.pdfReportFile;
    }

    public void setReportAsFile(File reportAsFile) {
        this.reportAsFile = reportAsFile;
    }

    public File getReportAsFile() {
        return this.reportAsFile;
    }

    public void addParameter(String name, Object value, String info) {
        if (value == null) {
            return;
        }
        if (value instanceof String && Util.isEmpty((String)value)) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = new Hashtable();
        }
        ProcessInfoParameter parameter = new ProcessInfoParameter(name, value, null, info, null);
        this.parameters.put(name, parameter);
    }

    public Integer getAD_Org_ID() {
        if (this.orgId == -1) {
            return Env.getAD_Org_ID(Env.getCtx());
        }
        return this.orgId;
    }

    public void setAD_Org_ID(int orgId) {
        this.orgId = new Integer(orgId);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable t) {
        this.throwable = t;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public void setManagedTransaction(boolean managedTransaction) {
        this.managedTransaction = managedTransaction;
    }

    public boolean isManagedTransaction() {
        return this.managedTransaction;
    }

    public ProcessInfoParameter getInfoParameter(String parameterName) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(parameterName);
    }

    public Object getParameter(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameter();
    }

    public BigDecimal getParameterAsBigDecimal(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterAsBigDecimal();
    }

    public boolean getParameterAsBoolean(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return false;
        }
        return parameter.getParameterAsBoolean();
    }

    public int getParameterAsInt(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return 0;
        }
        return parameter.getParameterAsInt();
    }

    public String getParameterAsString(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterAsString();
    }

    public Timestamp getParameterAsTimestamp(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterAsTimestamp();
    }

    public Object getParameterTo(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameter_To();
    }

    public BigDecimal getParameterToAsBigDecimal(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterToAsBigDecimal();
    }

    public boolean getParameterToAsBoolean(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return false;
        }
        return parameter.getParameter_ToAsBoolean();
    }

    public int getParameterToAsInt(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return 0;
        }
        return parameter.getParameter_ToAsInt();
    }

    public String getParameterToAsString(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterToAsString();
    }

    public Timestamp getParameterToAsTimestamp(String parameterName) {
        ProcessInfoParameter parameter = this.getInfoParameter(parameterName);
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterToAsTimestamp();
    }

    public Object getSelection(int key, String columnName) {
        LinkedHashMap<String, Object> record;
        if (this.selection != null && (record = this.selection.get(key)) != null) {
            return record.get(columnName);
        }
        return null;
    }

    public BigDecimal getSelectionAsBigDecimal(int key, String columnName) {
        Object retValue = this.getSelection(key, columnName);
        if (retValue == null) {
            return null;
        }
        if (retValue instanceof BigDecimal) {
            return (BigDecimal)retValue;
        }
        return null;
    }

    public boolean getSelectionAsBoolean(int key, String columnName) {
        Object retValue = this.getSelection(key, columnName);
        if (retValue == null) {
            return false;
        }
        if (retValue instanceof Boolean) {
            return (Boolean)retValue;
        }
        if (retValue instanceof String) {
            return "Y".equals(retValue);
        }
        return false;
    }

    public int getSelectionAsInt(int key, String columnName) {
        Object retValue = this.getSelection(key, columnName);
        if (retValue == null) {
            return 0;
        }
        if (retValue instanceof Number) {
            return ((Number)retValue).intValue();
        }
        return 0;
    }

    public String getSelectionAsString(int key, String columnName) {
        Object retValue = this.getSelection(key, columnName);
        if (retValue == null) {
            return null;
        }
        if (retValue instanceof String) {
            return (String)retValue;
        }
        return null;
    }

    public Timestamp getSelectionAsTimestamp(int key, String columnName) {
        Object retValue = this.getSelection(key, columnName);
        if (retValue == null) {
            return null;
        }
        if (retValue instanceof Timestamp) {
            return (Timestamp)retValue;
        }
        return null;
    }

    public String getTableName() {
        return MTable.getTableName(Env.getCtx(), this.getTable_ID());
    }

    public String getTableNameSelection() {
        return MTable.getTableName(Env.getCtx(), this.getTableSelectionId());
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    public String getReportType() {
        return this.reportType;
    }

    public String getDrillSource() {
        return this.drillSource;
    }

    public void setDrillSource(String drillSource) {
        this.drillSource = drillSource;
    }

    public void openResult(String tableName) {
        this.resultTableName = tableName;
    }

    public String getResultTableName() {
        return this.resultTableName;
    }

    public boolean isOpenResult() {
        return !Util.isEmpty(this.getResultTableName());
    }

    public String getInterfaceType() {
        if (this.interfaceType == null || this.interfaceType.isEmpty()) {
            this.interfaceType = INTERFACE_TYPE_NOT_SET;
        }
        return this.interfaceType;
    }

    public void setInterfaceType(String uiType) {
        if (!(uiType.equals(INTERFACE_TYPE_NOT_SET) || uiType.equals(INTERFACE_TYPE_ZK) || uiType.equals(INTERFACE_TYPE_SWING))) {
            throw new IllegalArgumentException("Unknown interface type " + uiType);
        }
        this.interfaceType = uiType;
    }
}

