/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.process.PSCreateFromOrderAbstract;
import org.compiere.util.Env;

public class PSCreateFromOrder
extends PSCreateFromOrderAbstract {
    private int m_SeqNo = 10;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@C_PaySelection_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        MPaySelection paySelection = new MPaySelection(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.m_SeqNo = paySelection.getLastLineNo();
        for (Integer key : this.getSelectionKeys()) {
            int C_Order_ID = key;
            String PaymentRule = this.getSelectionAsString(key, "ORD_PaymentRule");
            BigDecimal GrandTotal = this.getSelectionAsBigDecimal(key, "ORD_GrandTotal");
            BigDecimal ConvertedAmt = this.getSelectionAsBigDecimal(key, "ORD_ConvertedAmt");
            BigDecimal PayAmt = this.getSelectionAsBigDecimal(key, "ORD_PayAmt");
            this.m_SeqNo += 10;
            MPaySelectionLine line = new MPaySelectionLine(paySelection, this.m_SeqNo, PaymentRule);
            line.setOrder(C_Order_ID, GrandTotal, ConvertedAmt, PayAmt, Env.ZERO);
            line.saveEx();
        }
        return "@OK@";
    }
}

