/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.process.OrderBatchProcessAbstract;
import org.compiere.util.Trx;

public class OrderBatchProcess
extends OrderBatchProcessAbstract {
    private int counter = 0;
    private int errCounter = 0;

    @Override
    protected String doIt() throws Exception {
        this.getSelectionKeys().stream().forEach(orderId -> this.process((int)orderId));
        return "@Updated@=" + this.counter + ", @Errors@=" + this.errCounter;
    }

    private boolean process(int orderId) {
        try {
            Trx.run(trxName -> {
                MOrder order = new MOrder(this.getCtx(), orderId, trxName);
                this.log.info(order.toString());
                order.setDocAction(this.getDocAction());
                if (!order.processIt(this.getDocAction())) {
                    this.addLog(0, null, null, order.getDocumentNo() + ": @Error@ " + order.getProcessMsg());
                    throw new AdempiereException(order.getDocumentNo() + ": @Error@ " + order.getProcessMsg());
                }
                order.saveEx();
                this.addLog(0, null, null, order.getDocumentNo() + ": @OK@");
            });
            ++this.counter;
        }
        catch (Exception e) {
            ++this.errCounter;
            this.addLog(e.getMessage());
            this.log.warning(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

