/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.io.FileUtils;
import org.compiere.model.MMigration;
import org.compiere.process.MigrationApply;
import org.compiere.process.MigrationFromXMLAbstract;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrationFromXML
extends MigrationFromXMLAbstract {
    private DocumentBuilder builder;
    private Boolean success = false;
    public Comparator<File> fileComparator = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareToIgnoreCase(f2.getName());
        }
    };

    @Override
    protected String doIt() throws Exception {
        if (Ini.isPropertyBool("LogMigrationScript")) {
            this.addLog(Msg.getMsg(this.getCtx(), "LogMigrationScriptFlagIsSetMessage"));
            return "@Error@" + Msg.getMsg(this.getCtx(), "LogMigrationScriptFlagIsSet");
        }
        this.loadXML();
        return "Import complete";
    }

    static String readFile(File file, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        return new String(encoded, encoding);
    }

    private void loadXML() {
        block7: {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringElementContentWhitespace(true);
            File file = new File(this.getFilePathOrName());
            try {
                XMLUtils.setDefaultFeatures(dbf);
                this.builder = dbf.newDocumentBuilder();
                List<File> migrationFiles = new ArrayList<File>();
                if (!file.exists()) {
                    this.log.log(Level.WARNING, "No file or directory found");
                    return;
                }
                if (file.isDirectory()) {
                    this.log.log(Level.CONFIG, "Processing migration files in directory: " + file.getAbsolutePath());
                    migrationFiles = (List)FileUtils.listFiles((File)file, (String[])new String[]{"xml"}, (boolean)true);
                    Collections.sort(migrationFiles, this.fileComparator);
                } else {
                    this.log.log(Level.CONFIG, "Processing migration file: " + file.getAbsolutePath());
                    migrationFiles.add(file);
                }
                this.success = true;
                for (File migFile : migrationFiles) {
                    this.loadFile(migFile);
                    if (this.success.booleanValue()) continue;
                    break;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
            catch (AdempiereException e) {
                if (this.isForce()) break block7;
                throw new AdempiereException("Loading Migration from XML failed.", e);
            }
        }
    }

    private void loadFile(File file) throws SAXException, IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.getName().endsWith(".xml")) {
            return;
        }
        if (file.getName().equals("build.xml")) {
            return;
        }
        this.log.log(Level.CONFIG, "Loading file: " + file);
        Document doc = this.builder.parse(file);
        NodeList migrations = doc.getDocumentElement().getElementsByTagName("Migration");
        for (int i2 = 0; i2 < migrations.getLength(); ++i2) {
            Element element = (Element)migrations.item(i2);
            Trx.run(trxName -> {
                Properties ctx = Env.getCtx();
                try {
                    MMigration migration = MMigration.fromXmlNode(ctx, element, trxName);
                    if (migration == null) {
                        this.log.log(Level.INFO, "XML file not a Migration. Skipping.");
                        return;
                    }
                    if (this.isApply()) {
                        if ("A".equals(migration.getStatusCode())) {
                            this.log.log(Level.INFO, migration.toString() + " ---> Migration already applied - skipping.");
                            return;
                        }
                        if ("F".equals(migration.getStatusCode()) || "P".equals(migration.getStatusCode())) {
                            this.log.log(Level.INFO, migration.toString() + " ---> Migration exists but has to be rolled back.");
                            this.applyMigration(migration.getCtx(), migration.getAD_Migration_ID(), trxName);
                        }
                        this.applyMigration(migration.getCtx(), migration.getAD_Migration_ID(), trxName);
                    }
                }
                catch (SQLException | AdempiereException e) {
                    if (!this.isForce()) {
                        throw new AdempiereException("Loading migration from " + file.toString() + " failed.", e);
                    }
                    this.log.log(Level.SEVERE, e.getLocalizedMessage());
                }
            });
        }
    }

    private void applyMigration(Properties ctx, int migrationId, String trxName) throws AdempiereException {
        ProcessInfo processInfo = ProcessBuilder.create(ctx).process(MigrationApply.getProcessId()).withTitle("Apply migration").withRecordId(MMigration.Table_ID, migrationId).withParameter("FailOnError", true).withParameter("IsForce", this.isForce()).execute(trxName);
        this.log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
    }
}

