/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.model.Query;
import org.compiere.process.M_PriceList_CreateAbstract;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class M_PriceList_Create
extends M_PriceList_CreateAbstract {
    private MPriceListVersion priceListVersion;
    private MPriceList priceList;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getParameterAsInt("PriceList_Version_ID") != 0) {
            this.priceListVersion = new MPriceListVersion(this.getCtx(), this.getParameterAsInt("PriceList_Version_ID"), this.get_TrxName());
        } else if (this.getRecord_ID() != 0) {
            this.priceListVersion = new MPriceListVersion(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        }
        if (this.priceListVersion == null) {
            throw new AdempiereException("@PriceList_Version_ID@ @NotFound@");
        }
        this.priceList = MPriceList.get(this.getCtx(), this.priceListVersion.getM_PriceList_ID(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        int cntu = 0;
        int cntd = 0;
        int totu = 0;
        int toti = 0;
        int totd = 0;
        String message = " ";
        String sqlupd = "UPDATE M_Product_PO  SET\tPriceList = 0   WHERE\tPriceList IS NULL ";
        cntu = DB.executeUpdate(sqlupd, this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update The PriceList to zero of M_Product_PO WHERE\tPriceList IS NULL", sqlupd);
        }
        totu += cntu;
        this.log.fine("Updated " + cntu);
        sqlupd = "UPDATE M_Product_PO  SET\tPriceLastPO = 0   WHERE\tPriceLastPO IS NULL ";
        cntu = DB.executeUpdate(sqlupd, this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  The PriceListPO to zero of  M_Product_PO WHERE\tPriceLastPO IS NULL", sqlupd);
        }
        totu += cntu;
        this.log.fine("Updated " + cntu);
        sqlupd = "UPDATE M_Product_PO  SET\t    PricePO = PriceLastPO   WHERE\t(PricePO IS NULL OR PricePO = 0) AND PriceLastPO <> 0 ";
        cntu = DB.executeUpdate(sqlupd, this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  The PricePO to PriceLastPO of  M_Product_PO WHERE\t(PricePO IS NULL OR PricePO = 0) AND PriceLastPO <> 0 ", sqlupd);
        }
        totu += cntu;
        this.log.fine("Updated " + cntu);
        sqlupd = "UPDATE M_Product_PO  SET\t    PricePO = 0   WHERE\tPricePO IS NULL ";
        cntu = DB.executeUpdate(sqlupd, this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  The PricePO to Zero of  M_Product_PO WHERE\tPricePO IS NULL", sqlupd);
        }
        totu += cntu;
        this.log.fine("Updated " + cntu);
        sqlupd = "UPDATE M_Product_PO  SET\t     IsCurrentVendor = 'Y'   WHERE\t IsCurrentVendor = 'N'  AND NOT   EXISTS  (SELECT   pp.M_Product_ID   FROM     M_Product_PO pp   WHERE    pp.M_Product_ID = M_Product_PO.M_Product_ID  GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1) ";
        cntu = DB.executeUpdate(sqlupd, this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  IsCurrentVendor to Y of  M_Product_PO ", sqlupd);
        }
        totu += cntu;
        this.log.fine("Updated " + cntu);
        String sql = "SELECT DISTINCT M_Product_ID FROM M_Product_PO po  WHERE\t IsCurrentVendor='Y' AND IsActive='Y'    AND    EXISTS (SELECT   M_Product_ID  FROM     M_Product_PO x   WHERE    x.M_Product_ID=po.M_Product_ID    AND    IsCurrentVendor='Y' AND IsActive='Y'  GROUP BY M_Product_ID  HAVING COUNT(*) > 1 ) ";
        CPreparedStatement Cur_Duplicates = null;
        Cur_Duplicates = DB.prepareStatement(sql, this.get_TrxName());
        ResultSet dupl = Cur_Duplicates.executeQuery();
        while (dupl.next()) {
            sql = "SELECT\tM_Product_ID         ,C_BPartner_ID  FROM\tM_Product_PO  WHERE\tIsCurrentVendor = 'Y'   AND     IsActive        = 'Y'  AND\tM_Product_ID    = " + dupl.getInt("M_Product_ID") + " ORDER BY PriceList DESC";
            CPreparedStatement Cur_Vendors = null;
            Cur_Vendors = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet Vend = Cur_Vendors.executeQuery();
            Vend.next();
            while (Vend.next()) {
                sqlupd = "UPDATE M_Product_PO  SET\tIsCurrentVendor = 'N'   WHERE\tM_Product_ID= " + Vend.getInt("M_Product_ID") + " AND     C_BPartner_ID= " + Vend.getInt("C_BPartner_ID");
                cntu = DB.executeUpdate(sqlupd, this.get_TrxName());
                if (cntu == -1) {
                    this.raiseError("Update  IsCurrentVendor to N of  M_Product_PO for a M_Product_ID and C_BPartner_ID ingresed", sqlupd);
                }
                totu += cntu;
                this.log.fine("Updated " + cntu);
            }
            Vend.close();
            Cur_Vendors.close();
            Cur_Vendors = null;
        }
        this.log.fine("Total Updated " + totu);
        this.log.fine("Total Insert " + toti);
        this.log.fine("Total Updated " + totu);
        dupl.close();
        Cur_Duplicates.close();
        Cur_Duplicates = null;
        if (this.isDeleteOld()) {
            String sqldel = "DELETE M_ProductPrice  WHERE\tM_PriceList_Version_ID = " + this.priceListVersion.getM_PriceList_Version_ID();
            cntd = DB.executeUpdate(sqldel, this.get_TrxName());
            if (cntd == -1) {
                this.raiseError(" DELETE\tM_ProductPrice ", sqldel);
            }
            message = "@Deleted@=" + cntd + " - ";
            this.log.fine("Deleted " + cntd);
            this.log.fine(message + ": Total Deleted " + (totd += cntd));
        }
        HashMap combinationMap = new HashMap();
        HashMap conversionRateMap = new HashMap();
        StringBuffer whereClause = new StringBuffer("M_DiscountSchema_ID = ?");
        List<MDiscountSchemaLine> discountSchemaLineList = new Query(this.getCtx(), "M_DiscountSchemaLine", whereClause.toString(), this.get_TrxName()).setParameters(this.priceListVersion.getM_DiscountSchema_ID()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        if (this.priceListVersion.getM_Pricelist_Version_Base_ID() == 0) {
            discountSchemaLineList.forEach(discountSchemaLine -> {
                ArrayList<Object> parameters = new ArrayList<Object>();
                StringBuffer querywhereClause = new StringBuffer("IsCurrentVendor = 'Y'");
                if (discountSchemaLine.getC_BPartner_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("C_BPartner_ID = ?");
                    parameters.add(discountSchemaLine.getC_BPartner_ID());
                }
                if (discountSchemaLine.getM_Product_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("M_Product_ID = ?");
                    parameters.add(discountSchemaLine.getM_Product_ID());
                }
                if (discountSchemaLine.getM_Product_Category_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_Product_PO.M_Product_ID AND p.M_Product_Category_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Category_ID());
                }
                if (discountSchemaLine.getM_Product_Group_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_Product_PO.M_Product_ID AND p.M_Product_Group_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Group_ID());
                }
                if (discountSchemaLine.getM_Product_Class_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_Product_PO.M_Product_ID AND p.M_Product_Class_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Class_ID());
                }
                if (discountSchemaLine.getM_Product_Classification_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_Product_PO.M_Product_ID AND p.M_Product_Classification_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Classification_ID());
                }
                new Query(this.getCtx(), "M_Product_PO", querywhereClause.toString(), this.get_TrxName()).setParameters(parameters).list().forEach(productPurchasing -> {
                    String conversionRateKey = discountSchemaLine.getC_ConversionType_ID() + "|" + productPurchasing.getC_Currency_ID() + "|" + this.priceList.getC_Currency_ID();
                    BigDecimal conversionRate = null;
                    if (!conversionRateMap.containsKey(conversionRateKey)) {
                        conversionRate = MConversionRate.getRate(productPurchasing.getC_Currency_ID(), this.priceList.getC_Currency_ID(), this.priceListVersion.getValidFrom(), discountSchemaLine.getC_ConversionType_ID(), this.getAD_Client_ID(), this.priceListVersion.getAD_Org_ID());
                        if (conversionRate == null) {
                            conversionRate = Env.ZERO;
                        }
                        conversionRateMap.put(conversionRateKey, conversionRate);
                    } else {
                        conversionRate = (BigDecimal)conversionRateMap.get(conversionRateKey);
                    }
                    combinationMap.put(productPurchasing.getM_Product_ID(), new ProductCombination(productPurchasing.getM_Product_ID(), conversionRate, productPurchasing.getPriceList(), productPurchasing.getPriceList(), productPurchasing.getPricePO(), (MDiscountSchemaLine)discountSchemaLine));
                });
            });
        } else {
            MPriceList basePriceList = MPriceList.get(this.getCtx(), this.priceListVersion.getM_Pricelist_Version_Base().getM_PriceList_ID(), this.get_TrxName());
            discountSchemaLineList.forEach(discountSchemaLine -> {
                ArrayList<Object> parameters = new ArrayList<Object>();
                StringBuffer querywhereClause = new StringBuffer();
                querywhereClause = new StringBuffer("M_PriceList_Version_ID = ?");
                parameters.add(this.priceListVersion.getM_Pricelist_Version_Base_ID());
                if (discountSchemaLine.getM_Product_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("M_Product_ID = ?");
                    parameters.add(discountSchemaLine.getM_Product_ID());
                }
                if (discountSchemaLine.getM_Product_Category_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_ProductPrice.M_Product_ID AND p.M_Product_Category_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Category_ID());
                }
                if (discountSchemaLine.getM_Product_Group_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_ProductPrice.M_Product_ID AND p.M_Product_Group_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Group_ID());
                }
                if (discountSchemaLine.getM_Product_Class_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_ProductPrice.M_Product_ID AND p.M_Product_Class_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Class_ID());
                }
                if (discountSchemaLine.getM_Product_Classification_ID() != 0) {
                    if (querywhereClause.length() > 0) {
                        querywhereClause.append(" AND ");
                    }
                    querywhereClause.append("EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_ProductPrice.M_Product_ID AND p.M_Product_Classification_ID = ?)");
                    parameters.add(discountSchemaLine.getM_Product_Classification_ID());
                }
                new Query(this.getCtx(), "M_ProductPrice", querywhereClause.toString(), this.get_TrxName()).setParameters(parameters).list().forEach(productPrice -> {
                    String conversionRateKey = discountSchemaLine.getC_ConversionType_ID() + "|" + basePriceList.getC_Currency_ID() + "|" + this.priceList.getC_Currency_ID();
                    BigDecimal conversionRate = null;
                    if (!conversionRateMap.containsKey(conversionRateKey)) {
                        conversionRate = MConversionRate.getRate(basePriceList.getC_Currency_ID(), this.priceList.getC_Currency_ID(), this.priceListVersion.getValidFrom(), discountSchemaLine.getC_ConversionType_ID(), this.getAD_Client_ID(), this.priceListVersion.getAD_Org_ID());
                        if (conversionRate == null) {
                            conversionRate = Env.ZERO;
                        }
                        conversionRateMap.put(conversionRateKey, conversionRate);
                    } else {
                        conversionRate = (BigDecimal)conversionRateMap.get(conversionRateKey);
                    }
                    combinationMap.put(productPrice.getM_Product_ID(), new ProductCombination(productPrice.getM_Product_ID(), conversionRate, productPrice.getPriceList(), productPrice.getPriceStd(), productPrice.getPriceLimit(), (MDiscountSchemaLine)discountSchemaLine));
                });
            });
        }
        combinationMap.values().forEach(combination -> combination.calculate().save(this.priceListVersion));
        return "OK";
    }

    private void raiseError(String string, String sql) throws Exception {
        String msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = msg + sql;
        throw new AdempiereUserError(msg);
    }

    private class ProductCombination {
        private int productId;
        private BigDecimal priceStandard;
        private BigDecimal priceList;
        private BigDecimal priceLimit;
        private MDiscountSchemaLine discountSchemaLine;
        private BigDecimal conversionRate = Env.ZERO;
        private BigDecimal calculatedPriceStandard = Env.ZERO;
        private BigDecimal calculatedPriceList = Env.ZERO;
        private BigDecimal calculatedPriceLimit = Env.ZERO;

        public ProductCombination(int productId, BigDecimal conversionRate, BigDecimal priceStandard, BigDecimal priceList, BigDecimal priceLimit, MDiscountSchemaLine discountSchemaLine) {
            this.productId = productId;
            this.conversionRate = conversionRate;
            this.priceStandard = priceStandard == null ? Env.ZERO : priceStandard;
            this.priceList = priceList == null ? Env.ZERO : priceList;
            this.priceLimit = priceLimit == null ? Env.ZERO : priceLimit;
            this.discountSchemaLine = discountSchemaLine;
        }

        public ProductCombination calculate() {
            BigDecimal listAddAmt = this.getDiscountSchemaLine().getList_AddAmt();
            BigDecimal listDiscount = this.getDiscountSchemaLine().getList_Discount();
            BigDecimal stdAddAmt = this.getDiscountSchemaLine().getStd_AddAmt();
            BigDecimal stdDiscount = this.getDiscountSchemaLine().getStd_Discount();
            BigDecimal limitAddAmt = this.getDiscountSchemaLine().getLimit_AddAmt();
            BigDecimal limitDiscount = this.getDiscountSchemaLine().getLimit_Discount();
            this.calculatedPriceList = this.getDiscountSchemaLine().getList_Base().equals("S") ? this.getPriceStandard() : (this.getDiscountSchemaLine().getList_Base().equals("X") ? this.getPriceLimit() : this.getPriceList());
            this.calculatedPriceList = this.calculatedPriceList.multiply(this.getConversionRate());
            this.calculatedPriceList = this.calculatedPriceList.add(listAddAmt);
            this.calculatedPriceList = this.calculatedPriceList.multiply(Env.ONE.subtract(listDiscount.divide(Env.ONEHUNDRED)));
            this.calculatedPriceStandard = this.getDiscountSchemaLine().getStd_Base().equals("L") ? this.getPriceList() : (this.getDiscountSchemaLine().getStd_Base().equals("X") ? this.getPriceLimit() : this.getPriceStandard());
            this.calculatedPriceStandard = this.calculatedPriceStandard.multiply(this.getConversionRate());
            this.calculatedPriceStandard = this.calculatedPriceStandard.add(stdAddAmt);
            this.calculatedPriceStandard = this.calculatedPriceStandard.multiply(Env.ONE.subtract(stdDiscount.divide(Env.ONEHUNDRED)));
            this.calculatedPriceLimit = this.getDiscountSchemaLine().getLimit_Base().equals("L") ? this.getPriceList() : (this.getDiscountSchemaLine().getLimit_Base().equals("S") ? this.getPriceStandard() : this.getPriceLimit());
            this.calculatedPriceLimit = this.calculatedPriceLimit.multiply(this.getConversionRate());
            this.calculatedPriceLimit = this.calculatedPriceLimit.add(limitAddAmt);
            this.calculatedPriceLimit = this.calculatedPriceLimit.multiply(Env.ONE.subtract(limitDiscount.divide(Env.ONEHUNDRED)));
            return this;
        }

        public boolean save(MPriceListVersion priceListVersion) {
            try {
                MProductPrice productPrice = null;
                if (!M_PriceList_Create.this.isDeleteOld()) {
                    productPrice = MProductPrice.get(M_PriceList_Create.this.getCtx(), priceListVersion.getM_PriceList_Version_ID(), this.getProductId(), M_PriceList_Create.this.get_TrxName());
                }
                if (productPrice != null) {
                    productPrice.setPrices(this.getCalculatedPriceList(), this.getCalculatedPriceStandard(), this.getCalculatedPriceLimit());
                } else {
                    productPrice = new MProductPrice(priceListVersion, this.getProductId(), this.getCalculatedPriceList(), this.getCalculatedPriceStandard(), this.getCalculatedPriceLimit());
                }
                productPrice.saveEx();
            }
            catch (Exception e) {
                M_PriceList_Create.this.log.severe(e.getLocalizedMessage());
            }
            return true;
        }

        public final int getProductId() {
            return this.productId;
        }

        public final MDiscountSchemaLine getDiscountSchemaLine() {
            return this.discountSchemaLine;
        }

        public final BigDecimal getPriceStandard() {
            return this.priceStandard;
        }

        public final BigDecimal getPriceList() {
            return this.priceList;
        }

        public final BigDecimal getPriceLimit() {
            return this.priceLimit;
        }

        public final BigDecimal getCalculatedPriceStandard() {
            return this.calculatedPriceStandard;
        }

        public final BigDecimal getCalculatedPriceList() {
            return this.calculatedPriceList;
        }

        public final BigDecimal getCalculatedPriceLimit() {
            return this.calculatedPriceLimit;
        }

        public final BigDecimal getConversionRate() {
            return this.conversionRate;
        }

        public String toString() {
            return "ProductCombination [productId=" + this.productId + ", priceStandard=" + this.priceStandard + ", priceList=" + this.priceList + ", priceLimit=" + this.priceLimit + ", discountSchemaLine=" + this.discountSchemaLine + ", conversionRate=" + this.conversionRate + ", calculatedPriceStandard=" + this.calculatedPriceStandard + ", calculatedPriceList=" + this.calculatedPriceList + ", calculatedPriceLimit=" + this.calculatedPriceLimit + "]";
        }
    }
}

