/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.eevolution.model.MTaxGroup;

public class InvoiceGenerate_1
extends SvrProcess {
    private boolean p_Selection = false;
    private Timestamp p_DateInvoiced = null;
    private int p_AD_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_Order_ID = 0;
    private boolean p_ConsolidateDocument = false;
    private String p_docAction = "CO";
    private MInvoice invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    private boolean invoiceCompleted = false;
    private String invoiceTrxName;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
        if (!"CO".equals(this.p_docAction)) {
            this.p_docAction = "PR";
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.p_Selection + ", DateInvoiced=" + this.p_DateInvoiced + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_Order_ID=" + this.p_C_Order_ID + ", DocAction=" + this.p_docAction + ", Consolidate=" + this.p_ConsolidateDocument);
        String sql = null;
        if (this.p_Selection) {
            sql = "SELECT C_Order.* FROM C_Order, T_Selection WHERE C_Order.DocStatus='CO' AND C_Order.IsSOTrx='Y' AND C_Order.C_Order_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ORDER BY C_Order.C_BPartner_ID, C_Order.UY_ViaLoan_ID, C_Order.M_Warehouse_ID, C_Order.PriorityRule, C_Order.Bill_Location_ID, C_Order.C_Order_ID";
        } else {
            sql = "SELECT * FROM C_Order o WHERE DocStatus IN('CO','CL') AND IsSOTrx='Y'";
            if (this.p_AD_Org_ID != 0) {
                sql = sql + " AND AD_Org_ID=?";
            }
            if (this.p_C_BPartner_ID != 0) {
                sql = sql + " AND C_BPartner_ID=?";
            }
            if (this.p_C_Order_ID != 0) {
                sql = sql + " AND C_Order_ID=?";
            }
            sql = sql + " AND EXISTS (SELECT * FROM C_OrderLine ol WHERE o.C_Order_ID=ol.C_Order_ID AND ol.QtyOrdered<>ol.QtyInvoiced) AND o.C_DocType_ID IN (SELECT C_DocType_ID FROM C_DocType WHERE DocBaseType='SOO' AND DocSubTypeSO NOT IN ('ON','OB','WR')) ORDER BY M_Warehouse_ID, PriorityRule, C_BPartner_ID, Bill_Location_ID, C_Order_ID";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            int index = 1;
            if (this.p_Selection) {
                pstmt.setInt(index, this.getAD_PInstance_ID());
            } else {
                if (this.p_AD_Org_ID != 0) {
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                }
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
                if (this.p_C_Order_ID != 0) {
                    pstmt.setInt(index++, this.p_C_Order_ID);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return this.generate(pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.invoiceTrxName = Trx.createTrxName();
                Trx trxAux = Trx.get(this.invoiceTrxName, true);
                try {
                    MInOutLine[] shipLines;
                    MInOut ship;
                    int i;
                    MInOut[] shipments;
                    MOrder order = new MOrder(this.getCtx(), rs, this.invoiceTrxName);
                    boolean completeOrder = "O".equals(order.getInvoiceRule());
                    boolean doInvoice = false;
                    if ("S".equals(order.getInvoiceRule())) {
                        this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                        if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                            this.log.warning("BPartner has no Schedule - set to After Delivery");
                            order.setInvoiceRule("D");
                            order.saveEx();
                        } else {
                            MInvoiceSchedule is = MInvoiceSchedule.get(this.getCtx(), this.m_bp.getC_InvoiceSchedule_ID(), this.invoiceTrxName);
                            if (!is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) continue;
                            doInvoice = true;
                        }
                    }
                    if (doInvoice || "D".equals(order.getInvoiceRule())) {
                        shipments = order.getShipments();
                        for (i = 0; i < shipments.length; ++i) {
                            ship = shipments[i];
                            if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                            shipLines = ship.getLines(false);
                            for (int j = 0; j < shipLines.length; ++j) {
                                MInOutLine shipLine = shipLines[j];
                                if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                                this.createLine(order, ship, shipLine);
                            }
                            this.m_line += 1000;
                        }
                    } else {
                        MOrderLine[] oLines = order.getLines(true, null);
                        for (i = 0; i < oLines.length; ++i) {
                            boolean fullyDelivered;
                            MOrderLine oLine = oLines[i];
                            BigDecimal toInvoice = oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced());
                            if (toInvoice.compareTo(Env.ZERO) == 0 && oLine.getM_Product_ID() != 0) continue;
                            BigDecimal notInvoicedShipment = oLine.getQtyDelivered().subtract(oLine.getQtyInvoiced());
                            boolean bl = fullyDelivered = oLine.getQtyOrdered().compareTo(oLine.getQtyDelivered()) == 0;
                            if (completeOrder && !fullyDelivered) {
                                this.log.fine("Failed CompleteOrder - " + oLine);
                                this.addLog("Failed CompleteOrder - " + oLine);
                                completeOrder = false;
                                break;
                            }
                            if ("I".equals(order.getInvoiceRule())) {
                                this.log.fine("Immediate - ToInvoice=" + toInvoice + " - " + oLine);
                                BigDecimal qtyEntered = toInvoice;
                                if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                                    qtyEntered = toInvoice.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4);
                                }
                                this.createLine(order, oLine, toInvoice, qtyEntered);
                                continue;
                            }
                            this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                            this.addLog("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                        }
                        if ("I".equals(order.getInvoiceRule())) {
                            this.m_line += 1000;
                        }
                    }
                    if (completeOrder && "O".equals(order.getInvoiceRule())) {
                        shipments = order.getShipments();
                        for (i = 0; i < shipments.length; ++i) {
                            ship = shipments[i];
                            if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                            shipLines = ship.getLines(false);
                            for (int j = 0; j < shipLines.length; ++j) {
                                MInOutLine shipLine = shipLines[j];
                                if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                                this.createLine(order, ship, shipLine);
                            }
                            this.m_line += 1000;
                        }
                    }
                    if (!this.p_ConsolidateDocument || this.invoice != null && this.invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID()) {
                        this.completeInvoice();
                    }
                    if (!this.invoiceCompleted) {
                        trxAux.rollback();
                    }
                    trxAux.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    trxAux.rollback();
                    trxAux.close();
                    this.invoice = null;
                    this.m_ship = null;
                    this.m_line = 0;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            throw new AdempiereException(e.getMessage());
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.completeInvoice();
        return "@Created@ = " + this.m_created;
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.invoice == null) {
            if (order.getBill_Location_ID() <= 0) {
                throw new AdempiereException("La cuota Nro. " + order.getDocumentNo() + " no tiene direccion definida, reactive la misma y defina la direccion.");
            }
            MBPartner partner = (MBPartner)order.getC_BPartner();
            int docID = 1000002;
            int docCFE = 0;
            String sql = "select ad_table_id from ad_table where lower(tablename) like 'luy_cfetype'";
            int tableID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (tableID > 0 && partner.getC_TaxGroup_ID() > 0) {
                MTaxGroup tg = (MTaxGroup)partner.getC_TaxGroup();
                if (tg.getValue().equalsIgnoreCase("RUT")) {
                    sql = "select c_doctype_id from luy_cfetype where cfetype = '111'";
                    docCFE = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
                    if (docCFE > 0) {
                        docID = docCFE;
                    }
                } else {
                    sql = "select c_doctype_id from luy_cfetype where cfetype = '101'";
                    docCFE = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
                    if (docCFE > 0) {
                        docID = docCFE;
                    }
                }
            }
            this.invoice = new MInvoice(order, docID, this.p_DateInvoiced);
            if (order.get_ValueAsInt("UY_ViaLoan_ID") > 0) {
                this.invoice.set_ValueOfColumn("UY_ViaLoan_ID", (Object)order.get_ValueAsInt("UY_ViaLoan_ID"));
            }
            if (!this.invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (o)");
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        line.setLine(this.m_line + orderLine.getLine());
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (o)");
        }
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.invoice == null) {
            this.invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            if (order.get_ValueAsInt("UY_ViaLoan_ID") > 0) {
                this.invoice.set_ValueOfColumn("UY_ViaLoan_ID", (Object)order.get_ValueAsInt("UY_ViaLoan_ID"));
            }
            if (!this.invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (s)");
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        String toBeInvoiced = sLine.get_ValueAsString("ToBeInvoiced");
        if ("N".equals(toBeInvoiced)) {
            line.setPriceEntered(Env.ZERO);
            line.setPriceActual(Env.ZERO);
            line.setPriceLimit(Env.ZERO);
            line.setPriceList(Env.ZERO);
            line.setLineNetAmt(Env.ZERO);
            line.setIsDescription(true);
        }
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        this.log.fine(line.toString());
    }

    private void completeInvoice() {
        if (this.invoice != null) {
            this.invoiceCompleted = this.invoice.processIt(this.p_docAction);
            if (!this.invoiceCompleted) {
                this.log.warning("completeInvoice - failed: " + this.invoice);
                this.addLog("completeInvoice - failed: " + this.invoice);
            }
            this.invoice.saveEx();
            this.addLog(this.invoice.getC_Invoice_ID(), this.invoice.getDateInvoiced(), null, this.invoice.getDocumentNo());
            ++this.m_created;
        }
        this.invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }
}

