/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.util.StringUtils;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.model.X_T_BOM_Indented;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOMLine;

public class IndentedBOM
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_M_CostElement_ID = 0;
    private int m_LevelNo = 0;
    private int m_SeqNo = 0;
    private MAcctSchema m_as = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = para.getParameterAsInt();
                this.m_as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
                continue;
            }
            if (name.equals("M_CostElement_ID")) {
                this.p_M_CostElement_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_M_Product_ID == 0) {
            throw new FillMandatoryException(new String[]{"M_Product_ID"});
        }
        this.explodeProduct(this.p_M_Product_ID, Env.ONE, Env.ONE);
        return "";
    }

    private llCost explodeProduct(int M_Product_ID, BigDecimal qty, BigDecimal accumQty) {
        MProduct product = MProduct.get(this.getCtx(), M_Product_ID);
        X_T_BOM_Indented tboml = new X_T_BOM_Indented(this.getCtx(), 0, this.get_TrxName());
        tboml.setAD_Org_ID(this.p_AD_Org_ID);
        tboml.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
        tboml.setAD_PInstance_ID(this.getAD_PInstance_ID());
        tboml.setM_CostElement_ID(this.p_M_CostElement_ID);
        tboml.setSel_Product_ID(product.get_ID());
        tboml.setM_Product_ID(this.p_M_Product_ID);
        tboml.setQtyBOM(qty);
        tboml.setQty(accumQty);
        tboml.setSeqNo(this.m_SeqNo);
        tboml.setLevelNo(this.m_LevelNo);
        tboml.setLevels((this.m_LevelNo > 0 ? ":" : "") + StringUtils.repeat("    ", this.m_LevelNo) + " " + product.getValue());
        MCost cost = MCost.get(product, 0, this.m_as, this.p_AD_Org_ID, 0, this.p_M_CostElement_ID, this.get_TrxName());
        tboml.setCurrentCostPrice(cost.getCurrentCostPrice());
        tboml.setCost(cost.getCurrentCostPrice().multiply(accumQty));
        tboml.setFutureCostPrice(cost.getFutureCostPrice());
        tboml.setCostFuture(cost.getFutureCostPrice().multiply(accumQty));
        ++this.m_SeqNo;
        BigDecimal llCost2 = Env.ZERO;
        BigDecimal llFutureCost = Env.ZERO;
        List<MPPProductBOMLine> list = this.getBOMs(product);
        for (MPPProductBOMLine bom : list) {
            ++this.m_LevelNo;
            llCost ll = this.explodeProduct(bom.getM_Product_ID(), bom.getQtyBOM(), accumQty.multiply(bom.getQtyBOM()));
            llCost2 = llCost2.add(ll.currentCost.multiply(accumQty.multiply(bom.getQtyBOM())));
            llFutureCost = llFutureCost.add(ll.futureCost.multiply(accumQty.multiply(bom.getQtyBOM())));
            --this.m_LevelNo;
        }
        llCost retVal = new llCost();
        if (list.size() == 0) {
            tboml.setCurrentCostPriceLL(cost.getCurrentCostPrice());
            tboml.setFutureCostPriceLL(cost.getFutureCostPrice());
            retVal.currentCost = cost.getCurrentCostPrice();
            retVal.futureCost = cost.getFutureCostPrice();
        } else {
            tboml.setCurrentCostPriceLL(llCost2);
            tboml.setFutureCostPriceLL(llFutureCost);
            retVal.currentCost = llCost2;
            retVal.futureCost = llFutureCost;
        }
        tboml.saveEx();
        return retVal;
    }

    private List<MPPProductBOMLine> getBOMs(MProduct product) {
        this.log.severe(" PRODUCT NAME = " + product.getName());
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("PP_Product_BOM_ID");
        whereClause.append(" IN ( SELECT PP_Product_BOM_ID FROM PP_Product_BOM ");
        whereClause.append(" WHERE M_Product_ID = " + product.get_ID() + " ) ");
        List<MPPProductBOMLine> list = new Query(this.getCtx(), "PP_Product_BOMLine", whereClause.toString(), null).setOnlyActiveRecords(true).setOrderBy("Line").list();
        return list;
    }

    private class llCost {
        BigDecimal currentCost = Env.ZERO;
        BigDecimal futureCost = Env.ZERO;

        private llCost() {
        }
    }
}

