/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class GardenWorldCleanUp
extends SvrProcess {
    private Timestamp m_currentTime;
    private Timestamp m_minDate;
    private Timestamp m_maxDate;
    private long m_Offset;
    private int gw_client_id;
    private String m_sql;
    private String sqlWhereExclude;
    private String sqlOrderBy;

    public GardenWorldCleanUp() {
        this.m_minDate = this.m_currentTime = new Timestamp(System.currentTimeMillis());
        this.m_maxDate = new Timestamp(0L);
        this.m_Offset = 0L;
        this.gw_client_id = 11;
        this.m_sql = " SELECT t.tablename,c.ColumnName FROM AD_Column c  JOIN AD_Table t ON c.AD_Table_ID=t.AD_Table_ID  JOIN AD_Reference r ON (c.AD_Reference_ID = r.AD_Reference_ID)  JOIN (SELECT nc.AD_Table_ID FROM AD_Table nc JOIN AD_Column c        ON (nc.AD_Table_ID = c.AD_Table_ID) WHERE c.ColumnName = 'AD_Client_ID') nc    ON (nc.AD_Table_ID = t.AD_Table_ID)  WHERE r.validationtype='D' and r.name in ('Date','DateTime')  AND c.columnsql IS NULL AND t.tablename NOT LIKE 'I_%' AND t.tablename not like 'T_%'  AND t.isview='N' AND upper(t.tableName) not like 'RV%' AND t.tableName <> 'C_Period'  AND c.columnName NOT IN ('Created','Updated')  AND t.EntityType='D'";
        this.sqlWhereExclude = " AND c.columnName NOT LIKE '%From' AND c.columnName NOT LIKE '%To' ";
        this.sqlOrderBy = " ORDER BY t.tablename";
    }

    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() {
        if (!this.gardenWorldExists().booleanValue()) {
            return "Garden World client can't be found.";
        }
        this.clearSessionLog();
        this.setDateLimits();
        this.determineOffset();
        if (this.m_Offset == 0L) {
            this.log.config("The GardenWorld data is sufficiently up to date.  No changes were requried.");
            return "The GardenWorld data is sufficiently up to date.  No changes were requried.";
        }
        this.adjustCalendarAndPeriods();
        this.updateDates();
        this.updatePeriods();
        this.cleanUp();
        this.log.config("Successfully updated Garden World data.");
        return "Successfully updated Garden World data.";
    }

    private void updateDates() {
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = DB.prepareStatement(this.m_sql + this.sqlOrderBy, this.get_TrxName());
            rs = pstm.executeQuery();
            String tableName = null;
            String columnName = null;
            while (rs.next()) {
                tableName = rs.getString(1);
                columnName = rs.getString(2);
                this.updateTable(tableName, columnName);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstm);
                throw throwable;
            }
        }
        DB.close(rs, pstm);
    }

    private void updatePeriods() {
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = DB.prepareStatement(this.m_sql + this.sqlOrderBy, this.get_TrxName());
            rs = pstm.executeQuery();
            String tableName = null;
            String columnName = null;
            while (rs.next()) {
                tableName = rs.getString(1);
                columnName = rs.getString(2);
                this.setPeriods(tableName, columnName);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstm);
                throw throwable;
            }
        }
        DB.close(rs, pstm);
    }

    private void updateTable(String tableName, String columnName) {
        if (this.m_Offset == 0L || tableName.isEmpty() || columnName.isEmpty()) {
            return;
        }
        long monthOffset = this.m_Offset / 2592000000L;
        String sql = "UPDATE " + tableName + " SET  " + columnName + " = trunc(( CASE WHEN " + columnName + " > getdate() THEN add_months(" + columnName + ", " + monthOffset + ")       WHEN add_months(" + columnName + ", " + monthOffset + ") > getdate() THEN getdate()       ELSE add_months(" + columnName + ", " + monthOffset + ") END ), 'DD')  WHERE " + columnName + " IS NOT NULL  AND AD_Client_ID=" + this.gw_client_id;
        CPreparedStatement pstm = null;
        try {
            pstm = DB.prepareStatement(sql, this.get_TrxName());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("Problem in adding years to date columns", e);
            }
            catch (Throwable throwable) {
                DB.close(pstm);
                throw throwable;
            }
        }
        DB.close(pstm);
    }

    private void setPeriods(String tableName, String columnName) {
        String dateAcctColumn = null;
        MTable table2 = MTable.get(this.getCtx(), tableName);
        MColumn periodColumn = table2.getColumn("C_Period_ID");
        if (periodColumn != null) {
            MColumn dateaAcctColumn = table2.getColumn("DateAcct");
            MColumn assetDepDateColumn = table2.getColumn("AssetDepreciationDate");
            if (dateaAcctColumn != null) {
                dateAcctColumn = dateaAcctColumn.getColumnName();
            } else if (assetDepDateColumn != null) {
                dateAcctColumn = assetDepDateColumn.getColumnName();
            }
            if (dateAcctColumn != null) {
                this.log.fine("Table: " + tableName + " dateAcctColumn: " + dateAcctColumn);
                String updatePeriodSql = "update " + tableName + " set  C_Period_ID=(SELECT C_Period_ID from C_Period WHERE " + dateAcctColumn + " BETWEEN StartDate and EndDate and AD_Client_ID=" + this.gw_client_id + ") WHERE AD_Client_ID=" + this.gw_client_id;
                CPreparedStatement pstm = null;
                try {
                    pstm = DB.prepareStatement(updatePeriodSql, this.get_TrxName());
                    pstm.executeUpdate();
                }
                catch (SQLException e) {
                    try {
                        this.log.log(Level.SEVERE, e.getLocalizedMessage());
                        throw new AdempiereException("Problem in updating periods according to new accounting values.", e);
                    }
                    catch (Throwable throwable) {
                        DB.close(pstm);
                        throw throwable;
                    }
                }
                DB.close(pstm);
            }
        }
    }

    private void findDateLimits(String tableName, String columnName) {
        String sql = "SELECT MIN(" + columnName + "), MAX(" + columnName + ") from " + tableName + " WHERE AD_Client_ID=11 ";
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstm.executeQuery();
            while (rs.next()) {
                if (rs.getTimestamp(1) != null && rs.getTimestamp(1).getTime() != 0L && this.m_minDate.after(rs.getTimestamp(1))) {
                    this.m_minDate = rs.getTimestamp(1);
                    this.log.fine("Setting min date to " + this.m_minDate.toString() + "(" + tableName + "/" + columnName + ")");
                }
                if (rs.getTimestamp(2) == null || rs.getTimestamp(1).getTime() == 0L || rs.getTimestamp(2).after(this.m_currentTime) || !this.m_maxDate.before(rs.getTimestamp(2))) continue;
                this.m_maxDate = rs.getTimestamp(2);
                this.log.fine("Setting max date to " + this.m_maxDate.toString() + "(" + tableName + "/" + columnName + ")");
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("Problem finding the date limits", e);
            }
            catch (Throwable throwable) {
                DB.close(pstm);
                throw throwable;
            }
        }
        DB.close(pstm);
    }

    private void clearSessionLog() {
        String deleteSessionLogSQL = "DELETE FROM AD_Session where AD_Client_ID=" + this.gw_client_id;
        CPreparedStatement pstm = null;
        try {
            pstm = DB.prepareStatement(deleteSessionLogSQL, this.get_TrxName());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("Problem deleting the GardenWorld session log", e);
            }
            catch (Throwable throwable) {
                DB.close(pstm);
                throw throwable;
            }
        }
        DB.close(pstm);
    }

    private Boolean gardenWorldExists() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AD_Client_ID=?");
        MClient gwClient = (MClient)new Query(this.getCtx(), "AD_Client", whereClause.toString(), null).setParameters(this.gw_client_id).first();
        if (gwClient != null && gwClient.getName().equals("GardenWorld")) {
            return true;
        }
        return false;
    }

    protected void setDateLimits() {
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = DB.prepareStatement(this.m_sql + this.sqlWhereExclude + this.sqlOrderBy, this.get_TrxName());
            rs = pstm.executeQuery();
            String tableName = null;
            String columnName = null;
            while (rs.next()) {
                tableName = rs.getString(1);
                columnName = rs.getString(2);
                this.findDateLimits(tableName, columnName);
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstm);
                throw throwable;
            }
        }
        DB.close(rs, pstm);
    }

    private void determineOffset() {
        long twoYears = 63072000000L;
        long maxOffset = this.m_currentTime.getTime() - this.m_maxDate.getTime();
        long minOffset = this.m_currentTime.getTime() - twoYears - this.m_minDate.getTime();
        this.log.fine("Max offset - Years: " + maxOffset / 31536000000L);
        this.log.fine("Min offset - Years: " + minOffset / 31536000000L);
        if (maxOffset < 0L || minOffset < 0L) {
            this.m_Offset = 0L;
            return;
        }
        this.m_Offset = maxOffset > minOffset ? maxOffset : minOffset;
    }

    private void adjustCalendarAndPeriods() {
        long yearOffset = this.m_Offset / 31536000000L;
        long monthOffset = yearOffset * 12L;
        if (monthOffset == 0L) {
            return;
        }
        String updatePeriod = "UPDATE C_Period SET StartDate = add_months(Startdate, " + monthOffset + "),    EndDate = add_months(Enddate, " + monthOffset + "),    Name = to_char(add_months(Enddate, " + monthOffset + "),'YYYY-MM')  WHERE ad_client_id=" + this.gw_client_id;
        CPreparedStatement pstm = null;
        try {
            pstm = DB.prepareStatement(updatePeriod, this.get_TrxName());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("Problem Offsetting the periods", e);
            }
            catch (Throwable throwable) {
                DB.close(pstm);
                pstm = null;
                throw throwable;
            }
        }
        DB.close(pstm);
        pstm = null;
        String updateYear = "UPDATE C_Year SET fiscalyear=(SELECT max(to_char(p.enddate,'YYYY-MM'))  from c_period p where p.c_year_id=c_year.c_year_id)  WHERE ad_client_id=" + this.gw_client_id;
        try {
            pstm = DB.prepareStatement(updateYear, this.get_TrxName());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage());
            throw new AdempiereException("Problem offsetting the year - 1st query to YYYY-MM", e);
        }
        finally {
            DB.close(pstm);
            pstm = null;
        }
        updateYear = "UPDATE C_Year SET fiscalyear=(SELECT max(to_char(p.enddate,'YYYY'))  from c_period p where p.c_year_id=c_year.c_year_id)  WHERE ad_client_id=" + this.gw_client_id;
        try {
            pstm = DB.prepareStatement(updateYear, this.get_TrxName());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage());
            throw new AdempiereException("Problem offsetting the year to form YYYY", e);
        }
        finally {
            DB.close(pstm);
            pstm = null;
        }
    }

    private void cleanUp() {
        String deleteSessionLogSQL = "UPDATE C_BankStatement SET NAME = to_char(StatementDate, 'YYYY-MM_DD') where AD_Client_ID=" + this.gw_client_id;
        CPreparedStatement pstm = null;
        try {
            pstm = DB.prepareStatement(deleteSessionLogSQL, this.get_TrxName());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage());
                throw new AdempiereException("Problem updating the bank statement names", e);
            }
            catch (Throwable throwable) {
                DB.close(pstm);
                throw throwable;
            }
        }
        DB.close(pstm);
    }
}

