/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunning;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MDunningRunLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.compiere.process.DunningRunCreateAbstract;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DunningRunCreate
extends DunningRunCreateAbstract {
    private int entries = 0;

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_DunningRun_ID=" + this.getRecord_ID() + ", Dispute=" + this.isIncludeInDispute() + ", C_BP_Group_ID=" + this.getBPGroupId() + ", C_BPartner_ID=" + this.getBPartnerId());
        if (this.getRecord_ID() != 0) {
            MDunningRun dunningRun = new MDunningRun(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            this.processDunningRun(new MDunning(this.getCtx(), this.getDunningId(), this.get_TrxName()), dunningRun);
        } else if (this.getDunningId() != 0) {
            MDunningRun dunningRun = new MDunningRun(this.getCtx(), 0, this.get_TrxName());
            this.processDunningRun(new MDunning(this.getCtx(), this.getDunningId(), this.get_TrxName()), dunningRun);
        } else {
            new Query(this.getCtx(), "C_Dunning", null, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().list().stream().forEach(dunning -> this.processDunningRun((MDunning)dunning, new MDunningRun(this.getCtx(), 0, this.get_TrxName())));
        }
        return "@C_DunningRunEntry_ID@ #" + this.entries;
    }

    private void processDunningRun(MDunning dunning, MDunningRun dunningRun) {
        if (dunningRun.getC_DunningRun_ID() == 0 && this.getDunningDate() == null) {
            dunningRun.setDunningDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dunning.getC_Dunning_ID() != 0) {
            dunningRun.setC_Dunning_ID(dunning.getC_Dunning_ID());
        }
        if (this.getDunningLevelId() != 0) {
            dunningRun.setC_DunningLevel_ID(this.getDunningLevelId());
            if (dunning.getC_Dunning_ID() == 0) {
                MDunningLevel level = new MDunningLevel(this.getCtx(), this.getDunningLevelId(), this.get_TrxName());
                dunningRun.setC_Dunning_ID(level.getC_Dunning_ID());
            }
        }
        if (this.getDunningDate() != null) {
            dunningRun.setDunningDate(this.getDunningDate());
        }
        if (this.getOrgId() != 0) {
            dunningRun.setAD_Org_ID(this.getOrgId());
        }
        dunningRun.saveEx();
        dunningRun.deleteEntries(true);
        for (MDunningLevel level : dunningRun.getLevels()) {
            this.addInvoices(dunningRun, level);
            if (level.isIncludePayments()) {
                this.addPayments(dunningRun, level);
            }
            if (level.isChargeFee()) {
                this.addFees(dunningRun, level);
            }
            this.checkDunningEntry(dunningRun, level);
        }
        int localEntries = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM C_DunningRunEntry WHERE C_DunningRun_ID=?", dunningRun.get_ID());
        this.entries += localEntries;
        this.addLog("@C_DunningRunEntry_ID@ #" + localEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addInvoices(MDunningRun run, MDunningLevel level) {
        int count = 0;
        String sql = "SELECT i.C_Invoice_ID, i.C_Currency_ID, i.GrandTotal*i.MultiplierAP, invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)*MultiplierAP, COALESCE(daysBetween(?,ips.DueDate),paymentTermDueDays(i.C_PaymentTerm_ID,i.DateInvoiced,?)), i.IsInDispute, i.C_BPartner_ID, i.C_InvoicePaySchedule_ID, i.C_Order_ID FROM C_Invoice_v i  LEFT OUTER JOIN C_InvoicePaySchedule ips ON (i.C_InvoicePaySchedule_ID=ips.C_InvoicePaySchedule_ID) WHERE i.IsPaid='N' AND i.AD_Client_ID=? AND i.DocStatus IN ('CO','CL') AND (i.DunningGrace IS NULL OR i.DunningGrace<?)  AND EXISTS (SELECT 1 FROM C_DunningLevel dl WHERE dl.C_DunningLevel_ID=? AND dl.C_Dunning_ID IN (SELECT COALESCE(bp.C_Dunning_ID, bpg.C_Dunning_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bp.C_BP_Group_ID=bpg.C_BP_Group_ID) WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND (bp.DunningGrace IS NULL OR bp.DunningGrace<?)))";
        if (this.getBPartnerId() != 0) {
            sql = sql + " AND i.C_BPartner_ID=?";
        } else if (this.getBPGroupId() != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM C_BPartner bp WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)";
        }
        if (this.isOnlySOTrx()) {
            sql = sql + " AND i.IsSOTrx='Y'";
        }
        if (!this.isAllCurrencies()) {
            sql = sql + " AND i.C_Currency_ID=" + this.getCurrencyId();
        }
        if (this.getOrgId() != 0) {
            sql = sql + " AND i.AD_Org_ID=" + this.getOrgId();
        }
        if (level.getParent().isCreateLevelsSequentially()) {
            String sqlAppend = "";
            for (MDunningLevel element : level.getPreviousLevels()) {
                sqlAppend = sqlAppend + " AND EXISTS(SELECT 1 FROM C_DunningRunLine dl \t\t\t\tWHERE dl.C_Invoice_ID = i.C_Invoice_ID \t\t\t\tAND EXISTS(SELECT 1 FROM C_DunningRunEntry de \t\t\t\tWHERE de.C_DunningRunEntry_ID = dl.C_DunningRunEntry_ID \t\t\t\tAND EXISTS(SELECT 1 FROM C_DunningRunEntry dee \t\t\t\t\t\t\tWHERE dee.C_DunningRun_ID = de.C_DunningRun_ID \t\t\t\t\t\t\tAND dee.C_DunningLevel_ID=" + element.getC_DunningLevel_ID() + ")) \tAND dl.Processed <> 'N')";
            }
            sql = sql + sqlAppend;
        }
        BigDecimal daysAfterDue = level.getDaysAfterDue();
        int daysBetweenDunning = level.getDaysBetweenDunning();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(1, run.getDunningDate());
            pstmt.setTimestamp(2, run.getDunningDate());
            pstmt.setInt(3, run.getAD_Client_ID());
            pstmt.setTimestamp(4, run.getDunningDate());
            pstmt.setInt(5, level.getC_DunningLevel_ID());
            pstmt.setTimestamp(6, run.getDunningDate());
            if (this.getBPartnerId() != 0) {
                pstmt.setInt(7, this.getBPartnerId());
            } else if (this.getBPGroupId() != 0) {
                pstmt.setInt(7, this.getBPGroupId());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int invoiceId = rs.getInt(1);
                int currencyId = rs.getInt(2);
                BigDecimal grandTotal = rs.getBigDecimal(3);
                BigDecimal open = rs.getBigDecimal(4);
                int daysDue = rs.getInt(5);
                boolean isInDispute = "Y".equals(rs.getString(6));
                int bPartnerId = rs.getInt(7);
                int invoicePayScheduleId = rs.getInt(8);
                int orderId = rs.getInt(9);
                this.log.fine("DaysAfterDue: " + daysAfterDue.intValue() + " isShowAllDue: " + level.isShowAllDue());
                this.log.fine("C_Invoice_ID - DaysDue - GrandTotal: " + invoiceId + " - " + daysDue + " - " + grandTotal);
                this.log.fine("C_InvoicePaySchedule_ID: " + invoicePayScheduleId);
                if (!this.isIncludeInDispute() && isInDispute || daysDue > 0 && daysDue < daysAfterDue.intValue() && !level.isShowAllDue() || Env.ZERO.compareTo(open) == 0) continue;
                int timesDunned = 0;
                int daysAfterLast = 0;
                if (level.isRange()) {
                    if (level.getDaysFrom() == 0 && level.getDaysTo() == 0 && !level.isShowAllDue() || daysDue < level.getDaysFrom() && !level.isShowAllDue() || daysDue > level.getDaysTo() && level.getDaysTo() != 0 && !level.isShowAllDue()) {
                        continue;
                    }
                } else {
                    int[] values = this.getDunningTime(run.getC_DunningRun_ID(), invoiceId);
                    timesDunned = values[0];
                    daysAfterLast = values[1];
                    if (daysBetweenDunning != 0 && timesDunned > 0 && daysAfterLast < daysBetweenDunning && !level.isShowAllDue() && !level.isShowNotDue() || daysDue < 0 && !level.isShowNotDue()) continue;
                    if (daysAfterLast < daysBetweenDunning) {
                        timesDunned *= -1;
                    }
                }
                if (!this.createInvoiceLine(run, invoiceId, invoicePayScheduleId, currencyId, grandTotal, open, daysDue, isInDispute, bPartnerId, timesDunned, daysAfterLast, level.getC_DunningLevel_ID(), orderId)) continue;
                ++count;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "addInvoices", e);
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    private int[] getDunningTime(int dunningRunId, int invoiceId) throws SQLException {
        int[] values = new int[]{0, 0};
        String sql = "SELECT COUNT(*), COALESCE(DAYSBETWEEN(MAX(dr2.DunningDate), MAX(dr.DunningDate)),0)FROM C_DunningRun dr2, C_DunningRun dr INNER JOIN C_DunningRunEntry dre ON (dr.C_DunningRun_ID=dre.C_DunningRun_ID) INNER JOIN C_DunningRunLine drl ON (dre.C_DunningRunEntry_ID=drl.C_DunningRunEntry_ID) WHERE dr2.C_DunningRun_ID=? AND drl.C_Invoice_ID=?";
        CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
        pstmt.setInt(1, dunningRunId);
        pstmt.setInt(2, invoiceId);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            values[0] = rs.getInt(1);
            values[1] = rs.getInt(2);
        }
        DB.close(rs, pstmt);
        return values;
    }

    private boolean createInvoiceLine(MDunningRun run, int invoiceId, int invoicePayScheduleId, int currencyId, BigDecimal grandTotal, BigDecimal open, int daysDue, boolean isInDispute, int bPartnerId, int timesDunned, int daysAfterLast, int dunningLevelId, int orderId) {
        MDunningRunEntry entry = null;
        try {
            entry = run.getEntry(bPartnerId, this.getCurrencyId(), this.getSalesRepId(), dunningLevelId);
        }
        catch (BPartnerNoAddressException e) {
            String msg = "@Skip@ @C_Invoice_ID@ " + MInvoice.get(this.getCtx(), invoiceId).getDocumentInfo() + ", @C_BPartner_ID@ " + MBPartner.get(this.getCtx(), bPartnerId).getName() + " @No@ @IsActive@ @C_BPartner_Location_ID@";
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, msg);
            return false;
        }
        if (entry.get_ID() == 0) {
            entry.saveEx();
        }
        MDunningRunLine line = new MDunningRunLine(entry);
        line.setInvoice(invoiceId, currencyId, grandTotal, open, Env.ZERO, daysDue, isInDispute, timesDunned, daysAfterLast, orderId);
        line.setC_InvoicePaySchedule_ID(invoicePayScheduleId);
        if (orderId != 0) {
            line.setC_Order_ID(orderId);
        }
        line.saveEx();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPayments(MDunningRun run, MDunningLevel level) {
        String sql = "SELECT p.C_Payment_ID, p.C_Currency_ID, p.PayAmt, paymentAvailable(p.C_Payment_ID), p.C_BPartner_ID, p.C_Order_ID FROM C_Payment_v p WHERE AD_Client_ID=? AND IsAllocated='N' AND C_BPartner_ID IS NOT NULL AND C_Charge_ID IS NULL AND DocStatus IN ('CO','CL') AND EXISTS (SELECT 1 FROM C_DunningLevel dl WHERE dl.C_DunningLevel_ID=? AND dl.C_Dunning_ID IN (SELECT COALESCE(bp.C_Dunning_ID, bpg.C_Dunning_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bp.C_BP_Group_ID=bpg.C_BP_Group_ID) WHERE p.C_BPartner_ID=bp.C_BPartner_ID))";
        if (this.getBPartnerId() != 0) {
            sql = sql + " AND C_BPartner_ID=?";
        } else if (this.getBPGroupId() != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM C_BPartner bp WHERE p.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)";
        }
        if (!level.isStatement()) {
            sql = sql + " AND C_BPartner_ID IN (SELECT C_BPartner_ID FROM C_DunningRunEntry WHERE C_DunningRun_ID=" + run.get_ID() + ")";
        }
        if (this.isOnlySOTrx()) {
            sql = sql + " AND IsReceipt='Y'";
        }
        if (this.getOrgId() != 0) {
            sql = sql + " AND p.AD_Org_ID=" + this.getOrgId();
        }
        int count = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            pstmt.setInt(2, level.getC_DunningLevel_ID());
            if (this.getBPartnerId() != 0) {
                pstmt.setInt(3, this.getBPartnerId());
            } else if (this.getBPGroupId() != 0) {
                pstmt.setInt(3, this.getBPGroupId());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int paymentId = rs.getInt(1);
                int currencyId = rs.getInt(2);
                BigDecimal payAmt = rs.getBigDecimal(3).negate();
                BigDecimal openAmt = rs.getBigDecimal(4).negate();
                int bPartnerId = rs.getInt(5);
                int orderId = rs.getInt(6);
                if (Env.ZERO.compareTo(openAmt) == 0 || !this.createPaymentLine(run, paymentId, currencyId, payAmt, openAmt, bPartnerId, level.getC_DunningLevel_ID(), orderId)) continue;
                ++count;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    private boolean createPaymentLine(MDunningRun run, int paymentId, int currencyId, BigDecimal payAmt, BigDecimal openAmt, int bPartnerId, int dunningLevelId, int orderId) {
        MDunningRunEntry entry = null;
        try {
            entry = run.getEntry(bPartnerId, this.getCurrencyId(), this.getSalesRepId(), dunningLevelId);
        }
        catch (BPartnerNoAddressException e) {
            MPayment payment = new MPayment(this.getCtx(), paymentId, null);
            String msg = "@Skip@ @C_Payment_ID@ " + payment.getDocumentInfo() + ", @C_BPartner_ID@ " + MBPartner.get(this.getCtx(), bPartnerId).getName() + " @No@ @IsActive@ @C_BPartner_Location_ID@";
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, msg);
            return false;
        }
        if (entry.get_ID() == 0) {
            entry.saveEx();
        }
        MDunningRunLine line = new MDunningRunLine(entry);
        line.setPayment(paymentId, currencyId, payAmt, openAmt, orderId);
        line.saveEx();
        return true;
    }

    private void addFees(MDunningRun run, MDunningLevel level) {
        boolean onlyInvoices = level.isStatement();
        List<MDunningRunEntry> entries = run.getEntries(true, onlyInvoices);
        for (MDunningRunEntry entry : entries) {
            if (level.isShowAllDue() && level.isShowNotDue() && entry.getAmt().compareTo(Env.ZERO) < 0) continue;
            MDunningRunLine line = new MDunningRunLine(entry);
            line.setFee(this.getCurrencyId(), level.getFeeAmt());
            line.saveEx();
            entry.setQty(entry.getQty().subtract(new BigDecimal(1)));
        }
    }

    private void checkDunningEntry(MDunningRun run, MDunningLevel level) {
        if (level.isShowAllDue()) {
            for (MDunningRunEntry entry : run.getEntries(true)) {
                boolean entryDelete = true;
                for (MDunningRunLine line : entry.getLines(true)) {
                    if (line.getTimesDunned() < 0) {
                        line.setTimesDunned(line.getTimesDunned() * -1);
                        line.saveEx();
                        continue;
                    }
                    entryDelete = false;
                }
                if (!entryDelete) continue;
                entry.delete(false);
            }
        }
    }
}

