/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.engine.CostComponent;
import org.compiere.model.I_M_Cost;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProductCost {
    private int productId = 0;
    private int attributeSetInstanceId = 0;
    private MProduct product = null;
    private String trxName = null;
    private int uomId = 0;
    private BigDecimal quantity = Env.ZERO;
    private static CLogger log = CLogger.getCLogger(ProductCost.class);
    public static final int ACCTTYPE_P_Revenue = 1;
    public static final int ACCTTYPE_P_Expense = 2;
    public static final int ACCTTYPE_P_Asset = 3;
    public static final int ACCTTYPE_P_Cogs = 4;
    public static final int ACCTTYPE_P_PPV = 5;
    public static final int ACCTTYPE_P_IPV = 6;
    public static final int ACCTTYPE_P_TDiscountRec = 7;
    public static final int ACCTTYPE_P_TDiscountGrant = 8;
    public static final int ACCTTYPE_P_CostAdjustment = 9;
    public static final int ACCTTYPE_P_InventoryClearing = 10;
    public static final int ACCTTYPE_P_WorkInProcess = 11;
    public static final int ACCTTYPE_P_MethodChangeVariance = 12;
    public static final int ACCTTYPE_P_UsageVariance = 13;
    public static final int ACCTTYPE_P_RateVariance = 14;
    public static final int ACCTTYPE_P_MixVariance = 15;
    public static final int ACCTTYPE_P_FloorStock = 16;
    public static final int ACCTTYPE_P_CostOfProduction = 17;
    public static final int ACCTTYPE_P_Labor = 18;
    public static final int ACCTTYPE_P_Burden = 19;
    public static final int ACCTTYPE_P_OutsideProcessing = 20;
    public static final int ACCTTYPE_P_Overhead = 21;
    public static final int ACCTTYPE_P_Scrap = 22;
    public static final int ACCTTYPE_P_AverageCostVariance = 23;

    public ProductCost(Properties ctx, int productId, int attributeSetInstanceId, String trxName) {
        this.productId = productId;
        if (this.productId != 0) {
            this.product = MProduct.get(ctx, productId);
        }
        this.attributeSetInstanceId = attributeSetInstanceId;
        this.trxName = trxName;
    }

    public MProduct getProduct() {
        return this.product;
    }

    public boolean isService() {
        if (this.product != null) {
            return this.product.isService();
        }
        return false;
    }

    public void setQty(BigDecimal qty) {
        this.quantity = qty;
    }

    public void setQty(BigDecimal qty, int uomId) {
        this.quantity = MUOMConversion.convert(uomId, this.uomId, qty, true);
        if (qty != null && this.quantity == null) {
            log.severe("Conversion error - set to " + qty);
            this.quantity = qty;
        } else {
            this.uomId = uomId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAccount getAccount(int acctType, MAcctSchema acctSchema) {
        if (acctType < 1 || acctType > 23) {
            return null;
        }
        if (this.productId == 0) {
            return this.getAccountDefault(acctType, acctSchema);
        }
        String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct,P_CostAdjustment_Acct, P_InventoryClearing_Acct,P_WIP_Acct,P_MethodChangeVariance_Acct,P_UsageVariance_Acct,P_RateVariance_Acct,P_MixVariance_Acct,P_FloorStock_Acct,P_CostOfProduction_Acct,P_Labor_Acct,P_Burden_Acct,P_OutsideProcessing_Acct,P_Overhead_Acct,P_Scrap_Acct,P_AverageCostVariance_Acct FROM M_Product_Acct WHERE M_Product_ID=? AND C_AcctSchema_ID=?";
        int validCombinationId = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            pstmt.setInt(1, this.productId);
            pstmt.setInt(2, acctSchema.getC_AcctSchema_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                validCombinationId = rs.getInt(acctType);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (validCombinationId == 0) {
            return null;
        }
        return MAccount.getValidCombination(acctSchema.getCtx(), validCombinationId, this.trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAccount getAccount(int acctType, MAcctSchema acctSchema, int orgId) {
        if (acctType < 1 || acctType > 22) {
            return null;
        }
        if (this.productId == 0) {
            return this.getAccountDefault(acctType, acctSchema, orgId);
        }
        String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct,P_CostAdjustment_Acct, P_InventoryClearing_Acct,P_WIP_Acct,P_MethodChangeVariance_Acct,P_UsageVariance_Acct,P_RateVariance_Acct,P_MixVariance_Acct,P_FloorStock_Acct,P_CostOfProduction_Acct,P_Labor_Acct,P_Burden_Acct,P_OutsideProcessing_Acct,P_Overhead_Acct,P_Scrap_Acct FROM M_Product_Acct WHERE M_Product_ID=? AND C_AcctSchema_ID=? AND (AD_Org_ID=? OR AD_Org_ID=0) ORDER BY AD_Org_ID DESC";
        int validCombinationId = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            pstmt.setInt(1, this.productId);
            pstmt.setInt(2, acctSchema.getC_AcctSchema_ID());
            pstmt.setInt(3, orgId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                validCombinationId = rs.getInt(acctType);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (validCombinationId == 0) {
            return null;
        }
        return MAccount.getValidCombination(acctSchema.getCtx(), validCombinationId, this.trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAccount getAccountDefault(int acctType, MAcctSchema acctSchema) {
        if (acctType < 1 || acctType > 23) {
            return null;
        }
        String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct, P_WIP_Acct,P_MethodChangeVariance_Acct,P_UsageVariance_Acct,P_RateVariance_Acct,P_MixVariance_Acct,P_FloorStock_Acct,P_CostOfProduction_Acct,P_Labor_Acct,P_Burden_Acct,P_OutsideProcessing_Acct,P_Overhead_Acct,P_Scrap_Acct,P_AverageCostVariance_Acct FROM M_Product_Category pc, M_Product_Category_Acct pca WHERE pc.M_Product_Category_ID=pca.M_Product_Category_ID AND pca.C_AcctSchema_ID=? ORDER BY pc.IsDefault DESC, pc.Created";
        int validCombinationId = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            pstmt.setInt(1, acctSchema.getC_AcctSchema_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                validCombinationId = rs.getInt(acctType);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (validCombinationId == 0) {
            return null;
        }
        return MAccount.getValidCombination(acctSchema.getCtx(), validCombinationId, this.trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAccount getAccountDefault(int acctType, MAcctSchema acctSchema, int orgId) {
        if (acctType < 1 || acctType > 22) {
            return null;
        }
        String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct, P_WIP_Acct,P_MethodChangeVariance_Acct,P_UsageVariance_Acct,P_RateVariance_Acct,P_MixVariance_Acct,P_FloorStock_Acct,P_CostOfProduction_Acct,P_Labor_Acct,P_Burden_Acct,P_OutsideProcessing_Acct,P_Overhead_Acct,P_Scrap_Acct FROM M_Product_Category pc, M_Product_Category_Acct pca WHERE pc.M_Product_Category_ID=pca.M_Product_Category_ID AND pca.C_AcctSchema_ID=? AND (pca.AD_Org_ID=? OR pca.AD_Org_ID=0) ORDER BY pca.AD_Org_ID DESC , pc.IsDefault DESC, pc.Created ";
        int validCombinationId = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.trxName);
            pstmt.setInt(1, acctSchema.getC_AcctSchema_ID());
            pstmt.setInt(2, orgId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                validCombinationId = rs.getInt(acctType);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (validCombinationId == 0) {
            return null;
        }
        return MAccount.getValidCombination(acctSchema.getCtx(), validCombinationId, this.trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getProductItemCostOld(MAcctSchema as, String costType) {
        ResultSet rs;
        CPreparedStatement pstmt;
        BigDecimal cost;
        BigDecimal current;
        block10: {
            current = null;
            cost = null;
            String cm = as.getCostingMethod();
            StringBuffer sql = new StringBuffer("SELECT CurrentCostPrice,");
            if (costType == null && "A".equals(cm) || "A".equals(costType)) {
                sql.append("COSTAVERAGE");
            } else if (costType == null && "p".equals(cm) || "p".equals(costType)) {
                sql.append("PRICELASTPO");
            } else {
                sql.append("COSTSTANDARD");
            }
            sql.append(" FROM M_Product_Costing WHERE M_Product_ID=? AND C_AcctSchema_ID=?");
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.trxName);
                pstmt.setInt(1, this.productId);
                pstmt.setInt(2, as.getC_AcctSchema_ID());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block10;
                current = rs.getBigDecimal(1);
                cost = rs.getBigDecimal(2);
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, sql.toString(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (costType != null && cost != null && !cost.equals(Env.ZERO)) {
            log.fine("Costs=" + cost);
            return cost;
        }
        if (current != null && !current.equals(Env.ZERO)) {
            log.fine("Current=" + current);
            return current;
        }
        boolean create = cost == null && current == null;
        return this.updateCostsOld(as, create);
    }

    private BigDecimal updateCostsOld(MAcctSchema as, boolean create) {
        if (create) {
            StringBuffer sql = new StringBuffer("INSERT INTO M_Product_Costing (M_Product_ID,C_AcctSchema_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy, CurrentCostPrice,CostStandard,FutureCostPrice, CostStandardPOQty,CostStandardPOAmt,CostStandardCumQty,CostStandardCumAmt, CostAverage,CostAverageCumQty,CostAverageCumAmt, PriceLastPO,PriceLastInv, TotalInvQty,TotalInvAmt) VALUES (");
            sql.append(this.productId).append(",").append(as.getC_AcctSchema_ID()).append(",").append(as.getAD_Client_ID()).append(",").append(as.getAD_Org_ID()).append(",").append("'Y',SysDate,0,SysDate,0, 0,0,0,  0,0,0,0,  0,0,0,  0,0,  0,0)");
            int no = DB.executeUpdate(sql.toString(), this.trxName);
            if (no == 1) {
                log.fine("CostingCreated");
            }
        }
        String costSource = "PriceList-PO";
        BigDecimal costs = this.getPriceList(as, true);
        if (costs == null || costs.equals(Env.ZERO)) {
            costSource = "PO Cost";
            costs = this.getPOCost(as);
        }
        if (costs == null || costs.equals(Env.ZERO)) {
            costSource = "PriceList";
            costs = this.getPriceList(as, false);
        }
        if (costs == null || costs.equals(Env.ZERO)) {
            costSource = "Not Found";
            costs = new BigDecimal("1");
        }
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing ");
        sql.append("SET CurrentCostPrice=").append(costs).append(" WHERE M_Product_ID=").append(this.productId).append(" AND C_AcctSchema_ID=").append(as.getC_AcctSchema_ID());
        int no = DB.executeUpdate(sql.toString(), this.trxName);
        if (no == 1) {
            log.fine(costSource + " - " + costs);
        }
        return costs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPriceList(MAcctSchema as, boolean onlyPOPriceList) {
        ResultSet rs;
        CPreparedStatement pstmt;
        BigDecimal priceLimit;
        BigDecimal priceStd;
        BigDecimal priceList;
        int currencyId;
        block9: {
            StringBuffer sql = new StringBuffer("SELECT pl.C_Currency_ID, pp.PriceList, pp.PriceStd, pp.PriceLimit FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pl.M_PriceList_ID = plv.M_PriceList_ID AND plv.M_PriceList_Version_ID = pp.M_PriceList_Version_ID AND pp.M_Product_ID=?");
            if (onlyPOPriceList) {
                sql.append(" AND pl.IsSOPriceList='N'");
            }
            sql.append(" ORDER BY pl.IsSOPriceList ASC, plv.ValidFrom DESC");
            currencyId = 0;
            priceList = null;
            priceStd = null;
            priceLimit = null;
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.trxName);
                pstmt.setInt(1, this.productId);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block9;
                currencyId = rs.getInt(1);
                priceList = rs.getBigDecimal(2);
                priceStd = rs.getBigDecimal(3);
                priceLimit = rs.getBigDecimal(4);
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, sql.toString(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (currencyId == 0) {
            return null;
        }
        BigDecimal price = priceLimit;
        if (price == null || price.equals(Env.ZERO)) {
            price = priceStd;
        }
        if (price == null || price.equals(Env.ZERO)) {
            price = priceList;
        }
        if (price != null && !price.equals(Env.ZERO)) {
            price = MConversionRate.convert(as.getCtx(), price, currencyId, as.getC_Currency_ID(), as.getAD_Client_ID(), 0);
        }
        return price;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPOCost(MAcctSchema acctSchema) {
        String sql = "SELECT C_Currency_ID, PriceList,PricePO,PriceLastPO FROM M_Product_PO WHERE M_Product_ID=? ORDER BY IsCurrentVendor DESC";
        int currencyId = 0;
        BigDecimal PriceList = null;
        BigDecimal PricePO = null;
        BigDecimal PriceLastPO = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.productId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                currencyId = rs.getInt(1);
                PriceList = rs.getBigDecimal(2);
                PricePO = rs.getBigDecimal(3);
                PriceLastPO = rs.getBigDecimal(4);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (currencyId == 0) {
            return null;
        }
        BigDecimal cost = PriceLastPO;
        if (cost == null || cost.equals(Env.ZERO)) {
            cost = PricePO;
        }
        if (cost == null || cost.equals(Env.ZERO)) {
            cost = PriceList;
        }
        if (cost != null && !cost.equals(Env.ZERO)) {
            cost = MConversionRate.convert(acctSchema.getCtx(), cost, currencyId, acctSchema.getC_Currency_ID(), acctSchema.getAD_Client_ID(), acctSchema.getAD_Org_ID());
        }
        return cost;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ProductCost[");
        sb.append("M_Product_ID=").append(this.productId).append(",M_AttributeSetInstance_ID").append(this.attributeSetInstanceId).append(",Qty=").append(this.quantity).append("]");
        return sb.toString();
    }

    public List<CostComponent> getProductCostsLayers(I_M_Cost cost, int orderLineId, boolean zeroCostsOK) {
        if (this.quantity == null) {
            log.fine("No Qty");
            return null;
        }
        if (this.product == null) {
            log.fine("No Product");
            return null;
        }
        List<CostComponent> list = MCost.getCurrentCostLayers((MCost)cost, this.quantity, orderLineId, zeroCostsOK, this.trxName);
        if (list == null) {
            log.fine("No Costs");
            return null;
        }
        return list;
    }
}

