/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.InterfaceWrapperHelper;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public final class POCacheLocal {
    private static final CLogger logger = CLogger.getCLogger(POCacheLocal.class);
    private final PO parentPO;
    private final String parentColumnName;
    private final String tableName;
    private final String idColumnName;
    private final String loadWhereClause;
    private PO po = null;

    public static POCacheLocal newInstance(PO parent, String parentColumnName, String tableName) {
        return new POCacheLocal(parent, parentColumnName, tableName);
    }

    private POCacheLocal(PO parent, String parentColumnName, String tableName) {
        Util.assume(parent != null, "parent is null");
        Util.assume(parentColumnName != null, "parentColumnName is null");
        Util.assume(tableName != null, "tableName");
        this.parentPO = parent;
        this.parentColumnName = parentColumnName;
        this.tableName = tableName;
        POInfo poInfo = POInfo.getPOInfo(parent.getCtx(), tableName);
        this.idColumnName = poInfo.getKeyColumnName();
        if (this.idColumnName == null) {
            throw new IllegalStateException("Table " + tableName + " does not have a simple primary key");
        }
        this.loadWhereClause = this.idColumnName + "=?";
    }

    public <T> T get(Class<T> clazz) {
        return this.get(clazz, false);
    }

    public <T> T get(Class<T> clazz, boolean requery) {
        int id = this.getId();
        if (id <= 0) {
            if (this.po != null && !this.po.is_new()) {
                this.po = null;
                return null;
            }
            if (this.po != null) {
                return InterfaceWrapperHelper.create(this.po, clazz);
            }
            return null;
        }
        if (requery || this.po == null || !this.isValidPO(this.po)) {
            this.po = this.load(this.parentPO.getCtx(), id, this.parentPO.get_TrxName());
        }
        if (this.po == null) {
            return null;
        }
        return InterfaceWrapperHelper.create(this.po, clazz);
    }

    public void set(Object obj) {
        PO po = InterfaceWrapperHelper.getPO(obj);
        if (po == null && obj != null) {
            throw new AdempiereException("Invalid PO: " + obj);
        }
        if (po == null) {
            this.setId(-1);
            this.po = null;
            return;
        }
        int id = po.get_ID();
        this.setId(id);
        if (this.isValidPO(po)) {
            this.po = po;
        }
    }

    private boolean isValidPO(PO po) {
        if (!this.isSameTrxName(this.parentPO.get_TrxName(), po.get_TrxName())) {
            return false;
        }
        if (!po.get_TableName().equals(this.tableName)) {
            logger.warning("PO " + po + " does not expected table: " + this.tableName);
            return false;
        }
        int id = this.getId();
        if (id < 0) {
            return false;
        }
        return po.get_ID() == id;
    }

    private boolean isSameTrxName(String trxName1, String trxName2) {
        if (trxName1 == trxName2) {
            return true;
        }
        if (trxName1 == null) {
            return false;
        }
        return trxName1.equals(trxName2);
    }

    private PO load(Properties ctx, int id, String trxName) {
        if (id < 0) {
            return null;
        }
        Object po = new Query(ctx, this.tableName, this.loadWhereClause, trxName).setParameters(id).firstOnly();
        return po;
    }

    private int getId() {
        int id = this.parentPO.get_ValueAsInt(this.parentColumnName);
        return id;
    }

    private boolean setId(int id) {
        Integer value = id < 0 ? null : Integer.valueOf(id);
        boolean ok = this.parentPO.set_ValueOfColumnReturningBoolean(this.parentColumnName, (Object)value);
        if (!ok) {
            logger.warning("Cannot set " + this.parentColumnName + "=" + id);
        }
        return ok;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return "POCacheLocal [parentPO=" + this.parentPO + ", parentColumnName=" + this.parentColumnName + ", tableName=" + this.tableName + ", idColumnName=" + this.idColumnName + ", loadWhereClause=" + this.loadWhereClause + ", po=" + this.po + "]";
    }

    public POCacheLocal copy(PO parentPO) {
        POCacheLocal poCacheLocalNew = POCacheLocal.newInstance(parentPO, this.parentColumnName, this.tableName);
        poCacheLocalNew.po = this.po;
        return poCacheLocalNew;
    }
}

